/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle;

import java.sql.Connection;
import java.util.Properties;
import java.util.regex.Pattern;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.DatabaseType;
import org.flywaydb.core.internal.database.oracle.OracleDatabase;
import org.flywaydb.core.internal.database.oracle.OracleParser;
import org.flywaydb.core.internal.database.oracle.OracleSqlScriptExecutor;
import org.flywaydb.core.internal.database.oracle.pro.OracleDatabaseMetadata;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderProvider;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.util.ClassUtils;

public class OracleDatabaseType
extends DatabaseType {
    private static final Pattern usernamePasswordPattern = Pattern.compile("^jdbc:oracle:thin:[a-zA-Z0-9#_$]+/([a-zA-Z0-9#_$]+)@.*");

    @Override
    public String getName() {
        return "Oracle";
    }

    @Override
    public int getNullType() {
        return 12;
    }

    @Override
    public boolean handlesJDBCUrl(String url) {
        if (url.startsWith("jdbc-secretsmanager:oracle:")) {
            return true;
        }
        return url.startsWith("jdbc:oracle");
    }

    @Override
    public Pattern getJDBCCredentialsPattern() {
        return usernamePasswordPattern;
    }

    @Override
    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc-secretsmanager:oracle:")) {
            return "com.amazonaws.secretsmanager.sql.AWSSecretsManagerOracleDriver";
        }
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("Oracle");
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        OracleDatabase.enableTnsnamesOraSupport();
        return new OracleDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        OracleDatabaseMetadata metadata = OracleDatabaseMetadata.getDatabaseMetadata(configuration, this);
        return new OracleParser(configuration, configuration.isOracleSqlplus(), configuration.isOracleSqlplusWarn(), new SQLPlusPlaceholderProvider(configuration.getPlaceholders(), metadata.oracleUser, metadata.oracleConnectIdentifier, metadata.oracleOVersion, metadata.oracleORelease), resourceProvider, parsingContext);
    }

    @Override
    public SqlScriptExecutorFactory createSqlScriptExecutorFactory(JdbcConnectionFactory jdbcConnectionFactory, final CallbackExecutor callbackExecutor, final StatementInterceptor statementInterceptor) {
        final boolean supportsBatch = jdbcConnectionFactory.isSupportsBatch();
        final OracleDatabaseType thisRef = this;
        return new SqlScriptExecutorFactory(){

            @Override
            public SqlScriptExecutor createSqlScriptExecutor(Connection connection, boolean undo, boolean batch, boolean outputQueryResults) {
                if (!supportsBatch) {
                    batch = false;
                }
                return new OracleSqlScriptExecutor(new JdbcTemplate(connection, thisRef), callbackExecutor, undo, batch, outputQueryResults, statementInterceptor);
            }
        };
    }

    @Override
    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        String osUser = System.getProperty("user.name");
        props.put("v$session.osuser", osUser.substring(0, Math.min(osUser.length(), 30)));
        props.put("v$session.program", "Flyway by Redgate");
        props.put("oracle.net.keepAlive", "true");
        String oobb = ClassUtils.getStaticFieldValue("oracle.jdbc.OracleConnection", "CONNECTION_PROPERTY_THIN_NET_DISABLE_OUT_OF_BAND_BREAK", classLoader);
        props.put(oobb, "true");
    }

    @Override
    public void setConfigConnectionProps(Configuration config, Properties props, ClassLoader classLoader) {
        this.configureKerberosIfRequired(config, props, classLoader);
    }

    private void configureKerberosIfRequired(Configuration config, Properties props, ClassLoader classLoader) {
        if (config != null && !config.getOracleKerberosConfigFile().isEmpty()) {
            String authServices = ClassUtils.getStaticFieldValue("oracle.jdbc.OracleConnection", "CONNECTION_PROPERTY_THIN_NET_AUTHENTICATION_SERVICES", classLoader);
            props.setProperty(authServices, "( KERBEROS5 )");
            String krb5Mutual = ClassUtils.getStaticFieldValue("oracle.jdbc.OracleConnection", "CONNECTION_PROPERTY_THIN_NET_AUTHENTICATION_KRB5_MUTUAL", classLoader);
            props.setProperty(krb5Mutual, "true");
            String krb5CcCache = ClassUtils.getStaticFieldValue("oracle.jdbc.OracleConnection", "CONNECTION_PROPERTY_THIN_NET_AUTHENTICATION_KRB5_CC_NAME", classLoader);
            String cacheFile = config.getOracleKerberosCacheFile();
            if (cacheFile != null && !config.getOracleKerberosCacheFile().isEmpty()) {
                props.setProperty(krb5CcCache, config.getOracleKerberosCacheFile());
            }
            System.setProperty("java.security.krb5.conf", config.getOracleKerberosConfigFile());
            LOG.debug("Enabling Kerberos support - configuration " + config.getOracleKerberosConfigFile());
        }
    }

    @Override
    public boolean detectUserRequiredByUrl(String url) {
        return !usernamePasswordPattern.matcher(url).matches();
    }

    @Override
    public boolean detectPasswordRequiredByUrl(String url) {
        if (url.startsWith("jdbc-secretsmanager:oracle:")) {
            return false;
        }
        return !usernamePasswordPattern.matcher(url).matches();
    }
}

