/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.enterprise.spanner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.jdbc.JdbcNullTypes;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class SpannerJdbcTemplate
extends JdbcTemplate {
    public SpannerJdbcTemplate(Connection connection) {
        super(connection, DatabaseTypeRegister.getDatabaseTypeForConnection(connection));
    }

    @Override
    protected PreparedStatement prepareStatement(String sql, Object[] params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                statement.setNull(i + 1, this.nullType);
                continue;
            }
            if (params[i] instanceof Integer) {
                statement.setInt(i + 1, (Integer)params[i]);
                continue;
            }
            if (params[i] instanceof Boolean) {
                statement.setBoolean(i + 1, (Boolean)params[i]);
                continue;
            }
            if (params[i] instanceof String) {
                statement.setString(i + 1, params[i].toString());
                continue;
            }
            if (params[i] == JdbcNullTypes.StringNull) {
                statement.setNull(i + 1, -9);
                continue;
            }
            if (params[i] == JdbcNullTypes.IntegerNull) {
                statement.setNull(i + 1, 4);
                continue;
            }
            if (params[i] == JdbcNullTypes.BooleanNull) {
                statement.setNull(i + 1, 16);
                continue;
            }
            throw new FlywayException("Unhandled object of type '" + params[i].getClass().getName() + "'. Please contact support or leave an issue on GitHub.");
        }
        return statement;
    }
}

