/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.beta.gcp.spanner;

import java.sql.Connection;
import org.flywaydb.beta.gcp.spanner.SpannerDatabase;
import org.flywaydb.beta.gcp.spanner.SpannerParser;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;

public class SpannerDatabaseType
extends BaseDatabaseType {
    public String getName() {
        return "Google Cloud Spanner";
    }

    public int getNullType() {
        return 0;
    }

    public int getPriority() {
        return -1;
    }

    public boolean supportsReadOnlyTransactions() {
        return true;
    }

    public boolean handlesJDBCUrl(String url) {
        boolean gcpBeta = false;
        try {
            gcpBeta = Boolean.parseBoolean(System.getenv("flyway.googleCloudPlatformBeta"));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOG.debug("flyway.googleCloudPlatformBeta property missing or of illegal value");
        }
        return (url.startsWith("jdbc:cloudspanner:") || url.startsWith("jdbc:p6spy:cloudspanner:")) && gcpBeta;
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:cloudspanner:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "com.google.cloud.spanner.jdbc.JdbcDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.contains("Google Cloud Spanner");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new SpannerDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new SpannerParser(configuration, parsingContext);
    }

    public boolean detectUserRequiredByUrl(String url) {
        return !url.contains("credentials=");
    }

    public boolean detectPasswordRequiredByUrl(String url) {
        return !url.contains("credentials=");
    }
}

