/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.output;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.output.InfoOutput;
import org.flywaydb.core.internal.output.MigrationOutput;

public class InfoOutputFactory {
    public InfoOutput create(Configuration configuration, MigrationInfo[] migrationInfos, MigrationInfo current) {
        String databaseName = this.getDatabaseName(configuration);
        Set<MigrationVersion> undoableVersions = InfoOutputFactory.getUndoableVersions(migrationInfos);
        migrationInfos = InfoOutputFactory.removeAvailableUndos(migrationInfos);
        ArrayList<MigrationOutput> migrationOutputs = new ArrayList<MigrationOutput>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            migrationOutputs.add(this.createMigrationOutput(undoableVersions, migrationInfo));
        }
        MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
        MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
        String schemaVersion = schemaVersionToOutput.getVersion();
        String flywayVersion = VersionPrinter.getVersion();
        return new InfoOutput(flywayVersion, databaseName, schemaVersion, this.join(", ", configuration.getSchemas()), migrationOutputs);
    }

    private String getDatabaseName(Configuration configuration) {
        try {
            Connection connection = configuration.getDataSource().getConnection();
            String catalog = connection.getCatalog();
            connection.close();
            return catalog;
        }
        catch (Exception e) {
            return "";
        }
    }

    private MigrationOutput createMigrationOutput(Set<MigrationVersion> undoableVersions, MigrationInfo migrationInfo) {
        return new MigrationOutput(this.getCategory(migrationInfo), migrationInfo.getVersion() != null ? migrationInfo.getVersion().getVersion() : "", migrationInfo.getDescription(), migrationInfo.getType() != null ? migrationInfo.getType().toString() : "", migrationInfo.getInstalledOn() != null ? migrationInfo.getInstalledOn().toString() : "", migrationInfo.getState().getDisplayName(), InfoOutputFactory.getUndoableStatus(migrationInfo, undoableVersions), migrationInfo.getPhysicalLocation() != null ? migrationInfo.getPhysicalLocation() : "", migrationInfo.getInstalledBy() != null ? migrationInfo.getInstalledBy() : "", migrationInfo.getExecutionTime() != null ? migrationInfo.getExecutionTime() : 0);
    }

    private String join(String joiner, String[] strings) {
        if (strings.length == 1) {
            return strings[0];
        }
        StringBuilder output = new StringBuilder();
        for (String s : strings) {
            output.append(s).append(joiner);
        }
        return output.toString();
    }

    private static String getUndoableStatus(MigrationInfo migrationInfo, Set<MigrationVersion> undoableVersions) {
        if (migrationInfo.getVersion() != null && !migrationInfo.getType().isUndo() && !migrationInfo.getState().equals((Object)MigrationState.UNDONE)) {
            if (!migrationInfo.getState().isFailed() && undoableVersions.contains(migrationInfo.getVersion())) {
                return "Yes";
            }
            return "No";
        }
        return "";
    }

    private static Set<MigrationVersion> getUndoableVersions(MigrationInfo[] migrationInfos) {
        HashSet<MigrationVersion> result = new HashSet<MigrationVersion>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            if (!migrationInfo.getType().isUndo()) continue;
            result.add(migrationInfo.getVersion());
        }
        return result;
    }

    private static MigrationInfo[] removeAvailableUndos(MigrationInfo[] migrationInfos) {
        ArrayList<MigrationInfo> result = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            if (migrationInfo.getState().equals((Object)MigrationState.AVAILABLE)) continue;
            result.add(migrationInfo);
        }
        return result.toArray(new MigrationInfo[0]);
    }

    private String getCategory(MigrationInfo migrationInfo) {
        if (migrationInfo.getType().isSynthetic()) {
            return "";
        }
        if (migrationInfo.getVersion() == null) {
            return "Repeatable";
        }
        if (migrationInfo.getType().isUndo()) {
            return "Undo";
        }
        return "Versioned";
    }
}

