/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.platform.win32.WinNT;
import java.util.List;

public interface NTSecApi {
    public static final int ForestTrustTopLevelName = 0;
    public static final int ForestTrustTopLevelNameEx = 1;
    public static final int ForestTrustDomainInfo = 2;

    public static class PLSA_FOREST_TRUST_INFORMATION
    extends Structure {
        public static final List<String> FIELDS = PLSA_FOREST_TRUST_INFORMATION.createFieldsOrder((String)"fti");
        public LSA_FOREST_TRUST_INFORMATION.ByReference fti;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends PLSA_FOREST_TRUST_INFORMATION
        implements Structure.ByReference {
        }
    }

    public static class LSA_FOREST_TRUST_INFORMATION
    extends Structure {
        public static final List<String> FIELDS = LSA_FOREST_TRUST_INFORMATION.createFieldsOrder((String[])new String[]{"RecordCount", "Entries"});
        public int RecordCount;
        public PLSA_FOREST_TRUST_RECORD.ByReference Entries;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public PLSA_FOREST_TRUST_RECORD[] getEntries() {
            return (PLSA_FOREST_TRUST_RECORD[])this.Entries.toArray(this.RecordCount);
        }

        public static class ByReference
        extends LSA_FOREST_TRUST_INFORMATION
        implements Structure.ByReference {
        }
    }

    public static class PLSA_FOREST_TRUST_RECORD
    extends Structure {
        public static final List<String> FIELDS = PLSA_FOREST_TRUST_RECORD.createFieldsOrder((String)"tr");
        public LSA_FOREST_TRUST_RECORD.ByReference tr;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public static class ByReference
        extends PLSA_FOREST_TRUST_RECORD
        implements Structure.ByReference {
        }
    }

    public static class LSA_FOREST_TRUST_RECORD
    extends Structure {
        public static final List<String> FIELDS = LSA_FOREST_TRUST_RECORD.createFieldsOrder((String[])new String[]{"Flags", "ForestTrustType", "Time", "u"});
        public int Flags;
        public int ForestTrustType;
        public WinNT.LARGE_INTEGER Time;
        public UNION u;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public void read() {
            super.read();
            switch (this.ForestTrustType) {
                case 0: 
                case 1: {
                    this.u.setType(LSA_UNICODE_STRING.class);
                    break;
                }
                case 2: {
                    this.u.setType(LSA_FOREST_TRUST_DOMAIN_INFO.class);
                    break;
                }
                default: {
                    this.u.setType(LSA_FOREST_TRUST_BINARY_DATA.class);
                }
            }
            this.u.read();
        }

        public static class UNION
        extends Union {
            public LSA_UNICODE_STRING TopLevelName;
            public LSA_FOREST_TRUST_DOMAIN_INFO DomainInfo;
            public LSA_FOREST_TRUST_BINARY_DATA Data;

            public static class ByReference
            extends UNION
            implements Structure.ByReference {
            }
        }

        public static class ByReference
        extends LSA_FOREST_TRUST_RECORD
        implements Structure.ByReference {
        }
    }

    public static class LSA_FOREST_TRUST_BINARY_DATA
    extends Structure {
        public static final List<String> FIELDS = LSA_FOREST_TRUST_BINARY_DATA.createFieldsOrder((String[])new String[]{"Length", "Buffer"});
        public int Length;
        public Pointer Buffer;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }
    }

    public static class LSA_FOREST_TRUST_DOMAIN_INFO
    extends Structure {
        public static final List<String> FIELDS = LSA_FOREST_TRUST_DOMAIN_INFO.createFieldsOrder((String[])new String[]{"Sid", "DnsName", "NetbiosName"});
        public WinNT.PSID.ByReference Sid;
        public LSA_UNICODE_STRING DnsName;
        public LSA_UNICODE_STRING NetbiosName;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }
    }

    public static class PLSA_UNICODE_STRING {
        public LSA_UNICODE_STRING.ByReference s;

        public static class ByReference
        extends PLSA_UNICODE_STRING
        implements Structure.ByReference {
        }
    }

    public static class LSA_UNICODE_STRING
    extends Structure {
        public static final List<String> FIELDS = LSA_UNICODE_STRING.createFieldsOrder((String[])new String[]{"Length", "MaximumLength", "Buffer"});
        public short Length;
        public short MaximumLength;
        public Pointer Buffer;

        protected List<String> getFieldOrder() {
            return FIELDS;
        }

        public String getString() {
            byte[] data = this.Buffer.getByteArray(0L, (int)this.Length);
            if (data.length < 2 || data[data.length - 1] != 0) {
                Memory newdata = new Memory((long)(data.length + 2));
                newdata.write(0L, data, 0, data.length);
                return newdata.getWideString(0L);
            }
            return this.Buffer.getWideString(0L);
        }

        public static class ByReference
        extends LSA_UNICODE_STRING
        implements Structure.ByReference {
        }
    }
}

