/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBResourceTransactionException;
import org.firebirdsql.jca.FirebirdLocalTransaction;
import org.firebirdsql.jdbc.FBConnection;

public class FBLocalTransaction
implements FirebirdLocalTransaction,
LocalTransaction {
    protected final FBManagedConnection mc;
    protected Xid xid = null;
    protected final ConnectionEvent beginEvent;
    protected final ConnectionEvent commitEvent;
    protected final ConnectionEvent rollbackEvent;

    public FBLocalTransaction(FBManagedConnection mc, FBConnection c) {
        this.mc = mc;
        if (c == null) {
            this.beginEvent = null;
            this.commitEvent = null;
            this.rollbackEvent = null;
        } else {
            this.beginEvent = new ConnectionEvent((ManagedConnection)mc, 2, null);
            this.beginEvent.setConnectionHandle((Object)c);
            this.commitEvent = new ConnectionEvent((ManagedConnection)mc, 3, null);
            this.commitEvent.setConnectionHandle((Object)c);
            this.rollbackEvent = new ConnectionEvent((ManagedConnection)mc, 4, null);
            this.rollbackEvent.setConnectionHandle((Object)c);
        }
    }

    @Override
    public Xid getXid() {
        return this.xid;
    }

    @Override
    public boolean inTransaction() throws ResourceException {
        try {
            return this.mc.getGDSHelper().inTransaction();
        }
        catch (SQLException ex) {
            throw new FBResourceException(ex);
        }
    }

    public void begin() throws ResourceException {
        this.internalBegin();
    }

    public void internalBegin() throws ResourceException {
        if (this.xid != null && this.mc.isXidActive(this.xid)) {
            throw new FBResourceTransactionException("Local transaction active: can't begin another", "25S02");
        }
        this.xid = new FBLocalXid();
        try {
            this.mc.internalStart(this.xid, 0);
        }
        catch (SQLException | XAException ex) {
            this.xid = null;
            throw new FBResourceException(ex);
        }
        if (this.beginEvent != null) {
            this.mc.notify(FBManagedConnection.localTransactionStartedNotifier, this.beginEvent);
        }
    }

    public void commit() throws ResourceException {
        this.internalCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCommit() throws ResourceException {
        if (this.xid == null) {
            return;
        }
        Object object = this.mc.getSynchronizationObject();
        synchronized (object) {
            try {
                this.mc.internalEnd(this.xid, 0x4000000);
                this.mc.internalCommit(this.xid, true);
            }
            catch (XAException ex) {
                throw new FBResourceTransactionException(ex.getMessage(), ex);
            }
            catch (SQLException ex) {
                throw new FBResourceException(ex);
            }
            finally {
                this.xid = null;
            }
            if (this.commitEvent != null) {
                this.mc.notify(FBManagedConnection.localTransactionCommittedNotifier, this.commitEvent);
            }
        }
    }

    public void rollback() throws ResourceException {
        this.internalRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalRollback() throws ResourceException {
        if (this.xid == null) {
            return;
        }
        Object object = this.mc.getSynchronizationObject();
        synchronized (object) {
            try {
                this.mc.internalEnd(this.xid, 0x4000000);
                this.mc.internalRollback(this.xid);
            }
            catch (SQLException | XAException ex) {
                throw new FBResourceTransactionException(ex.getMessage(), ex);
            }
            finally {
                this.xid = null;
            }
            if (this.rollbackEvent != null) {
                this.mc.notify(FBManagedConnection.localTransactionRolledbackNotifier, this.rollbackEvent);
            }
        }
    }

    public static class FBLocalXid
    implements Xid {
        private static final int formatId = 258;
        private String strValue = "Xid[" + this.hashCode() + "]";

        @Override
        public byte[] getGlobalTransactionId() {
            return null;
        }

        @Override
        public byte[] getBranchQualifier() {
            return null;
        }

        @Override
        public int getFormatId() {
            return 258;
        }

        public String toString() {
            return this.strValue;
        }
    }
}

