/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.FbWireBlob;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;

public abstract class AbstractFbWireBlob
extends AbstractFbBlob
implements FbWireBlob {
    private int blobHandle;

    protected AbstractFbWireBlob(FbWireDatabase database, FbWireTransaction transaction, BlobParameterBuffer blobParameterBuffer) {
        super(database, transaction, blobParameterBuffer);
    }

    @Override
    public FbWireDatabase getDatabase() {
        return (FbWireDatabase)super.getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getHandle() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            return this.blobHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setHandle(int blobHandle) {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.blobHandle = blobHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseBlob(int releaseOperation) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.getDatabase().releaseObject(releaseOperation, this.getHandle());
        }
    }

    @Override
    protected void closeImpl() throws SQLException {
        try {
            this.releaseBlob(39);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void cancelImpl() throws SQLException {
        try {
            this.releaseBlob(38);
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    protected void releaseResources() {
    }

    @Override
    public byte[] getBlobInfo(byte[] requestItems, int bufferLength) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                try {
                    XdrOutputStream xdrOut = this.getDatabase().getXdrStreamAccess().getXdrOut();
                    xdrOut.writeInt(43);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(0);
                    xdrOut.writeBuffer(requestItems);
                    xdrOut.writeInt(bufferLength);
                    xdrOut.flush();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    GenericResponse response = this.getDatabase().readGenericResponse(null);
                    return response.getData();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }
}

