/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSFactoryPlugin;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbDatabaseFactory;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class GDSFactory {
    private static Logger log = LoggerFactory.getLogger(GDSFactory.class);
    private static final Set<GDSFactoryPlugin> registeredPlugins = new HashSet<GDSFactoryPlugin>();
    private static final Map<GDSType, GDSFactoryPlugin> typeToPluginMap = new HashMap<GDSType, GDSFactoryPlugin>();
    private static final TreeMap<String, GDSFactoryPlugin> jdbcUrlToPluginMap = new TreeMap(new ReversedStringComparator());
    private static GDSType defaultType;

    private static List<ClassLoader> classLoadersForLoading() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(2);
        ClassLoader classLoader = GDSFactoryPlugin.class.getClassLoader();
        if (classLoader != null) {
            classLoaders.add(classLoader);
        } else {
            classLoaders.add(ClassLoader.getSystemClassLoader());
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && !classLoaders.contains(contextClassLoader)) {
            classLoaders.add(contextClassLoader);
        }
        return classLoaders;
    }

    private static void loadPluginsFromClassLoader(ClassLoader classLoader) {
        ServiceLoader<GDSFactoryPlugin> pluginLoader = ServiceLoader.load(GDSFactoryPlugin.class, classLoader);
        Iterator<GDSFactoryPlugin> pluginIterator = pluginLoader.iterator();
        while (pluginIterator.hasNext()) {
            try {
                GDSFactoryPlugin plugin = pluginIterator.next();
                GDSFactory.registerPlugin(plugin);
            }
            catch (Exception | ServiceConfigurationError e) {
                log.error("Can't register plugin (skipping): " + e.getMessage(), e);
            }
        }
    }

    private static void loadPluginsFallback(ClassLoader classLoader) {
        String[] pluginClasses;
        for (String className : pluginClasses = new String[]{"org.firebirdsql.gds.impl.wire.WireGDSFactoryPlugin", "org.firebirdsql.gds.impl.jni.NativeGDSFactoryPlugin", "org.firebirdsql.gds.impl.jni.LocalGDSFactoryPlugin", "org.firebirdsql.gds.impl.jni.EmbeddedGDSFactoryPlugin", "org.firebirdsql.gds.impl.oo.OOGDSFactoryPlugin"}) {
            GDSFactory.loadPlugin(className, classLoader);
        }
    }

    private static void loadPlugin(String className, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            GDSFactoryPlugin plugin = (GDSFactoryPlugin)clazz.newInstance();
            GDSFactory.registerPlugin(plugin);
        }
        catch (Exception ex) {
            log.error("Can't register plugin " + className, ex);
        }
    }

    public static void registerPlugin(GDSFactoryPlugin plugin) {
        String[] jdbcUrls;
        String[] aliases;
        boolean newPlugin = registeredPlugins.add(plugin);
        if (!newPlugin) {
            return;
        }
        GDSType type = GDSType.registerType(plugin.getTypeName());
        typeToPluginMap.put(type, plugin);
        if (defaultType == null) {
            defaultType = type;
        }
        for (String alias : aliases = plugin.getTypeAliases()) {
            GDSType aliasType = GDSType.registerType(alias);
            typeToPluginMap.put(aliasType, plugin);
        }
        for (String jdbcUrl : jdbcUrls = plugin.getSupportedProtocols()) {
            GDSFactoryPlugin otherPlugin = jdbcUrlToPluginMap.put(jdbcUrl, plugin);
            if (otherPlugin == null || otherPlugin.equals(plugin)) continue;
            throw new IllegalArgumentException("Duplicate JDBC URL pattern detected: URL " + jdbcUrl + ", plugin " + plugin.getTypeName() + ", other plugin " + otherPlugin.getTypeName());
        }
    }

    public static GDSType getDefaultGDSType() {
        return defaultType;
    }

    public static FbDatabaseFactory getDatabaseFactoryForType(GDSType gdsType) {
        if (gdsType == null) {
            gdsType = defaultType;
        }
        return GDSFactory.getPlugin(gdsType).getDatabaseFactory();
    }

    public static String getDatabasePath(GDSType gdsType, String server, Integer port, String path) throws GDSException {
        return GDSFactory.getPlugin(gdsType).getDatabasePath(server, port, path);
    }

    public static String getDatabasePath(GDSType gdsType, String jdbcUrl) throws GDSException {
        return GDSFactory.getPlugin(gdsType).getDatabasePath(jdbcUrl);
    }

    public static Set<String> getSupportedProtocols() {
        return Collections.unmodifiableSet(jdbcUrlToPluginMap.keySet());
    }

    public static String getJdbcUrl(GDSType gdsType, String databasePath) {
        return GDSFactory.getPlugin(gdsType).getDefaultProtocol() + databasePath;
    }

    public static GDSType getTypeForProtocol(String jdbcUrl) {
        for (Map.Entry<String, GDSFactoryPlugin> entry : jdbcUrlToPluginMap.entrySet()) {
            String jdbcProtocol = entry.getKey();
            if (!jdbcUrl.startsWith(jdbcProtocol)) continue;
            return GDSType.getType(entry.getValue().getTypeName());
        }
        return null;
    }

    public static Class<?> getConnectionClass(GDSType gdsType) {
        return GDSFactory.getPlugin(gdsType).getConnectionClass();
    }

    private static GDSFactoryPlugin getPlugin(GDSType gdsType) {
        GDSFactoryPlugin gdsPlugin = typeToPluginMap.get(gdsType);
        if (gdsPlugin == null) {
            throw new IllegalArgumentException("Specified GDS type " + gdsType + " is unknown.");
        }
        return gdsPlugin;
    }

    static {
        List<ClassLoader> classLoaders = GDSFactory.classLoadersForLoading();
        try {
            for (ClassLoader classLoader : classLoaders) {
                GDSFactory.loadPluginsFromClassLoader(classLoader);
            }
        }
        catch (Exception ex) {
            log.error("Can't register plugins ", ex);
        }
        if (jdbcUrlToPluginMap.isEmpty()) {
            log.warn("No plugins loaded from META-INF/services, falling back to fixed registration of default plugins");
            for (ClassLoader classLoader : classLoaders) {
                GDSFactory.loadPluginsFallback(classLoader);
            }
        }
    }

    private static class ReversedStringComparator
    implements Comparator<String>,
    Serializable {
        private ReversedStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s2.compareTo(s1);
        }
    }
}

