/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.management.BackupManager;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.PageSizeConstants;

public abstract class FBBackupManagerBase
extends FBServiceManager
implements BackupManager {
    protected boolean noLimitRestore = false;
    protected List<PathSizeStruct> restorePaths = new ArrayList<PathSizeStruct>();
    protected boolean verbose = false;
    private int restoreBufferCount = -1;
    private int restorePageSize = -1;
    private boolean restoreReadOnly = false;
    private boolean restoreReplace = false;
    private static final int RESTORE_REPLACE = 4096;
    private static final int RESTORE_CREATE = 8192;

    public FBBackupManagerBase() {
    }

    public FBBackupManagerBase(String gdsType) {
        super(gdsType);
    }

    public FBBackupManagerBase(GDSType gdsType) {
        super(gdsType);
    }

    @Override
    public void addBackupPath(String path) {
        this.addBackupPath(path, -1);
    }

    @Override
    public void setDatabase(String database) {
        super.setDatabase(database);
        this.addRestorePath(database, -1);
        this.noLimitRestore = true;
    }

    @Override
    public void addRestorePath(String path, int size) {
        if (this.noLimitRestore) {
            throw new IllegalArgumentException("You cannot use setDatabase(String) and addRestorePath(String, int) methods simultaneously.");
        }
        this.restorePaths.add(new PathSizeStruct(path, size));
    }

    @Override
    public void clearRestorePaths() {
        this.restorePaths.clear();
        this.noLimitRestore = false;
    }

    @Override
    public void backupDatabase() throws SQLException {
        this.backupDatabase(0);
    }

    @Override
    public void backupMetadata() throws SQLException {
        this.backupDatabase(4);
    }

    protected ServiceRequestBuffer getBackupSRB(FbService service, int options) throws SQLException {
        ServiceRequestBuffer backupSPB = service.createServiceRequestBuffer();
        backupSPB.addArgument(1);
        backupSPB.addArgument(106, this.getDatabase());
        this.addBackupsToBackupRequestBuffer(service, backupSPB);
        if (this.verboseBackup()) {
            backupSPB.addArgument(107);
        }
        backupSPB.addArgument(108, options);
        return backupSPB;
    }

    @Override
    public void restoreDatabase() throws SQLException {
        this.restoreDatabase(0);
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void setRestorePageBufferCount(int bufferCount) {
        if (bufferCount < 0) {
            throw new IllegalArgumentException("Buffer count must be positive");
        }
        this.restoreBufferCount = bufferCount;
    }

    @Override
    public void setRestorePageSize(int pageSize) {
        this.restorePageSize = PageSizeConstants.requireValidPageSize(pageSize);
    }

    @Override
    public void setRestoreReplace(boolean replace) {
        this.restoreReplace = replace;
    }

    @Override
    public void setRestoreReadOnly(boolean readOnly) {
        this.restoreReadOnly = readOnly;
    }

    protected ServiceRequestBuffer getRestoreSRB(FbService service, int options) {
        ServiceRequestBuffer restoreSPB = service.createServiceRequestBuffer();
        restoreSPB.addArgument(2);
        Iterator<PathSizeStruct> iter = this.restorePaths.iterator();
        while (iter.hasNext()) {
            PathSizeStruct pathSize = iter.next();
            restoreSPB.addArgument(106, pathSize.getPath());
            if (!iter.hasNext() || pathSize.getSize() == -1) continue;
            restoreSPB.addArgument(11, pathSize.getSize());
        }
        this.addBackupsToRestoreRequestBuffer(service, restoreSPB);
        if (this.restoreBufferCount != -1) {
            restoreSPB.addArgument(9, this.restoreBufferCount);
        }
        if (this.restorePageSize != -1) {
            restoreSPB.addArgument(10, this.restorePageSize);
        }
        restoreSPB.addArgument(12, (byte)(this.restoreReadOnly ? 39 : 40));
        if (this.verbose) {
            restoreSPB.addArgument(107);
        }
        if ((options & 0x2000) != 8192 && (options & 0x1000) != 4096) {
            options |= this.restoreReplace ? 4096 : 8192;
        }
        restoreSPB.addArgument(108, options);
        return restoreSPB;
    }

    protected abstract void addBackupsToBackupRequestBuffer(FbService var1, ServiceRequestBuffer var2) throws SQLException;

    protected abstract void addBackupsToRestoreRequestBuffer(FbService var1, ServiceRequestBuffer var2);

    protected abstract boolean verboseBackup();

    protected static class PathSizeStruct {
        private int size;
        private String path;

        protected PathSizeStruct(String path, int size) {
            this.path = path;
            this.size = size;
        }

        public String getPath() {
            return this.path;
        }

        public int getSize() {
            return this.size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PathSizeStruct)) {
                return false;
            }
            PathSizeStruct that = (PathSizeStruct)obj;
            return this.path.equals(that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.path + " " + this.size;
        }
    }
}

