/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.util.BomFilter;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class ChecksumCalculator {
    private ChecksumCalculator() {
    }

    public static int calculate(LoadableResource ... loadableResources) {
        int checksum;
        if (loadableResources.length == 1) {
            checksum = ChecksumCalculator.calculateChecksumForReader(loadableResources[0].read());
        } else {
            CRC32 crc32 = new CRC32();
            for (LoadableResource resource : loadableResources) {
                crc32.update(ChecksumCalculator.intToByteArray(ChecksumCalculator.calculateChecksumForReader(resource.read())));
            }
            checksum = (int)crc32.getValue();
        }
        return checksum;
    }

    private static int calculateChecksumForReader(Reader reader) {
        CRC32 crc32 = new CRC32();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(reader, 4096);
            String line = bufferedReader.readLine();
            if (line != null) {
                line = BomFilter.FilterBomFromString(line);
                do {
                    crc32.update(StringUtils.trimLineBreak(line).getBytes(StandardCharsets.UTF_8));
                } while ((line = bufferedReader.readLine()) != null);
            }
        }
        catch (IOException e) {
            try {
                throw new FlywayException("Unable to calculate checksum " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.close(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.close(bufferedReader);
        return (int)crc32.getValue();
    }

    private static byte[] intToByteArray(int i) {
        return new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
    }
}

