/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class TimestampltzAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 11;

    TimestampltzAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.TIMESTAMPLTZ, oracleStatement, 11, bl);
        this.init(oracleStatement, 231, 231, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    TimestampltzAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        super(Representation.TIMESTAMPLTZ, oracleStatement, 11, false);
        this.init(oracleStatement, 231, 231, s2, false);
        this.initForDescribe(231, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        Calendar calendar2 = Calendar.getInstance(timeZone);
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        calendar.set(14, 0);
        oracle.sql.TIMESTAMPLTZ.TimeZoneAdjust(this.statement.connection, calendar, calendar2);
        n3 = calendar2.get(1);
        int n4 = calendar2.get(2) + 1;
        int n5 = calendar2.get(5);
        int n6 = calendar2.get(11);
        int n7 = calendar2.get(12);
        int n8 = calendar2.get(13);
        int n9 = 0;
        boolean bl = n6 < 12;
        String string2 = calendar2.getTimeZone().getID();
        if (string2.length() > 3 && string2.startsWith("GMT")) {
            string2 = string2.substring(3);
        }
        if (this.getLength(n2) == 11) {
            n9 = this.oracleNanos(this.tmpBytes);
        }
        return this.toText(n3, n4, n5, n6, n7, n8, n9, bl, string2);
    }

    @Override
    Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDate(n2);
    }

    @Override
    Date getDate(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        calendar.set(14, 0);
        long l2 = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, calendar);
        return new Date(l2);
    }

    @Override
    Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTime(n2);
    }

    @Override
    Time getTime(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        calendar.set(14, 0);
        long l2 = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, calendar);
        return new Time(l2);
    }

    @Override
    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestamp(n2);
    }

    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        Calendar calendar = this.statement.connection.getDbTzCalendar();
        String string = this.statement.connection.getSessionTimeZone();
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 198).fillInStackTrace();
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.oracleYear(this.tmpBytes);
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(this.tmpBytes));
        calendar.set(5, this.oracleDay(this.tmpBytes));
        calendar.set(11, this.oracleHour(this.tmpBytes));
        calendar.set(12, this.oracleMin(this.tmpBytes));
        calendar.set(13, this.oracleSec(this.tmpBytes));
        calendar.set(14, 0);
        long l2 = oracle.sql.TIMESTAMPLTZ.TimeZoneAdjustUTC(this.statement.connection, calendar);
        Timestamp timestamp = new Timestamp(l2);
        if (this.getLength(n2) == 11) {
            timestamp.setNanos(this.oracleNanos(this.tmpBytes));
        }
        return timestamp;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getTIMESTAMPLTZ(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getTIMESTAMPLTZ(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getTIMESTAMPLTZ(n2);
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        return new TIMESTAMPLTZ(this.getBytesInternal(n2));
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        return oracle.sql.TIMESTAMPLTZ.toTIMESTAMPTZ(this.statement.connection, this.getBytesInternal(n2));
    }

    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        TIMESTAMPTZ tIMESTAMPTZ = this.getTIMESTAMPTZ(n2);
        return oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tIMESTAMPTZ.getBytes());
    }

    @Override
    DATE getDATE(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        TIMESTAMPTZ tIMESTAMPTZ = this.getTIMESTAMPTZ(n2);
        return oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tIMESTAMPTZ.getBytes());
    }
}

