/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.read.resultset;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.mariadb.jdbc.MariaDbBlob;
import org.mariadb.jdbc.MariaDbClob;
import org.mariadb.jdbc.MariaDbResultSetMetaData;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.read.ErrorPacket;
import org.mariadb.jdbc.internal.com.read.dao.ColumnNameMap;
import org.mariadb.jdbc.internal.com.read.dao.Results;
import org.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.BinaryRowProtocol;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.RowProtocol;
import org.mariadb.jdbc.internal.com.read.resultset.rowprotocol.TextRowProtocol;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.input.StandardPacketInputStream;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.SqlStates;
import org.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class SelectResultSet
implements ResultSet {
    public static final int TINYINT1_IS_BIT = 1;
    public static final int YEAR_IS_DATE_TYPE = 2;
    private static final String NOT_UPDATABLE_ERROR = "Updates are not supported when using ResultSet.CONCUR_READ_ONLY";
    private static final ColumnInformation[] INSERT_ID_COLUMNS = new ColumnInformation[1];
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected TimeZone timeZone;
    protected Options options;
    protected ColumnInformation[] columnsInformation;
    protected int columnInformationLength;
    protected boolean noBackslashEscapes;
    private Protocol protocol;
    private PacketInputStream reader;
    private boolean isEof;
    private boolean callableResult;
    private MariaDbStatement statement;
    private RowProtocol row;
    private int dataFetchTime;
    private boolean streaming;
    private byte[][] data;
    private int dataSize;
    private int fetchSize;
    private int resultSetScrollType;
    private int rowPointer;
    private ColumnNameMap columnNameMap;
    private int lastRowPointer = -1;
    private int dataTypeMappingFlags;
    private boolean returnTableAlias;
    private boolean isClosed;
    private boolean eofDeprecated;
    private ReentrantLock lock;

    public SelectResultSet(ColumnInformation[] columnInformation, Results results, Protocol protocol, PacketInputStream reader, boolean callableResult, boolean eofDeprecated) throws IOException, SQLException {
        this.statement = results.getStatement();
        this.isClosed = false;
        this.protocol = protocol;
        this.options = protocol.getOptions();
        this.noBackslashEscapes = protocol.noBackslashEscapes();
        this.returnTableAlias = this.options.useOldAliasMetadataBehavior;
        this.columnsInformation = columnInformation;
        this.columnNameMap = new ColumnNameMap(this.columnsInformation);
        this.columnInformationLength = columnInformation.length;
        this.reader = reader;
        this.isEof = false;
        this.timeZone = protocol.getTimeZone();
        this.row = results.isBinaryFormat() ? new BinaryRowProtocol(this.columnsInformation, this.columnInformationLength, results.getMaxFieldSize(), this.options) : new TextRowProtocol(results.getMaxFieldSize(), this.options);
        this.fetchSize = results.getFetchSize();
        this.resultSetScrollType = results.getResultSetScrollType();
        this.dataSize = 0;
        this.dataFetchTime = 0;
        this.rowPointer = -1;
        this.callableResult = callableResult;
        this.eofDeprecated = eofDeprecated;
        if (this.fetchSize == 0 || callableResult) {
            this.data = new byte[10][];
            this.fetchAllResults();
            this.streaming = false;
        } else {
            this.lock = protocol.getLock();
            protocol.setActiveStreamingResult(results);
            protocol.removeHasMoreResults();
            this.data = new byte[Math.max(10, this.fetchSize)][];
            this.nextStreamingValue();
            this.streaming = true;
        }
    }

    public SelectResultSet(ColumnInformation[] columnInformation, List<byte[]> resultSet, Protocol protocol, int resultSetScrollType) {
        this.statement = null;
        this.isClosed = false;
        if (protocol != null) {
            this.options = protocol.getOptions();
            this.timeZone = protocol.getTimeZone();
            this.returnTableAlias = this.options.useOldAliasMetadataBehavior;
        } else {
            this.options = new Options();
            this.timeZone = TimeZone.getDefault();
            this.returnTableAlias = false;
        }
        this.row = new TextRowProtocol(0, this.options);
        this.protocol = null;
        this.columnsInformation = columnInformation;
        this.columnNameMap = new ColumnNameMap(this.columnsInformation);
        this.columnInformationLength = columnInformation.length;
        this.isEof = true;
        this.fetchSize = 0;
        this.resultSetScrollType = resultSetScrollType;
        this.data = (byte[][])resultSet.toArray((T[])new byte[10][]);
        this.dataSize = resultSet.size();
        this.dataFetchTime = 0;
        this.rowPointer = -1;
        this.callableResult = false;
        this.streaming = false;
    }

    public static ResultSet createGeneratedData(long[] data, Protocol protocol, boolean findColumnReturnsOne) {
        ColumnInformation[] columns = new ColumnInformation[]{ColumnInformation.create("insert_id", ColumnType.BIGINT)};
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (long rowData : data) {
            if (rowData == 0L) continue;
            rows.add(StandardPacketInputStream.create(String.valueOf(rowData).getBytes()));
        }
        if (findColumnReturnsOne) {
            return new SelectResultSet(columns, rows, protocol, 1005){

                @Override
                public int findColumn(String name) {
                    return 1;
                }
            };
        }
        return new SelectResultSet(columns, rows, protocol, 1005);
    }

    public static ResultSet createResultSet(String[] columnNames, ColumnType[] columnTypes, String[][] data, Protocol protocol) {
        int columnNameLength = columnNames.length;
        ColumnInformation[] columns = new ColumnInformation[columnNameLength];
        for (int i = 0; i < columnNameLength; ++i) {
            columns[i] = ColumnInformation.create(columnNames[i], columnTypes[i]);
        }
        ArrayList<byte[]> rows = new ArrayList<byte[]>();
        for (String[] rowData : data) {
            assert (rowData.length == columnNameLength);
            byte[][] rowBytes = new byte[rowData.length][];
            for (int i = 0; i < rowData.length; ++i) {
                if (rowData[i] == null) continue;
                rowBytes[i] = rowData[i].getBytes();
            }
            rows.add(StandardPacketInputStream.create(rowBytes, columnTypes));
        }
        return new SelectResultSet(columns, rows, protocol, 1005);
    }

    public static SelectResultSet createEmptyResultSet() {
        return new SelectResultSet(INSERT_ID_COLUMNS, new ArrayList<byte[]>(), null, 1005);
    }

    public boolean isFullyLoaded() {
        return this.isEof;
    }

    private void fetchAllResults() throws IOException, SQLException {
        this.dataSize = 0;
        while (this.readNextValue()) {
        }
        ++this.dataFetchTime;
    }

    public void fetchRemaining() throws SQLException {
        if (!this.isEof) {
            this.lock.lock();
            try {
                this.lastRowPointer = -1;
                while (!this.isEof) {
                    this.addStreamingValue();
                }
            }
            catch (SQLException queryException) {
                throw ExceptionMapper.getException(queryException, null, this.statement, false);
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
            }
            ++this.dataFetchTime;
        }
    }

    private SQLException handleIoException(IOException ioe) {
        return ExceptionMapper.getException(new SQLException("Server has closed the connection. If result set contain huge amount of data, Server expects client to read off the result set relatively fast. In this case, please consider increasing net_wait_timeout session variable / processing your result set faster (check Streaming result sets documentation for more information)", SqlStates.CONNECTION_EXCEPTION.getSqlState(), ioe), null, this.statement, false);
    }

    private void nextStreamingValue() throws IOException, SQLException {
        this.lastRowPointer = -1;
        if (this.resultSetScrollType == 1003) {
            this.dataSize = 0;
        }
        this.addStreamingValue();
    }

    private void addStreamingValue() throws IOException, SQLException {
        for (int fetchSizeTmp = this.fetchSize; fetchSizeTmp > 0 && this.readNextValue(); --fetchSizeTmp) {
        }
        ++this.dataFetchTime;
    }

    private boolean readNextValue() throws IOException, SQLException {
        byte[] buf = this.reader.getPacketArray(false);
        if (buf[0] == -1) {
            this.protocol.removeActiveStreamingResult();
            this.protocol.removeHasMoreResults();
            this.protocol.setHasWarnings(false);
            ErrorPacket errorPacket = new ErrorPacket(new Buffer(buf));
            this.resetVariables();
            throw ExceptionMapper.get(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorNumber(), null, false);
        }
        if (buf[0] == -2 && (this.eofDeprecated && buf.length < 0xFFFFFF || !this.eofDeprecated && buf.length < 8)) {
            int serverStatus;
            int warnings;
            if (!this.eofDeprecated) {
                warnings = (buf[1] & 0xFF) + ((buf[2] & 0xFF) << 8);
                serverStatus = (buf[3] & 0xFF) + ((buf[4] & 0xFF) << 8);
                if (this.callableResult) {
                    serverStatus |= 8;
                }
            } else {
                int pos = this.skipLengthEncodedValue(buf, 1);
                pos = this.skipLengthEncodedValue(buf, pos);
                serverStatus = (buf[pos++] & 0xFF) + ((buf[pos++] & 0xFF) << 8);
                warnings = (buf[pos++] & 0xFF) + ((buf[pos] & 0xFF) << 8);
                this.callableResult = (serverStatus & 0x1000) != 0;
            }
            this.protocol.setServerStatus((short)serverStatus);
            this.protocol.setHasWarnings(warnings > 0);
            if ((serverStatus & 8) == 0) {
                this.protocol.removeActiveStreamingResult();
            }
            this.resetVariables();
            return false;
        }
        if (this.dataSize + 1 >= this.data.length) {
            this.growDataArray();
        }
        this.data[this.dataSize++] = buf;
        return true;
    }

    protected byte[] getCurrentRowData() {
        return this.data[this.rowPointer];
    }

    protected void updateRowData(byte[] rawData) {
        this.data[this.rowPointer] = rawData;
        this.row.resetRow(this.data[this.rowPointer]);
    }

    protected void deleteCurrentRowData() throws SQLException {
        System.arraycopy(this.data, this.rowPointer + 1, this.data, this.rowPointer, this.dataSize - 1 - this.rowPointer);
        this.data[this.dataSize - 1] = null;
        --this.dataSize;
        this.lastRowPointer = -1;
        this.previous();
    }

    protected void addRowData(byte[] rawData) {
        if (this.dataSize + 1 >= this.data.length) {
            this.growDataArray();
        }
        this.data[this.dataSize] = rawData;
        this.rowPointer = this.dataSize++;
    }

    private int skipLengthEncodedValue(byte[] buf, int pos) {
        int type = buf[pos++] & 0xFF;
        switch (type) {
            case 251: {
                return pos;
            }
            case 252: {
                return pos + 2 + (0xFFFF & (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8));
            }
            case 253: {
                return pos + 3 + (0xFFFFFF & (buf[pos] & 0xFF) + ((buf[pos + 1] & 0xFF) << 8) + ((buf[pos + 2] & 0xFF) << 16));
            }
            case 254: {
                return (int)((long)(pos + 8) + ((long)(buf[pos] & 0xFF) + ((long)(buf[pos + 1] & 0xFF) << 8) + ((long)(buf[pos + 2] & 0xFF) << 16) + ((long)(buf[pos + 3] & 0xFF) << 24) + ((long)(buf[pos + 4] & 0xFF) << 32) + ((long)(buf[pos + 5] & 0xFF) << 40) + ((long)(buf[pos + 6] & 0xFF) << 48) + ((long)(buf[pos + 7] & 0xFF) << 56)));
            }
        }
        return pos + type;
    }

    private void growDataArray() {
        int newCapacity = this.data.length + (this.data.length >> 1);
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = 0x7FFFFFF7;
        }
        this.data = (byte[][])Arrays.copyOf(this.data, newCapacity);
    }

    public void abort() throws SQLException {
        this.isClosed = true;
        this.resetVariables();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
        if (this.statement != null) {
            this.statement.checkCloseOnCompletion(this);
            this.statement = null;
        }
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        if (!this.isEof) {
            this.lock.lock();
            try {
                while (!this.isEof) {
                    this.dataSize = 0;
                    this.readNextValue();
                }
            }
            catch (SQLException queryException) {
                throw ExceptionMapper.getException(queryException, null, this.statement, false);
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.resetVariables();
                this.lock.unlock();
            }
        }
        this.resetVariables();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
        if (this.statement != null) {
            this.statement.checkCloseOnCompletion(this);
            this.statement = null;
        }
    }

    private void resetVariables() {
        this.protocol = null;
        this.reader = null;
        this.isEof = true;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Operation not permit on a closed resultSet", "HY000");
        }
        if (this.rowPointer < this.dataSize - 1) {
            ++this.rowPointer;
            return true;
        }
        if (this.streaming && !this.isEof) {
            this.lock.lock();
            try {
                if (!this.isEof) {
                    this.nextStreamingValue();
                }
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
            }
            if (this.resultSetScrollType == 1003) {
                this.rowPointer = 0;
                return this.dataSize > 0;
            }
            ++this.rowPointer;
            return this.dataSize > this.rowPointer;
        }
        this.rowPointer = this.dataSize;
        return false;
    }

    private void checkObjectRange(int position) throws SQLException {
        if (this.rowPointer < 0) {
            throw new SQLDataException("Current position is before the first row", "22023");
        }
        if (this.rowPointer >= this.dataSize) {
            throw new SQLDataException("Current position is after the last row", "22023");
        }
        if (position <= 0 || position > this.columnInformationLength) {
            throw new SQLDataException("No such column: " + position, "22023");
        }
        if (this.lastRowPointer != this.rowPointer) {
            this.row.resetRow(this.data[this.rowPointer]);
            this.lastRowPointer = this.rowPointer;
        }
        this.row.setPosition(position - 1);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.statement == null) {
            return null;
        }
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() {
        if (this.statement != null) {
            this.statement.clearWarnings();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClose();
        return this.dataFetchTime > 0 ? this.rowPointer == -1 && this.dataSize > 0 : this.rowPointer == -1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize) {
            return false;
        }
        if (this.streaming && !this.isEof) {
            this.lock.lock();
            try {
                if (!this.isEof) {
                    this.addStreamingValue();
                }
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
            }
            return this.dataSize == this.rowPointer;
        }
        return this.dataSize > 0 || this.dataFetchTime > 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClose();
        return this.dataFetchTime == 1 && this.rowPointer == 0 && this.dataSize > 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClose();
        if (this.rowPointer < this.dataSize - 1) {
            return false;
        }
        if (this.isEof) {
            return this.rowPointer == this.dataSize - 1 && this.dataSize > 0;
        }
        this.lock.lock();
        try {
            if (!this.isEof) {
                this.addStreamingValue();
            }
        }
        catch (IOException ioe) {
            throw this.handleIoException(ioe);
        }
        finally {
            this.lock.unlock();
        }
        if (this.isEof) {
            return this.rowPointer == this.dataSize - 1 && this.dataSize > 0;
        }
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        this.fetchRemaining();
        this.rowPointer = this.dataSize;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        this.rowPointer = 0;
        return this.dataSize > 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        this.fetchRemaining();
        this.rowPointer = this.dataSize - 1;
        return this.dataSize > 0;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            return 0;
        }
        return this.rowPointer + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        if (row >= 0 && row <= this.dataSize) {
            this.rowPointer = row - 1;
            return true;
        }
        this.fetchRemaining();
        if (row >= 0) {
            if (row <= this.dataSize) {
                this.rowPointer = row - 1;
                return true;
            }
            this.rowPointer = this.dataSize;
            return false;
        }
        if (this.dataSize + row >= 0) {
            this.rowPointer = this.dataSize + row;
            return true;
        }
        this.rowPointer = -1;
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        int newPos = this.rowPointer + rows;
        if (newPos <= -1) {
            this.rowPointer = -1;
            return false;
        }
        if (newPos >= this.dataSize) {
            this.rowPointer = this.dataSize;
            return false;
        }
        this.rowPointer = newPos;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        if (this.streaming && this.resultSetScrollType == 1003) {
            throw new SQLException("Invalid operation for result set type TYPE_FORWARD_ONLY");
        }
        if (this.rowPointer > -1) {
            --this.rowPointer;
            return this.rowPointer != -1;
        }
        return false;
    }

    @Override
    public int getFetchDirection() {
        return 1002;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction == 1001) {
            throw new SQLException("Invalid operation. Allowed direction are ResultSet.FETCH_FORWARD and ResultSet.FETCH_UNKNOWN");
        }
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        if (this.streaming && fetchSize == 0) {
            this.lock.lock();
            try {
                while (!this.isEof) {
                    this.addStreamingValue();
                }
            }
            catch (IOException ioe) {
                throw this.handleIoException(ioe);
            }
            finally {
                this.lock.unlock();
            }
            this.streaming = this.dataFetchTime == 1;
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public int getType() {
        return this.resultSetScrollType;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    private void checkClose() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Operation not permit on a closed resultSet", "HY000");
        }
    }

    public boolean isCallableResult() {
        return this.callableResult;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public MariaDbStatement getStatement() {
        return this.statement;
    }

    public void setStatement(MariaDbStatement statement) {
        this.statement = statement;
    }

    @Override
    public boolean wasNull() {
        return this.row.wasNull();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        return new ByteArrayInputStream(new String(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize(), StandardCharsets.UTF_8).getBytes());
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalString(this.columnsInformation[columnIndex - 1], null, this.timeZone);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    private String zeroFillingIfNeeded(String value, ColumnInformation columnInformation) {
        if (columnInformation.isZeroFill()) {
            StringBuilder zeroAppendStr = new StringBuilder();
            long zeroToAdd = columnInformation.getDisplaySize() - value.length();
            while (zeroToAdd-- > 0L) {
                zeroAppendStr.append("0");
            }
            return zeroAppendStr.append(value).toString();
        }
        return value;
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        return new ByteArrayInputStream(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalInt(this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalLong(this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalFloat(this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalDouble(this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalBigDecimal(this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalBigDecimal(this.columnsInformation[columnIndex - 1]);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        byte[] data = new byte[this.row.getLengthMaxFieldSize()];
        System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
        return data;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalDate(this.columnsInformation[columnIndex - 1], null, this.timeZone);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalDate(this.columnsInformation[columnIndex - 1], cal, this.timeZone);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalTime(this.columnsInformation[columnIndex - 1], null, this.timeZone);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalTime(this.columnsInformation[columnIndex - 1], cal, this.timeZone);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalTimestamp(this.columnsInformation[columnIndex - 1], cal, this.timeZone);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalTimestamp(this.columnsInformation[columnIndex - 1], null, this.timeZone);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        return new ByteArrayInputStream(new String(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize(), StandardCharsets.UTF_8).getBytes());
    }

    @Override
    public String getCursorName() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Cursors not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new MariaDbResultSetMetaData(this.columnsInformation, this.options, this.returnTableAlias);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        return this.row.getInternalObject(this.columnsInformation[columnIndex - 1], this.timeZone);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Method ResultSet.getObject(int columnIndex, Map<String, Class<?>> map) not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Method ResultSet.getObject(String columnLabel, Map<String, Class<?>> map) not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("Class type cannot be null");
        }
        this.checkObjectRange(columnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        ColumnInformation col = this.columnsInformation[columnIndex - 1];
        if (type.equals(String.class)) {
            return (T)this.row.getInternalString(col, null, this.timeZone);
        }
        if (type.equals(Integer.class)) {
            return (T)Integer.valueOf(this.row.getInternalInt(col));
        }
        if (type.equals(Long.class)) {
            return (T)Long.valueOf(this.row.getInternalLong(col));
        }
        if (type.equals(Short.class)) {
            return (T)Short.valueOf(this.row.getInternalShort(col));
        }
        if (type.equals(Double.class)) {
            return (T)Double.valueOf(this.row.getInternalDouble(col));
        }
        if (type.equals(Float.class)) {
            return (T)Float.valueOf(this.row.getInternalFloat(col));
        }
        if (type.equals(Byte.class)) {
            return (T)Byte.valueOf(this.row.getInternalByte(col));
        }
        if (type.equals(byte[].class)) {
            byte[] data = new byte[this.row.getLengthMaxFieldSize()];
            System.arraycopy(this.row.buf, this.row.pos, data, 0, this.row.getLengthMaxFieldSize());
            return (T)data;
        }
        if (type.equals(Date.class)) {
            return (T)this.row.getInternalDate(col, null, this.timeZone);
        }
        if (type.equals(Time.class)) {
            return (T)this.row.getInternalTime(col, null, this.timeZone);
        }
        if (type.equals(Timestamp.class) || type.equals(java.util.Date.class)) {
            return (T)this.row.getInternalTimestamp(col, null, this.timeZone);
        }
        if (type.equals(Boolean.class)) {
            return (T)Boolean.valueOf(this.row.getInternalBoolean(col));
        }
        if (type.equals(Calendar.class)) {
            Calendar calendar = Calendar.getInstance(this.timeZone);
            Timestamp timestamp = this.row.getInternalTimestamp(col, null, this.timeZone);
            if (timestamp == null) {
                return null;
            }
            calendar.setTimeInMillis(timestamp.getTime());
            return type.cast(calendar);
        }
        if (type.equals(Clob.class) || type.equals(NClob.class)) {
            return (T)new MariaDbClob(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
        }
        if (type.equals(InputStream.class)) {
            return (T)new ByteArrayInputStream(this.row.buf, this.row.pos, this.row.getLengthMaxFieldSize());
        }
        if (type.equals(Reader.class)) {
            String value = this.row.getInternalString(col, null, this.timeZone);
            if (value == null) {
                return null;
            }
            return (T)new StringReader(value);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.row.getInternalBigDecimal(col);
        }
        if (type.equals(BigInteger.class)) {
            return (T)this.row.getInternalBigInteger(col);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)this.row.getInternalBigDecimal(col);
        }
        if (type.equals(LocalDateTime.class)) {
            ZonedDateTime zonedDateTime = this.row.getInternalZonedDateTime(col, LocalDateTime.class, this.timeZone);
            return zonedDateTime == null ? null : (T)type.cast(zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
        }
        if (type.equals(ZonedDateTime.class)) {
            ZonedDateTime zonedDateTime = this.row.getInternalZonedDateTime(col, ZonedDateTime.class, this.timeZone);
            if (zonedDateTime == null) {
                return null;
            }
            return type.cast(this.row.getInternalZonedDateTime(col, ZonedDateTime.class, this.timeZone));
        }
        if (type.equals(OffsetDateTime.class)) {
            ZonedDateTime tmpZonedDateTime = this.row.getInternalZonedDateTime(col, OffsetDateTime.class, this.timeZone);
            return tmpZonedDateTime == null ? null : (T)type.cast(tmpZonedDateTime.toOffsetDateTime());
        }
        if (type.equals(OffsetDateTime.class)) {
            LocalDate localDate = this.row.getInternalLocalDate(col, this.timeZone);
            if (localDate == null) {
                return null;
            }
            return type.cast(localDate);
        }
        if (type.equals(LocalDate.class)) {
            LocalDate localDate = this.row.getInternalLocalDate(col, this.timeZone);
            if (localDate == null) {
                return null;
            }
            return type.cast(localDate);
        }
        if (type.equals(LocalTime.class)) {
            LocalTime localTime = this.row.getInternalLocalTime(col, this.timeZone);
            if (localTime == null) {
                return null;
            }
            return type.cast(localTime);
        }
        if (type.equals(OffsetTime.class)) {
            OffsetTime offsetTime = this.row.getInternalOffsetTime(col, this.timeZone);
            if (offsetTime == null) {
                return null;
            }
            return type.cast(offsetTime);
        }
        throw ExceptionMapper.getFeatureNotSupportedException("Type class '" + type.getName() + "' is not supported");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return type.cast(this.getObject(this.findColumn(columnLabel), type));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.columnNameMap.getIndex(columnLabel) + 1;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        String value = this.row.getInternalString(this.columnsInformation[columnIndex - 1], null, this.timeZone);
        if (value == null) {
            return null;
        }
        return new StringReader(value);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Getting REFs not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        return new MariaDbBlob(this.row.buf, this.row.pos, this.row.length);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        return new MariaDbClob(this.row.buf, this.row.pos, this.row.length);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Arrays are not supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        try {
            return new URL(this.row.getInternalString(this.columnsInformation[columnIndex - 1], null, this.timeZone));
        }
        catch (MalformedURLException e) {
            throw ExceptionMapper.getSqlException("Could not parse as URL");
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.checkObjectRange(columnIndex);
        if (this.row.lastValueWasNull()) {
            return null;
        }
        return new MariaDbClob(this.row.buf, this.row.pos, this.row.length);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int index) throws SQLException {
        this.checkObjectRange(index);
        return this.row.getInternalBoolean(this.columnsInformation[index - 1]);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int index) throws SQLException {
        this.checkObjectRange(index);
        return this.row.getInternalByte(this.columnsInformation[index - 1]);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int index) throws SQLException {
        this.checkObjectRange(index);
        return this.row.getInternalShort(this.columnsInformation[index - 1]);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Detecting row updates are not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Detecting inserts are not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Row deletes are not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("insertRow are not supported when using ResultSet.CONCUR_READ_ONLY");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("deleteRow are not supported when using ResultSet.CONCUR_READ_ONLY");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("refreshRow are not supported when using ResultSet.CONCUR_READ_ONLY");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean bool) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateByte(int columnIndex, byte value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateByte(String columnLabel, byte value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateShort(int columnIndex, short value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateShort(String columnLabel, short value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateInt(int columnIndex, int value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateInt(String columnLabel, int value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateFloat(int columnIndex, float value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateFloat(String columnLabel, float value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateDouble(int columnIndex, double value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateDouble(String columnLabel, double value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateString(int columnIndex, String value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateString(String columnLabel, String value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateDate(int columnIndex, Date date) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateDate(String columnLabel, Date value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateTime(String columnLabel, Time value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp timeStamp) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateObject(int columnIndex, Object value, int scaleOrLength) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateObject(int columnIndex, Object value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateObject(String columnLabel, Object value, int scaleOrLength) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateObject(String columnLabel, Object value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateLong(String columnLabel, long value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateLong(int columnIndex, long value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateRow() throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("updateRow are not supported when using ResultSet.CONCUR_READ_ONLY");
    }

    @Override
    public void updateRef(int columnIndex, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateRef(String columnLabel, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(int columnIndex, Blob blob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(String columnLabel, Blob blob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(int columnIndex, Clob clob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(String columnLabel, Clob clob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateArray(int columnIndex, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateArray(String columnLabel, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateRowId(int columnIndex, RowId rowId) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateRowId(String columnLabel, RowId rowId) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNString(int columnIndex, String nstring) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNString(String columnLabel, String nstring) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nclob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nclob) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQLXML not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader value, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException(NOT_UPDATABLE_ERROR);
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return iface.cast(this);
            }
            throw new SQLException("The receiver is not a wrapper for " + iface.getName());
        }
        catch (Exception e) {
            throw new SQLException("The receiver is not a wrapper and does not implement the interface");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public void setReturnTableAlias(boolean returnTableAlias) {
        this.returnTableAlias = returnTableAlias;
    }

    private void rangeCheck(Object className, long minValue, long maxValue, long value, ColumnInformation columnInfo) throws SQLException {
        if (value < minValue || value > maxValue) {
            throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + value + " is not in " + className + " range", "22003", 1264);
        }
    }

    public int getRowPointer() {
        return this.rowPointer;
    }

    protected void setRowPointer(int pointer) {
        this.rowPointer = pointer;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public boolean isBinaryEncoded() {
        return this.row.isBinaryEncoded();
    }

    static {
        SelectResultSet.INSERT_ID_COLUMNS[0] = ColumnInformation.create("insert_id", ColumnType.BIGINT);
    }
}

