/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.PlaceholderReplacingReader;
import org.flywaydb.core.internal.parser.PositionTracker;
import org.flywaydb.core.internal.parser.PositionTrackingReader;
import org.flywaydb.core.internal.parser.Recorder;
import org.flywaydb.core.internal.parser.RecordingReader;
import org.flywaydb.core.internal.parser.StatementType;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.Resource;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.ParsedSqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementIterator;
import org.flywaydb.core.internal.util.BomStrippingReader;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.StringUtils;

public abstract class Parser {
    private static final Log LOG = LogFactory.getLog(Parser.class);
    private final Configuration configuration;
    private final int peekDepth;
    private final char identifierQuote;
    private final char alternativeIdentifierQuote;
    private final char alternativeStringLiteralQuote;
    private final Set<String> validKeywords;
    private final ParsingContext parsingContext;

    protected Parser(Configuration configuration, ParsingContext parsingContext, int peekDepth) {
        this.configuration = configuration;
        this.peekDepth = peekDepth;
        this.identifierQuote = this.getIdentifierQuote();
        this.alternativeIdentifierQuote = this.getAlternativeIdentifierQuote();
        this.alternativeStringLiteralQuote = this.getAlternativeStringLiteralQuote();
        this.validKeywords = this.getValidKeywords();
        this.parsingContext = parsingContext;
    }

    protected Delimiter getDefaultDelimiter() {
        return Delimiter.SEMICOLON;
    }

    protected char getIdentifierQuote() {
        return '\"';
    }

    protected char getAlternativeIdentifierQuote() {
        return '\u0000';
    }

    protected char getAlternativeStringLiteralQuote() {
        return '\u0000';
    }

    protected Set<String> getValidKeywords() {
        return null;
    }

    public final SqlStatementIterator parse(LoadableResource resource) {
        PositionTracker tracker = new PositionTracker();
        Recorder recorder = new Recorder();
        ParserContext context = new ParserContext(this.getDefaultDelimiter());
        LOG.debug("Parsing " + resource.getFilename() + " ...");
        PeekingReader peekingReader = new PeekingReader(new RecordingReader(recorder, new PositionTrackingReader(tracker, this.replacePlaceholders(new BomStrippingReader(new BufferedReader(resource.read(), 4096))))));
        return new ParserSqlStatementIterator(peekingReader, resource, recorder, tracker, context);
    }

    protected Reader replacePlaceholders(Reader r) {
        if (this.configuration.isPlaceholderReplacement()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            Map<String, String> configurationPlaceholders = this.configuration.getPlaceholders();
            Map<String, String> parsingContextPlaceholders = this.parsingContext.getPlaceholders();
            placeholders.putAll(configurationPlaceholders);
            placeholders.putAll(parsingContextPlaceholders);
            return new PlaceholderReplacingReader(this.configuration.getPlaceholderPrefix(), this.configuration.getPlaceholderSuffix(), placeholders, r);
        }
        return r;
    }

    private SqlStatement getNextStatement(Resource resource, PeekingReader reader, Recorder recorder, PositionTracker tracker, ParserContext context) {
        this.resetDelimiter(context);
        int statementLine = tracker.getLine();
        int statementCol = tracker.getCol();
        try {
            ArrayList<Token> tokens = new ArrayList<Token>();
            ArrayList<Token> keywords = new ArrayList<Token>();
            int statementPos = -1;
            recorder.start();
            int nonCommentPartPos = -1;
            int nonCommentPartLine = -1;
            int nonCommentPartCol = -1;
            StatementType statementType = null;
            Boolean canExecuteInTransaction = null;
            String simplifiedStatement = "";
            while (true) {
                Token token;
                if ((token = this.readToken(reader, tracker, context)) == null) {
                    if (tokens.isEmpty()) {
                        recorder.start();
                        statementLine = tracker.getLine();
                        statementCol = tracker.getCol();
                        simplifiedStatement = "";
                        continue;
                    }
                    recorder.confirm();
                    continue;
                }
                TokenType tokenType = token.getType();
                if (tokenType == TokenType.NEW_DELIMITER) {
                    context.setDelimiter(new Delimiter(token.getText(), false));
                    tokens.clear();
                    recorder.start();
                    statementLine = tracker.getLine();
                    statementCol = tracker.getCol();
                    simplifiedStatement = "";
                    continue;
                }
                if (this.shouldDiscard(token, nonCommentPartPos >= 0)) {
                    tokens.clear();
                    recorder.start();
                    statementLine = tracker.getLine();
                    statementCol = tracker.getCol();
                    simplifiedStatement = "";
                    continue;
                }
                if (this.shouldAdjustBlockDepth(context, token)) {
                    if (tokenType == TokenType.KEYWORD) {
                        keywords.add(token);
                    }
                    this.adjustBlockDepth(context, tokens, token, reader);
                }
                int parensDepth = token.getParensDepth();
                int blockDepth = context.getBlockDepth();
                if (TokenType.EOF == tokenType || TokenType.DELIMITER == tokenType && parensDepth == 0 && blockDepth == 0) {
                    String sql = recorder.stop();
                    if (TokenType.EOF == tokenType && (sql.length() == 0 || tokens.isEmpty() || nonCommentPartPos < 0)) {
                        return null;
                    }
                    if (canExecuteInTransaction == null) {
                        canExecuteInTransaction = true;
                    }
                    if (TokenType.EOF == tokenType && (parensDepth > 0 || blockDepth > 0)) {
                        throw new FlywayException("Incomplete statement at line " + statementLine + " col " + statementCol + ": " + sql);
                    }
                    return this.createStatement(reader, recorder, statementPos, statementLine, statementCol, nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, statementType, canExecuteInTransaction, context.getDelimiter(), sql);
                }
                if (nonCommentPartPos < 0 && TokenType.COMMENT != tokenType) {
                    nonCommentPartPos = token.getPos();
                    nonCommentPartLine = token.getLine();
                    nonCommentPartCol = token.getCol();
                }
                if (tokens.isEmpty()) {
                    statementPos = token.getPos();
                    statementLine = token.getLine();
                    statementCol = token.getCol();
                }
                tokens.add(token);
                recorder.confirm();
                if (keywords.size() > this.getTransactionalDetectionCutoff() || tokenType != TokenType.KEYWORD || parensDepth != 0 || statementType != null && canExecuteInTransaction != null) continue;
                if (!simplifiedStatement.isEmpty()) {
                    simplifiedStatement = simplifiedStatement + " ";
                }
                simplifiedStatement = simplifiedStatement + Parser.keywordToUpperCase(token.getText());
                if (statementType == null) {
                    if (keywords.size() > this.getTransactionalDetectionCutoff()) {
                        statementType = StatementType.GENERIC;
                    } else {
                        statementType = this.detectStatementType(simplifiedStatement);
                        context.setStatementType(statementType);
                    }
                    this.adjustDelimiter(context, statementType);
                }
                if (canExecuteInTransaction != null) continue;
                if (keywords.size() > this.getTransactionalDetectionCutoff()) {
                    canExecuteInTransaction = true;
                    continue;
                }
                canExecuteInTransaction = this.detectCanExecuteInTransaction(simplifiedStatement, keywords);
            }
        }
        catch (Exception e) {
            IOUtils.close(reader);
            throw new FlywayException("Unable to parse statement in " + resource.getAbsolutePath() + " at line " + statementLine + " col " + statementCol + ": " + e.getMessage(), e);
        }
    }

    protected boolean shouldAdjustBlockDepth(ParserContext context, Token token) {
        return token.getType() == TokenType.KEYWORD && token.getParensDepth() == 0;
    }

    protected boolean shouldDiscard(Token token, boolean nonCommentPartSeen) {
        TokenType tokenType = token.getType();
        return (tokenType == TokenType.DELIMITER || tokenType == TokenType.BLANK_LINES) && !nonCommentPartSeen;
    }

    protected void resetDelimiter(ParserContext context) {
        context.setDelimiter(this.getDefaultDelimiter());
    }

    protected void adjustDelimiter(ParserContext context, StatementType statementType) {
    }

    protected int getTransactionalDetectionCutoff() {
        return 10;
    }

    protected void adjustBlockDepth(ParserContext context, List<Token> tokens, Token keyword, PeekingReader reader) throws IOException {
    }

    protected static int getLastKeywordIndex(List<Token> tokens) {
        return Parser.getLastKeywordIndex(tokens, tokens.size());
    }

    protected static int getLastKeywordIndex(List<Token> tokens, int endIndex) {
        for (int i = endIndex - 1; i >= 0; --i) {
            Token token = tokens.get(i);
            if (token.getType() != TokenType.KEYWORD) continue;
            return i;
        }
        return -1;
    }

    static String keywordToUpperCase(String text) {
        if (!Parser.containsLowerCase(text)) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= 'a' && c <= 'z') {
                result.append((char)(c - 32));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static boolean containsLowerCase(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c < 'a' || c > 'z') continue;
            return true;
        }
        return false;
    }

    protected static boolean containsWithinLast(int count, List<Token> tokens, int parensDepth, String ... consecutiveTokenTexts) {
        int j = consecutiveTokenTexts.length - 1;
        int remaining = count;
        for (int i = tokens.size() - 1; i >= 0 && remaining > 0; --i) {
            if (tokens.get(i).getParensDepth() != parensDepth) continue;
            if (consecutiveTokenTexts[j].equals(tokens.get(i).getText())) {
                if (j == 0) {
                    return true;
                }
                --j;
            } else if (j < consecutiveTokenTexts.length - 1) {
                j = consecutiveTokenTexts.length - 1;
            }
            --remaining;
        }
        return false;
    }

    protected static boolean doTokensMatchPattern(List<Token> previousTokens, Token current, Pattern regex) {
        Token prevToken;
        ArrayList<String> tokenStrings = new ArrayList<String>();
        tokenStrings.add(current.getText());
        for (int i = previousTokens.size() - 1; i >= 0 && (prevToken = previousTokens.get(i)).getParensDepth() == current.getParensDepth(); --i) {
            tokenStrings.add(prevToken.getText());
        }
        StringBuilder builder = new StringBuilder();
        for (int i = tokenStrings.size() - 1; i >= 0; --i) {
            builder.append((String)tokenStrings.get(i));
            if (i == 0) continue;
            builder.append(" ");
        }
        return regex.matcher(builder.toString()).matches();
    }

    protected ParsedSqlStatement createStatement(PeekingReader reader, Recorder recorder, int statementPos, int statementLine, int statementCol, int nonCommentPartPos, int nonCommentPartLine, int nonCommentPartCol, StatementType statementType, boolean canExecuteInTransaction, Delimiter delimiter, String sql) throws IOException {
        return new ParsedSqlStatement(statementPos, statementLine, statementCol, sql, delimiter, canExecuteInTransaction);
    }

    protected StatementType detectStatementType(String simplifiedStatement) {
        return null;
    }

    protected Boolean detectCanExecuteInTransaction(String simplifiedStatement, List<Token> keywords) {
        return true;
    }

    private Token readToken(PeekingReader reader, PositionTracker tracker, ParserContext context) throws IOException {
        int pos = tracker.getPos();
        int line = tracker.getLine();
        int col = tracker.getCol();
        String peek = reader.peek(this.peekDepth);
        if (peek == null) {
            return new Token(TokenType.EOF, pos, line, col, null, null, 0);
        }
        char c = peek.charAt(0);
        if (this.isAlternativeStringLiteral(peek)) {
            return this.handleAlternativeStringLiteral(reader, context, pos, line, col);
        }
        if (c == '\'') {
            return this.handleStringLiteral(reader, context, pos, line, col);
        }
        if (c == '(') {
            context.increaseParensDepth();
            reader.swallow();
            return null;
        }
        if (c == ')') {
            context.decreaseParensDepth();
            reader.swallow();
            return null;
        }
        if (c == this.identifierQuote || c == this.alternativeIdentifierQuote) {
            reader.swallow();
            String text = reader.readUntilExcludingWithEscape(c, true);
            if (reader.peek('.')) {
                text = this.readAdditionalIdentifierParts(reader, c, context.getDelimiter(), context);
            }
            return new Token(TokenType.IDENTIFIER, pos, line, col, text, text, context.getParensDepth());
        }
        if (this.isCommentDirective(peek)) {
            return this.handleCommentDirective(reader, context, pos, line, col);
        }
        if (this.isSingleLineComment(peek, context, col)) {
            reader.swallowUntilExcluding('\n', '\r');
            return new Token(TokenType.COMMENT, pos, line, col, null, null, context.getParensDepth());
        }
        if (peek.startsWith("/*")) {
            reader.swallow(2);
            reader.swallowUntilExcluding("*/");
            reader.swallow(2);
            return new Token(TokenType.COMMENT, pos, line, col, null, null, context.getParensDepth());
        }
        if (Parser.isDigit(c)) {
            String text = reader.readNumeric();
            return new Token(TokenType.NUMERIC, pos, line, col, text, text, context.getParensDepth());
        }
        if (peek.startsWith("B'") || peek.startsWith("E'") || peek.startsWith("X'")) {
            reader.swallow(2);
            reader.swallowUntilExcludingWithEscape('\'', true);
            return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
        }
        if (peek.startsWith("U&'")) {
            reader.swallow(3);
            reader.swallowUntilExcludingWithEscape('\'', true);
            return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
        }
        if (this.isDelimiter(peek, context, col)) {
            return this.handleDelimiter(reader, context, pos, line, col);
        }
        if (c == '_' || context.isLetter(c)) {
            String text = this.readKeyword(reader, context.getDelimiter(), context);
            if (reader.peek('.')) {
                text = text + this.readAdditionalIdentifierParts(reader, this.identifierQuote, context.getDelimiter(), context);
            }
            if (!this.isKeyword(text)) {
                return new Token(TokenType.IDENTIFIER, pos, line, col, text, text, context.getParensDepth());
            }
            return this.handleKeyword(reader, context, pos, line, col, text);
        }
        if (StringUtils.isCharAnyOf(c, ",=*.:;[]~+-/%^|?!@$&#<>'{}\\")) {
            String text = "" + (char)reader.read();
            return new Token(TokenType.SYMBOL, pos, line, col, text, text, context.getParensDepth());
        }
        if (c == ' ' || c == '\r' || c == '\u00a0') {
            reader.swallow();
            return null;
        }
        if (Character.isWhitespace(c)) {
            String text = reader.readWhitespace();
            if (Parser.containsAtLeast(text, '\n', 2)) {
                return new Token(TokenType.BLANK_LINES, pos, line, col, null, null, context.getParensDepth());
            }
            return null;
        }
        throw new FlywayException("Unknown char " + (char)reader.read() + " encountered on line " + line + " at column " + col);
    }

    protected String readKeyword(PeekingReader reader, Delimiter delimiter, ParserContext context) throws IOException {
        return "" + (char)reader.read() + reader.readKeywordPart(delimiter, context);
    }

    protected Token handleDelimiter(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        Delimiter delimiter = context.getDelimiter();
        String text = delimiter.getDelimiter();
        reader.swallow(text.length());
        return new Token(TokenType.DELIMITER, pos, line, col, text, text, context.getParensDepth());
    }

    protected boolean isAlternativeStringLiteral(String peek) {
        return this.alternativeStringLiteralQuote != '\u0000' && peek.charAt(0) == this.alternativeStringLiteralQuote;
    }

    protected boolean isDelimiter(String peek, ParserContext context, int col) {
        Delimiter delimiter = context.getDelimiter();
        return peek.startsWith(delimiter.getDelimiter());
    }

    protected boolean isSingleLineComment(String peek, ParserContext context, int col) {
        return peek.startsWith("--");
    }

    protected boolean isKeyword(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_') continue;
            return false;
        }
        if (this.validKeywords != null) {
            return this.validKeywords.contains(text);
        }
        return true;
    }

    private String readAdditionalIdentifierParts(PeekingReader reader, char quote, Delimiter delimiter, ParserContext context) throws IOException {
        String result = "";
        reader.swallow();
        result = result + ".";
        if (reader.peek(quote)) {
            reader.swallow();
            result = result + reader.readUntilExcludingWithEscape(quote, true);
        } else {
            result = result + reader.readKeywordPart(delimiter, context);
        }
        if (reader.peek('.')) {
            reader.swallow();
            result = result + ".";
            if (reader.peek(quote)) {
                reader.swallow();
                result = result + reader.readUntilExcludingWithEscape(quote, true);
            } else {
                result = result + reader.readKeywordPart(delimiter, context);
            }
        }
        return result;
    }

    protected boolean isCommentDirective(String peek) {
        return false;
    }

    protected Token handleCommentDirective(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        return null;
    }

    protected Token handleStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        reader.swallow();
        reader.swallowUntilExcludingWithEscape('\'', true);
        return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
    }

    protected Token handleAlternativeStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        return null;
    }

    protected Token handleKeyword(PeekingReader reader, ParserContext context, int pos, int line, int col, String keyword) throws IOException {
        return new Token(TokenType.KEYWORD, pos, line, col, Parser.keywordToUpperCase(keyword), keyword, context.getParensDepth());
    }

    private static boolean containsAtLeast(String str, char c, int min) {
        if (min > str.length()) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c || ++count < min) continue;
            return true;
        }
        return false;
    }

    protected static boolean keywordIs(String expected, String actual) {
        if (expected.length() != actual.length()) {
            return false;
        }
        for (int i = 0; i < expected.length(); ++i) {
            char ca;
            char ce = expected.charAt(i);
            if (ce == (ca = actual.charAt(i)) || ce + 32 == ca) continue;
            return false;
        }
        return true;
    }

    protected static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public class ParserSqlStatementIterator
    implements SqlStatementIterator {
        private final PeekingReader peekingReader;
        private final LoadableResource resource;
        private final Recorder recorder;
        private final PositionTracker tracker;
        private final ParserContext context;
        private SqlStatement nextStatement;

        public ParserSqlStatementIterator(PeekingReader peekingReader, LoadableResource resource, Recorder recorder, PositionTracker tracker, ParserContext context) {
            this.peekingReader = peekingReader;
            this.resource = resource;
            this.recorder = recorder;
            this.tracker = tracker;
            this.context = context;
            this.nextStatement = Parser.this.getNextStatement(resource, peekingReader, recorder, tracker, context);
        }

        @Override
        public void close() {
            IOUtils.close(this.peekingReader);
        }

        @Override
        public boolean hasNext() {
            return this.nextStatement != null;
        }

        @Override
        public SqlStatement next() {
            if (this.nextStatement == null) {
                throw new NoSuchElementException("No more statements in " + this.resource.getFilename());
            }
            SqlStatement result = this.nextStatement;
            this.nextStatement = Parser.this.getNextStatement(this.resource, this.peekingReader, this.recorder, this.tracker, this.context);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

