/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.parser;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.parser.StatementType;
import org.flywaydb.core.internal.sqlscript.Delimiter;

public class ParserContext {
    private int parensDepth = 0;
    private int blockDepth = 0;
    private Delimiter delimiter;
    private StatementType statementType;

    public ParserContext(Delimiter delimiter) {
        this.delimiter = delimiter;
    }

    public void increaseParensDepth() {
        ++this.parensDepth;
    }

    public void decreaseParensDepth() {
        --this.parensDepth;
    }

    public int getParensDepth() {
        return this.parensDepth;
    }

    public void increaseBlockDepth() {
        ++this.blockDepth;
    }

    public void decreaseBlockDepth() {
        if (this.blockDepth == 0) {
            throw new FlywayException("Flyway parsing bug: unable to decrease block depth below 0");
        }
        --this.blockDepth;
    }

    public int getBlockDepth() {
        return this.blockDepth;
    }

    public Delimiter getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Delimiter delimiter) {
        this.delimiter = delimiter;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public boolean isLetter(char c) {
        if (Character.isLetter(c)) {
            return true;
        }
        if (this.getStatementType() != null) {
            return this.statementType.treatAsIfLetter(c);
        }
        return false;
    }
}

