/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlserver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.sqlserver.SQLServerApplicationLockTemplate;
import org.flywaydb.core.internal.database.sqlserver.SQLServerDatabase;
import org.flywaydb.core.internal.database.sqlserver.SQLServerSchema;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;

public class SQLServerConnection
extends org.flywaydb.core.internal.database.base.Connection<SQLServerDatabase> {
    private final String originalDatabaseName;
    private final String originalAnsiNulls;

    SQLServerConnection(Configuration configuration, SQLServerDatabase database, Connection connection, boolean originalAutoCommit, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, database, connection, originalAutoCommit, dryRunStatementInterceptor);
        try {
            this.originalDatabaseName = this.jdbcTemplate.queryForString("SELECT DB_NAME()", new String[0]);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine current database", e);
        }
        try {
            this.originalAnsiNulls = database.isAzure() ? null : this.jdbcTemplate.queryForString("DECLARE @ANSI_NULLS VARCHAR(3) = 'OFF';\nIF ( (32 & @@OPTIONS) = 32 ) SET @ANSI_NULLS = 'ON';\nSELECT @ANSI_NULLS AS ANSI_NULLS;", new String[0]);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine ANSI NULLS state", e);
        }
    }

    void setCurrentDatabase(String databaseName) throws SQLException {
        this.jdbcTemplate.execute("USE " + ((SQLServerDatabase)this.database).quote(databaseName), new Object[0]);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT SCHEMA_NAME()", new String[0]);
    }

    @Override
    protected void doRestoreOriginalState() throws SQLException {
        this.setCurrentDatabase(this.originalDatabaseName);
        if (!((SQLServerDatabase)this.database).isAzure()) {
            this.jdbcTemplate.execute("SET ANSI_NULLS " + this.originalAnsiNulls, new Object[0]);
        }
    }

    @Override
    public Schema getSchema(String name) {
        return new SQLServerSchema(this.jdbcTemplate, (SQLServerDatabase)this.database, this.originalDatabaseName, name);
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        return new SQLServerApplicationLockTemplate(this, this.jdbcTemplate, this.originalDatabaseName, table.toString().hashCode()).execute(callable);
    }
}

