--
-- Copyright 2010-2018 Boxfuse GmbH
--
--
-- Boxfuse GmbH grants the Licensee a non-exclusive,
-- timely limited and non-transferable license
-- to install and use the Software under the terms of
-- the Flyway License and Maintenance Agreement.
--
--
-- This software is distributed with a LIMITED WARRANTY.
-- See the Flyway License and Maintenance Agreement
-- for more details:
-- https://flywaydb.org/licenses/flyway-pro.txt
--

CREATE TABLE `${schema}`.`${table}` (
    `installed_rank` INT NOT NULL,
    `version` VARCHAR(50),
    `description` VARCHAR(200) NOT NULL,
    `type` VARCHAR(20) NOT NULL,
    `script` VARCHAR(1000) NOT NULL,
    `checksum` INT,
    `installed_by` VARCHAR(100) NOT NULL,
    `installed_on` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `execution_time` INT NOT NULL,
    `success` BOOL NOT NULL,
    -- Add the primary key as part of the CREATE TABLE statement in case `innodb_force_primary_key` is enabled
    CONSTRAINT `${table}_pk`PRIMARY KEY (`installed_rank`)
) ENGINE=InnoDB;

CREATE INDEX `${table}_s_idx` ON `${schema}`.`${table}` (`success`);
