/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderReplacer;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLPlusAtSqlStatement
extends AbstractSQLPlusSqlStatement {
    final SqlScript referencedSqlScript;

    public SQLPlusAtSqlStatement(List<Line> lines, SQLPlusPlaceholderReplacer sqlPlusPlaceholderReplacer, SqlStatementBuilderFactory sqlStatementBuilderFactory, ResourceProvider resourceProvider) {
        super(lines);
        LoadableResource resource;
        String sql = this.getSql();
        String noCommand = sql.startsWith("@") ? StringUtils.trimLeadingCharacter(sql, '@').trim() : sql.substring(sql.indexOf(32)).trim();
        List<String> tokens = StringUtils.tokenizeToStringCollection(noCommand, " ");
        String file = tokens.get(0);
        if (!file.contains(".") || file.endsWith(".")) {
            file = file + "." + sqlPlusPlaceholderReplacer.getSuffix();
        }
        if ((resource = resourceProvider.getResource(file)) == null) {
            throw new FlywayException("SP2-0310: unable to open file \"" + file + "\"");
        }
        SQLPlusPlaceholderReplacer placeholderReplacer = (SQLPlusPlaceholderReplacer)sqlStatementBuilderFactory.getPlaceholderReplacer();
        for (int i = 1; i < tokens.size(); ++i) {
            placeholderReplacer.define("" + i, tokens.get(i));
        }
        this.referencedSqlScript = new SqlScript(sqlStatementBuilderFactory, resource, false);
    }

    @Override
    public SqlScript getReferencedSqlScript() {
        return this.referencedSqlScript;
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        sqlScriptExecutor.execute(this.referencedSqlScript);
        return new Results();
    }
}

