/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderReplacer;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLPlusDefineSqlStatement
extends AbstractSQLPlusSqlStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLPlusDefineSqlStatement.class);
    private final Map<String, String> varsToPrint = new TreeMap<String, String>();

    public SQLPlusDefineSqlStatement(List<Line> lines, SQLPlusPlaceholderReplacer sqlPlusPlaceholderReplacer) {
        super(lines);
        String sql = this.getSql();
        String noDefine = sql.replaceFirst("(?i)(DEF(INE)?)[ ]?", "");
        String noDash = noDefine.replace("-\n", " ");
        int idx = noDash.indexOf("=");
        if (idx > 0) {
            String varName = noDash.substring(0, idx).trim();
            String varValue = noDash.substring(idx + 1).trim();
            if (varValue.startsWith("'") && varValue.endsWith("'")) {
                varValue = varValue.substring(1, varValue.length() - 1);
            }
            sqlPlusPlaceholderReplacer.define(varName, varValue);
        } else {
            String varName = noDash.trim();
            if (StringUtils.hasLength(varName)) {
                this.varsToPrint.put(varName, sqlPlusPlaceholderReplacer.getPlaceholderReplacements().get(varName));
            } else {
                this.varsToPrint.putAll(sqlPlusPlaceholderReplacer.getPlaceholderReplacements());
            }
        }
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        for (Map.Entry<String, String> entry : this.varsToPrint.entrySet()) {
            if (entry.getValue() == null) {
                LOGGER.warn("SP2-0135: symbol " + entry.getKey() + " is UNDEFINED");
                continue;
            }
            LOGGER.info("DEFINE " + entry.getKey() + " = \"" + entry.getValue() + "\" (CHAR)");
        }
        return new Results();
    }
}

