/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.license.pro;

import java.math.BigInteger;
import org.flywaydb.core.api.FlywayException;

public enum LicenseType {
    TRIAL(0, "Flyway Trial Edition"),
    PRO10(1, "Flyway Pro Edition (10 schemas)"),
    PRO20(2, "Flyway Pro Edition (20 schemas)"),
    PRO30(3, "Flyway Pro Edition (30 schemas)"),
    PRO40(4, "Flyway Pro Edition (40 schemas)"),
    PRO50(5, "Flyway Pro Edition (50 schemas)"),
    PRO60(6, "Flyway Pro Edition (60 schemas)"),
    PRO70(7, "Flyway Pro Edition (70 schemas)"),
    PRO80(8, "Flyway Pro Edition (80 schemas)"),
    PRO90(9, "Flyway Pro Edition (90 schemas)"),
    PROSITE(15, "Flyway Pro Edition (unlimited schemas)"),
    ENTERPRISE10(17, "Flyway Enterprise Edition (10 schemas)"),
    ENTERPRISE20(18, "Flyway Enterprise Edition (20 schemas)"),
    ENTERPRISE30(19, "Flyway Enterprise Edition (30 schemas)"),
    ENTERPRISE40(20, "Flyway Enterprise Edition (40 schemas)"),
    ENTERPRISE50(21, "Flyway Enterprise Edition (50 schemas)"),
    ENTERPRISE60(22, "Flyway Enterprise Edition (60 schemas)"),
    ENTERPRISE70(23, "Flyway Enterprise Edition (70 schemas)"),
    ENTERPRISE80(24, "Flyway Enterprise Edition (80 schemas)"),
    ENTERPRISE90(25, "Flyway Enterprise Edition (90 schemas)"),
    ENTERPRISESITE(31, "Flyway Enterprise Edition (unlimited schemas)"),
    PRO10_REDISTRIBUTABLE(33, "Flyway Pro Edition (10 schemas, redistributable)"),
    PRO20_REDISTRIBUTABLE(34, "Flyway Pro Edition (20 schemas, redistributable)"),
    PRO30_REDISTRIBUTABLE(35, "Flyway Pro Edition (30 schemas, redistributable)"),
    PRO40_REDISTRIBUTABLE(36, "Flyway Pro Edition (40 schemas, redistributable)"),
    PRO50_REDISTRIBUTABLE(37, "Flyway Pro Edition (50 schemas, redistributable)"),
    PRO60_REDISTRIBUTABLE(38, "Flyway Pro Edition (60 schemas, redistributable)"),
    PRO70_REDISTRIBUTABLE(39, "Flyway Pro Edition (70 schemas, redistributable)"),
    PRO80_REDISTRIBUTABLE(40, "Flyway Pro Edition (80 schemas, redistributable)"),
    PRO90_REDISTRIBUTABLE(41, "Flyway Pro Edition (90 schemas, redistributable)"),
    PROSITE_REDISTRIBUTABLE(47, "Flyway Pro Edition (unlimited schemas, redistributable)"),
    ENTERPRISE10_REDISTRIBUTABLE(49, "Flyway Enterprise Edition (10 schemas, redistributable)"),
    ENTERPRISE20_REDISTRIBUTABLE(50, "Flyway Enterprise Edition (20 schemas, redistributable)"),
    ENTERPRISE30_REDISTRIBUTABLE(51, "Flyway Enterprise Edition (30 schemas, redistributable)"),
    ENTERPRISE40_REDISTRIBUTABLE(52, "Flyway Enterprise Edition (40 schemas, redistributable)"),
    ENTERPRISE50_REDISTRIBUTABLE(53, "Flyway Enterprise Edition (50 schemas, redistributable)"),
    ENTERPRISE60_REDISTRIBUTABLE(54, "Flyway Enterprise Edition (60 schemas, redistributable)"),
    ENTERPRISE70_REDISTRIBUTABLE(55, "Flyway Enterprise Edition (70 schemas, redistributable)"),
    ENTERPRISE80_REDISTRIBUTABLE(56, "Flyway Enterprise Edition (80 schemas, redistributable)"),
    ENTERPRISE90_REDISTRIBUTABLE(57, "Flyway Enterprise Edition (90 schemas, redistributable)"),
    ENTERPRISESITE_REDISTRIBUTABLE(63, "Flyway Enterprise Edition (unlimited schemas, redistributable)");

    private final byte code;
    private final String description;

    private LicenseType(byte code, String description) {
        this.code = code;
        this.description = description;
    }

    public byte getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static LicenseType fromCode(byte code) {
        for (LicenseType licenseType : LicenseType.values()) {
            if (licenseType.code != code) continue;
            return licenseType;
        }
        throw new FlywayException("Unknown license code: 0x" + LicenseType.toHex(code));
    }

    private static String toHex(byte ... array) {
        BigInteger bi = new BigInteger(1, array);
        String hex = bi.toString(16);
        int paddingLength = array.length * 2 - hex.length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }
}

