/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.OracleResults;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderReplacer;
import org.flywaydb.core.internal.database.oracle.pro.ServerOutputFormat;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;

public class SQLPlusSetSqlStatement
extends AbstractSQLPlusSqlStatement {
    private static final Log LOG = LogFactory.getLog(SQLPlusSetSqlStatement.class);
    public static final String SERVEROUTPUT_REGEX = "SERVEROUT(PUT)? (ON|OFF)( SIZE ([0-9]{4,7}|UNL(IMITED)?))?( FOR(MAT)? ((WRA(PPED)?)|(WOR(D_WRAPPED)?)|(TRUN(CATED)?)))?";
    private static final Pattern SERVEROUTPUT_PATTERN = Pattern.compile("SERVEROUT(PUT)? (ON|OFF)( SIZE ([0-9]{4,7}|UNL(IMITED)?))?( FOR(MAT)? ((WRA(PPED)?)|(WOR(D_WRAPPED)?)|(TRUN(CATED)?)))?");
    private Boolean heading;
    private Boolean serverOutput;
    String serverOutputSize;
    private ServerOutputFormat serverOutputFormat;
    private String flagger;
    private Integer lineSize;
    private String nullText;
    private String unknown;

    public SQLPlusSetSqlStatement(List<Line> lines, SQLPlusPlaceholderReplacer sqlPlusPlaceholderReplacer) {
        super(lines);
        String sql = this.getSql();
        String option = sql.substring("SET ".length()).toUpperCase(Locale.ENGLISH);
        Matcher serverOutputMatcher = SERVEROUTPUT_PATTERN.matcher(option);
        if (serverOutputMatcher.matches()) {
            this.serverOutput = "ON".equals(serverOutputMatcher.group(2));
            this.serverOutputSize = this.serverOutput != false ? serverOutputMatcher.group(4) : "UNLIMITED";
            this.serverOutputFormat = this.serverOutput != false ? ServerOutputFormat.fromText(serverOutputMatcher.group(8)) : ServerOutputFormat.WORD_WRAPPED;
        } else if (option.matches("SERVEROUT(PUT)? OFF")) {
            this.serverOutput = false;
        } else if (option.matches("NULL .+")) {
            this.nullText = SQLPlusSetSqlStatement.getNullText(option);
        } else if (option.matches("DEF(INE)? ON")) {
            sqlPlusPlaceholderReplacer.setDefineOn(true);
            sqlPlusPlaceholderReplacer.setDefineChar('&');
        } else if (option.matches("DEF(INE)? [^A-Z0-9 ]")) {
            sqlPlusPlaceholderReplacer.setDefineOn(true);
            sqlPlusPlaceholderReplacer.setDefineChar(sql.substring(sql.length() - 1).charAt(0));
        } else if (option.matches("DEF(INE)? OFF")) {
            sqlPlusPlaceholderReplacer.setDefineOn(false);
        } else if (option.matches("ESC(APE)? ON")) {
            sqlPlusPlaceholderReplacer.setEscapeOn(true);
        } else if (option.matches("ESC(APE)? [^A-Z0-9 ]")) {
            sqlPlusPlaceholderReplacer.setEscapeChar(sql.substring(sql.length() - 1).charAt(0));
        } else if (option.matches("ESC(APE)? OFF")) {
            sqlPlusPlaceholderReplacer.setEscapeOn(false);
        } else if (option.matches("FLAGGER (OFF|ENTRY|INTERMED(IATE)?|FULL)")) {
            this.flagger = option.substring("FLAGGER".length());
        } else if (option.matches("SCAN ON")) {
            sqlPlusPlaceholderReplacer.setDefineOn(true);
        } else if (option.matches("SCAN OFF")) {
            sqlPlusPlaceholderReplacer.setDefineOn(false);
        } else if (option.matches("HEA(DING)? ON")) {
            this.heading = true;
        } else if (option.matches("HEA(DING)? OFF")) {
            this.heading = false;
        } else if (option.matches("SUF(FIX)? \\w+")) {
            sqlPlusPlaceholderReplacer.setSuffix(sql.substring(sql.lastIndexOf(" ") + 1));
        } else if (option.matches("LIN(ESIZE)? [0-9]{1,5}")) {
            this.lineSize = Integer.parseInt(sql.substring(sql.lastIndexOf(" ") + 1));
            sqlPlusPlaceholderReplacer.setLineSize(this.lineSize);
        } else {
            this.unknown = option;
        }
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        OracleResults oracleResults = new OracleResults();
        try {
            if (Boolean.TRUE.equals(this.serverOutput)) {
                oracleResults.setServerOutput(true);
                if (this.serverOutputSize != null) {
                    oracleResults.setServerOutputSize(this.serverOutputSize);
                }
                if (this.serverOutputFormat != null) {
                    oracleResults.setServerOutputFormat(this.serverOutputFormat);
                }
                jdbcTemplate.execute("BEGIN\nDBMS_OUTPUT.ENABLE(" + (this.serverOutputSize != null && this.serverOutputSize.matches("[0-9]{4,7}") ? this.serverOutputSize : "buffer_size => NULL") + ");\nEND;", new Object[0]);
            } else if (Boolean.FALSE.equals(this.serverOutput)) {
                jdbcTemplate.execute("BEGIN\nDBMS_OUTPUT.DISABLE;\nEND;", new Object[0]);
                oracleResults.setServerOutput(false);
            } else if (this.nullText != null) {
                oracleResults.setNullText(this.nullText);
            } else if (this.flagger != null) {
                jdbcTemplate.execute("ALTER SESSION SET FLAGGER=" + this.flagger, new Object[0]);
            } else if (this.heading != null) {
                oracleResults.setHeading(this.heading);
            } else if (this.lineSize != null) {
                if (this.lineSize < 1 || this.lineSize > Short.MAX_VALUE) {
                    throw new FlywayException("SP2-0267: linesize option " + this.lineSize + " out of range (1 through 32767)");
                }
                oracleResults.setLineSize(this.lineSize);
            } else if (this.unknown != null) {
                LOG.warn("Unknown option for SET: " + this.unknown);
            }
        }
        catch (SQLException e) {
            oracleResults.setException(e);
        }
        return oracleResults;
    }

    static String getNullText(String option) {
        String nullText = option.substring(5);
        if (nullText.startsWith("\"")) {
            nullText = nullText.substring(1);
        }
        if (nullText.endsWith("\"")) {
            nullText = nullText.substring(0, nullText.length() - 1);
        }
        return nullText;
    }
}

