/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBConnection;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBSqlScript;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

public class CockroachDBDatabase
extends Database<CockroachDBConnection> {
    public static boolean isCockroachDB(Connection connection) {
        try {
            return new JdbcTemplate(connection).queryForString("SELECT version()", new String[0]).contains("CockroachDB");
        }
        catch (Exception e) {
            return false;
        }
    }

    public CockroachDBDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected CockroachDBConnection getConnection(Connection connection) {
        return new CockroachDBConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    protected final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 1 || this.majorVersion == 1 && this.minorVersion < 1) {
            throw new FlywayDbUpgradeRequiredException("CockroachDB", version, "1.1");
        }
        if (this.majorVersion > 2 || this.majorVersion == 2 && this.minorVersion > 0) {
            this.recommendFlywayUpgrade("CockroachDB", version);
        }
    }

    @Override
    protected SqlScript doCreateSqlScript(LoadableResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, boolean mixed) {
        return new CockroachDBSqlScript(this.configuration, sqlScriptResource, mixed, placeholderReplacer);
    }

    @Override
    protected Pair<Integer, Integer> determineMajorAndMinorVersion() {
        String version;
        try {
            version = ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT value FROM crdb_internal.node_build_info where field='Version'", new String[0]);
            if (version == null) {
                version = ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT value FROM crdb_internal.node_build_info where field='Tag'", new String[0]);
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine CockroachDB version", e);
        }
        int firstDot = version.indexOf(".");
        int majorVersion = Integer.parseInt(version.substring(1, firstDot));
        String minorPatch = version.substring(firstDot + 1);
        int minorVersion = Integer.parseInt(minorPatch.substring(0, minorPatch.indexOf(".")));
        return Pair.of(majorVersion, minorVersion);
    }

    @Override
    public String getDbName() {
        return "cockroachdb";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((CockroachDBConnection)this.getMainConnection()).getJdbcTemplate().queryForString("(SELECT * FROM [SHOW SESSION_USER])", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    protected boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }
}

