/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.BomStrippingReader;
import org.flywaydb.core.internal.util.FileCopyUtils;
import org.flywaydb.core.internal.util.line.DefaultLineReader;
import org.flywaydb.core.internal.util.line.LineReader;
import org.flywaydb.core.internal.util.scanner.AbstractLoadableResource;

public class ClassPathResource
extends AbstractLoadableResource
implements Comparable<ClassPathResource> {
    private final String location;
    private final ClassLoader classLoader;
    private final Charset encoding;

    public ClassPathResource(String location, ClassLoader classLoader, Charset encoding) {
        this.location = location;
        this.classLoader = classLoader;
        this.encoding = encoding;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getLocationOnDisk() {
        URL url = this.getUrl();
        if (url == null) {
            throw new FlywayException("Unable to location resource on disk: " + this.location);
        }
        try {
            return new File(URLDecoder.decode(url.getPath(), "UTF-8")).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new FlywayException("Unknown encoding: UTF-8", e);
        }
    }

    private URL getUrl() {
        return this.classLoader.getResource(this.location);
    }

    @Override
    public LineReader loadAsString() {
        try {
            InputStream inputStream = this.classLoader.getResourceAsStream(this.location);
            if (inputStream == null) {
                throw new FlywayException("Unable to obtain inputstream for resource: " + this.location);
            }
            return new DefaultLineReader(new BomStrippingReader(new InputStreamReader(inputStream, this.encoding)));
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load resource: " + this.location + " (encoding: " + this.encoding + ")", e);
        }
    }

    @Override
    public byte[] loadAsBytes() {
        try {
            InputStream inputStream = this.classLoader.getResourceAsStream(this.location);
            if (inputStream == null) {
                throw new FlywayException("Unable to obtain inputstream for resource: " + this.location);
            }
            return FileCopyUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load resource: " + this.location, e);
        }
    }

    @Override
    public String getFilename() {
        return this.location.substring(this.location.lastIndexOf("/") + 1);
    }

    public boolean exists() {
        return this.getUrl() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathResource that = (ClassPathResource)o;
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    @Override
    public int compareTo(ClassPathResource o) {
        return this.location.compareTo(o.location);
    }
}

