/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.BomStrippingReader;
import org.flywaydb.core.internal.util.FileCopyUtils;
import org.flywaydb.core.internal.util.line.DefaultLineReader;
import org.flywaydb.core.internal.util.line.LineReader;
import org.flywaydb.core.internal.util.scanner.AbstractLoadableResource;

public class FileSystemResource
extends AbstractLoadableResource
implements Comparable<FileSystemResource> {
    private final File file;
    private final Charset encoding;

    public FileSystemResource(String location, Charset encoding) {
        this.file = new File(new File(location).getPath());
        this.encoding = encoding;
    }

    @Override
    public String getLocation() {
        return this.file.getPath();
    }

    @Override
    public String getLocationOnDisk() {
        return this.file.getAbsolutePath();
    }

    @Override
    public LineReader loadAsString() {
        try {
            return new DefaultLineReader(new BomStrippingReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding)));
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load filesystem resource: " + this.file.getPath() + " (encoding: " + this.encoding + ")", e);
        }
    }

    @Override
    public byte[] loadAsBytes() {
        try {
            FileInputStream inputStream = new FileInputStream(this.file);
            return FileCopyUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load filesystem resource: " + this.file.getPath(), e);
        }
    }

    @Override
    public String getFilename() {
        return this.file.getName();
    }

    @Override
    public int compareTo(FileSystemResource o) {
        return this.file.compareTo(o.file);
    }
}

