/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.callback.SqlScriptFlywayCallback;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.resolver.MigrationInfoHelper;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationExecutor;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;
import org.flywaydb.core.internal.util.scanner.Resource;
import org.flywaydb.core.internal.util.scanner.Scanner;

public class SqlMigrationResolver
implements MigrationResolver {
    private final Database database;
    private final Scanner scanner;
    private final Locations locations;
    private final PlaceholderReplacer placeholderReplacer;
    private final FlywayConfiguration configuration;

    public SqlMigrationResolver(Database database, Scanner scanner, Locations locations, PlaceholderReplacer placeholderReplacer, FlywayConfiguration configuration) {
        this.database = database;
        this.scanner = scanner;
        this.locations = locations;
        this.placeholderReplacer = placeholderReplacer;
        this.configuration = configuration;
    }

    public List<ResolvedMigration> resolveMigrations() {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        String separator = this.configuration.getSqlMigrationSeparator();
        String[] suffixes = this.configuration.getSqlMigrationSuffixes();
        for (Location location : this.locations.getLocations()) {
            this.scanForMigrations(location, migrations, this.configuration.getSqlMigrationPrefix(), separator, suffixes, false);
            this.scanForMigrations(location, migrations, this.configuration.getRepeatableSqlMigrationPrefix(), separator, suffixes, true);
        }
        Collections.sort(migrations, new ResolvedMigrationComparator());
        return migrations;
    }

    private void scanForMigrations(Location location, List<ResolvedMigration> migrations, String prefix, String separator, String[] suffixes, boolean repeatable) {
        for (LoadableResource resource : this.scanner.scanForResources(location, prefix, suffixes)) {
            String filename = resource.getFilename();
            if (SqlMigrationResolver.isSqlCallback(filename, suffixes)) continue;
            Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(filename, prefix, separator, suffixes, repeatable);
            ResolvedMigrationImpl migration = new ResolvedMigrationImpl();
            migration.setVersion(info.getLeft());
            migration.setDescription(info.getRight());
            migration.setScript(this.extractScriptName(resource, location));
            migration.setChecksum(SqlMigrationResolver.calculateChecksum(resource, resource.loadAsString(this.configuration.getEncoding())));
            migration.setType(MigrationType.SQL);
            migration.setPhysicalLocation(resource.getLocationOnDisk());
            migration.setExecutor(new SqlMigrationExecutor(this.database, resource, this.placeholderReplacer, this.configuration));
            migrations.add(migration);
        }
    }

    static boolean isSqlCallback(String filename, String ... suffixes) {
        for (String suffix : suffixes) {
            String baseName = filename.substring(0, filename.length() - suffix.length());
            if (!SqlScriptFlywayCallback.ALL_CALLBACKS.contains(baseName)) continue;
            return true;
        }
        return false;
    }

    String extractScriptName(Resource resource, Location location) {
        if (location.getPath().isEmpty()) {
            return resource.getLocation();
        }
        return resource.getLocation().substring(location.getPath().length() + 1);
    }

    static int calculateChecksum(Resource resource, String str) {
        CRC32 crc32 = new CRC32();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(str));
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                crc32.update(line.getBytes("UTF-8"));
            }
        }
        catch (IOException e) {
            String message = "Unable to calculate checksum";
            if (resource != null) {
                message = message + " for " + resource.getLocation() + " (" + resource.getLocationOnDisk() + ")";
            }
            throw new FlywayException(message, e);
        }
        return (int)crc32.getValue();
    }
}

