/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.SQLException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBSchema;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.StringUtils;

public class CockroachDBConnection
extends Connection<CockroachDBDatabase> {
    CockroachDBConnection(FlywayConfiguration configuration, CockroachDBDatabase database, java.sql.Connection connection, int nullType) {
        super(configuration, database, connection, nullType);
    }

    @Override
    public Schema getOriginalSchema() {
        if (this.originalSchema == null) {
            return null;
        }
        return this.getSchema(this.getFirstSchemaFromSearchPath(this.originalSchema));
    }

    private String getFirstSchemaFromSearchPath(String searchPath) {
        String result = searchPath.replace(((CockroachDBDatabase)this.database).doQuote("$user"), "").trim();
        if (result.startsWith(",")) {
            result = result.substring(1);
        }
        if (result.contains(",")) {
            result = result.substring(0, result.indexOf(","));
        }
        if ((result = result.trim()).startsWith("\"") && result.endsWith("\"") && !result.endsWith("\\\"") && result.length() > 1) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    @Override
    public Schema getSchema(String name) {
        return new CockroachDBSchema(this.jdbcTemplate, (CockroachDBDatabase)this.database, name);
    }

    @Override
    protected String doGetCurrentSchemaName() throws SQLException {
        return this.jdbcTemplate.queryForString("SHOW database", new String[0]);
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (schema.getName().equals(this.originalSchema) || !schema.exists()) {
                return;
            }
            this.doChangeCurrentSchemaTo(schema.getName());
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error setting current schema to " + schema, e);
        }
    }

    @Override
    public void doChangeCurrentSchemaTo(String schema) throws SQLException {
        if (!StringUtils.hasLength(schema)) {
            schema = "DEFAULT";
        }
        this.jdbcTemplate.execute("SET database = " + schema, new Object[0]);
    }
}

