/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.database.Delimiter;
import org.flywaydb.core.internal.database.StandardSqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.jdbc.ContextImpl;

public class SqlStatementBuilder {
    protected StringBuilder statement = new StringBuilder();
    protected int lineNumber;
    private boolean empty = true;
    private boolean terminated;
    private boolean insideQuoteStringLiteral = false;
    private boolean insideAlternateQuoteStringLiteral = false;
    private String alternateQuote;
    private boolean lineEndsWithSingleLineComment = false;
    private boolean insideMultiLineComment = false;
    private boolean nonCommentStatementPartSeen = false;
    private int nestedBlockDepth = 0;
    protected boolean executeInTransaction = true;
    protected final Delimiter defaultDelimiter;
    protected Delimiter delimiter;

    public SqlStatementBuilder(Delimiter defaultDelimiter) {
        this.defaultDelimiter = defaultDelimiter;
        this.delimiter = defaultDelimiter;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setDelimiter(Delimiter delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public <C extends ContextImpl> SqlStatement<C> getSqlStatement() {
        return new StandardSqlStatement(this.lineNumber, this.statement.toString());
    }

    public Delimiter extractNewDelimiterFromLine(String line) {
        return null;
    }

    public boolean isCommentDirective(String line) {
        return false;
    }

    protected boolean isSingleLineComment(String line) {
        return line.startsWith("--");
    }

    public void addLine(String line) {
        if (this.isEmpty()) {
            this.empty = false;
        } else {
            this.statement.append("\n");
        }
        if (this.isCommentDirective(line.trim())) {
            this.nonCommentStatementPartSeen = true;
        }
        String lineSimplified = this.simplifyLine(line);
        this.applyStateChanges(lineSimplified);
        if (this.endWithOpenMultilineStringLiteral() || this.insideMultiLineComment || this.isSingleLineComment(lineSimplified)) {
            this.statement.append(line);
            return;
        }
        this.delimiter = this.changeDelimiterIfNecessary(lineSimplified, this.delimiter);
        this.statement.append(line);
        if (!this.lineEndsWithSingleLineComment && this.lineTerminatesStatement(lineSimplified, this.delimiter)) {
            SqlStatementBuilder.stripDelimiter(this.statement, this.delimiter);
            this.terminated = true;
        }
    }

    boolean endWithOpenMultilineStringLiteral() {
        return this.insideQuoteStringLiteral || this.insideAlternateQuoteStringLiteral;
    }

    public boolean canDiscard() {
        return !this.insideAlternateQuoteStringLiteral && !this.insideQuoteStringLiteral && !this.insideMultiLineComment && !this.nonCommentStatementPartSeen;
    }

    protected String simplifyLine(String line) {
        return this.removeEscapedQuotes(line).replace("--", " -- ").replace("/*", " /* ").replace("*/", " */ ").replaceAll("\\s+", " ").trim().toUpperCase();
    }

    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        return delimiter;
    }

    private boolean lineTerminatesStatement(String line, Delimiter delimiter) {
        if (delimiter == null || this.defaultDelimiter.equals(delimiter) && this.nestedBlockDepth > 0) {
            return false;
        }
        String upperCaseDelimiter = delimiter.getDelimiter().toUpperCase();
        if (delimiter.isAloneOnLine()) {
            return line.equals(upperCaseDelimiter);
        }
        return line.endsWith(upperCaseDelimiter);
    }

    static void stripDelimiter(StringBuilder sql, Delimiter delimiter) {
        int last;
        for (last = sql.length(); last > 0 && Character.isWhitespace(sql.charAt(last - 1)); --last) {
        }
        sql.delete(last - delimiter.getDelimiter().length(), sql.length());
    }

    protected String extractAlternateOpenQuote(String token) {
        return null;
    }

    protected String computeAlternateCloseQuote(String openQuote) {
        return openQuote;
    }

    protected void applyStateChanges(String line) {
        String[] tokens = this.tokenizeLine(line);
        List<TokenType> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        this.lineEndsWithSingleLineComment = false;
        for (TokenType delimitingToken : delimitingTokens) {
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && TokenType.MULTI_LINE_COMMENT_OPEN.equals((Object)delimitingToken)) {
                this.insideMultiLineComment = true;
            }
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && TokenType.MULTI_LINE_COMMENT_CLOSE.equals((Object)delimitingToken)) {
                this.insideMultiLineComment = false;
            }
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && !this.insideMultiLineComment && TokenType.SINGLE_LINE_COMMENT.equals((Object)delimitingToken)) {
                this.lineEndsWithSingleLineComment = true;
                return;
            }
            if (!this.insideMultiLineComment && !this.insideQuoteStringLiteral && TokenType.ALTERNATE_QUOTE.equals((Object)delimitingToken)) {
                boolean bl = this.insideAlternateQuoteStringLiteral = !this.insideAlternateQuoteStringLiteral;
            }
            if (!this.insideMultiLineComment && !this.insideAlternateQuoteStringLiteral && TokenType.QUOTE.equals((Object)delimitingToken)) {
                boolean bl = this.insideQuoteStringLiteral = !this.insideQuoteStringLiteral;
            }
            if (this.insideMultiLineComment || this.insideQuoteStringLiteral || this.insideAlternateQuoteStringLiteral || !TokenType.OTHER.equals((Object)delimitingToken) && !TokenType.BLOCK_BEGIN.equals((Object)delimitingToken) && !TokenType.BLOCK_END.equals((Object)delimitingToken)) continue;
            this.nonCommentStatementPartSeen = true;
            if (!this.isBlockStatement()) continue;
            if (TokenType.BLOCK_BEGIN.equals((Object)delimitingToken)) {
                ++this.nestedBlockDepth;
                continue;
            }
            if (!TokenType.BLOCK_END.equals((Object)delimitingToken)) continue;
            --this.nestedBlockDepth;
        }
    }

    protected boolean isBlockStatement() {
        return false;
    }

    protected String[] tokenizeLine(String line) {
        return StringUtils.tokenizeToStringArray(line, " @<>;:=|(),+{}");
    }

    private List<TokenType> extractStringLiteralDelimitingTokens(String[] tokens) {
        ArrayList<TokenType> delimitingTokens = new ArrayList<TokenType>();
        for (String token : tokens) {
            String alternateQuoteFromToken;
            String cleanToken = this.cleanToken(token);
            boolean handled = false;
            if (this.alternateQuote == null && (alternateQuoteFromToken = this.extractAlternateOpenQuote(cleanToken)) != null) {
                String closeQuote = this.computeAlternateCloseQuote(alternateQuoteFromToken);
                if (cleanToken.length() >= alternateQuoteFromToken.length() + closeQuote.length() && cleanToken.startsWith(alternateQuoteFromToken) && cleanToken.endsWith(closeQuote)) continue;
                this.alternateQuote = closeQuote;
                delimitingTokens.add(TokenType.ALTERNATE_QUOTE);
                continue;
            }
            if (this.alternateQuote != null && cleanToken.endsWith(this.alternateQuote)) {
                this.alternateQuote = null;
                delimitingTokens.add(TokenType.ALTERNATE_QUOTE);
                continue;
            }
            if (cleanToken.length() >= 2 && cleanToken.startsWith("'") && cleanToken.endsWith("'")) continue;
            if (cleanToken.length() >= 4) {
                int numberOfOpeningMultiLineComments = StringUtils.countOccurrencesOf(cleanToken, "/*");
                int numberOfClosingMultiLineComments = StringUtils.countOccurrencesOf(cleanToken, "*/");
                if (numberOfOpeningMultiLineComments > 0 && numberOfOpeningMultiLineComments == numberOfClosingMultiLineComments) continue;
            }
            if (this.isSingleLineComment(cleanToken)) {
                delimitingTokens.add(TokenType.SINGLE_LINE_COMMENT);
                handled = true;
            }
            if (cleanToken.contains("/*")) {
                delimitingTokens.add(TokenType.MULTI_LINE_COMMENT_OPEN);
                handled = true;
            } else if (cleanToken.startsWith("'")) {
                delimitingTokens.add(TokenType.QUOTE);
                handled = true;
            }
            if (!cleanToken.contains("/*") && cleanToken.contains("*/")) {
                delimitingTokens.add(TokenType.MULTI_LINE_COMMENT_CLOSE);
                handled = true;
            } else if (!cleanToken.startsWith("'") && cleanToken.endsWith("'")) {
                delimitingTokens.add(TokenType.QUOTE);
                handled = true;
            }
            if (handled) continue;
            if (this.isBlockBeginToken(cleanToken)) {
                delimitingTokens.add(TokenType.BLOCK_BEGIN);
                continue;
            }
            if (this.isBlockEndToken(cleanToken)) {
                delimitingTokens.add(TokenType.BLOCK_END);
                continue;
            }
            delimitingTokens.add(TokenType.OTHER);
        }
        return delimitingTokens;
    }

    protected boolean isBlockBeginToken(String token) {
        return false;
    }

    protected boolean isBlockEndToken(String token) {
        return false;
    }

    protected String removeEscapedQuotes(String token) {
        return StringUtils.replaceAll(token, "''", "");
    }

    protected String cleanToken(String token) {
        return token;
    }

    public boolean executeInTransaction() {
        return this.executeInTransaction;
    }

    private static enum TokenType {
        OTHER,
        QUOTE,
        ALTERNATE_QUOTE,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT_OPEN,
        MULTI_LINE_COMMENT_CLOSE,
        BLOCK_BEGIN,
        BLOCK_END;

    }
}

