/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.oceanbase;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.flywaydb.core.internal.util.StringUtils;

public class OceanBaseJdbcUtils {
    public static String getVersionComment(Connection connection) throws SQLException {
        return OceanBaseJdbcUtils.queryVariable(connection, "version_comment");
    }

    public static String getVersionNumber(Connection connection) throws SQLException {
        String[] parts;
        String versionComment = OceanBaseJdbcUtils.getVersionComment(connection);
        if (StringUtils.hasText((String)versionComment) && (parts = versionComment.split(" ")).length > 1) {
            return parts[1];
        }
        return null;
    }

    private static String queryVariable(Connection connection, String variable) throws SQLException {
        assert (StringUtils.hasText((String)variable));
        String sql = String.format("SHOW VARIABLES LIKE '%s'", variable);
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery(sql);
            if (rs.next()) {
                String string = rs.getString("VALUE");
                return string;
            }
        }
        return null;
    }
}

