/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.SessionHolder;
import com.ing.data.cassandra.jdbc.utils.DriverUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class CassandraDriver
implements Driver {
    private final LoadingCache<Map<String, String>, SessionHolder> sessionsCache = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<Map<String, String>, SessionHolder>(){

        public SessionHolder load(Map<String, String> params) throws Exception {
            return new SessionHolder(params, (LoadingCache<Map<String, String>, SessionHolder>)CassandraDriver.this.sessionsCache);
        }
    });

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith("jdbc:cassandra:");
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        if (this.acceptsURL(url)) {
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if ("contactPoints".equals(key)) continue;
                params.put(key, properties.getProperty(key));
            }
            params.put("jdbcUrl", url);
            Map cacheKey = Collections.unmodifiableMap(params);
            try {
                SessionHolder sessionHolder;
                while ((sessionHolder = (SessionHolder)this.sessionsCache.get(cacheKey)) == null || !sessionHolder.acquire()) {
                }
                return new CassandraConnection(sessionHolder);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLNonTransientConnectionException("Unexpected error while creating connection.", e);
            }
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return DriverUtil.safeParseVersion(DriverUtil.getDriverProperty("driver.version")).getMajor();
    }

    @Override
    public int getMinorVersion() {
        return DriverUtil.safeParseVersion(DriverUtil.getDriverProperty("driver.version")).getMinor();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) {
        Properties properties = props;
        if (props == null) {
            properties = new Properties();
        }
        DriverPropertyInfo[] info = new DriverPropertyInfo[2];
        info[0] = new DriverPropertyInfo("user", properties.getProperty("user"));
        info[0].description = "The 'user' property";
        info[1] = new DriverPropertyInfo("password", properties.getProperty("password"));
        info[1].description = "The 'password' property";
        return info;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    static {
        try {
            CassandraDriver driverInstance = new CassandraDriver();
            DriverManager.registerDriver(driverInstance);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

