/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.clean;

import java.util.Arrays;
import java.util.LinkedList;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.verb.VerbUtils;

public class CleanVerbExtension
implements VerbExtension {
    public boolean handlesVerb(String verb) {
        return "clean".equals(verb);
    }

    public Object executeVerb(Configuration configuration, FlywayTelemetryManager flywayTelemetryManager) {
        ExperimentalDatabase experimentalDatabase;
        if (configuration.isCleanDisabled()) {
            throw new FlywayException("Unable to execute clean as it has been disabled with the 'flyway.cleanDisabled' property.");
        }
        try {
            experimentalDatabase = VerbUtils.getExperimentalDatabase((Configuration)configuration);
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
        ExperimentalModeUtils.logExperimentalDataTelemetry((FlywayTelemetryManager)flywayTelemetryManager, (MetaData)experimentalDatabase.getDatabaseMetaData());
        LinkedList<String> schemas = new LinkedList<String>(Arrays.asList(configuration.getSchemas()));
        String defaultSchema = experimentalDatabase.getDefaultSchema(configuration);
        if (!schemas.contains(defaultSchema)) {
            schemas.add(0, defaultSchema);
        }
        CleanResult cleanResult = new CleanResult(VersionPrinter.getVersion(), experimentalDatabase.getDatabaseMetaData().databaseName());
        cleanResult.operation = "clean";
        experimentalDatabase.doClean(schemas, cleanResult);
        return cleanResult;
    }
}

