/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.db2z;

import java.sql.SQLException;
import org.flywaydb.community.database.db2z.DB2ZDatabase;
import org.flywaydb.community.database.db2z.DB2ZSchema;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class DB2ZTable
extends Table<DB2ZDatabase, DB2ZSchema> {
    private static final Log LOG = LogFactory.getLog(DB2ZTable.class);

    DB2ZTable(JdbcTemplate jdbcTemplate, DB2ZDatabase database, DB2ZSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
    }

    protected void doDrop() throws SQLException {
        String dbName = this.jdbcTemplate.queryForString("SELECT DBNAME FROM SYSIBM.SYSTABLES WHERE NAME=? AND CREATOR=?", new String[]{this.getName(), ((DB2ZSchema)this.getSchema()).getName()});
        String tableSpaceName = this.jdbcTemplate.queryForString("SELECT TSNAME FROM SYSIBM.SYSTABLES WHERE NAME=? AND CREATOR=?", new String[]{this.getName(), ((DB2ZSchema)this.getSchema()).getName()});
        String sqlId = ((DB2ZDatabase)this.database).getSqlId() == "" ? ((DB2ZSchema)this.getSchema()).getName() : ((DB2ZDatabase)this.database).getSqlId();
        String implicit = this.jdbcTemplate.queryForString("SELECT IMPLICIT FROM SYSIBM.SYSTABLESPACE WHERE DBNAME=? AND CREATOR=? AND NAME=?", new String[]{dbName, sqlId, tableSpaceName});
        String tableSpaceType = this.jdbcTemplate.queryForString("SELECT TYPE FROM SYSIBM.SYSTABLESPACE WHERE DBNAME=? AND CREATOR=? AND NAME=?", new String[]{dbName, sqlId, tableSpaceName});
        if (implicit == null || implicit.isEmpty()) {
            LOG.debug("Nothing to drop because table " + this.getName() + " does exist on tablespace " + tableSpaceName + " but with creator other than " + sqlId);
        } else if (implicit.equals("N") && (tableSpaceType.equals("G") || tableSpaceType.equals("R"))) {
            LOG.debug("Table '" + this + "' cannot be dropped directly (tableSpaceName=" + tableSpaceName + ", implicit=" + implicit + ", tableSpaceType=" + tableSpaceType + ")");
        } else {
            LOG.debug("Dropping table " + this + " ...");
            this.jdbcTemplate.execute("DROP TABLE " + this, new Object[0]);
        }
    }

    protected boolean doExists() throws SQLException {
        return this.exists(null, this.schema, this.name, new String[0]);
    }

    protected void doLock() throws SQLException {
        this.jdbcTemplate.update("lock table " + this + " in exclusive mode", new Object[0]);
    }
}

