/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.JdbcDataTypeConverter;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.jdbc.AbstractJdbcWrapper;
import com.google.cloud.spanner.jdbc.JdbcDataType;
import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcPreparedStatement;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.rpc.Code;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.TypeCode;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class JdbcParameterMetaData
extends AbstractJdbcWrapper
implements ParameterMetaData {
    private final JdbcPreparedStatement statement;
    private final StructType parameters;

    JdbcParameterMetaData(JdbcPreparedStatement statement, ResultSet resultSet) {
        this.statement = statement;
        this.parameters = resultSet.getMetadata().getUndeclaredParameters();
    }

    private StructType.Field getField(int param) throws SQLException {
        JdbcPreconditions.checkArgument(param > 0 && param <= this.parameters.getFieldsCount(), param);
        String paramName = "p" + param;
        return this.parameters.getFieldsList().stream().filter(field -> field.getName().equals(paramName)).findAny().orElseThrow(() -> JdbcSqlExceptionFactory.of("Unknown parameter: " + paramName, Code.INVALID_ARGUMENT));
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public int getParameterCount() {
        return this.parameters.getFieldsCount();
    }

    @Override
    public int isNullable(int param) {
        Integer nullable = this.statement.getParameters().getNullable(param);
        return nullable == null ? 2 : nullable;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        int type = this.getParameterType(param);
        return type == 8 || type == 6 || type == 7 || type == -5 || type == 4 || type == 5 || type == -6 || type == 3 || type == 2;
    }

    @Override
    public int getPrecision(int param) {
        Integer length = this.statement.getParameters().getScaleOrLength(param);
        return length == null ? 0 : length;
    }

    @Override
    public int getScale(int param) {
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        JdbcPreconditions.checkArgument(param > 0 && param <= this.parameters.getFieldsCount(), param);
        int typeFromValue = this.getParameterTypeFromValue(param);
        if (typeFromValue != 1111) {
            return typeFromValue;
        }
        com.google.spanner.v1.Type type = this.getField(param).getType();
        if (type.getCode() == TypeCode.ARRAY) {
            return 2003;
        }
        JdbcDataType jdbcDataType = JdbcDataType.getType(JdbcDataTypeConverter.toSpannerType(type).getCode());
        return jdbcDataType == null ? 1111 : jdbcDataType.getSqlType();
    }

    private int getParameterTypeFromValue(int param) {
        Integer type = this.statement.getParameters().getType(param);
        if (type != null) {
            return type;
        }
        Object value = this.statement.getParameters().getParameter(param);
        if (value == null) {
            return 1111;
        }
        if (Boolean.class.isAssignableFrom(value.getClass())) {
            return 16;
        }
        if (Byte.class.isAssignableFrom(value.getClass())) {
            return -6;
        }
        if (Short.class.isAssignableFrom(value.getClass())) {
            return 5;
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return 4;
        }
        if (Long.class.isAssignableFrom(value.getClass())) {
            return -5;
        }
        if (Float.class.isAssignableFrom(value.getClass())) {
            return 7;
        }
        if (Double.class.isAssignableFrom(value.getClass())) {
            return 8;
        }
        if (BigDecimal.class.isAssignableFrom(value.getClass())) {
            return 2;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return 91;
        }
        if (Timestamp.class.isAssignableFrom(value.getClass())) {
            return 93;
        }
        if (Time.class.isAssignableFrom(value.getClass())) {
            return 92;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return -9;
        }
        if (byte[].class.isAssignableFrom(value.getClass())) {
            return -2;
        }
        return 1111;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        JdbcPreconditions.checkArgument(param > 0 && param <= this.parameters.getFieldsCount(), param);
        String typeNameFromValue = this.getParameterTypeNameFromValue(param);
        if (typeNameFromValue != null) {
            return typeNameFromValue;
        }
        Type type = JdbcDataTypeConverter.toSpannerType(this.getField(param).getType());
        return JdbcParameterMetaData.getSpannerTypeName(type, this.statement.getConnection().getDialect());
    }

    private String getParameterTypeNameFromValue(int param) {
        int type = this.getParameterTypeFromValue(param);
        if (type != 1111) {
            return JdbcParameterMetaData.getSpannerTypeName(type);
        }
        return null;
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        JdbcPreconditions.checkArgument(param > 0 && param <= this.parameters.getFieldsCount(), param);
        String classNameFromValue = this.getParameterClassNameFromValue(param);
        if (classNameFromValue != null) {
            return classNameFromValue;
        }
        Type type = JdbcDataTypeConverter.toSpannerType(this.getField(param).getType());
        return JdbcParameterMetaData.getClassName(type);
    }

    private String getParameterClassNameFromValue(int param) {
        Object value = this.statement.getParameters().getParameter(param);
        if (value != null) {
            return value.getClass().getName();
        }
        Integer type = this.statement.getParameters().getType(param);
        if (type != null) {
            return JdbcParameterMetaData.getClassName(type);
        }
        return null;
    }

    @Override
    public int getParameterMode(int param) {
        return 1;
    }

    public String toString() {
        try {
            StringBuilder res = new StringBuilder();
            res.append("CloudSpannerPreparedStatementParameterMetaData, parameter count: ").append(this.getParameterCount());
            for (int param = 1; param <= this.getParameterCount(); ++param) {
                res.append("\nParameter ").append(param).append(":\n\t Class name: ").append(this.getParameterClassName(param));
                res.append(",\n\t Parameter type name: ").append(this.getParameterTypeName(param));
                res.append(",\n\t Parameter type: ").append(this.getParameterType(param));
                res.append(",\n\t Parameter precision: ").append(this.getPrecision(param));
                res.append(",\n\t Parameter scale: ").append(this.getScale(param));
                res.append(",\n\t Parameter signed: ").append(this.isSigned(param));
                res.append(",\n\t Parameter nullable: ").append(this.isNullable(param));
                res.append(",\n\t Parameter mode: ").append(this.getParameterMode(param));
            }
            return res.toString();
        }
        catch (SQLException exception) {
            return "Failed to get parameter metadata: " + exception;
        }
    }
}

