/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate.migrators;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.flywaydb.core.api.LoadableMigrationInfo;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.internal.exception.FlywayMigrateException;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.verb.VerbUtils;
import org.flywaydb.verb.migrate.MigrationExecutionGroup;
import org.flywaydb.verb.migrate.migrators.Migrator;

public class ApiMigrator
extends Migrator {
    private static final Log LOG = LogFactory.getLog(ApiMigrator.class);

    @Override
    public List<MigrationExecutionGroup> createGroups(MigrationInfo[] allPendingMigrations, Configuration configuration, ExperimentalDatabase experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext) {
        return List.of(new MigrationExecutionGroup(List.of(allPendingMigrations), true));
    }

    @Override
    public int doExecutionGroup(Configuration configuration, MigrationExecutionGroup executionGroup, ExperimentalDatabase experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext, int installedRank) {
        boolean executeInTransaction;
        int rank = installedRank;
        boolean bl = executeInTransaction = configuration.isExecuteInTransaction() && executionGroup.shouldExecuteInTransaction();
        if (executeInTransaction) {
            experimentalDatabase.startTransaction();
        }
        for (MigrationInfo migrationInfo : executionGroup.migrations()) {
            this.doIndividualMigration(migrationInfo, experimentalDatabase, configuration, migrateResult, rank);
            ++rank;
        }
        if (executeInTransaction) {
            experimentalDatabase.commitTransaction();
        }
        return rank;
    }

    private void doIndividualMigration(MigrationInfo migrationInfo, ExperimentalDatabase experimentalDatabase, Configuration configuration, MigrateResult migrateResult, int installedRank) {
        StopWatch watch = new StopWatch();
        watch.start();
        boolean outOfOrder = migrationInfo.getState() == MigrationState.OUT_OF_ORDER && configuration.isOutOfOrder();
        String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)false, (ExperimentalDatabase)experimentalDatabase, (boolean)outOfOrder);
        try {
            if (configuration.isSkipExecutingMigrations()) {
                LOG.debug("Skipping execution of migration of " + migrationText);
            } else {
                LOG.debug("Starting migration of " + migrationText + " ...");
                if (!migrationInfo.getType().isUndo()) {
                    LOG.info("Migrating " + migrationText);
                } else {
                    LOG.info("Undoing migration of " + migrationText);
                }
                String executionUnit = String.join((CharSequence)"\n", Files.readAllLines(Path.of(migrationInfo.getPhysicalLocation(), new String[0])));
                experimentalDatabase.doExecute(executionUnit, configuration.isOutputQueryResults());
            }
        }
        catch (Exception e) {
            watch.stop();
            int totalTimeMillis = (int)watch.getTotalTimeMillis();
            this.handleMigrationError(e, experimentalDatabase, migrationInfo, migrateResult, configuration.getTable(), configuration.isOutOfOrder(), installedRank, experimentalDatabase.getInstalledBy(configuration), totalTimeMillis);
        }
        watch.stop();
        ++migrateResult.migrationsExecuted;
        int totalTimeMillis = (int)watch.getTotalTimeMillis();
        migrateResult.putSuccessfulMigration(migrationInfo, totalTimeMillis);
        if (migrationInfo.isVersioned()) {
            migrateResult.targetSchemaVersion = migrationInfo.getVersion().getVersion();
        }
        migrateResult.migrations.add(CommandResultFactory.createMigrateOutput((MigrationInfo)migrationInfo, (int)totalTimeMillis, null));
        ApiMigrator.updateSchemaHistoryTable(configuration.getTable(), migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, experimentalDatabase.getInstalledBy(configuration), true);
    }

    private void handleMigrationError(Exception e, ExperimentalDatabase experimentalDatabase, MigrationInfo migrationInfo, MigrateResult migrateResult, String schemaHistoryTableName, boolean outOfOrder, int installedRank, String installedBy, int totalTimeMillis) {
        String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)false, (ExperimentalDatabase)experimentalDatabase, (boolean)outOfOrder);
        String failedMsg = !migrationInfo.getType().isUndo() ? "Migration of " + migrationText + " failed!" : "Undo of migration of " + migrationText + " failed!";
        migrateResult.putFailedMigration(migrationInfo, totalTimeMillis);
        migrateResult.setSuccess(false);
        LOG.error(failedMsg + " Please restore backups and roll back database and code!");
        ApiMigrator.updateSchemaHistoryTable(schemaHistoryTableName, migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, installedBy, false);
        throw new FlywayMigrateException(migrationInfo, this.calculateErrorMessage(e, migrationInfo), true, migrateResult);
    }

    private String calculateErrorMessage(Exception e, MigrationInfo migrationInfo) {
        String title = "Script " + Paths.get(migrationInfo.getScript(), new String[0]).getFileName() + " failed";
        String underline = StringUtils.trimOrPad((String)"", (int)title.length(), (char)'-');
        StringBuilder messageBuilder = new StringBuilder().append(title).append("\n").append(underline).append("\n");
        messageBuilder.append("Message    : ").append(e.getMessage()).append("\n");
        if (migrationInfo instanceof LoadableMigrationInfo) {
            LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
            messageBuilder.append("Location   : ").append(loadableMigrationInfo.getLoadableResource().getAbsolutePath()).append(" (").append(loadableMigrationInfo.getLoadableResource().getAbsolutePathOnDisk()).append(")\n");
        } else {
            messageBuilder.append("Location   : ").append(migrationInfo.getPhysicalLocation());
        }
        return messageBuilder.toString();
    }
}

