/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.exception.FlywayValidateException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.ValidateResult;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.experimental.ConnectionType;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.TimeFormat;
import org.flywaydb.core.internal.util.ValidatePatternUtils;
import org.flywaydb.verb.VerbUtils;
import org.flywaydb.verb.info.ExperimentalMigrationInfoService;
import org.flywaydb.verb.migrate.MigrationExecutionGroup;
import org.flywaydb.verb.migrate.migrators.ApiMigrator;
import org.flywaydb.verb.migrate.migrators.ExecutableMigrator;
import org.flywaydb.verb.migrate.migrators.JdbcMigrator;
import org.flywaydb.verb.migrate.migrators.Migrator;
import org.flywaydb.verb.schemas.SchemasVerbExtension;
import org.flywaydb.verb.validate.ValidateVerbExtension;

public class MigrateVerbExtension
implements VerbExtension {
    private static final Log LOG = LogFactory.getLog(MigrateVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "migrate".equals(verb);
    }

    public Object executeVerb(Configuration configuration, FlywayTelemetryManager flywayTelemetryManager) {
        ExperimentalDatabase experimentalDatabase;
        if (configuration.isValidateOnMigrate()) {
            MigrateVerbExtension.validate(configuration, flywayTelemetryManager);
        }
        try {
            experimentalDatabase = VerbUtils.getExperimentalDatabase((Configuration)configuration);
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
        ExperimentalModeUtils.logExperimentalDataTelemetry((FlywayTelemetryManager)flywayTelemetryManager, (MetaData)experimentalDatabase.getDatabaseMetaData());
        if (configuration.isCreateSchemas()) {
            try {
                new SchemasVerbExtension().executeVerb(configuration, flywayTelemetryManager);
            }
            catch (NoClassDefFoundError e) {
                throw new FlywayException("Schemas verb extension is required for creating schemas but is not present", (Throwable)e);
            }
        }
        if (!experimentalDatabase.schemaHistoryTableExists(configuration.getTable())) {
            List<String> populatedSchemas = Arrays.stream(VerbUtils.getAllSchemasFromConfiguration((Configuration)configuration)).filter(arg_0 -> ((ExperimentalDatabase)experimentalDatabase).isSchemaExists(arg_0)).filter(x -> !experimentalDatabase.isSchemaEmpty(x)).toList();
            if (!populatedSchemas.isEmpty() && !configuration.isSkipExecutingMigrations()) {
                if (configuration.isBaselineOnMigrate()) {
                    new Flyway(configuration).baseline();
                } else {
                    throw new FlywayException("Found non-empty schema(s) " + StringUtils.collectionToCommaDelimitedString(populatedSchemas) + " but no schema history table. Use baseline() or set baselineOnMigrate to true to initialize the schema history table.", (ErrorCode)CoreErrorCode.NON_EMPTY_SCHEMA_WITHOUT_SCHEMA_HISTORY_TABLE);
                }
            }
        }
        experimentalDatabase.createSchemaHistoryTableIfNotExists(configuration.getTable());
        SchemaHistoryModel schemaHistoryModel = VerbUtils.getSchemaHistoryModel((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase);
        MigrationInfo[] migrations = VerbUtils.getMigrationInfos((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase, (SchemaHistoryModel)VerbUtils.getSchemaHistoryModel((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase));
        MigrateResult migrateResult = new MigrateResult(VersionPrinter.getVersion(), experimentalDatabase.getDatabaseMetaData().databaseName(), "", experimentalDatabase.getDatabaseType());
        ExperimentalMigrationInfoService migrationInfoService = new ExperimentalMigrationInfoService(migrations, configuration, experimentalDatabase.getName(), experimentalDatabase.allSchemasEmpty(VerbUtils.getAllSchemasFromConfiguration((Configuration)configuration)));
        MigrationInfo current = migrationInfoService.current();
        MigrationVersion initialSchemaVersion = current != null && current.isVersioned() ? current.getVersion() : MigrationVersion.EMPTY;
        migrateResult.initialSchemaVersion = initialSchemaVersion.getVersion();
        MigrationInfo[] allPendingMigrations = migrationInfoService.pending();
        if (allPendingMigrations.length > 1 && configuration.getTarget().equals((Object)MigrationVersion.NEXT)) {
            allPendingMigrations = Arrays.copyOf(allPendingMigrations, 1);
        }
        LOG.info("Current version of schema " + experimentalDatabase.doQuote(experimentalDatabase.getCurrentSchema()) + ": " + initialSchemaVersion);
        MigrateVerbExtension.secondValidate((MigrationInfoService)migrationInfoService, configuration, experimentalDatabase.doQuote(experimentalDatabase.getCurrentSchema()));
        if (configuration.isOutOfOrder()) {
            String outOfOrderWarning = "outOfOrder mode is active. Migration of schema " + experimentalDatabase.doQuote(experimentalDatabase.getCurrentSchema()) + " may not be reproducible.";
            LOG.warn(outOfOrderWarning);
            migrateResult.addWarning(outOfOrderWarning);
        } else {
            allPendingMigrations = this.removeOutOfOrderPendingMigrations(allPendingMigrations);
        }
        ParsingContext parsingContext = new ParsingContext();
        parsingContext.populate(experimentalDatabase, configuration);
        Migrator migrator = switch (experimentalDatabase.getDatabaseMetaData().connectionType()) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionType.API -> new ApiMigrator();
            case ConnectionType.JDBC -> new JdbcMigrator();
            case ConnectionType.EXECUTABLE -> new ExecutableMigrator();
        };
        List<MigrationExecutionGroup> executionGroups = migrator.createGroups(allPendingMigrations, configuration, experimentalDatabase, migrateResult, parsingContext);
        int installedRank = experimentalDatabase.getSchemaHistoryModel(configuration.getTable()).calculateInstalledRank((MigrationType)CoreMigrationType.SQL);
        for (MigrationExecutionGroup executionGroup : executionGroups) {
            installedRank = migrator.doExecutionGroup(configuration, executionGroup, experimentalDatabase, migrateResult, parsingContext, installedRank);
        }
        this.logSummary(migrateResult.migrationsExecuted, migrateResult.getTotalMigrationTime(), migrateResult.targetSchemaVersion, experimentalDatabase);
        try {
            experimentalDatabase.close();
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
        return migrateResult;
    }

    private static void validate(Configuration configuration, FlywayTelemetryManager flywayTelemetryManager) {
        FluentConfiguration validateConfig = new FluentConfiguration().configuration(configuration);
        ArrayList<ValidatePattern> ignorePatterns = new ArrayList<ValidatePattern>(Arrays.asList(configuration.getIgnoreMigrationPatterns()));
        ignorePatterns.add(ValidatePattern.fromPattern((String)"*:pending"));
        validateConfig.ignoreMigrationPatterns((ValidatePattern[])ignorePatterns.toArray(ValidatePattern[]::new));
        ValidateResult validateResult = (ValidateResult)new ValidateVerbExtension().executeVerb((Configuration)validateConfig, flywayTelemetryManager);
        if (!validateResult.validationSuccessful) {
            throw new FlywayValidateException(validateResult.errorDetails, validateResult.getAllErrorMessages());
        }
    }

    private static void secondValidate(MigrationInfoService infoService, Configuration configuration, String schema) {
        List<MigrationInfo> failed = Arrays.stream(infoService.all()).filter(migrationInfo -> migrationInfo.getState().isFailed()).toList();
        if (failed.isEmpty()) {
            return;
        }
        MigrationInfo firstFailure = failed.get(0);
        if (failed.size() == 1 && firstFailure.getState() == MigrationState.FUTURE_FAILED && ValidatePatternUtils.isFutureIgnored((ValidatePattern[])configuration.getIgnoreMigrationPatterns())) {
            LOG.warn("Schema " + schema + " contains a failed future migration to version " + firstFailure.getVersion() + " !");
            return;
        }
        if (firstFailure.isRepeatable()) {
            throw new FlywayException("Schema " + schema + " contains a failed repeatable migration (\"" + firstFailure.getDescription() + "\") !");
        }
        throw new FlywayException("Schema " + schema + " contains a failed migration to version " + firstFailure.getVersion() + " !");
    }

    private MigrationInfo[] removeOutOfOrderPendingMigrations(MigrationInfo[] migrations) {
        ArrayList<MigrationInfo> result = new ArrayList<MigrationInfo>();
        for (MigrationInfo migration : migrations) {
            if (migration.isVersioned() && !result.isEmpty() && !migration.getVersion().isNewerThan(((MigrationInfo)result.get(result.size() - 1)).getVersion())) continue;
            result.add(migration);
        }
        return (MigrationInfo[])result.toArray(MigrationInfo[]::new);
    }

    private void logSummary(int migrationSuccessCount, long executionTime, String targetVersion, ExperimentalDatabase experimentalDatabase) {
        String schemaName = experimentalDatabase.doQuote(experimentalDatabase.getCurrentSchema());
        if (migrationSuccessCount == 0) {
            LOG.info("Schema " + schemaName + " is up to date. No migration necessary.");
            return;
        }
        Object targetText = targetVersion != null ? ", now at version v" + targetVersion : "";
        String migrationText = "migration" + StringUtils.pluralizeSuffix((long)migrationSuccessCount);
        LOG.info("Successfully applied %d %s to schema %s%s (execution time %s)".formatted(migrationSuccessCount, migrationText, schemaName, targetText, TimeFormat.format((long)executionTime)));
    }
}

