/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.server;

import com.singlestore.jdbc.ServerPreparedStatement;
import com.singlestore.jdbc.client.Client;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.context.Context;
import com.singlestore.jdbc.client.socket.PacketReader;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import com.singlestore.jdbc.message.server.Completion;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import java.io.IOException;
import java.sql.SQLException;

public class PrepareResultPacket
implements Completion {
    private static final Logger logger = Loggers.getLogger(PrepareResultPacket.class);
    private final ColumnDefinitionPacket[] parameters;
    private ColumnDefinitionPacket[] columns;
    protected int statementId;

    public PrepareResultPacket(ReadableByteBuf buffer, PacketReader reader, Context context) throws IOException {
        int i;
        boolean trace = logger.isTraceEnabled();
        buffer.readByte();
        this.statementId = buffer.readInt();
        int numColumns = buffer.readUnsignedShort();
        int numParams = buffer.readUnsignedShort();
        this.parameters = new ColumnDefinitionPacket[numParams];
        this.columns = new ColumnDefinitionPacket[numColumns];
        if (numParams > 0) {
            for (i = 0; i < numParams; ++i) {
                this.parameters[i] = new ColumnDefinitionPacket(reader.readPacket(false, trace), (context.getServerCapabilities() & 0x800000000L) > 0L);
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
        if (numColumns > 0) {
            for (i = 0; i < numColumns; ++i) {
                this.columns[i] = new ColumnDefinitionPacket(reader.readPacket(false, trace), (context.getServerCapabilities() & 0x800000000L) > 0L);
            }
            if (!context.isEofDeprecated()) {
                reader.readPacket(true, trace);
            }
        }
    }

    public void close(Client con) throws SQLException {
        con.closePrepare(this);
    }

    public void decrementUse(Client con, ServerPreparedStatement preparedStatement) throws SQLException {
        this.close(con);
    }

    public int getStatementId() {
        return this.statementId;
    }

    public ColumnDefinitionPacket[] getParameters() {
        return this.parameters;
    }

    public ColumnDefinitionPacket[] getColumns() {
        return this.columns;
    }

    public void setColumns(ColumnDefinitionPacket[] columns) {
        this.columns = columns;
    }
}

