/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.clickhouse;

import java.util.Map;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public class ClickHouseConfigurationExtension
implements ConfigurationExtension {
    private static final String CLUSTER_NAME = "flyway.clickhouse.clusterName";
    private static final String ZOOKEEPER_PATH = "flyway.clickhouse.zookeeperPath";
    private static final String ZOOKEEPER_PATH_DEFAULT_VALUE = "/clickhouse/tables/{shard}/{database}/{table}";
    private String clusterName;
    private String zookeeperPath = "/clickhouse/tables/{shard}/{database}/{table}";

    public String getNamespace() {
        return "clickhouse";
    }

    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        String zookeeperPath;
        String clusterName = configuration.remove(CLUSTER_NAME);
        if (clusterName != null) {
            this.clusterName = clusterName;
        }
        if ((zookeeperPath = configuration.remove(ZOOKEEPER_PATH)) != null) {
            this.zookeeperPath = zookeeperPath;
        }
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        if ("FLYWAY_CLICKHOUSE_CLUSTER_NAME".equals(environmentVariable)) {
            return CLUSTER_NAME;
        }
        if ("FLYWAY_CLICKHOUSE_ZOOKEEPER_PATH".equals(environmentVariable)) {
            return ZOOKEEPER_PATH;
        }
        return null;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getZookeeperPath() {
        return this.zookeeperPath;
    }
}

