/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import java.io.Console;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.commandline.Main;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.CommandLineConfigurationUtils;
import org.flywaydb.commandline.configuration.ConfigurationManager;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class LegacyConfigurationManager
implements ConfigurationManager {
    private static final Log LOG = LogFactory.getLog(LegacyConfigurationManager.class);

    @Override
    public Configuration getConfiguration(CommandLineArguments commandLineArguments) {
        Map<String, String> config = new HashMap<String, String>();
        String installDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : ClassUtils.getInstallDir(Main.class);
        String workingDirectory = commandLineArguments.getWorkingDirectoryOrNull();
        File jarDir = new File(installDirectory, "jars");
        ConfigUtils.warnIfUsingDeprecatedMigrationsFolder((File)jarDir, (String)".jar");
        if (jarDir.exists()) {
            config.put("flyway.jarDirs", jarDir.getAbsolutePath());
        }
        Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
        this.loadConfigurationFromConfigFiles(config, commandLineArguments, envVars);
        config.putAll(envVars);
        config = LegacyConfigurationManager.overrideConfiguration(config, commandLineArguments.getConfiguration(false));
        File sqlFolder = new File(installDirectory, "sql");
        if (ConfigUtils.shouldUseDefaultCliSqlLocation((File)sqlFolder, (boolean)StringUtils.hasText((String)config.get("flyway.locations")))) {
            config.put("flyway.locations", "filesystem:" + sqlFolder.getAbsolutePath());
        }
        if (workingDirectory != null) {
            ConfigUtils.makeRelativeLocationsBasedOnWorkingDirectory((String)workingDirectory, config);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<File> jarFiles = new ArrayList<File>(CommandLineConfigurationUtils.getJdbcDriverJarFiles());
        String jarDirs = config.get("flyway.jarDirs");
        if (StringUtils.hasText((String)jarDirs)) {
            jarFiles.addAll(CommandLineConfigurationUtils.getJavaMigrationJarFiles(StringUtils.tokenizeToStringArray((String)jarDirs.replace(File.pathSeparator, ","), (String)",")));
        }
        if (!jarFiles.isEmpty()) {
            classLoader = ClassUtils.addJarsOrDirectoriesToClasspath((ClassLoader)classLoader, jarFiles);
        }
        ConfigUtils.dumpConfigurationMap(config);
        this.filterProperties(config);
        FluentConfiguration configuration = new FluentConfiguration(classLoader).configuration(config).workingDirectory(workingDirectory);
        if (!commandLineArguments.shouldSuppressPrompt()) {
            this.promptForCredentialsIfMissing(config, configuration);
        }
        return configuration;
    }

    protected void loadConfigurationFromConfigFiles(Map<String, String> config, CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        String encoding = LegacyConfigurationManager.determineConfigurationFileEncoding(commandLineArguments, envVars);
        File installationDir = new File(ClassUtils.getInstallDir(Main.class));
        String workingDirectory = commandLineArguments.getWorkingDirectoryOrNull();
        config.putAll(ConfigUtils.loadDefaultConfigurationFiles((File)installationDir, (String)workingDirectory, (String)encoding));
        for (File configFile : LegacyConfigurationManager.determineLegacyConfigFilesFromArgs(commandLineArguments)) {
            config.putAll(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
    }

    private static String determineConfigurationFileEncoding(CommandLineArguments commandLineArguments, Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        if (commandLineArguments.isConfigFileEncodingSet()) {
            return commandLineArguments.getConfigFileEncoding();
        }
        return "UTF-8";
    }

    private static List<File> determineLegacyConfigFilesFromArgs(CommandLineArguments commandLineArguments) {
        List<File> legacyFiles = commandLineArguments.getConfigFilePathsFromEnv(false);
        legacyFiles.addAll(commandLineArguments.getConfigFiles().stream().filter(s -> !s.endsWith(".toml")).map(File::new).toList());
        return legacyFiles;
    }

    private static Map<String, String> overrideConfiguration(Map<String, String> existingConfiguration, Map<String, String> newConfiguration) {
        HashMap<String, String> combinedConfiguration = new HashMap<String, String>();
        combinedConfiguration.putAll(existingConfiguration);
        combinedConfiguration.putAll(newConfiguration);
        return combinedConfiguration;
    }

    private void promptForCredentialsIfMissing(Map<String, String> config, FluentConfiguration configuration) {
        boolean hasPassword;
        Console console = System.console();
        if (console == null) {
            return;
        }
        if (!config.containsKey("flyway.url")) {
            return;
        }
        String url = config.get("flyway.url");
        boolean interactivePrompted = false;
        boolean hasUser = config.containsKey("flyway.user");
        if (!hasUser && this.needsUser(url, config.getOrDefault("flyway.password", null), (Configuration)configuration)) {
            configuration.dataSource(configuration.getUrl(), console.readLine("Database user: ", new Object[0]), configuration.getPassword());
            interactivePrompted = true;
        }
        if (!(hasPassword = config.containsKey("flyway.password")) && this.needsPassword(url, config.get("flyway.user"), (Configuration)configuration)) {
            char[] password = console.readPassword("Database password: ", new Object[0]);
            configuration.dataSource(configuration.getUrl(), configuration.getUser(), password == null ? "" : String.valueOf(password));
            interactivePrompted = true;
        }
        if (interactivePrompted) {
            LOG.warn("Interactive prompt behavior is deprecated and will be removed in a future release - please consider alternatives like secrets management tools or environment variables");
        }
    }

    boolean needsUser(String url, String password, Configuration configuration) {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForUrl((String)url);
        return databaseType.detectUserRequiredByUrl(url);
    }

    boolean needsPassword(String url, String username, Configuration configuration) {
        DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForUrl((String)url);
        return databaseType.detectPasswordRequiredByUrl(url);
    }

    private void filterProperties(Map<String, String> config) {
        config.remove("flyway.jarDirs");
        config.remove("flyway.configFiles");
        config.remove("flyway.configFileEncoding");
    }
}

