/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.saphana;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.saphana.SAPHANADatabase;
import org.flywaydb.database.saphana.SAPHANASchema;

public class SAPHANAConnection
extends org.flywaydb.core.internal.database.base.Connection<SAPHANADatabase> {
    private final boolean isCloud;

    SAPHANAConnection(SAPHANADatabase database, Connection connection) {
        super((Database)database, connection);
        try {
            String buildBranch;
            String buildQrcVersion = this.jdbcTemplate.queryForString("SELECT VALUE FROM M_HOST_INFORMATION WHERE KEY='build_qrc_version'", new String[0]);
            this.isCloud = StringUtils.hasText((String)buildQrcVersion) ? true : StringUtils.hasText((String)(buildBranch = this.jdbcTemplate.queryForString("SELECT VALUE FROM M_HOST_INFORMATION WHERE KEY='build_branch'", new String[0]))) && buildBranch.startsWith("fa/CE");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine build edition", e);
        }
    }

    public boolean isCloudConnection() {
        return this.isCloud;
    }

    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT CURRENT_SCHEMA FROM DUMMY", new String[0]);
    }

    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + ((SAPHANADatabase)this.database).doQuote(schema), new Object[0]);
    }

    public Schema getSchema(String name) {
        return new SAPHANASchema(this.jdbcTemplate, (SAPHANADatabase)this.database, name);
    }
}

