/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.fips.FIPS_140_2;

public class ASN1Null
implements ASN1TaggedObject {
    private static final ASN1Header a = new ASN1Header(5, 0, 0, 0);

    public ASN1Null() {
    }

    public ASN1Null(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    @Override
    public ASN1Header getHeader() {
        return a;
    }

    public String toString() {
        return "NULL";
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(5);
        aSN1Header.checkEncodingMethod(0);
        if (aSN1Header.getBodyLength() != 0) {
            throw new ASN1FormatException("NULL object has non-zero length.");
        }
    }

    @Override
    public int length() {
        return a.totalLength();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        a.output(outputStream);
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

