// vim:ts=2:sw=2:expandtab:autoindent:filetype=cpp:
/*
The MIT License

Copyright (c) 2008, 2009 Flusspferd contributors (see "CONTRIBUTORS" or
                                       http://flusspferd.org/contributors.txt)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef FLUSSPFERD_HPP
#define FLUSSPFERD_HPP

/**
 * @file flusspferd.hpp
 *
 * Include most Flusspferd headers.
 */

#include "flusspferd/arguments.hpp"
#include "flusspferd/array.hpp"
#include "flusspferd/binary.hpp"
#include "flusspferd/call_context.hpp"
#include "flusspferd/class.hpp"
#include "flusspferd/class_description.hpp"
#include "flusspferd/context.hpp"
#include "flusspferd/convert.hpp"
#include "flusspferd/create.hpp"
#include "flusspferd/current_context_scope.hpp"
#include "flusspferd/encodings.hpp"
#include "flusspferd/evaluate.hpp"
#include "flusspferd/exception.hpp"
#include "flusspferd/function_adapter.hpp"
#include "flusspferd/function.hpp"
#include "flusspferd/getopt.hpp"
#include "flusspferd/modules.hpp"
#include "flusspferd/init.hpp"
#include "flusspferd/load_core.hpp"
#include "flusspferd/local_root_scope.hpp"
#include "flusspferd/native_function_base.hpp"
#include "flusspferd/native_function.hpp"
#include "flusspferd/native_object_base.hpp"
#include "flusspferd/object.hpp"
#include "flusspferd/properties_functions.hpp"
#include "flusspferd/property_attributes.hpp"
#include "flusspferd/property_iterator.hpp"
#include "flusspferd/root.hpp"
#include "flusspferd/security.hpp"
#include "flusspferd/string.hpp"
#include "flusspferd/string_io.hpp"
#include "flusspferd/system.hpp"
#include "flusspferd/tracer.hpp"
#include "flusspferd/value.hpp"
#include "flusspferd/value_io.hpp"
#include "flusspferd/version.hpp"

#endif
