/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <fluent-bit/flb_info.h>
#include <fluent-bit/flb_sha512.h>

#include "flb_tests_internal.h"

static uint8_t sha512_abcdef[] = {
    0xe3, 0x2e, 0xf1, 0x96, 0x23, 0xe8, 0xed, 0x9d,
    0x26, 0x7f, 0x65, 0x7a, 0x81, 0x94, 0x4b, 0x3d,
    0x07, 0xad, 0xbb, 0x76, 0x85, 0x18, 0x06, 0x8e,
    0x88, 0x43, 0x57, 0x45, 0x56, 0x4e, 0x8d, 0x41,
    0x50, 0xa0, 0xa7, 0x03, 0xbe, 0x2a, 0x7d, 0x88,
    0xb6, 0x1e, 0x3d, 0x39, 0x0c, 0x2b, 0xb9, 0x7e,
    0x2d, 0x4c, 0x31, 0x1f, 0xdc, 0x69, 0xd6, 0xb1,
    0x26, 0x7f, 0x05, 0xf5, 0x9a, 0xa9, 0x20, 0xe7
};

static void test_sha512()
{
    struct flb_sha512 sha512;
    uint8_t buf[64];

    flb_sha512_init(&sha512);
    flb_sha512_update(&sha512, "abc", 3);
    flb_sha512_update(&sha512, "def", 3);
    flb_sha512_sum(&sha512, buf);

    TEST_CHECK(memcmp(buf, sha512_abcdef, 64) == 0);
}

TEST_LIST = {
    { "test_sha512", test_sha512 },
    { 0 }
};
