//
// Setting and shell dialogs for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2023 by Bill Spitzak and others.
//
// This library is free software. Distribution and use rights are outlined in
// the file "COPYING" which should have been included with this file.  If this
// file is missing or damaged, see the license at:
//
//     https://www.fltk.org/COPYING.php
//
// Please see the following page on how to report bugs and issues:
//
//     https://www.fltk.org/bugs.php
//

// generated by Fast Light User Interface Designer (fluid) version 1.0400

#include "alignment_panel.h"
#include "undo.h"
#include <FL/Fl_Preferences.H>
#include <FL/Fl_Tooltip.H>
#include <FL/fl_ask.H>
#include <string.h>
void scheme_cb(Fl_Scheme_Choice *, void *);

Fl_Double_Window *settings_window=(Fl_Double_Window *)0;

Fl_Tabs *w_settings_tabs=(Fl_Tabs *)0;

static void cb_w_settings_tabs(Fl_Tabs* o, void* v) {
  propagate_load(o, v);
}

#include <FL/Fl_PNG_Image.H>

static const unsigned char idata_general_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,8,57,73,68,65,84,104,222,205,154,107,112,85,213,21,199,127,
151,60,185,36,18,66,204,131,120,155,82,136,163,131,4,41,180,130,36,2,117,8,15,
173,58,109,103,168,97,42,67,135,78,167,84,16,59,118,192,41,29,201,244,3,14,182,
14,62,74,77,149,42,12,226,180,160,130,19,32,136,144,34,193,240,104,136,52,193,
18,196,16,200,131,128,121,191,47,185,247,158,126,72,206,221,251,60,238,189,39,
112,46,115,247,249,178,207,217,123,159,179,214,218,107,173,255,90,107,31,176,
187,37,81,72,13,237,184,25,196,135,130,130,143,65,220,180,83,67,33,73,68,120,
203,162,114,152,108,179,203,199,89,178,34,155,129,210,128,196,171,87,73,36,147,
63,11,119,72,6,220,60,108,231,39,71,217,204,64,108,200,57,177,204,180,243,147,
209,182,50,112,175,191,167,188,231,72,197,65,52,224,65,225,58,43,20,28,195,99,
223,139,92,6,114,212,206,115,142,185,196,73,3,110,86,59,222,80,111,210,34,87,
133,198,169,157,4,162,52,3,81,36,138,155,187,35,149,129,120,225,229,83,116,12,
140,98,172,184,153,100,231,190,223,202,171,82,153,137,135,47,185,161,123,158,41,
196,156,233,87,120,149,1,9,193,146,201,160,94,183,54,141,217,140,226,20,141,225,
118,148,73,108,167,29,47,30,218,216,71,174,127,7,147,216,196,13,225,44,15,40,77,
186,107,135,236,74,27,217,64,130,95,132,115,41,166,29,47,94,58,217,65,114,56,
201,143,231,51,157,79,175,100,5,78,150,114,69,198,95,151,114,204,192,64,137,30,
147,107,200,39,129,149,124,201,77,205,200,49,156,225,99,96,155,73,152,224,165,
89,71,130,50,77,57,99,96,224,164,114,191,126,229,0,205,120,77,194,141,183,71,
66,82,212,8,230,174,96,131,201,124,135,222,229,36,243,56,15,51,90,55,109,144,
38,174,208,175,181,191,4,157,169,12,189,47,135,58,254,107,149,40,135,101,242,
93,156,9,237,193,103,243,20,51,112,201,78,83,69,54,186,168,231,52,123,249,79,
232,111,53,49,203,96,230,183,189,3,219,69,8,176,148,181,164,114,141,30,205,132,
251,89,199,175,153,77,154,6,194,132,164,226,73,101,42,115,152,200,101,58,52,99,
233,20,176,26,39,85,234,131,68,82,248,216,222,29,152,79,137,26,231,76,103,51,83,
232,161,150,227,236,163,122,120,66,1,203,185,143,24,11,175,114,83,205,54,246,
162,190,237,113,114,153,72,2,213,172,163,82,76,202,231,115,59,25,40,103,150,218,
45,98,201,240,198,221,164,145,51,236,231,48,235,249,57,169,35,48,167,38,118,
178,133,37,60,198,116,38,12,75,198,203,62,158,21,83,62,99,129,125,12,44,96,191,
42,220,103,88,39,34,6,192,199,13,174,49,137,187,70,232,208,218,185,194,4,82,52,
161,64,43,47,243,190,176,250,133,148,218,101,3,69,100,15,117,156,252,129,201,6,
39,148,97,170,245,193,219,104,210,25,163,147,159,19,39,187,5,101,99,196,205,
237,197,66,89,252,80,237,254,130,41,97,5,250,105,252,74,222,119,11,233,167,149,
88,104,145,240,138,249,254,8,32,120,243,209,78,61,77,12,224,32,142,76,92,36,89,
146,85,34,243,4,142,221,197,34,138,236,96,32,93,221,105,39,221,220,12,153,116,
41,92,163,140,35,156,160,205,15,109,121,60,202,28,241,162,32,30,106,64,214,206,
84,123,108,96,10,75,134,190,60,72,5,9,184,12,40,43,55,15,167,120,149,55,184,40,
161,110,63,53,28,164,137,52,210,131,238,67,43,31,179,70,150,196,238,208,168,103,
133,129,22,86,16,63,212,237,226,48,94,238,97,92,0,89,122,56,194,70,78,153,142,
93,228,44,46,178,2,176,160,112,137,191,179,89,235,168,126,79,167,29,12,116,16,
71,158,248,110,5,117,164,144,97,170,125,229,108,224,155,128,47,106,227,60,57,
100,154,170,78,25,175,242,145,252,200,203,75,28,180,203,141,30,167,139,92,161,
252,117,156,32,1,151,33,238,109,226,117,173,244,251,248,150,30,162,5,64,183,209,
203,15,12,142,160,133,15,249,147,31,211,1,232,225,69,94,67,177,211,195,61,194,
37,109,224,251,182,46,96,110,80,182,200,227,189,252,153,73,196,19,79,54,175,
211,47,70,182,42,13,186,149,127,211,135,212,53,214,107,71,214,115,226,207,153,
195,30,124,226,193,120,3,182,150,202,178,95,198,11,124,195,0,3,124,205,26,126,
41,220,203,33,218,13,121,146,198,3,239,33,143,47,194,145,212,95,103,169,216,
214,100,57,77,7,160,158,195,50,118,239,213,12,126,192,187,66,31,175,27,146,105,
167,176,229,215,88,106,200,182,109,171,74,248,168,81,187,19,12,154,220,68,159,
144,255,91,134,181,91,212,225,54,90,117,67,99,229,90,87,141,188,203,246,151,85,
226,84,255,25,101,88,234,22,221,78,174,26,86,54,8,151,216,106,32,34,74,128,215,
8,195,42,123,11,91,193,223,235,184,83,31,10,142,245,138,234,166,125,134,205,
145,138,47,247,24,86,126,71,24,77,138,65,51,189,194,6,220,225,101,224,1,85,142,
181,116,7,54,197,209,172,54,172,124,94,141,64,146,13,254,171,131,90,177,75,83,
71,70,211,72,38,167,113,128,85,194,78,187,12,89,127,190,184,89,201,211,154,193,
229,44,23,128,146,22,216,252,225,55,124,66,70,56,24,152,207,41,22,203,243,91,13,
69,187,31,201,174,253,31,188,233,7,178,34,138,132,134,45,212,100,116,67,193,
158,134,162,199,40,231,81,187,109,229,69,250,100,172,76,87,54,43,213,134,226,85,
133,242,99,45,162,246,210,72,147,118,229,83,74,165,97,93,149,242,178,146,174,93,
217,199,70,107,194,181,22,11,253,145,66,57,13,152,207,75,44,48,169,253,36,146,
202,89,127,22,0,196,144,72,162,92,170,200,102,189,116,10,34,82,201,251,152,70,
27,151,229,149,143,16,195,81,123,24,152,200,123,114,220,182,138,231,200,9,144,
9,165,227,226,188,204,130,166,101,179,145,135,76,5,27,141,139,7,137,149,195,
127,7,223,103,31,223,218,193,64,1,63,81,125,79,58,27,89,70,70,64,151,62,138,44,
166,209,195,69,147,177,39,89,207,67,1,83,64,7,227,200,97,50,135,196,163,88,234,
57,97,71,74,121,183,74,111,50,175,144,23,34,165,140,102,6,46,22,115,80,151,82,
46,100,54,169,33,176,108,28,63,229,119,101,228,74,229,4,91,146,250,102,134,15,
232,218,24,109,225,24,210,65,26,79,144,199,117,90,105,193,65,10,227,73,179,152,
212,199,176,39,247,103,226,182,214,30,6,74,232,86,235,86,37,76,53,49,94,51,85,
26,111,128,43,43,173,151,99,114,72,126,192,30,28,184,34,52,113,23,95,133,181,
46,84,205,54,57,15,252,202,30,6,224,21,6,85,161,236,209,1,152,66,43,103,13,168,
28,186,245,80,73,139,46,158,234,100,191,192,100,15,127,181,15,7,234,88,132,107,
168,91,197,84,178,135,249,246,208,72,41,239,178,137,104,38,90,44,121,169,185,
209,78,94,224,42,110,156,36,12,191,205,199,81,10,229,250,192,122,251,24,128,75,
20,168,246,210,192,116,82,233,231,2,197,108,229,45,254,199,32,95,208,69,186,
174,84,27,184,114,116,158,34,182,50,200,5,14,82,69,55,177,36,18,195,5,254,66,
131,40,237,254,150,175,173,16,102,61,70,223,141,223,61,60,205,60,170,217,171,59,
68,121,128,101,204,39,51,168,76,124,92,163,148,247,57,167,11,3,159,224,65,142,
179,67,60,250,132,39,173,145,101,243,17,211,92,22,51,131,239,50,198,100,172,143,
58,42,248,148,35,86,74,105,115,76,177,240,54,219,114,6,67,254,76,163,160,184,
148,103,149,42,67,192,118,94,121,94,113,41,86,214,227,97,101,120,242,129,237,
108,55,41,53,41,180,227,209,86,39,254,77,175,137,252,143,234,207,237,60,180,155,
150,174,118,241,78,184,50,178,53,148,233,72,56,199,90,238,165,128,58,249,113,
173,137,91,237,215,135,120,87,121,134,201,172,162,82,203,62,39,229,115,38,251,
91,10,219,232,196,135,143,46,138,89,228,143,44,82,40,164,89,168,65,177,65,133,
62,148,149,164,133,77,254,210,121,52,249,124,68,7,62,124,244,240,175,145,100,
99,183,90,41,112,145,11,148,209,168,195,161,108,42,212,56,99,167,156,157,1,112,
64,40,118,47,51,185,96,72,168,231,18,67,25,151,71,86,21,186,181,191,85,234,249,
192,244,249,101,90,85,6,26,241,233,180,179,95,6,225,6,195,218,70,118,221,153,
178,74,112,132,234,21,65,129,86,144,94,57,51,105,212,157,144,223,209,186,80,240,
230,167,178,75,103,153,62,249,232,168,206,206,79,218,251,207,220,57,230,13,117,
78,83,204,120,198,18,7,12,208,73,7,21,98,86,119,228,50,224,79,64,78,115,122,56,
93,71,174,249,12,181,139,145,203,64,57,110,109,113,182,207,56,103,144,114,34,
184,29,10,25,40,124,74,68,183,76,202,131,254,252,125,210,238,159,191,163,108,
102,160,155,127,210,133,147,49,68,161,224,192,1,40,120,241,208,73,37,239,176,
150,102,123,63,248,127,27,97,180,206,27,14,172,151,0,0,0,0,73,69,78,68,174,66,
96,130};
static Fl_Image *image_general_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("general_64.png", idata_general_64, 2162);
  return image;
}

Fl_Scheme_Choice *scheme_choice=(Fl_Scheme_Choice *)0;

Fl_Check_Button *tooltips_button=(Fl_Check_Button *)0;

static void cb_tooltips_button(Fl_Check_Button*, void*) {
  Fl_Tooltip::enable(tooltips_button->value());
  fluid_prefs.set("show_tooltips", tooltips_button->value());
}

Fl_Check_Button *completion_button=(Fl_Check_Button *)0;

static void cb_completion_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("show_completion_dialogs", completion_button->value());
}

Fl_Check_Button *openlast_button=(Fl_Check_Button *)0;

static void cb_openlast_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("open_previous_file", openlast_button->value());
}

Fl_Check_Button *prevpos_button=(Fl_Check_Button *)0;

static void cb_prevpos_button(Fl_Check_Button*, void*) {
  fluid_prefs.set("prev_window_pos", prevpos_button->value());
}

Fl_Check_Button *show_comments_button=(Fl_Check_Button *)0;

static void cb_show_comments_button(Fl_Check_Button*, void*) {
  show_comments = show_comments_button->value();
  fluid_prefs.set("show_comments", show_comments);
  redraw_browser();
}

Fl_Spinner *recent_spinner=(Fl_Spinner *)0;

static void cb_recent_spinner(Fl_Spinner*, void*) {
  fluid_prefs.set("recent_files", recent_spinner->value());
  load_history();
}

Fl_Check_Button *use_external_editor_button=(Fl_Check_Button *)0;

static void cb_use_external_editor_button(Fl_Check_Button*, void*) {
  G_use_external_editor = use_external_editor_button->value();
  fluid_prefs.set("use_external_editor", G_use_external_editor);
  redraw_browser();
}

Fl_Input *editor_command_input=(Fl_Input *)0;

static void cb_editor_command_input(Fl_Input*, void*) {
  strncpy(G_external_editor_command, editor_command_input->value(), sizeof(G_external_editor_command)-1);
  G_external_editor_command[sizeof(G_external_editor_command)-1] = 0;
  fluid_prefs.set("external_editor_command", G_external_editor_command);
  redraw_browser();
}

Fl_Check_Button *guides_button=(Fl_Check_Button *)0;

Fl_Check_Button *restricted_button=(Fl_Check_Button *)0;

Fl_Group *w_settings_project_tab=(Fl_Group *)0;

static void cb_w_settings_project_tab(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

static const unsigned char idata_document_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,3,102,73,68,65,84,104,222,237,154,223,75,83,81,28,192,63,155,
115,58,171,153,191,42,140,2,75,115,41,69,20,73,61,244,3,67,176,68,122,168,8,234,
65,123,90,32,81,68,65,47,65,100,208,15,95,194,8,130,94,140,30,250,3,210,94,6,
65,15,162,15,21,250,160,145,62,68,141,182,39,205,205,156,211,181,173,135,221,
93,231,118,167,251,113,239,238,153,236,156,135,125,57,231,220,123,191,159,123,
239,247,215,221,129,244,90,39,223,9,16,206,178,7,113,97,71,135,102,199,151,181,
242,209,30,224,113,174,213,111,194,163,154,250,145,231,240,44,183,0,3,170,170,
31,65,232,203,86,41,83,26,107,143,70,133,50,74,51,184,148,31,95,252,144,145,
219,192,221,220,0,24,87,180,190,65,27,134,52,47,20,198,193,83,165,179,102,137,
144,14,128,49,42,214,178,63,3,128,9,89,238,98,150,247,42,33,152,244,112,102,167,
57,72,136,33,85,16,140,122,0,24,57,68,47,29,171,95,164,190,60,2,0,131,106,8,58,
1,168,135,160,27,128,90,8,58,2,168,131,160,43,64,18,132,222,60,2,136,32,60,
162,51,86,163,59,156,20,28,96,17,111,76,159,103,15,55,87,242,20,40,165,91,192,
64,102,160,88,150,223,50,26,119,23,131,120,98,7,14,11,25,137,183,203,210,48,
195,107,47,45,199,196,63,225,94,33,27,87,52,137,234,57,107,21,116,113,74,245,
179,230,52,153,107,230,33,67,56,112,179,156,90,189,32,26,128,145,6,174,115,137,
5,130,169,214,11,226,165,211,165,236,92,183,94,200,171,64,150,71,70,92,0,208,
206,6,194,120,249,131,159,176,194,156,25,43,149,20,137,12,224,103,132,65,62,51,
163,56,187,9,27,103,105,163,74,84,128,101,6,121,192,108,210,249,89,156,56,232,
193,78,181,152,54,48,65,223,26,234,71,219,75,62,42,248,126,1,0,130,124,193,153,
210,202,15,41,96,234,240,10,45,241,83,150,79,176,149,80,220,221,9,48,142,27,128,
105,188,212,136,7,16,98,94,206,128,175,81,159,224,135,22,232,151,0,60,138,249,
143,80,201,156,133,50,133,81,237,28,104,33,18,111,160,72,28,27,147,87,215,193,
225,184,185,176,52,46,12,128,129,18,73,242,240,137,169,4,128,69,126,201,241,218,
193,164,12,80,66,29,123,177,232,15,96,166,86,150,95,173,185,210,23,87,174,236,
226,42,151,99,10,125,157,108,160,152,230,12,143,116,242,132,55,171,63,166,232,
99,196,45,220,202,248,216,231,140,233,15,96,165,155,251,236,200,240,232,49,2,
250,123,161,109,116,211,138,147,57,217,68,127,243,66,250,194,112,128,14,44,9,
166,237,102,0,63,0,46,150,98,190,216,233,230,70,45,52,210,24,227,36,39,121,45,1,
236,166,157,205,9,0,211,188,147,0,150,196,138,3,134,184,223,168,172,166,223,47,
164,18,27,60,149,72,44,120,22,20,94,180,69,209,1,204,148,75,245,215,56,253,20,
39,148,57,115,114,0,179,102,157,110,107,2,96,165,129,31,0,184,165,114,38,89,
171,195,44,162,13,84,210,158,210,186,58,90,178,126,2,154,0,20,209,70,79,10,152,
247,216,39,170,17,87,97,167,158,65,166,20,140,56,50,127,140,243,28,201,50,10,
107,234,133,170,185,64,43,94,197,82,222,128,133,10,182,168,18,224,52,116,163,38,
106,52,249,144,82,136,196,5,0,157,82,137,208,74,64,117,241,77,245,12,51,140,75,
241,90,169,102,192,169,180,9,154,34,66,102,219,46,215,107,49,127,179,142,114,92,
11,47,52,18,5,240,101,244,143,110,90,87,210,164,217,152,83,125,239,174,82,159,
193,166,213,157,233,226,175,230,234,123,185,168,229,195,61,199,184,10,219,239,
147,239,104,255,202,153,244,20,250,15,100,60,232,29,230,9,101,148,0,0,0,0,73,69,
78,68,174,66,96,130};
static Fl_Image *image_document_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("document_64.png", idata_document_64, 927);
  return image;
}

Fl_Input *header_file_input=(Fl_Input *)0;

static void cb_header_file_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.header_file_name.c_str());
  } else {
    if (strcmp(g_project.header_file_name.c_str(), o->value())) {
      g_project.header_file_name = o->value();
      set_modflag(1);
    }
  }
}

Fl_Input *code_file_input=(Fl_Input *)0;

static void cb_code_file_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.code_file_name.c_str());
  } else {
    if (strcmp(g_project.code_file_name.c_str(), o->value())) {
      g_project.code_file_name = o->value();
      set_modflag(1);
    }
  }
}

Fl_Check_Button *include_H_from_C_button=(Fl_Check_Button *)0;

static void cb_include_H_from_C_button(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.include_H_from_C);
  } else {
    if (g_project.include_H_from_C != o->value()) {
      set_modflag(1);
      g_project.include_H_from_C = o->value();
    }
  }
}

Fl_Check_Button *use_FL_COMMAND_button=(Fl_Check_Button *)0;

static void cb_use_FL_COMMAND_button(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.use_FL_COMMAND);
  } else {
    if (g_project.use_FL_COMMAND != o->value()) {
      set_modflag(1);
      g_project.use_FL_COMMAND = o->value();
    }
  }
}

Fl_Check_Button *utf8_in_src_button=(Fl_Check_Button *)0;

static void cb_utf8_in_src_button(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.utf8_in_src);
  } else {
    if (g_project.utf8_in_src != o->value()) {
      set_modflag(1);
      g_project.utf8_in_src = o->value();
    }
  }
}

Fl_Check_Button *avoid_early_includes_button=(Fl_Check_Button *)0;

static void cb_avoid_early_includes_button(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.avoid_early_includes);
  } else {
    if (g_project.avoid_early_includes != o->value()) {
      set_modflag(1);
      g_project.avoid_early_includes = o->value();
    }
  }
}

Fl_Group *w_settings_layout_tab=(Fl_Group *)0;

static void cb_w_settings_layout_tab(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

static const unsigned char idata_layout_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,1,168,73,68,65,84,104,222,237,154,49,75,3,49,20,199,127,119,
84,168,109,23,197,201,209,69,116,16,197,130,159,160,123,151,226,226,42,14,98,
29,244,35,184,56,59,250,77,244,27,88,113,171,90,144,66,41,116,180,72,75,45,120,
92,92,122,109,167,144,75,155,35,202,123,89,18,146,123,252,127,112,239,46,47,
121,144,206,78,232,16,161,28,181,136,14,53,28,218,21,99,103,226,147,246,205,185,
43,249,135,12,157,203,87,40,6,28,152,139,10,83,0,92,83,36,11,43,113,106,190,56,
151,194,241,94,210,41,144,215,46,28,51,154,246,215,141,221,207,61,85,118,1,16,
178,154,116,47,168,16,104,22,126,112,57,17,83,161,78,17,101,224,94,241,200,109,
50,216,32,36,94,62,192,84,243,38,59,26,0,136,201,79,0,214,216,166,100,228,94,
209,156,13,2,115,128,144,63,110,2,32,0,2,32,0,2,176,144,229,220,186,143,24,26,
174,84,140,125,4,104,112,195,138,209,86,2,218,62,2,116,233,74,12,72,16,47,102,
86,249,128,63,0,150,249,128,63,0,150,249,128,4,177,0,8,128,0,8,128,0,8,128,0,8,
128,0,8,128,0,8,128,0,184,55,171,156,184,199,155,246,146,175,109,121,76,152,25,
192,29,247,218,121,187,3,146,12,1,70,25,10,148,32,254,151,65,92,102,75,51,27,
208,231,193,111,128,26,85,205,87,40,224,157,103,62,125,6,200,83,210,150,26,20,
36,6,4,64,0,4,64,0,4,192,187,31,89,60,187,171,51,207,7,250,180,140,47,249,122,
243,131,216,84,86,144,2,182,201,110,242,167,117,92,118,249,196,145,139,173,196,
75,2,144,38,31,176,218,19,53,220,188,110,251,12,50,41,61,254,154,149,216,46,
219,234,153,20,127,159,185,12,250,99,90,14,203,239,127,120,165,154,78,208,47,
215,15,118,242,56,45,94,1,0,0,0,0,73,69,78,68,174,66,96,130};
static Fl_Image *image_layout_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("layout_64.png", idata_layout_64, 481);
  return image;
}

Fl_Choice *layout_choice=(Fl_Choice *)0;

static void cb_layout_choice(Fl_Choice* o, void* v) {
  if (v == LOAD) {
      o->value(g_layout_list.current_suite());
    } else {
      int index = o->value();
      g_layout_list.current_suite(index);
      g_layout_list.update_dialogs();
    }
}

Fl_Menu_Item menu_layout_choice[] = {
 {"FLTK", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"Grid", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

static void cb_(Fl_Button*, void* v) {
  // Clone the current layout suite

  if (v == LOAD) return;

  Fl_String old_name = "Copy of ";
  old_name.append(g_layout_list[g_layout_list.current_suite()].name_);
  const char *new_name = fl_input("Enter a name for the new layout:", old_name.c_str());
  if (new_name == NULL)
    return; 

  g_layout_list.add(new_name);
  g_layout_list.update_dialogs();
}

Fl_Menu_Button *w_layout_menu=(Fl_Menu_Button *)0;

static void cb_w_layout_menu(Fl_Menu_Button*, void* v) {
  if (v == LOAD) {
    Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
    if (suite.storage_ == FD_STORE_INTERNAL) {
      w_layout_menu_rename->deactivate();
      for (int i=1; i<4; i++) w_layout_menu_storage[i]->deactivate();
      w_layout_menu_delete->deactivate();
    } else {
      w_layout_menu_rename->activate();
      for (int i=1; i<4; i++) w_layout_menu_storage[i]->activate();
      w_layout_menu_delete->activate();
    }
    w_layout_menu_storage[suite.storage_]->setonly();
  }
}

static void cb_w_layout_menu_rename(Fl_Menu_*, void*) {
  // Rename the current layout suite

  Fl_String old_name = g_layout_list[g_layout_list.current_suite()].name_;
  const char *new_name = fl_input("Enter a new name for the layout:", old_name.c_str());
  if (new_name == NULL)
    return; 

  g_layout_list.rename(new_name);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_storage(Fl_Menu_*, void*) {
  Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
  suite.storage(FD_STORE_INTERNAL);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_storage1(Fl_Menu_*, void*) {
  Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
  suite.storage(FD_STORE_USER);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_storage2(Fl_Menu_*, void*) {
  Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
  suite.storage(FD_STORE_PROJECT);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_storage3(Fl_Menu_*, void*) {
  Fd_Layout_Suite &suite = g_layout_list[g_layout_list.current_suite()];
  suite.storage(FD_STORE_FILE);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_load(Fl_Menu_*, void*) {
  // Give the user a file chooser and load that file
  Fl_Native_File_Chooser fnfc;
  fnfc.title("Load Layout Settings:");
  fnfc.type(Fl_Native_File_Chooser::BROWSE_FILE);
  fnfc.options(Fl_Native_File_Chooser::USE_FILTER_EXT);
  fnfc.filter("FLUID Layouts\t*.fll\n");
  if (fnfc.show() != 0) return;
  const char *new_filename = fnfc.filename();
  if (!new_filename) return;
  g_layout_list.load(new_filename);
  //g_layout_list.current_suite(n);
  g_layout_list.update_dialogs();
}

static void cb_w_layout_menu_save(Fl_Menu_*, void*) {
  // Give the user a file chooser with a suggested name
    Fl_Native_File_Chooser fnfc;
    fnfc.title("Save Layout Settings:");
    fnfc.type(Fl_Native_File_Chooser::BROWSE_SAVE_FILE);
    fnfc.options(Fl_Native_File_Chooser::SAVEAS_CONFIRM | Fl_Native_File_Chooser::USE_FILTER_EXT);
    fnfc.filter("FLUID Layouts\t*.fll\n");
    if (g_layout_list.filename_) {
      char *fn = fl_strdup(g_layout_list.filename_);
      char *name = (char*)fl_filename_name(g_layout_list.filename_);
      if (name > fn) {
        name[-1] = 0;
        fnfc.directory(fn);
        fnfc.preset_file(name);
        ::free(fn);
      } else if (name) {
        fnfc.preset_file(name);
        ::free(fn);
      }
    }
    if (fnfc.show() != 0) return;
    const char *new_filename = fnfc.filename();
    if (!new_filename) return;
    if (g_layout_list.filename_)
      ::free(g_layout_list.filename_);
    g_layout_list.filename_ = fl_strdup(new_filename);
    g_layout_list.save(new_filename);
}

static void cb_w_layout_menu_delete(Fl_Menu_*, void*) {
  // remove the current suite

  g_layout_list.remove(g_layout_list.current_suite());
  g_layout_list.update_dialogs();
}

Fl_Menu_Item menu_w_layout_menu[] = {
 {"Rename...", 0,  (Fl_Callback*)cb_w_layout_menu_rename, 0, 128, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"@fd_beaker  FLUID Built-In", 0,  (Fl_Callback*)cb_w_layout_menu_storage, 0, 9, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"@fd_user  User Preference", 0,  (Fl_Callback*)cb_w_layout_menu_storage1, 0, 8, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"@fd_project  Store in .fl Project File", 0,  (Fl_Callback*)cb_w_layout_menu_storage2, 0, 8, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"@fd_file  Store in External File", 0,  (Fl_Callback*)cb_w_layout_menu_storage3, 0, 136, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"Load...", 0,  (Fl_Callback*)cb_w_layout_menu_load, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"Save...", 0,  (Fl_Callback*)cb_w_layout_menu_save, 0, 128, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {"Delete", 0,  (Fl_Callback*)cb_w_layout_menu_delete, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Button *preset_choice[3]={(Fl_Button *)0};

static void cb_Left(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->left_window_margin);
  } else {
    layout->left_window_margin = (int)o->value();
  }
}

static void cb_Top(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->top_window_margin);
  } else {
    layout->top_window_margin = (int)o->value();
  }
}

static void cb_Right(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->right_window_margin);
  } else {
    layout->right_window_margin = (int)o->value();
  }
}

static void cb_Bottom(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->bottom_window_margin);
  } else {
    layout->bottom_window_margin = (int)o->value();
  }
}

static void cb_Horizontal(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->window_grid_x);
  } else {
    layout->window_grid_x = (int)o->value();
  }
}

static void cb_Vertical(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->window_grid_y);
  } else {
    layout->window_grid_y = (int)o->value();
  }
}

static void cb_Left1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->left_group_margin);
  } else {
    layout->left_group_margin = (int)o->value();
  }
}

static void cb_Top1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->top_group_margin);
  } else {
    layout->top_group_margin = (int)o->value();
  }
}

static void cb_Right1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->right_group_margin);
  } else {
    layout->right_group_margin = (int)o->value();
  }
}

static void cb_Bottom1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->bottom_group_margin);
  } else {
    layout->bottom_group_margin = (int)o->value();
  }
}

static void cb_Horizontal1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->group_grid_x);
  } else {
    layout->group_grid_x = (int)o->value();
  }
}

static void cb_Vertical1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->group_grid_y);
  } else {
    layout->group_grid_y = (int)o->value();
  }
}

static void cb_Top2(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->top_tabs_margin);
  } else {
    layout->top_tabs_margin = (int)o->value();
  }
}

static void cb_Bottom2(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->bottom_tabs_margin);
  } else {
    layout->bottom_tabs_margin = (int)o->value();
  }
}

static void cb_Minimum(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_min_w);
  } else {
    layout->widget_min_w = (int)o->value();
  }
}

static void cb_Increment(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_inc_w);
  } else {
    layout->widget_inc_w = (int)o->value();
  }
}

static void cb_Gap(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_gap_x);
  } else {
    layout->widget_gap_x = (int)o->value();
  }
}

static void cb_1(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_min_h);
  } else {
    layout->widget_min_h = (int)o->value();
  }
}

static void cb_2(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_inc_h);
  } else {
    layout->widget_inc_h = (int)o->value();
  }
}

static void cb_3(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value((double)layout->widget_gap_y);
  } else {
    layout->widget_gap_y = (int)o->value();
  }
}

static void cb_4(Fl_Choice* o, void* v) {
  if (v == LOAD) {
    o->value(layout->labelfont+1);
  } else {
    layout->labelfont = (int)o->value()-1;
  }
}

static void cb_5(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value(layout->labelsize);
  } else {
    layout->labelsize = (int)o->value();
  }
}

static void cb_6(Fl_Choice* o, void* v) {
  if (v == LOAD) {
    o->value(layout->textfont+1);
  } else {
    layout->textfont = (int)o->value()-1;
  }
}

static void cb_7(Fl_Value_Input* o, void* v) {
  if (v == LOAD) {
    o->value(layout->textsize);
  } else {
    layout->textsize = (int)o->value();
  }
}

Fl_Group *w_settings_shell_tab=(Fl_Group *)0;

static void cb_w_settings_shell_tab(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

static const unsigned char idata_shell_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,2,233,73,68,65,84,104,222,237,154,207,107,19,65,20,199,63,
155,196,70,235,161,154,149,104,165,148,170,104,127,252,3,30,5,43,69,130,55,15,
222,234,77,65,240,34,182,1,127,28,2,189,181,9,120,16,244,82,240,32,210,179,162,
69,241,170,30,196,91,107,171,208,218,94,26,161,77,218,131,182,49,38,245,80,77,
118,67,205,254,152,113,102,87,242,114,217,101,194,240,253,236,188,247,102,230,
205,128,179,181,145,97,141,10,219,10,127,21,86,201,208,134,4,139,49,165,88,124,
29,98,146,152,56,64,70,147,252,29,132,180,147,60,195,17,96,141,4,250,236,43,71,
68,1,42,68,118,30,246,18,87,164,122,163,254,88,37,42,10,176,253,71,126,134,30,
170,10,228,71,248,98,245,28,195,41,68,93,90,156,110,78,40,26,129,170,39,220,144,
91,11,64,183,185,142,129,18,203,68,20,5,241,178,135,127,187,206,66,245,52,106,
73,114,116,252,19,132,18,91,174,21,122,0,208,100,70,43,136,255,147,32,134,33,
14,42,241,39,131,34,47,229,3,36,184,78,159,34,128,57,222,83,144,63,2,237,236,
87,228,22,237,173,153,184,5,16,200,44,100,223,114,124,96,157,227,12,176,39,140,
0,155,60,102,12,56,198,109,206,201,41,29,168,117,161,60,83,0,44,114,135,87,
252,8,31,128,81,27,184,60,119,53,35,248,2,56,204,69,203,104,232,69,240,5,176,
143,75,140,4,4,193,103,26,53,25,14,8,130,239,121,32,40,8,2,19,89,48,16,132,102,
226,32,32,8,46,37,244,35,8,175,133,116,35,72,88,204,153,12,115,211,134,240,154,
114,184,86,163,38,151,109,163,48,198,76,216,150,211,118,71,90,100,154,205,176,
237,7,76,134,45,69,241,55,172,135,111,67,99,114,186,182,155,45,11,22,33,11,58,0,
62,241,136,239,181,26,134,170,141,78,76,158,252,44,79,107,111,131,202,14,214,
36,1,204,147,179,200,79,49,40,239,203,168,0,152,39,203,179,218,219,16,55,232,
14,250,166,222,106,115,228,108,242,71,233,119,81,244,14,12,192,28,19,60,183,
200,79,211,167,80,190,112,22,250,104,147,127,94,154,252,132,154,17,152,37,103,
147,63,74,175,210,175,47,8,48,203,4,211,154,229,11,0,204,144,109,42,191,76,201,
67,111,113,223,19,95,204,175,252,113,203,33,68,138,17,78,217,228,127,230,5,75,
84,92,246,22,165,135,148,207,123,0,190,0,10,76,54,200,239,109,104,127,192,19,
143,125,46,113,203,215,236,237,43,11,21,121,215,68,190,189,221,173,189,165,168,
46,141,182,211,245,251,233,194,46,242,173,237,238,173,203,211,185,140,160,11,
37,185,194,79,22,57,203,85,78,254,181,125,222,67,143,253,92,35,169,14,32,202,
25,6,248,198,33,14,52,105,223,112,125,36,104,208,65,210,233,102,147,220,44,20,
163,211,177,189,51,108,59,50,61,214,2,208,109,174,99,160,192,130,178,251,66,11,
214,235,54,142,9,192,201,42,205,71,41,33,161,178,208,216,199,86,173,56,32,227,
218,229,42,166,70,15,89,225,168,104,12,220,87,226,55,187,91,149,123,50,162,100,
82,219,229,239,135,114,138,14,109,164,201,83,85,44,126,133,81,55,103,232,191,0,
145,21,211,195,226,88,204,195,0,0,0,0,73,69,78,68,174,66,96,130};
static Fl_Image *image_shell_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("shell_64.png", idata_shell_64, 802);
  return image;
}

static void cb_Command(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_shell_command.c_str());
  } else {
    g_shell_command = o->value();
  }
}

static void cb_save(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_shell_save_fl);
  } else {
    g_shell_save_fl = o->value();
  }
}

static void cb_save1(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_shell_save_code);
  } else {
    g_shell_save_code = o->value();
  }
}

static void cb_save2(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_shell_save_strings);
  } else {
    g_shell_save_strings = o->value();
  }
}

Fl_Check_Button *shell_use_fl_button=(Fl_Check_Button *)0;

static void cb_shell_use_fl_button(Fl_Check_Button* o, void* v) {
  if (v == LOAD) {
    o->value(g_shell_use_fl_settings);
  } else {
    g_shell_use_fl_settings = o->value();
    fluid_prefs.set("shell_use_fl", g_shell_use_fl_settings);
    if (g_shell_use_fl_settings) {
      shell_settings_read();
    } else {
      shell_prefs_get();
    }
    w_settings_shell_tab->do_callback(w_settings_shell_tab, LOAD);
  }
}

static void cb_save3(Fl_Button*, void* v) {
  if (v != LOAD) 
    shell_prefs_set();
}

static void cb_Run(Fl_Return_Button*, void* v) {
  if (v != LOAD)
    do_shell_command(NULL, NULL);
}

Fl_Group *w_settings_i18n_tab=(Fl_Group *)0;

static void cb_w_settings_i18n_tab(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

static const unsigned char idata_language_64[] =
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,96,0,0,0,64,8,4,0,0,0,
79,61,186,133,0,0,5,113,73,68,65,84,104,222,237,154,107,76,28,85,20,199,127,
188,10,44,182,184,116,75,75,65,1,129,146,20,140,15,106,91,170,166,129,182,40,98,
53,104,98,66,240,145,26,67,140,38,245,21,245,139,177,54,126,48,126,48,209,38,
162,198,132,24,141,181,173,209,86,98,130,129,32,98,1,91,196,214,90,181,136,20,
90,160,32,10,8,88,96,11,44,227,7,102,239,206,46,236,206,238,236,206,204,154,
120,246,195,158,123,103,231,222,243,223,123,207,255,156,251,0,117,89,193,43,140,
226,64,210,244,89,96,154,47,72,197,52,137,230,144,102,227,93,159,78,178,204,2,
176,63,4,230,75,72,52,154,5,96,52,36,230,75,204,82,164,207,4,81,147,171,157,74,
28,177,26,58,152,112,42,49,220,74,147,25,0,34,157,230,239,39,131,133,128,26,
143,96,154,26,90,156,197,181,230,140,128,44,177,92,171,193,15,167,72,116,21,162,
244,0,16,25,124,19,14,102,152,51,145,36,131,148,113,154,57,199,90,138,200,88,
182,249,213,174,194,80,24,2,88,160,153,87,1,24,96,175,114,186,136,137,183,133,
134,69,203,71,248,52,140,0,56,24,225,31,192,206,247,114,77,43,219,73,101,129,56,
214,16,167,248,229,205,188,193,69,86,83,85,78,167,30,0,34,84,127,33,45,126,37,
242,46,57,194,252,54,62,164,199,157,38,101,154,181,114,15,229,172,92,210,204,
166,136,48,242,129,17,14,114,122,73,173,29,59,48,193,1,242,40,48,204,137,53,177,
208,140,138,63,254,105,32,11,105,2,96,101,147,74,204,8,115,26,77,228,65,210,232,
195,225,230,42,221,116,201,250,42,225,43,179,174,216,189,53,160,46,254,162,159,
89,29,89,40,131,74,143,246,175,80,35,0,196,3,115,116,241,19,3,92,118,254,224,
120,64,29,204,49,204,219,188,201,188,110,113,32,134,24,15,0,3,178,102,195,194,
28,245,188,47,106,52,244,20,77,6,175,147,207,99,106,16,52,166,18,14,134,185,
160,160,80,152,18,230,166,96,225,20,175,185,155,175,205,63,31,226,57,93,156,216,
65,27,47,241,56,111,113,65,212,13,10,61,23,7,141,216,67,67,49,207,232,26,7,106,
73,39,149,24,64,226,146,120,154,206,44,103,68,41,73,67,251,118,166,157,234,26,
93,0,184,226,192,143,236,38,9,152,22,14,12,89,56,24,145,245,93,236,37,193,25,
204,253,254,219,187,121,202,9,33,82,23,0,241,88,229,25,126,142,113,146,128,63,
104,149,159,165,145,162,224,39,43,185,92,165,33,69,140,115,141,129,30,62,144,
200,13,98,50,245,2,18,231,196,152,220,66,82,128,255,184,9,145,56,86,177,54,107,
101,146,9,78,186,146,182,128,167,140,9,0,34,200,37,69,214,107,233,228,23,234,68,
128,203,53,120,69,166,49,14,92,195,46,161,31,84,172,84,118,178,238,191,1,32,158,
109,66,111,17,251,14,113,108,115,91,204,132,49,0,216,200,158,37,117,21,100,27,
190,168,215,12,192,66,9,121,30,9,222,78,44,126,190,61,65,19,71,57,19,130,221,
140,32,182,85,50,20,126,0,144,185,204,66,210,91,32,252,152,74,158,164,74,193,94,
134,3,152,166,221,163,251,38,222,161,141,73,63,222,237,162,26,128,126,142,50,
110,206,174,68,47,95,114,204,45,27,5,168,163,137,18,74,177,120,164,218,158,169,
254,9,198,100,253,19,42,84,86,119,186,0,24,231,35,106,189,164,97,181,116,113,
151,79,46,186,36,162,6,64,51,121,196,27,61,133,198,57,165,40,149,242,60,215,43,
202,157,124,231,35,153,150,232,160,93,81,254,156,126,227,71,32,158,20,57,153,
139,99,15,101,216,40,160,142,195,178,217,54,114,124,24,53,202,215,30,147,177,
157,172,32,246,125,53,1,176,81,201,60,253,108,225,110,242,137,7,178,121,148,219,
105,230,56,243,84,144,69,131,215,119,207,114,108,137,231,20,179,222,88,0,81,20,
146,195,12,86,86,137,173,189,4,110,100,3,247,1,201,244,123,77,134,167,150,89,
219,55,113,214,104,0,16,181,236,105,133,69,14,100,222,179,209,223,57,34,107,235,
72,17,187,123,245,108,198,106,124,32,11,92,230,56,41,8,244,14,158,37,83,144,
233,121,51,34,113,224,162,36,208,29,108,165,76,65,166,51,225,15,64,73,160,59,
200,35,129,219,66,64,166,126,251,192,21,250,136,244,114,200,23,193,74,108,170,
84,168,36,208,116,70,152,4,242,249,57,72,50,85,7,176,176,56,74,118,246,249,216,
180,189,142,71,40,84,49,64,73,160,135,100,221,30,52,153,170,3,24,195,230,76,19,
188,199,215,211,68,147,227,243,28,213,157,64,167,151,16,173,86,50,85,247,129,
106,255,14,135,135,84,220,176,91,16,168,55,169,15,58,51,245,54,70,31,248,117,91,
98,150,59,21,160,229,218,7,164,46,105,80,26,148,46,74,251,252,184,142,80,43,13,
74,131,210,160,212,40,37,185,106,131,158,66,243,84,209,206,211,164,249,204,145,
47,115,128,175,252,35,208,18,172,110,118,245,208,17,68,102,234,15,11,205,82,77,
13,169,62,246,41,37,250,124,157,58,41,9,180,136,151,73,118,123,122,130,135,5,
153,238,102,131,78,52,106,231,188,246,112,57,198,55,66,47,35,221,131,173,110,
226,126,62,147,201,180,131,236,0,67,147,33,129,108,92,100,61,57,108,94,66,182,
73,138,123,56,191,6,188,45,111,8,0,11,105,178,86,46,52,101,24,44,160,80,214,
215,251,116,180,16,102,163,129,73,50,85,204,211,75,49,247,46,187,216,76,227,9,
160,151,98,74,195,19,64,20,219,217,200,20,54,215,237,169,128,158,155,14,0,162,
197,102,176,182,231,97,146,78,235,33,255,3,48,91,244,241,1,113,7,225,111,126,
211,112,200,215,19,64,52,208,7,128,72,43,26,248,65,195,235,138,99,214,5,115,0,
180,48,231,36,244,177,224,90,26,54,107,106,126,27,146,219,190,14,94,52,11,64,38,
157,33,48,255,61,163,226,212,114,146,206,17,166,130,48,126,136,23,88,161,222,
205,191,56,75,123,84,202,251,159,166,0,0,0,0,73,69,78,68,174,66,96,130};
static Fl_Image *image_language_64() {
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_PNG_Image("language_64.png", idata_language_64, 1450);
  return image;
}

Fl_Choice *i18n_type_chooser=(Fl_Choice *)0;

Fl_Menu_Item menu_i18n_type_chooser[] = {
 {"None", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"GNU gettext", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {"POSIX catgets", 0,  0, 0, 0, (uchar)FL_NORMAL_LABEL, 0, 11, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Group *i18n_gnu_group=(Fl_Group *)0;

static void cb_i18n_gnu_group(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

Fl_Input *i18n_gnu_include_input=(Fl_Input *)0;

static void cb_i18n_gnu_include_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_gnu_include.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_gnu_include = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_gnu_conditional_input=(Fl_Input *)0;

static void cb_i18n_gnu_conditional_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_gnu_conditional.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_gnu_conditional = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_gnu_function_input=(Fl_Input *)0;

static void cb_i18n_gnu_function_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_gnu_function.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_gnu_function = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_gnu_static_function_input=(Fl_Input *)0;

static void cb_i18n_gnu_static_function_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_gnu_static_function.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_gnu_static_function = o->value();
    set_modflag(1);
  }
}

Fl_Group *i18n_posix_group=(Fl_Group *)0;

static void cb_i18n_posix_group(Fl_Group* o, void* v) {
  propagate_load(o, v);
}

Fl_Input *i18n_pos_include_input=(Fl_Input *)0;

static void cb_i18n_pos_include_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_pos_include.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_pos_include = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_pos_conditional_input=(Fl_Input *)0;

static void cb_i18n_pos_conditional_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_pos_conditional.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_pos_conditional = o->value();
    set_modflag(1);
  }
}

Fl_Input *i18n_pos_file_input=(Fl_Input *)0;

static void cb_i18n_pos_file_input(Fl_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_pos_file.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_pos_file = o->value();
    set_modflag(1);
  }
}

Fl_Int_Input *i18n_pos_set_input=(Fl_Int_Input *)0;

static void cb_i18n_pos_set_input(Fl_Int_Input* o, void* v) {
  if (v == LOAD) {
    o->value(g_project.i18n_pos_set.c_str());
  } else {
    undo_checkpoint();
    g_project.i18n_pos_set = o->value();
    set_modflag(1);
  }
}

static void cb_Close(Fl_Button*, void*) {
  settings_window->hide();
}

Fl_Double_Window* make_settings_window() {
  { Fl_Double_Window* o = settings_window = new Fl_Double_Window(340, 580, "FLUID Settings");
    settings_window->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { w_settings_tabs = new Fl_Tabs(10, 10, 320, 530);
      w_settings_tabs->selection_color((Fl_Color)12);
      w_settings_tabs->labelsize(11);
      w_settings_tabs->labelcolor(FL_WHITE);
      w_settings_tabs->callback((Fl_Callback*)cb_w_settings_tabs);
      { Fl_Group* o = new Fl_Group(10, 60, 320, 480, "General");
        o->image( image_general_64() );
        o->labelsize(11);
        { scheme_choice = new Fl_Scheme_Choice(120, 78, 120, 25, "Scheme: ");
          scheme_choice->box(FL_UP_BOX);
          scheme_choice->down_box(FL_BORDER_BOX);
          scheme_choice->color(FL_BACKGROUND_COLOR);
          scheme_choice->selection_color(FL_SELECTION_COLOR);
          scheme_choice->labeltype(FL_NORMAL_LABEL);
          scheme_choice->labelfont(1);
          scheme_choice->labelsize(11);
          scheme_choice->labelcolor(FL_FOREGROUND_COLOR);
          scheme_choice->callback((Fl_Callback*)scheme_cb);
          scheme_choice->align(Fl_Align(FL_ALIGN_LEFT));
          scheme_choice->when(FL_WHEN_RELEASE);
          init_scheme();
        } // Fl_Scheme_Choice* scheme_choice
        { Fl_Box* o = new Fl_Box(120, 115, 0, 20, "Options: ");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT));
        } // Fl_Box* o
        { tooltips_button = new Fl_Check_Button(120, 115, 200, 20, "Show Tooltips");
          tooltips_button->down_box(FL_DOWN_BOX);
          tooltips_button->labelsize(11);
          tooltips_button->callback((Fl_Callback*)cb_tooltips_button);
          int b;
          fluid_prefs.get("show_tooltips", b, 1);
          tooltips_button->value(b);
          Fl_Tooltip::enable(b);
        } // Fl_Check_Button* tooltips_button
        { completion_button = new Fl_Check_Button(120, 135, 200, 20, "Show Completion Dialogs");
          completion_button->down_box(FL_DOWN_BOX);
          completion_button->labelsize(11);
          completion_button->callback((Fl_Callback*)cb_completion_button);
          int b;
          fluid_prefs.get("show_completion_dialogs", b, 1);
          completion_button->value(b);
        } // Fl_Check_Button* completion_button
        { openlast_button = new Fl_Check_Button(120, 155, 200, 20, "Open Previous File on Startup");
          openlast_button->down_box(FL_DOWN_BOX);
          openlast_button->labelsize(11);
          openlast_button->callback((Fl_Callback*)cb_openlast_button);
          int b;
          fluid_prefs.get("open_previous_file", b, 0);
          openlast_button->value(b);
        } // Fl_Check_Button* openlast_button
        { prevpos_button = new Fl_Check_Button(120, 175, 200, 20, "Remember Window Positions");
          prevpos_button->down_box(FL_DOWN_BOX);
          prevpos_button->labelsize(11);
          prevpos_button->callback((Fl_Callback*)cb_prevpos_button);
          int b;
          fluid_prefs.get("prev_window_pos", b, 1);
          prevpos_button->value(b);
        } // Fl_Check_Button* prevpos_button
        { show_comments_button = new Fl_Check_Button(120, 195, 200, 20, "Show Comments in Browser");
          show_comments_button->down_box(FL_DOWN_BOX);
          show_comments_button->labelsize(11);
          show_comments_button->callback((Fl_Callback*)cb_show_comments_button);
          fluid_prefs.get("show_comments", show_comments, 1);
          show_comments_button->value(show_comments);
        } // Fl_Check_Button* show_comments_button
        { recent_spinner = new Fl_Spinner(120, 225, 40, 20, "# Recent Files:");
          recent_spinner->labelfont(1);
          recent_spinner->labelsize(11);
          recent_spinner->maximum(10);
          recent_spinner->textsize(11);
          recent_spinner->callback((Fl_Callback*)cb_recent_spinner);
          recent_spinner->when(FL_WHEN_CHANGED);
          int c;
          fluid_prefs.get("recent_files", c, 5);
          recent_spinner->maximum(10);
          recent_spinner->value(c);
        } // Fl_Spinner* recent_spinner
        { use_external_editor_button = new Fl_Check_Button(120, 275, 200, 20, "Use for Code Nodes");
          use_external_editor_button->down_box(FL_DOWN_BOX);
          use_external_editor_button->labelsize(11);
          use_external_editor_button->callback((Fl_Callback*)cb_use_external_editor_button);
          fluid_prefs.get("use_external_editor", G_use_external_editor, 0);
          use_external_editor_button->value(G_use_external_editor);
        } // Fl_Check_Button* use_external_editor_button
        { editor_command_input = new Fl_Input(120, 255, 200, 20, "External Editor:");
          editor_command_input->tooltip("The editor command to open your external text editor.\nInclude any necessary \
flags to ensure your editor does not background itself.\nExamples:\n    gvim -\
f\n    gedit\n emacs");
          editor_command_input->labelfont(1);
          editor_command_input->labelsize(11);
          editor_command_input->textfont(4);
          editor_command_input->textsize(11);
          editor_command_input->callback((Fl_Callback*)cb_editor_command_input);
          editor_command_input->when(FL_WHEN_CHANGED);
          fluid_prefs.get("external_editor_command", G_external_editor_command, "", sizeof(G_external_editor_command)-1);
          editor_command_input->value(G_external_editor_command);
        } // Fl_Input* editor_command_input
        { Fl_Box* o = new Fl_Box(120, 300, 0, 20, "Overlays: ");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT));
        } // Fl_Box* o
        { Fl_Check_Button* o = guides_button = new Fl_Check_Button(120, 300, 200, 20, "Show Positioning Guides");
          guides_button->tooltip("show guides that help to position and resize widgets and enable snapping");
          guides_button->down_box(FL_DOWN_BOX);
          guides_button->labelsize(11);
          guides_button->callback((Fl_Callback*)toggle_guides_cb);
          o->value(show_guides);
        } // Fl_Check_Button* guides_button
        { Fl_Check_Button* o = restricted_button = new Fl_Check_Button(120, 320, 200, 20, "Show Restricted Areas");
          restricted_button->tooltip("show overlapping and out of bounds areas, show unfilled areas in Fl_Pack grou\
ps");
          restricted_button->down_box(FL_DOWN_BOX);
          restricted_button->labelsize(11);
          restricted_button->callback((Fl_Callback*)toggle_restricted_cb);
          o->value(show_restricted);
        } // Fl_Check_Button* restricted_button
        o->image()->scale(36, 24);
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = w_settings_project_tab = new Fl_Group(10, 60, 320, 480, "Project");
        w_settings_project_tab->image( image_document_64() );
        w_settings_project_tab->labelsize(11);
        w_settings_project_tab->callback((Fl_Callback*)cb_w_settings_project_tab);
        w_settings_project_tab->hide();
        { Fl_Box* o = new Fl_Box(100, 78, 220, 30, "Use \"name.ext\" to set a file name or just \".ext\" to set extension.");
          o->labelsize(11);
          o->align(Fl_Align(132|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { header_file_input = new Fl_Input(100, 112, 220, 20, "Header File:");
          header_file_input->tooltip("The name of the generated header file.");
          header_file_input->box(FL_THIN_DOWN_BOX);
          header_file_input->labelfont(1);
          header_file_input->labelsize(11);
          header_file_input->textfont(4);
          header_file_input->textsize(11);
          header_file_input->callback((Fl_Callback*)cb_header_file_input, (void*)(1));
          header_file_input->when(FL_WHEN_CHANGED);
        } // Fl_Input* header_file_input
        { code_file_input = new Fl_Input(100, 137, 220, 20, "Code File:");
          code_file_input->tooltip("The name of the generated code file.");
          code_file_input->box(FL_THIN_DOWN_BOX);
          code_file_input->labelfont(1);
          code_file_input->labelsize(11);
          code_file_input->textfont(4);
          code_file_input->textsize(11);
          code_file_input->callback((Fl_Callback*)cb_code_file_input, (void*)(1));
          code_file_input->when(FL_WHEN_CHANGED);
        } // Fl_Input* code_file_input
        { Fl_Box* o = new Fl_Box(100, 205, 0, 20, "Options: ");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT));
        } // Fl_Box* o
        { include_H_from_C_button = new Fl_Check_Button(100, 162, 220, 20, "Include Header from Code");
          include_H_from_C_button->tooltip("Include the header file from the code file.");
          include_H_from_C_button->down_box(FL_DOWN_BOX);
          include_H_from_C_button->labelsize(11);
          include_H_from_C_button->callback((Fl_Callback*)cb_include_H_from_C_button);
        } // Fl_Check_Button* include_H_from_C_button
        { use_FL_COMMAND_button = new Fl_Check_Button(100, 205, 220, 20, "Menu shortcuts use FL_COMMAND");
          use_FL_COMMAND_button->tooltip("Replace FL_CTRL and FL_META with FL_COMMAND when generating menu shortcuts");
          use_FL_COMMAND_button->down_box(FL_DOWN_BOX);
          use_FL_COMMAND_button->labelsize(11);
          use_FL_COMMAND_button->callback((Fl_Callback*)cb_use_FL_COMMAND_button);
        } // Fl_Check_Button* use_FL_COMMAND_button
        { utf8_in_src_button = new Fl_Check_Button(100, 230, 220, 20, "allow Unicode UTF-8 in source code");
          utf8_in_src_button->tooltip("For older compilers, characters outside of the printable ASCII range are esca\
ped using octal notation `\\0123`. If this option is checked, Fluid will write\
 UTF-8 characters unchanged.");
          utf8_in_src_button->down_box(FL_DOWN_BOX);
          utf8_in_src_button->labelsize(11);
          utf8_in_src_button->callback((Fl_Callback*)cb_utf8_in_src_button);
        } // Fl_Check_Button* utf8_in_src_button
        { avoid_early_includes_button = new Fl_Check_Button(100, 255, 220, 20, "avoid early include of Fl.H");
          avoid_early_includes_button->tooltip("Do not emit #include <FL//Fl.H> until it is needed by another include file.");
          avoid_early_includes_button->down_box(FL_DOWN_BOX);
          avoid_early_includes_button->labelsize(11);
          avoid_early_includes_button->callback((Fl_Callback*)cb_avoid_early_includes_button);
        } // Fl_Check_Button* avoid_early_includes_button
        o->image()->scale(36, 24);
        w_settings_project_tab->end();
      } // Fl_Group* w_settings_project_tab
      { Fl_Group* o = w_settings_layout_tab = new Fl_Group(10, 60, 320, 480, "Layout");
        w_settings_layout_tab->image( image_layout_64() );
        w_settings_layout_tab->labelsize(11);
        w_settings_layout_tab->callback((Fl_Callback*)cb_w_settings_layout_tab);
        w_settings_layout_tab->hide();
        { Fl_Box* o = new Fl_Box(25, 78, 60, 24, "Layout:");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { layout_choice = new Fl_Choice(85, 78, 187, 24);
          layout_choice->down_box(FL_BORDER_BOX);
          layout_choice->callback((Fl_Callback*)cb_layout_choice);
          layout_choice->menu(menu_layout_choice);
        } // Fl_Choice* layout_choice
        { Fl_Button* o = new Fl_Button(272, 78, 24, 24, "+");
          o->callback((Fl_Callback*)cb_);
        } // Fl_Button* o
        { w_layout_menu = new Fl_Menu_Button(296, 78, 24, 24);
          w_layout_menu->callback((Fl_Callback*)cb_w_layout_menu);
            w_layout_menu_storage[0] = &menu_w_layout_menu[1];
            w_layout_menu_storage[1] = &menu_w_layout_menu[2];
            w_layout_menu_storage[2] = &menu_w_layout_menu[3];
            w_layout_menu_storage[3] = &menu_w_layout_menu[4];
          w_layout_menu->menu(menu_w_layout_menu);
        } // Fl_Menu_Button* w_layout_menu
        { Fl_Box* o = new Fl_Box(25, 107, 60, 20, "Preset:");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Group* o = new Fl_Group(85, 107, 235, 20);
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          { preset_choice[0] = new Fl_Button(85, 107, 78, 20, "Application");
            preset_choice[0]->type(102);
            preset_choice[0]->value(1);
            preset_choice[0]->selection_color(FL_DARK2);
            preset_choice[0]->labelsize(11);
            preset_choice[0]->callback((Fl_Callback*)edit_layout_preset_cb, (void*)(0));
          } // Fl_Button* preset_choice[0]
          { preset_choice[1] = new Fl_Button(163, 107, 79, 20, "Dialog");
            preset_choice[1]->type(102);
            preset_choice[1]->selection_color(FL_DARK2);
            preset_choice[1]->labelsize(11);
            preset_choice[1]->callback((Fl_Callback*)edit_layout_preset_cb, (void*)(1));
          } // Fl_Button* preset_choice[1]
          { preset_choice[2] = new Fl_Button(242, 107, 78, 20, "Toolbox");
            preset_choice[2]->type(102);
            preset_choice[2]->selection_color(FL_DARK2);
            preset_choice[2]->labelsize(11);
            preset_choice[2]->callback((Fl_Callback*)edit_layout_preset_cb, (void*)(2));
          } // Fl_Button* preset_choice[2]
          o->end();
        } // Fl_Group* o
        { Fl_Box* o = new Fl_Box(85, 132, 235, 20, "---- Window ----");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(25, 167, 60, 20, "Margin:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 167, 55, 20, "Left:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Left);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 167, 55, 20, "Top:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Top);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(205, 167, 55, 20, "Right:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Right);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(265, 167, 55, 20, "Bottom:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Bottom);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(32, 201, 53, 20, "Grid:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 201, 55, 20, "Horizontal:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Horizontal);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 201, 55, 20, "Vertical:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Vertical);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(85, 226, 235, 20, "---- Group ----");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(25, 261, 60, 20, "Margin:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 261, 55, 20, "Left:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Left1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 261, 55, 20, "Top:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Top1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(205, 261, 55, 20, "Right:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Right1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(265, 261, 55, 20, "Bottom:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Bottom1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(32, 295, 53, 20, "Grid:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 295, 55, 20, "Horizontal:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Horizontal1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 295, 55, 20, "Vertical:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Vertical1);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(85, 320, 235, 20, "---- Tabs ----");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(25, 355, 60, 20, "Margin:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 355, 55, 20, "Top:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Top2);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 355, 55, 20, "Bottom:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Bottom2);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(85, 380, 235, 20, "---- Widget ----");
          o->labelfont(1);
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Box* o = new Fl_Box(25, 415, 60, 20, "Horizontal:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 414, 55, 20, "Minimum:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Minimum);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 414, 55, 20, "Increment:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Increment);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(205, 414, 55, 20, "Gap:");
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Gap);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Box* o = new Fl_Box(32, 440, 53, 20, "Vertical:");
          o->labelsize(11);
          o->align(Fl_Align(FL_ALIGN_RIGHT|FL_ALIGN_INSIDE));
        } // Fl_Box* o
        { Fl_Value_Input* o = new Fl_Value_Input(85, 440, 55, 20);
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_1);
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(145, 440, 55, 20);
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_2);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Value_Input* o = new Fl_Value_Input(205, 440, 55, 20);
          o->labelsize(11);
          o->maximum(32767);
          o->step(1);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_3);
          o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        } // Fl_Value_Input* o
        { Fl_Group* o = new Fl_Group(85, 465, 201, 20, "Label Font:");
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Choice* o = new Fl_Choice(85, 465, 150, 20);
            o->tooltip("The style of the label text.");
            o->box(FL_THIN_UP_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_4);
            Fl_Group::current()->resizable(o);
            o->menu(fontmenu_w_default);
          } // Fl_Choice* o
          { Fl_Value_Input* o = new Fl_Value_Input(235, 465, 50, 20);
            o->tooltip("The size of the label text.");
            o->labelsize(11);
            o->minimum(1);
            o->maximum(1000);
            o->step(1);
            o->value(14);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_5);
          } // Fl_Value_Input* o
          o->end();
        } // Fl_Group* o
        { Fl_Group* o = new Fl_Group(85, 490, 200, 20, "Text Font:");
          o->labelsize(11);
          o->callback((Fl_Callback*)propagate_load);
          o->align(Fl_Align(FL_ALIGN_LEFT));
          { Fl_Choice* o = new Fl_Choice(85, 490, 150, 20);
            o->tooltip("The value text style.");
            o->box(FL_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->labelfont(1);
            o->labelsize(11);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_6);
            o->menu(fontmenu_w_default);
          } // Fl_Choice* o
          { Fl_Value_Input* o = new Fl_Value_Input(235, 490, 50, 20);
            o->tooltip("The value text size.");
            o->labelsize(11);
            o->maximum(1000);
            o->step(1);
            o->value(14);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_7);
          } // Fl_Value_Input* o
          o->end();
        } // Fl_Group* o
        o->image()->scale(36, 24);
        w_settings_layout_tab->end();
      } // Fl_Group* w_settings_layout_tab
      { Fl_Group* o = w_settings_shell_tab = new Fl_Group(10, 60, 320, 480, "Shell");
        w_settings_shell_tab->image( image_shell_64() );
        w_settings_shell_tab->labelsize(11);
        w_settings_shell_tab->callback((Fl_Callback*)cb_w_settings_shell_tab);
        w_settings_shell_tab->hide();
        { Fl_Input* o = new Fl_Input(100, 78, 220, 20, "Command:");
          o->tooltip("external shell command");
          o->labelfont(1);
          o->labelsize(11);
          o->textfont(4);
          o->textsize(11);
          o->callback((Fl_Callback*)cb_Command);
        } // Fl_Input* o
        { Fl_Check_Button* o = new Fl_Check_Button(100, 98, 220, 20, "save .fl project file");
          o->tooltip("save the project to the .fl file before running the command");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_save);
        } // Fl_Check_Button* o
        { Fl_Check_Button* o = new Fl_Check_Button(100, 118, 220, 19, "save source code");
          o->tooltip("generate the source code and header file before running the command");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_save1);
        } // Fl_Check_Button* o
        { Fl_Check_Button* o = new Fl_Check_Button(100, 137, 220, 20, "save i18n strings");
          o->tooltip("save the internationalisation string before running the command");
          o->down_box(FL_DOWN_BOX);
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_save2);
        } // Fl_Check_Button* o
        { shell_use_fl_button = new Fl_Check_Button(100, 194, 220, 19, "save settings in .fl project files");
          shell_use_fl_button->tooltip("check to read and write shell command from and to .fl files");
          shell_use_fl_button->down_box(FL_DOWN_BOX);
          shell_use_fl_button->labelsize(11);
          shell_use_fl_button->callback((Fl_Callback*)cb_shell_use_fl_button);
          shell_use_fl_button->deactivate();
        } // Fl_Check_Button* shell_use_fl_button
        { Fl_Button* o = new Fl_Button(100, 218, 115, 20, "save as default");
          o->tooltip("update the Fluid app settings for external shell commands to the current sett\
ings");
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_save3);
        } // Fl_Button* o
        { Fl_Return_Button* o = new Fl_Return_Button(100, 162, 100, 20, "Run");
          o->tooltip("save selected files and run the command");
          o->labelsize(11);
          o->callback((Fl_Callback*)cb_Run);
        } // Fl_Return_Button* o
        o->image()->scale(36, 24);
        w_settings_shell_tab->end();
      } // Fl_Group* w_settings_shell_tab
      { Fl_Group* o = w_settings_i18n_tab = new Fl_Group(10, 60, 320, 480, "Locale");
        w_settings_i18n_tab->image( image_language_64() );
        w_settings_i18n_tab->labelsize(11);
        w_settings_i18n_tab->callback((Fl_Callback*)cb_w_settings_i18n_tab);
        w_settings_i18n_tab->hide();
        { i18n_type_chooser = new Fl_Choice(100, 78, 160, 20, "i18n Library:");
          i18n_type_chooser->tooltip("Type of internationalization to use.");
          i18n_type_chooser->box(FL_THIN_UP_BOX);
          i18n_type_chooser->down_box(FL_BORDER_BOX);
          i18n_type_chooser->labelsize(11);
          i18n_type_chooser->textsize(11);
          i18n_type_chooser->callback((Fl_Callback*)i18n_type_cb);
          i18n_type_chooser->menu(menu_i18n_type_chooser);
        } // Fl_Choice* i18n_type_chooser
        { i18n_gnu_group = new Fl_Group(100, 103, 220, 95);
          i18n_gnu_group->callback((Fl_Callback*)cb_i18n_gnu_group);
          { i18n_gnu_include_input = new Fl_Input(100, 103, 220, 20, "#include:");
            i18n_gnu_include_input->tooltip("The include file for internationalization.");
            i18n_gnu_include_input->box(FL_THIN_DOWN_BOX);
            i18n_gnu_include_input->labelsize(11);
            i18n_gnu_include_input->textfont(4);
            i18n_gnu_include_input->textsize(11);
            i18n_gnu_include_input->callback((Fl_Callback*)cb_i18n_gnu_include_input);
          } // Fl_Input* i18n_gnu_include_input
          { i18n_gnu_conditional_input = new Fl_Input(100, 128, 220, 20, "Conditional:");
            i18n_gnu_conditional_input->tooltip("only include the header file if this preprocessor macro is defined, for examp\
le FLTK_GETTEXT_FOUND");
            i18n_gnu_conditional_input->box(FL_THIN_DOWN_BOX);
            i18n_gnu_conditional_input->labelsize(11);
            i18n_gnu_conditional_input->textfont(4);
            i18n_gnu_conditional_input->textsize(11);
            i18n_gnu_conditional_input->callback((Fl_Callback*)cb_i18n_gnu_conditional_input);
          } // Fl_Input* i18n_gnu_conditional_input
          { i18n_gnu_function_input = new Fl_Input(100, 153, 220, 20, "Function:");
            i18n_gnu_function_input->tooltip("The function to call to translate labels and tooltips, usually \"gettext\" or\
 \"_\"");
            i18n_gnu_function_input->box(FL_THIN_DOWN_BOX);
            i18n_gnu_function_input->labelsize(11);
            i18n_gnu_function_input->textfont(4);
            i18n_gnu_function_input->textsize(11);
            i18n_gnu_function_input->callback((Fl_Callback*)cb_i18n_gnu_function_input);
          } // Fl_Input* i18n_gnu_function_input
          { i18n_gnu_static_function_input = new Fl_Input(100, 178, 220, 20, "Static Function:");
            i18n_gnu_static_function_input->tooltip("function to call to translate static text, The function to call to internatio\
nalize labels and tooltips, usually \"gettext_noop\" or \"N_\"");
            i18n_gnu_static_function_input->box(FL_THIN_DOWN_BOX);
            i18n_gnu_static_function_input->labelsize(11);
            i18n_gnu_static_function_input->textfont(4);
            i18n_gnu_static_function_input->textsize(11);
            i18n_gnu_static_function_input->callback((Fl_Callback*)cb_i18n_gnu_static_function_input);
          } // Fl_Input* i18n_gnu_static_function_input
          i18n_gnu_group->end();
        } // Fl_Group* i18n_gnu_group
        { i18n_posix_group = new Fl_Group(100, 103, 220, 95);
          i18n_posix_group->callback((Fl_Callback*)cb_i18n_posix_group);
          i18n_posix_group->hide();
          { i18n_pos_include_input = new Fl_Input(100, 103, 220, 20, "#include:");
            i18n_pos_include_input->tooltip("The include file for internationalization.");
            i18n_pos_include_input->box(FL_THIN_DOWN_BOX);
            i18n_pos_include_input->labelsize(11);
            i18n_pos_include_input->textfont(4);
            i18n_pos_include_input->textsize(11);
            i18n_pos_include_input->callback((Fl_Callback*)cb_i18n_pos_include_input);
          } // Fl_Input* i18n_pos_include_input
          { i18n_pos_conditional_input = new Fl_Input(100, 128, 220, 20, "Conditional:");
            i18n_pos_conditional_input->tooltip("only include the header file if this preprocessor macro is defined, for examp\
le FLTK_GETTEXT_FOUND");
            i18n_pos_conditional_input->box(FL_THIN_DOWN_BOX);
            i18n_pos_conditional_input->labelsize(11);
            i18n_pos_conditional_input->textfont(4);
            i18n_pos_conditional_input->textsize(11);
            i18n_pos_conditional_input->callback((Fl_Callback*)cb_i18n_pos_conditional_input);
          } // Fl_Input* i18n_pos_conditional_input
          { i18n_pos_file_input = new Fl_Input(100, 153, 220, 20, "File:");
            i18n_pos_file_input->tooltip("The name of the message catalog.");
            i18n_pos_file_input->box(FL_THIN_DOWN_BOX);
            i18n_pos_file_input->labelsize(11);
            i18n_pos_file_input->textfont(4);
            i18n_pos_file_input->textsize(11);
            i18n_pos_file_input->callback((Fl_Callback*)cb_i18n_pos_file_input);
          } // Fl_Input* i18n_pos_file_input
          { i18n_pos_set_input = new Fl_Int_Input(100, 178, 80, 20, "Set:");
            i18n_pos_set_input->tooltip("The message set number.");
            i18n_pos_set_input->type(2);
            i18n_pos_set_input->box(FL_THIN_DOWN_BOX);
            i18n_pos_set_input->labelsize(11);
            i18n_pos_set_input->textfont(4);
            i18n_pos_set_input->textsize(11);
            i18n_pos_set_input->callback((Fl_Callback*)cb_i18n_pos_set_input);
          } // Fl_Int_Input* i18n_pos_set_input
          i18n_posix_group->end();
        } // Fl_Group* i18n_posix_group
        o->image()->scale(36, 24);
        w_settings_i18n_tab->end();
      } // Fl_Group* w_settings_i18n_tab
      w_settings_tabs->end();
    } // Fl_Tabs* w_settings_tabs
    { Fl_Button* o = new Fl_Button(230, 550, 100, 20, "Close");
      o->tooltip("Close this dialog.");
      o->labelsize(11);
      o->callback((Fl_Callback*)cb_Close);
    } // Fl_Button* o
    settings_window->set_non_modal();
    o->size_range(o->w(), o->h());
    settings_window->end();
  } // Fl_Double_Window* settings_window
  w_settings_tabs->do_callback(w_settings_tabs, LOAD);
  return settings_window;
}

Fl_Double_Window *shell_run_window=(Fl_Double_Window *)0;

Fl_Simple_Terminal *shell_run_terminal=(Fl_Simple_Terminal *)0;

static void cb_Clear(Fl_Button*, void*) {
  shell_run_terminal->clear();
}

Fl_Return_Button *shell_run_button=(Fl_Return_Button *)0;

static void cb_shell_run_button(Fl_Return_Button*, void*) {
  Fl_Preferences pos(fluid_prefs, "shell_run_Window_pos");
  pos.set("x", shell_run_window->x());
  pos.set("y", shell_run_window->y());
  pos.set("w", shell_run_window->w());
  pos.set("h", shell_run_window->h());
  shell_run_window->hide();
}

Fl_Double_Window* make_shell_window() {
  { shell_run_window = new Fl_Double_Window(555, 430, "Shell Command Output");
    shell_run_window->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
    { shell_run_terminal = new Fl_Simple_Terminal(10, 10, 535, 375);
      Fl_Group::current()->resizable(shell_run_terminal);
      shell_run_terminal->ansi(1);
    } // Fl_Simple_Terminal* shell_run_terminal
    { Fl_Group* o = new Fl_Group(10, 395, 535, 25);
      { Fl_Button* o = new Fl_Button(10, 395, 94, 25, "Clear");
        o->callback((Fl_Callback*)cb_Clear);
      } // Fl_Button* o
      { Fl_Box* o = new Fl_Box(104, 395, 341, 25);
        o->hide();
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      { shell_run_button = new Fl_Return_Button(445, 395, 100, 25, "Close");
        shell_run_button->callback((Fl_Callback*)cb_shell_run_button);
      } // Fl_Return_Button* shell_run_button
      o->end();
    } // Fl_Group* o
    shell_run_window->end();
  } // Fl_Double_Window* shell_run_window
  return shell_run_window;
}
Fl_Menu_Item *w_layout_menu_storage[4];
