
//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
    This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
    Copyright (C) 2013-2025 Martin Koehler

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 3 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/



#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include "flexiblas_config.h"
#include "flexiblas_fortran_mangle.h"
#include "flexiblas_fortran_char_len.h"

#include "lapack_3_6_1.h"



HIDDEN void *__flexiblas_lapack_addr[10240];
HIDDEN void flexiblas_lapack_dummy_function_not_called(void)
{
    size_t k = 0;
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slamc3,SLAMC3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlamc3,DLAMC3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cbbcsd,CBBCSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cbdsqr,CBDSQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbbrd,CGBBRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbcon,CGBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbequ,CGBEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbequb,CGBEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbrfs,CGBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbsv,CGBSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbsvx,CGBSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbtf2,CGBTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbtrf,CGBTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgbtrs,CGBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgebak,CGEBAK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgebal,CGEBAL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgebd2,CGEBD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgebrd,CGEBRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgecon,CGECON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeequ,CGEEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeequb,CGEEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgees,CGEES)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeesx,CGEESX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeev,CGEEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeevx,CGEEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgegs,CGEGS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgegv,CGEGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgehd2,CGEHD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgehrd,CGEHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgejsv,CGEJSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgelq2,CGELQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgelqf,CGELQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgels,CGELS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgelsd,CGELSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgelss,CGELSS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgelsx,CGELSX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgelsy,CGELSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgemqrt,CGEMQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeql2,CGEQL2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqlf,CGEQLF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqp3,CGEQP3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqpf,CGEQPF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqr2,CGEQR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqr2p,CGEQR2P)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqrf,CGEQRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqrfp,CGEQRFP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqrt,CGEQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqrt2,CGEQRT2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgeqrt3,CGEQRT3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgerfs,CGERFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgerq2,CGERQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgerqf,CGERQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgesc2,CGESC2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgesdd,CGESDD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgesv,CGESV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgesvd,CGESVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgesvdx,CGESVDX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgesvj,CGESVJ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgesvx,CGESVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgetc2,CGETC2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgetf2,CGETF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgetrf,CGETRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgetrf2,CGETRF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgetri,CGETRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgetrs,CGETRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggbak,CGGBAK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggbal,CGGBAL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgges,CGGES)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgges3,CGGES3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggesx,CGGESX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggev,CGGEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggev3,CGGEV3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggevx,CGGEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggglm,CGGGLM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgghd3,CGGHD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgghrd,CGGHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgglse,CGGLSE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggqrf,CGGQRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggrqf,CGGRQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggsvd,CGGSVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggsvd3,CGGSVD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggsvp,CGGSVP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cggsvp3,CGGSVP3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgsvj0,CGSVJ0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgsvj1,CGSVJ1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgtcon,CGTCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgtrfs,CGTRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgtsv,CGTSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgtsvx,CGTSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgttrf,CGTTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgttrs,CGTTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cgtts2,CGTTS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chbev,CHBEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chbevd,CHBEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chbevx,CHBEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chbgst,CHBGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chbgv,CHBGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chbgvd,CHBGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chbgvx,CHBGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chbtrd,CHBTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(checon,CHECON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(checon_rook,CHECON_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cheequb,CHEEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cheev,CHEEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cheevd,CHEEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cheevr,CHEEVR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cheevx,CHEEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chegs2,CHEGS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chegst,CHEGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chegv,CHEGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chegvd,CHEGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chegvx,CHEGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cherfs,CHERFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chesv,CHESV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chesv_rook,CHESV_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chesvx,CHESVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cheswapr,CHESWAPR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetd2,CHETD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetf2,CHETF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetf2_rook,CHETF2_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetrd,CHETRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetrf,CHETRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetrf_rook,CHETRF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetri,CHETRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetri2,CHETRI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetri2x,CHETRI2X)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetri_rook,CHETRI_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetrs,CHETRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetrs2,CHETRS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chetrs_rook,CHETRS_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chfrk,CHFRK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chgeqz,CHGEQZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chla_transtype,CHLA_TRANSTYPE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpcon,CHPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpev,CHPEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpevd,CHPEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpevx,CHPEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpgst,CHPGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpgv,CHPGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpgvd,CHPGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpgvx,CHPGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chprfs,CHPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpsv,CHPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chpsvx,CHPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chptrd,CHPTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chptrf,CHPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chptri,CHPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chptrs,CHPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chsein,CHSEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(chseqr,CHSEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clabrd,CLABRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clacgv,CLACGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clacn2,CLACN2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clacon,CLACON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clacp2,CLACP2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clacpy,CLACPY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clacrm,CLACRM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clacrt,CLACRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cladiv,CLADIV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claed0,CLAED0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claed7,CLAED7)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claed8,CLAED8)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claein,CLAEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claesy,CLAESY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claev2,CLAEV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clag2z,CLAG2Z)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clags2,CLAGS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clagtm,CLAGTM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clahef,CLAHEF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clahef_rook,CLAHEF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clahqr,CLAHQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clahr2,CLAHR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clahrd,CLAHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claic1,CLAIC1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clals0,CLALS0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clalsa,CLALSA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clalsd,CLALSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clangb,CLANGB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clange,CLANGE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clangt,CLANGT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clanhb,CLANHB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clanhe,CLANHE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clanhf,CLANHF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clanhp,CLANHP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clanhs,CLANHS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clanht,CLANHT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clansb,CLANSB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clansp,CLANSP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clansy,CLANSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clantb,CLANTB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clantp,CLANTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clantr,CLANTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clapll,CLAPLL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clapmr,CLAPMR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clapmt,CLAPMT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqgb,CLAQGB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqge,CLAQGE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqhb,CLAQHB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqhe,CLAQHE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqhp,CLAQHP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqp2,CLAQP2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqps,CLAQPS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqr0,CLAQR0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqr1,CLAQR1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqr2,CLAQR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqr3,CLAQR3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqr4,CLAQR4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqr5,CLAQR5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqsb,CLAQSB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqsp,CLAQSP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claqsy,CLAQSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clar1v,CLAR1V)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clar2v,CLAR2V)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarcm,CLARCM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarf,CLARF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarfb,CLARFB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarfg,CLARFG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarfgp,CLARFGP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarft,CLARFT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarfx,CLARFX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clargv,CLARGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarnv,CLARNV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarrv,CLARRV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clartg,CLARTG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clartv,CLARTV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarz,CLARZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarzb,CLARZB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clarzt,CLARZT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clascl,CLASCL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claset,CLASET)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clasr,CLASR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(classq,CLASSQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(claswp,CLASWP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clasyf,CLASYF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clasyf_rook,CLASYF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clatbs,CLATBS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clatdf,CLATDF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clatps,CLATPS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clatrd,CLATRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clatrs,CLATRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clatrz,CLATRZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clatzm,CLATZM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clauu2,CLAUU2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(clauum,CLAUUM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpbcon,CPBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpbequ,CPBEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpbrfs,CPBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpbstf,CPBSTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpbsv,CPBSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpbsvx,CPBSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpbtf2,CPBTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpbtrf,CPBTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpbtrs,CPBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpftrf,CPFTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpftri,CPFTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpftrs,CPFTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpocon,CPOCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpoequ,CPOEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpoequb,CPOEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cporfs,CPORFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cposv,CPOSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cposvx,CPOSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpotf2,CPOTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpotrf,CPOTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpotrf2,CPOTRF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpotri,CPOTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpotrs,CPOTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cppcon,CPPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cppequ,CPPEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpprfs,CPPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cppsv,CPPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cppsvx,CPPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpptrf,CPPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpptri,CPPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpptrs,CPPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpstf2,CPSTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpstrf,CPSTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cptcon,CPTCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpteqr,CPTEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cptrfs,CPTRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cptsv,CPTSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cptsvx,CPTSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpttrf,CPTTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cpttrs,CPTTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cptts2,CPTTS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(crot,CROT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cspcon,CSPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cspmv,CSPMV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cspr,CSPR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csprfs,CSPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cspsv,CSPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cspsvx,CSPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csptrf,CSPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csptri,CSPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csptrs,CSPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csrscl,CSRSCL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cstedc,CSTEDC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cstegr,CSTEGR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cstein,CSTEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cstemr,CSTEMR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csteqr,CSTEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csycon,CSYCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csycon_rook,CSYCON_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csyconv,CSYCONV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csyequb,CSYEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csymv,CSYMV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csyr,CSYR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csyrfs,CSYRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csysv,CSYSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csysv_rook,CSYSV_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csysvx,CSYSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csyswapr,CSYSWAPR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytf2,CSYTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytf2_rook,CSYTF2_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytrf,CSYTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytrf_rook,CSYTRF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytri,CSYTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytri2,CSYTRI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytri2x,CSYTRI2X)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytri_rook,CSYTRI_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytrs,CSYTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytrs2,CSYTRS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(csytrs_rook,CSYTRS_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctbcon,CTBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctbrfs,CTBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctbtrs,CTBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctfsm,CTFSM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctftri,CTFTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctfttp,CTFTTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctfttr,CTFTTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctgevc,CTGEVC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctgex2,CTGEX2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctgexc,CTGEXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctgsen,CTGSEN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctgsja,CTGSJA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctgsna,CTGSNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctgsy2,CTGSY2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctgsyl,CTGSYL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctpcon,CTPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctpmqrt,CTPMQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctpqrt,CTPQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctpqrt2,CTPQRT2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctprfb,CTPRFB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctprfs,CTPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctptri,CTPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctptrs,CTPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctpttf,CTPTTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctpttr,CTPTTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrcon,CTRCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrevc,CTREVC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrevc3,CTREVC3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrexc,CTREXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrrfs,CTRRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrsen,CTRSEN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrsna,CTRSNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrsyl,CTRSYL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrti2,CTRTI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrtri,CTRTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrtrs,CTRTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrttf,CTRTTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctrttp,CTRTTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctzrqf,CTZRQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ctzrzf,CTZRZF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunbdb,CUNBDB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunbdb1,CUNBDB1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunbdb2,CUNBDB2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunbdb3,CUNBDB3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunbdb4,CUNBDB4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunbdb5,CUNBDB5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunbdb6,CUNBDB6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cuncsd,CUNCSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cuncsd2by1,CUNCSD2BY1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cung2l,CUNG2L)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cung2r,CUNG2R)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cungbr,CUNGBR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunghr,CUNGHR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cungl2,CUNGL2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunglq,CUNGLQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cungql,CUNGQL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cungqr,CUNGQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cungr2,CUNGR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cungrq,CUNGRQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cungtr,CUNGTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunm22,CUNM22)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunm2l,CUNM2L)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunm2r,CUNM2R)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmbr,CUNMBR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmhr,CUNMHR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunml2,CUNML2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmlq,CUNMLQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmql,CUNMQL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmqr,CUNMQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmr2,CUNMR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmr3,CUNMR3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmrq,CUNMRQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmrz,CUNMRZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cunmtr,CUNMTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cupgtr,CUPGTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(cupmtr,CUPMTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dbbcsd,DBBCSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dbdsdc,DBDSDC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dbdsqr,DBDSQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dbdsvdx,DBDSVDX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ddisna,DDISNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbbrd,DGBBRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbcon,DGBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbequ,DGBEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbequb,DGBEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbrfs,DGBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbsv,DGBSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbsvx,DGBSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbtf2,DGBTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbtrf,DGBTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgbtrs,DGBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgebak,DGEBAK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgebal,DGEBAL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgebd2,DGEBD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgebrd,DGEBRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgecon,DGECON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeequ,DGEEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeequb,DGEEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgees,DGEES)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeesx,DGEESX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeev,DGEEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeevx,DGEEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgegs,DGEGS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgegv,DGEGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgehd2,DGEHD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgehrd,DGEHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgejsv,DGEJSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgelq2,DGELQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgelqf,DGELQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgels,DGELS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgelsd,DGELSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgelss,DGELSS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgelsx,DGELSX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgelsy,DGELSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgemqrt,DGEMQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeql2,DGEQL2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqlf,DGEQLF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqp3,DGEQP3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqpf,DGEQPF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqr2,DGEQR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqr2p,DGEQR2P)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqrf,DGEQRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqrfp,DGEQRFP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqrt,DGEQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqrt2,DGEQRT2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgeqrt3,DGEQRT3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgerfs,DGERFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgerq2,DGERQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgerqf,DGERQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgesc2,DGESC2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgesdd,DGESDD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgesv,DGESV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgesvd,DGESVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgesvdx,DGESVDX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgesvj,DGESVJ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgesvx,DGESVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgetc2,DGETC2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgetf2,DGETF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgetrf,DGETRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgetrf2,DGETRF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgetri,DGETRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgetrs,DGETRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggbak,DGGBAK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggbal,DGGBAL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgges,DGGES)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgges3,DGGES3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggesx,DGGESX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggev,DGGEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggev3,DGGEV3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggevx,DGGEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggglm,DGGGLM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgghd3,DGGHD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgghrd,DGGHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgglse,DGGLSE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggqrf,DGGQRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggrqf,DGGRQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggsvd,DGGSVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggsvd3,DGGSVD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggsvp,DGGSVP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dggsvp3,DGGSVP3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgsvj0,DGSVJ0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgsvj1,DGSVJ1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgtcon,DGTCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgtrfs,DGTRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgtsv,DGTSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgtsvx,DGTSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgttrf,DGTTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgttrs,DGTTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dgtts2,DGTTS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dhgeqz,DHGEQZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dhsein,DHSEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dhseqr,DHSEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(disnan,DISNAN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlabad,DLABAD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlabrd,DLABRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlacn2,DLACN2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlacon,DLACON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlacpy,DLACPY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dladiv,DLADIV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dladiv1,DLADIV1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dladiv2,DLADIV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlae2,DLAE2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaebz,DLAEBZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed0,DLAED0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed1,DLAED1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed2,DLAED2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed3,DLAED3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed4,DLAED4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed5,DLAED5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed6,DLAED6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed7,DLAED7)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed8,DLAED8)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaed9,DLAED9)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaeda,DLAEDA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaein,DLAEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaev2,DLAEV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaexc,DLAEXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlag2,DLAG2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlag2s,DLAG2S)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlags2,DLAGS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlagtf,DLAGTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlagtm,DLAGTM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlagts,DLAGTS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlagv2,DLAGV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlahqr,DLAHQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlahr2,DLAHR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlahrd,DLAHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaic1,DLAIC1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaisnan,DLAISNAN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaln2,DLALN2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlals0,DLALS0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlalsa,DLALSA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlalsd,DLALSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlamch,DLAMCH)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlamrg,DLAMRG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaneg,DLANEG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlangb,DLANGB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlange,DLANGE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlangt,DLANGT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlanhs,DLANHS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlansb,DLANSB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlansf,DLANSF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlansp,DLANSP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlanst,DLANST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlansy,DLANSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlantb,DLANTB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlantp,DLANTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlantr,DLANTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlanv2,DLANV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlapll,DLAPLL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlapmr,DLAPMR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlapmt,DLAPMT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlapy2,DLAPY2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlapy3,DLAPY3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqgb,DLAQGB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqge,DLAQGE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqp2,DLAQP2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqps,DLAQPS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqr0,DLAQR0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqr1,DLAQR1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqr2,DLAQR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqr3,DLAQR3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqr4,DLAQR4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqr5,DLAQR5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqsb,DLAQSB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqsp,DLAQSP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqsy,DLAQSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaqtr,DLAQTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlar1v,DLAR1V)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlar2v,DLAR2V)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarf,DLARF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarfb,DLARFB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarfg,DLARFG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarfgp,DLARFGP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarft,DLARFT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarfx,DLARFX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlargv,DLARGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarnv,DLARNV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarra,DLARRA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarrb,DLARRB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarrc,DLARRC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarrd,DLARRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarre,DLARRE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarrf,DLARRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarrj,DLARRJ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarrk,DLARRK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarrr,DLARRR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarrv,DLARRV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlartg,DLARTG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlartgp,DLARTGP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlartgs,DLARTGS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlartv,DLARTV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaruv,DLARUV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarz,DLARZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarzb,DLARZB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlarzt,DLARZT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlas2,DLAS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlascl,DLASCL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasd0,DLASD0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasd1,DLASD1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasd2,DLASD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasd3,DLASD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasd4,DLASD4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasd5,DLASD5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasd6,DLASD6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasd7,DLASD7)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasd8,DLASD8)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasda,DLASDA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasdq,DLASDQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasdt,DLASDT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaset,DLASET)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasq1,DLASQ1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasq2,DLASQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasq3,DLASQ3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasq4,DLASQ4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasq5,DLASQ5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasq6,DLASQ6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasr,DLASR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasrt,DLASRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlassq,DLASSQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasv2,DLASV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlaswp,DLASWP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasy2,DLASY2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasyf,DLASYF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlasyf_rook,DLASYF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlat2s,DLAT2S)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlatbs,DLATBS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlatdf,DLATDF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlatps,DLATPS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlatrd,DLATRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlatrs,DLATRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlatrz,DLATRZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlatzm,DLATZM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlauu2,DLAUU2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dlauum,DLAUUM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dopgtr,DOPGTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dopmtr,DOPMTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorbdb,DORBDB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorbdb1,DORBDB1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorbdb2,DORBDB2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorbdb3,DORBDB3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorbdb4,DORBDB4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorbdb5,DORBDB5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorbdb6,DORBDB6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorcsd,DORCSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorcsd2by1,DORCSD2BY1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorg2l,DORG2L)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorg2r,DORG2R)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorgbr,DORGBR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorghr,DORGHR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorgl2,DORGL2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorglq,DORGLQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorgql,DORGQL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorgqr,DORGQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorgr2,DORGR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorgrq,DORGRQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorgtr,DORGTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorm22,DORM22)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorm2l,DORM2L)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorm2r,DORM2R)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormbr,DORMBR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormhr,DORMHR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dorml2,DORML2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormlq,DORMLQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormql,DORMQL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormqr,DORMQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormr2,DORMR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormr3,DORMR3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormrq,DORMRQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormrz,DORMRZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dormtr,DORMTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpbcon,DPBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpbequ,DPBEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpbrfs,DPBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpbstf,DPBSTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpbsv,DPBSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpbsvx,DPBSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpbtf2,DPBTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpbtrf,DPBTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpbtrs,DPBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpftrf,DPFTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpftri,DPFTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpftrs,DPFTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpocon,DPOCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpoequ,DPOEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpoequb,DPOEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dporfs,DPORFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dposv,DPOSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dposvx,DPOSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpotf2,DPOTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpotrf,DPOTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpotrf2,DPOTRF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpotri,DPOTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpotrs,DPOTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dppcon,DPPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dppequ,DPPEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpprfs,DPPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dppsv,DPPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dppsvx,DPPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpptrf,DPPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpptri,DPPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpptrs,DPPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpstf2,DPSTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpstrf,DPSTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dptcon,DPTCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpteqr,DPTEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dptrfs,DPTRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dptsv,DPTSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dptsvx,DPTSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpttrf,DPTTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dpttrs,DPTTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dptts2,DPTTS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(drscl,DRSCL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsbev,DSBEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsbevd,DSBEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsbevx,DSBEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsbgst,DSBGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsbgv,DSBGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsbgvd,DSBGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsbgvx,DSBGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsbtrd,DSBTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsecnd,DSECND)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsfrk,DSFRK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsgesv,DSGESV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspcon,DSPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspev,DSPEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspevd,DSPEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspevx,DSPEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspgst,DSPGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspgv,DSPGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspgvd,DSPGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspgvx,DSPGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsposv,DSPOSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsprfs,DSPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspsv,DSPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dspsvx,DSPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsptrd,DSPTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsptrf,DSPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsptri,DSPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsptrs,DSPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dstebz,DSTEBZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dstedc,DSTEDC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dstegr,DSTEGR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dstein,DSTEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dstemr,DSTEMR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsteqr,DSTEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsterf,DSTERF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dstev,DSTEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dstevd,DSTEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dstevr,DSTEVR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dstevx,DSTEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsycon,DSYCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsycon_rook,DSYCON_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsyconv,DSYCONV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsyequb,DSYEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsyev,DSYEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsyevd,DSYEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsyevr,DSYEVR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsyevx,DSYEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsygs2,DSYGS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsygst,DSYGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsygv,DSYGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsygvd,DSYGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsygvx,DSYGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsyrfs,DSYRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsysv,DSYSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsysv_rook,DSYSV_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsysvx,DSYSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsyswapr,DSYSWAPR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytd2,DSYTD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytf2,DSYTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytf2_rook,DSYTF2_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytrd,DSYTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytrf,DSYTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytrf_rook,DSYTRF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytri,DSYTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytri2,DSYTRI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytri2x,DSYTRI2X)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytri_rook,DSYTRI_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytrs,DSYTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytrs2,DSYTRS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dsytrs_rook,DSYTRS_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtbcon,DTBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtbrfs,DTBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtbtrs,DTBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtfsm,DTFSM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtftri,DTFTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtfttp,DTFTTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtfttr,DTFTTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtgevc,DTGEVC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtgex2,DTGEX2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtgexc,DTGEXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtgsen,DTGSEN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtgsja,DTGSJA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtgsna,DTGSNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtgsy2,DTGSY2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtgsyl,DTGSYL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtpcon,DTPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtpmqrt,DTPMQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtpqrt,DTPQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtpqrt2,DTPQRT2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtprfb,DTPRFB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtprfs,DTPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtptri,DTPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtptrs,DTPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtpttf,DTPTTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtpttr,DTPTTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrcon,DTRCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrevc,DTREVC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrevc3,DTREVC3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrexc,DTREXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrrfs,DTRRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrsen,DTRSEN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrsna,DTRSNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrsyl,DTRSYL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrti2,DTRTI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrtri,DTRTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrtrs,DTRTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrttf,DTRTTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtrttp,DTRTTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtzrqf,DTZRQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dtzrzf,DTZRZF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(dzsum1,DZSUM1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(icmax1,ICMAX1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ieeeck,IEEECK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilaclc,ILACLC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilaclr,ILACLR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(iladiag,ILADIAG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(iladlc,ILADLC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(iladlr,ILADLR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilaenv,ILAENV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilaprec,ILAPREC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilaslc,ILASLC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilaslr,ILASLR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilatrans,ILATRANS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilauplo,ILAUPLO)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilazlc,ILAZLC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ilazlr,ILAZLR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(iparmq,IPARMQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(izmax1,IZMAX1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sbbcsd,SBBCSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sbdsdc,SBDSDC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sbdsqr,SBDSQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sbdsvdx,SBDSVDX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(scsum1,SCSUM1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sdisna,SDISNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(second,SECOND)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbbrd,SGBBRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbcon,SGBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbequ,SGBEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbequb,SGBEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbrfs,SGBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbsv,SGBSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbsvx,SGBSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbtf2,SGBTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbtrf,SGBTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgbtrs,SGBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgebak,SGEBAK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgebal,SGEBAL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgebd2,SGEBD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgebrd,SGEBRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgecon,SGECON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeequ,SGEEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeequb,SGEEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgees,SGEES)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeesx,SGEESX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeev,SGEEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeevx,SGEEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgegs,SGEGS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgegv,SGEGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgehd2,SGEHD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgehrd,SGEHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgejsv,SGEJSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgelq2,SGELQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgelqf,SGELQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgels,SGELS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgelsd,SGELSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgelss,SGELSS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgelsx,SGELSX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgelsy,SGELSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgemqrt,SGEMQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeql2,SGEQL2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqlf,SGEQLF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqp3,SGEQP3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqpf,SGEQPF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqr2,SGEQR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqr2p,SGEQR2P)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqrf,SGEQRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqrfp,SGEQRFP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqrt,SGEQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqrt2,SGEQRT2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgeqrt3,SGEQRT3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgerfs,SGERFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgerq2,SGERQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgerqf,SGERQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgesc2,SGESC2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgesdd,SGESDD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgesv,SGESV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgesvd,SGESVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgesvdx,SGESVDX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgesvj,SGESVJ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgesvx,SGESVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgetc2,SGETC2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgetf2,SGETF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgetrf,SGETRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgetrf2,SGETRF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgetri,SGETRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgetrs,SGETRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggbak,SGGBAK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggbal,SGGBAL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgges,SGGES)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgges3,SGGES3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggesx,SGGESX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggev,SGGEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggev3,SGGEV3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggevx,SGGEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggglm,SGGGLM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgghd3,SGGHD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgghrd,SGGHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgglse,SGGLSE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggqrf,SGGQRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggrqf,SGGRQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggsvd,SGGSVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggsvd3,SGGSVD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggsvp,SGGSVP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sggsvp3,SGGSVP3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgsvj0,SGSVJ0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgsvj1,SGSVJ1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgtcon,SGTCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgtrfs,SGTRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgtsv,SGTSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgtsvx,SGTSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgttrf,SGTTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgttrs,SGTTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sgtts2,SGTTS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(shgeqz,SHGEQZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(shsein,SHSEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(shseqr,SHSEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sisnan,SISNAN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slabad,SLABAD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slabrd,SLABRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slacn2,SLACN2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slacon,SLACON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slacpy,SLACPY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sladiv,SLADIV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sladiv1,SLADIV1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sladiv2,SLADIV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slae2,SLAE2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaebz,SLAEBZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed0,SLAED0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed1,SLAED1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed2,SLAED2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed3,SLAED3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed4,SLAED4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed5,SLAED5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed6,SLAED6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed7,SLAED7)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed8,SLAED8)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaed9,SLAED9)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaeda,SLAEDA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaein,SLAEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaev2,SLAEV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaexc,SLAEXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slag2,SLAG2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slag2d,SLAG2D)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slags2,SLAGS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slagtf,SLAGTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slagtm,SLAGTM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slagts,SLAGTS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slagv2,SLAGV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slahqr,SLAHQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slahr2,SLAHR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slahrd,SLAHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaic1,SLAIC1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaisnan,SLAISNAN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaln2,SLALN2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slals0,SLALS0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slalsa,SLALSA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slalsd,SLALSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slamch,SLAMCH)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slamrg,SLAMRG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaneg,SLANEG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slangb,SLANGB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slange,SLANGE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slangt,SLANGT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slanhs,SLANHS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slansb,SLANSB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slansf,SLANSF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slansp,SLANSP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slanst,SLANST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slansy,SLANSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slantb,SLANTB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slantp,SLANTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slantr,SLANTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slanv2,SLANV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slapll,SLAPLL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slapmr,SLAPMR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slapmt,SLAPMT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slapy2,SLAPY2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slapy3,SLAPY3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqgb,SLAQGB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqge,SLAQGE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqp2,SLAQP2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqps,SLAQPS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqr0,SLAQR0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqr1,SLAQR1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqr2,SLAQR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqr3,SLAQR3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqr4,SLAQR4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqr5,SLAQR5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqsb,SLAQSB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqsp,SLAQSP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqsy,SLAQSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaqtr,SLAQTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slar1v,SLAR1V)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slar2v,SLAR2V)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarf,SLARF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarfb,SLARFB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarfg,SLARFG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarfgp,SLARFGP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarft,SLARFT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarfx,SLARFX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slargv,SLARGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarnv,SLARNV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarra,SLARRA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarrb,SLARRB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarrc,SLARRC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarrd,SLARRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarre,SLARRE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarrf,SLARRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarrj,SLARRJ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarrk,SLARRK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarrr,SLARRR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarrv,SLARRV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slartg,SLARTG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slartgp,SLARTGP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slartgs,SLARTGS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slartv,SLARTV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaruv,SLARUV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarz,SLARZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarzb,SLARZB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slarzt,SLARZT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slas2,SLAS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slascl,SLASCL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasd0,SLASD0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasd1,SLASD1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasd2,SLASD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasd3,SLASD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasd4,SLASD4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasd5,SLASD5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasd6,SLASD6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasd7,SLASD7)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasd8,SLASD8)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasda,SLASDA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasdq,SLASDQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasdt,SLASDT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaset,SLASET)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasq1,SLASQ1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasq2,SLASQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasq3,SLASQ3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasq4,SLASQ4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasq5,SLASQ5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasq6,SLASQ6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasr,SLASR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasrt,SLASRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slassq,SLASSQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasv2,SLASV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slaswp,SLASWP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasy2,SLASY2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasyf,SLASYF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slasyf_rook,SLASYF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slatbs,SLATBS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slatdf,SLATDF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slatps,SLATPS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slatrd,SLATRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slatrs,SLATRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slatrz,SLATRZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slatzm,SLATZM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slauu2,SLAUU2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(slauum,SLAUUM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sopgtr,SOPGTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sopmtr,SOPMTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorbdb,SORBDB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorbdb1,SORBDB1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorbdb2,SORBDB2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorbdb3,SORBDB3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorbdb4,SORBDB4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorbdb5,SORBDB5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorbdb6,SORBDB6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorcsd,SORCSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorcsd2by1,SORCSD2BY1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorg2l,SORG2L)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorg2r,SORG2R)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorgbr,SORGBR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorghr,SORGHR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorgl2,SORGL2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorglq,SORGLQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorgql,SORGQL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorgqr,SORGQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorgr2,SORGR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorgrq,SORGRQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorgtr,SORGTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorm22,SORM22)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorm2l,SORM2L)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorm2r,SORM2R)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormbr,SORMBR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormhr,SORMHR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sorml2,SORML2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormlq,SORMLQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormql,SORMQL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormqr,SORMQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormr2,SORMR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormr3,SORMR3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormrq,SORMRQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormrz,SORMRZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sormtr,SORMTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spbcon,SPBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spbequ,SPBEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spbrfs,SPBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spbstf,SPBSTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spbsv,SPBSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spbsvx,SPBSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spbtf2,SPBTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spbtrf,SPBTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spbtrs,SPBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spftrf,SPFTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spftri,SPFTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spftrs,SPFTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spocon,SPOCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spoequ,SPOEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spoequb,SPOEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sporfs,SPORFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sposv,SPOSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sposvx,SPOSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spotf2,SPOTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spotrf,SPOTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spotrf2,SPOTRF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spotri,SPOTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spotrs,SPOTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sppcon,SPPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sppequ,SPPEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spprfs,SPPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sppsv,SPPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sppsvx,SPPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spptrf,SPPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spptri,SPPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spptrs,SPPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spstf2,SPSTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spstrf,SPSTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sptcon,SPTCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spteqr,SPTEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sptrfs,SPTRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sptsv,SPTSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sptsvx,SPTSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spttrf,SPTTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(spttrs,SPTTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sptts2,SPTTS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(srscl,SRSCL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssbev,SSBEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssbevd,SSBEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssbevx,SSBEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssbgst,SSBGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssbgv,SSBGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssbgvd,SSBGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssbgvx,SSBGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssbtrd,SSBTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssfrk,SSFRK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspcon,SSPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspev,SSPEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspevd,SSPEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspevx,SSPEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspgst,SSPGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspgv,SSPGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspgvd,SSPGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspgvx,SSPGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssprfs,SSPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspsv,SSPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sspsvx,SSPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssptrd,SSPTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssptrf,SSPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssptri,SSPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssptrs,SSPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sstebz,SSTEBZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sstedc,SSTEDC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sstegr,SSTEGR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sstein,SSTEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sstemr,SSTEMR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssteqr,SSTEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssterf,SSTERF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sstev,SSTEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sstevd,SSTEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sstevr,SSTEVR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(sstevx,SSTEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssycon,SSYCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssycon_rook,SSYCON_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssyconv,SSYCONV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssyequb,SSYEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssyev,SSYEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssyevd,SSYEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssyevr,SSYEVR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssyevx,SSYEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssygs2,SSYGS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssygst,SSYGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssygv,SSYGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssygvd,SSYGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssygvx,SSYGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssyrfs,SSYRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssysv,SSYSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssysv_rook,SSYSV_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssysvx,SSYSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssyswapr,SSYSWAPR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytd2,SSYTD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytf2,SSYTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytf2_rook,SSYTF2_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytrd,SSYTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytrf,SSYTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytrf_rook,SSYTRF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytri,SSYTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytri2,SSYTRI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytri2x,SSYTRI2X)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytri_rook,SSYTRI_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytrs,SSYTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytrs2,SSYTRS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ssytrs_rook,SSYTRS_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stbcon,STBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stbrfs,STBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stbtrs,STBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stfsm,STFSM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stftri,STFTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stfttp,STFTTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stfttr,STFTTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stgevc,STGEVC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stgex2,STGEX2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stgexc,STGEXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stgsen,STGSEN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stgsja,STGSJA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stgsna,STGSNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stgsy2,STGSY2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stgsyl,STGSYL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stpcon,STPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stpmqrt,STPMQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stpqrt,STPQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stpqrt2,STPQRT2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stprfb,STPRFB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stprfs,STPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stptri,STPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stptrs,STPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stpttf,STPTTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stpttr,STPTTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strcon,STRCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strevc,STREVC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strevc3,STREVC3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strexc,STREXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strrfs,STRRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strsen,STRSEN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strsna,STRSNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strsyl,STRSYL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strti2,STRTI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strtri,STRTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strtrs,STRTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strttf,STRTTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(strttp,STRTTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stzrqf,STZRQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(stzrzf,STZRZF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(xerbla_array,XERBLA_ARRAY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zbbcsd,ZBBCSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zbdsqr,ZBDSQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zcgesv,ZCGESV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zcposv,ZCPOSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zdrscl,ZDRSCL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbbrd,ZGBBRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbcon,ZGBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbequ,ZGBEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbequb,ZGBEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbrfs,ZGBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbsv,ZGBSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbsvx,ZGBSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbtf2,ZGBTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbtrf,ZGBTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgbtrs,ZGBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgebak,ZGEBAK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgebal,ZGEBAL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgebd2,ZGEBD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgebrd,ZGEBRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgecon,ZGECON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeequ,ZGEEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeequb,ZGEEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgees,ZGEES)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeesx,ZGEESX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeev,ZGEEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeevx,ZGEEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgegs,ZGEGS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgegv,ZGEGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgehd2,ZGEHD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgehrd,ZGEHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgejsv,ZGEJSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgelq2,ZGELQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgelqf,ZGELQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgels,ZGELS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgelsd,ZGELSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgelss,ZGELSS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgelsx,ZGELSX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgelsy,ZGELSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgemqrt,ZGEMQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeql2,ZGEQL2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqlf,ZGEQLF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqp3,ZGEQP3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqpf,ZGEQPF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqr2,ZGEQR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqr2p,ZGEQR2P)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqrf,ZGEQRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqrfp,ZGEQRFP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqrt,ZGEQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqrt2,ZGEQRT2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgeqrt3,ZGEQRT3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgerfs,ZGERFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgerq2,ZGERQ2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgerqf,ZGERQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgesc2,ZGESC2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgesdd,ZGESDD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgesv,ZGESV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgesvd,ZGESVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgesvdx,ZGESVDX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgesvj,ZGESVJ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgesvx,ZGESVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgetc2,ZGETC2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgetf2,ZGETF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgetrf,ZGETRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgetrf2,ZGETRF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgetri,ZGETRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgetrs,ZGETRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggbak,ZGGBAK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggbal,ZGGBAL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgges,ZGGES)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgges3,ZGGES3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggesx,ZGGESX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggev,ZGGEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggev3,ZGGEV3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggevx,ZGGEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggglm,ZGGGLM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgghd3,ZGGHD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgghrd,ZGGHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgglse,ZGGLSE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggqrf,ZGGQRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggrqf,ZGGRQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggsvd,ZGGSVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggsvd3,ZGGSVD3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggsvp,ZGGSVP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zggsvp3,ZGGSVP3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgsvj0,ZGSVJ0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgsvj1,ZGSVJ1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgtcon,ZGTCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgtrfs,ZGTRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgtsv,ZGTSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgtsvx,ZGTSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgttrf,ZGTTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgttrs,ZGTTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zgtts2,ZGTTS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhbev,ZHBEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhbevd,ZHBEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhbevx,ZHBEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhbgst,ZHBGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhbgv,ZHBGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhbgvd,ZHBGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhbgvx,ZHBGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhbtrd,ZHBTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhecon,ZHECON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhecon_rook,ZHECON_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zheequb,ZHEEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zheev,ZHEEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zheevd,ZHEEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zheevr,ZHEEVR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zheevx,ZHEEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhegs2,ZHEGS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhegst,ZHEGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhegv,ZHEGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhegvd,ZHEGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhegvx,ZHEGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zherfs,ZHERFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhesv,ZHESV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhesv_rook,ZHESV_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhesvx,ZHESVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zheswapr,ZHESWAPR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetd2,ZHETD2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetf2,ZHETF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetf2_rook,ZHETF2_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetrd,ZHETRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetrf,ZHETRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetrf_rook,ZHETRF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetri,ZHETRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetri2,ZHETRI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetri2x,ZHETRI2X)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetri_rook,ZHETRI_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetrs,ZHETRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetrs2,ZHETRS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhetrs_rook,ZHETRS_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhfrk,ZHFRK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhgeqz,ZHGEQZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpcon,ZHPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpev,ZHPEV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpevd,ZHPEVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpevx,ZHPEVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpgst,ZHPGST)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpgv,ZHPGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpgvd,ZHPGVD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpgvx,ZHPGVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhprfs,ZHPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpsv,ZHPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhpsvx,ZHPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhptrd,ZHPTRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhptrf,ZHPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhptri,ZHPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhptrs,ZHPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhsein,ZHSEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zhseqr,ZHSEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlabrd,ZLABRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlacgv,ZLACGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlacn2,ZLACN2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlacon,ZLACON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlacp2,ZLACP2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlacpy,ZLACPY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlacrm,ZLACRM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlacrt,ZLACRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zladiv,ZLADIV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaed0,ZLAED0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaed7,ZLAED7)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaed8,ZLAED8)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaein,ZLAEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaesy,ZLAESY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaev2,ZLAEV2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlag2c,ZLAG2C)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlags2,ZLAGS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlagtm,ZLAGTM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlahef,ZLAHEF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlahef_rook,ZLAHEF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlahqr,ZLAHQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlahr2,ZLAHR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlahrd,ZLAHRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaic1,ZLAIC1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlals0,ZLALS0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlalsa,ZLALSA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlalsd,ZLALSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlangb,ZLANGB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlange,ZLANGE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlangt,ZLANGT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlanhb,ZLANHB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlanhe,ZLANHE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlanhf,ZLANHF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlanhp,ZLANHP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlanhs,ZLANHS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlanht,ZLANHT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlansb,ZLANSB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlansp,ZLANSP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlansy,ZLANSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlantb,ZLANTB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlantp,ZLANTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlantr,ZLANTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlapll,ZLAPLL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlapmr,ZLAPMR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlapmt,ZLAPMT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqgb,ZLAQGB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqge,ZLAQGE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqhb,ZLAQHB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqhe,ZLAQHE)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqhp,ZLAQHP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqp2,ZLAQP2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqps,ZLAQPS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqr0,ZLAQR0)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqr1,ZLAQR1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqr2,ZLAQR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqr3,ZLAQR3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqr4,ZLAQR4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqr5,ZLAQR5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqsb,ZLAQSB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqsp,ZLAQSP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaqsy,ZLAQSY)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlar1v,ZLAR1V)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlar2v,ZLAR2V)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarcm,ZLARCM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarf,ZLARF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarfb,ZLARFB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarfg,ZLARFG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarfgp,ZLARFGP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarft,ZLARFT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarfx,ZLARFX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlargv,ZLARGV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarnv,ZLARNV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarrv,ZLARRV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlartg,ZLARTG)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlartv,ZLARTV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarz,ZLARZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarzb,ZLARZB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlarzt,ZLARZT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlascl,ZLASCL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaset,ZLASET)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlasr,ZLASR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlassq,ZLASSQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlaswp,ZLASWP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlasyf,ZLASYF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlasyf_rook,ZLASYF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlat2c,ZLAT2C)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlatbs,ZLATBS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlatdf,ZLATDF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlatps,ZLATPS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlatrd,ZLATRD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlatrs,ZLATRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlatrz,ZLATRZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlatzm,ZLATZM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlauu2,ZLAUU2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zlauum,ZLAUUM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpbcon,ZPBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpbequ,ZPBEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpbrfs,ZPBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpbstf,ZPBSTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpbsv,ZPBSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpbsvx,ZPBSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpbtf2,ZPBTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpbtrf,ZPBTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpbtrs,ZPBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpftrf,ZPFTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpftri,ZPFTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpftrs,ZPFTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpocon,ZPOCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpoequ,ZPOEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpoequb,ZPOEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zporfs,ZPORFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zposv,ZPOSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zposvx,ZPOSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpotf2,ZPOTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpotrf,ZPOTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpotrf2,ZPOTRF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpotri,ZPOTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpotrs,ZPOTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zppcon,ZPPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zppequ,ZPPEQU)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpprfs,ZPPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zppsv,ZPPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zppsvx,ZPPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpptrf,ZPPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpptri,ZPPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpptrs,ZPPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpstf2,ZPSTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpstrf,ZPSTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zptcon,ZPTCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpteqr,ZPTEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zptrfs,ZPTRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zptsv,ZPTSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zptsvx,ZPTSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpttrf,ZPTTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zpttrs,ZPTTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zptts2,ZPTTS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zrot,ZROT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zspcon,ZSPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zspmv,ZSPMV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zspr,ZSPR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsprfs,ZSPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zspsv,ZSPSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zspsvx,ZSPSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsptrf,ZSPTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsptri,ZSPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsptrs,ZSPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zstedc,ZSTEDC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zstegr,ZSTEGR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zstein,ZSTEIN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zstemr,ZSTEMR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsteqr,ZSTEQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsycon,ZSYCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsycon_rook,ZSYCON_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsyconv,ZSYCONV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsyequb,ZSYEQUB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsymv,ZSYMV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsyr,ZSYR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsyrfs,ZSYRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsysv,ZSYSV)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsysv_rook,ZSYSV_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsysvx,ZSYSVX)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsyswapr,ZSYSWAPR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytf2,ZSYTF2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytf2_rook,ZSYTF2_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytrf,ZSYTRF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytrf_rook,ZSYTRF_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytri,ZSYTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytri2,ZSYTRI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytri2x,ZSYTRI2X)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytri_rook,ZSYTRI_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytrs,ZSYTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytrs2,ZSYTRS2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zsytrs_rook,ZSYTRS_ROOK)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztbcon,ZTBCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztbrfs,ZTBRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztbtrs,ZTBTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztfsm,ZTFSM)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztftri,ZTFTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztfttp,ZTFTTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztfttr,ZTFTTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztgevc,ZTGEVC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztgex2,ZTGEX2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztgexc,ZTGEXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztgsen,ZTGSEN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztgsja,ZTGSJA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztgsna,ZTGSNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztgsy2,ZTGSY2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztgsyl,ZTGSYL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztpcon,ZTPCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztpmqrt,ZTPMQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztpqrt,ZTPQRT)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztpqrt2,ZTPQRT2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztprfb,ZTPRFB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztprfs,ZTPRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztptri,ZTPTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztptrs,ZTPTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztpttf,ZTPTTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztpttr,ZTPTTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrcon,ZTRCON)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrevc,ZTREVC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrevc3,ZTREVC3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrexc,ZTREXC)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrrfs,ZTRRFS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrsen,ZTRSEN)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrsna,ZTRSNA)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrsyl,ZTRSYL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrti2,ZTRTI2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrtri,ZTRTRI)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrtrs,ZTRTRS)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrttf,ZTRTTF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztrttp,ZTRTTP)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztzrqf,ZTZRQF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(ztzrzf,ZTZRZF)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunbdb,ZUNBDB)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunbdb1,ZUNBDB1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunbdb2,ZUNBDB2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunbdb3,ZUNBDB3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunbdb4,ZUNBDB4)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunbdb5,ZUNBDB5)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunbdb6,ZUNBDB6)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zuncsd,ZUNCSD)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zuncsd2by1,ZUNCSD2BY1)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zung2l,ZUNG2L)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zung2r,ZUNG2R)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zungbr,ZUNGBR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunghr,ZUNGHR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zungl2,ZUNGL2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunglq,ZUNGLQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zungql,ZUNGQL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zungqr,ZUNGQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zungr2,ZUNGR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zungrq,ZUNGRQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zungtr,ZUNGTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunm22,ZUNM22)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunm2l,ZUNM2L)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunm2r,ZUNM2R)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmbr,ZUNMBR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmhr,ZUNMHR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunml2,ZUNML2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmlq,ZUNMLQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmql,ZUNMQL)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmqr,ZUNMQR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmr2,ZUNMR2)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmr3,ZUNMR3)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmrq,ZUNMRQ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmrz,ZUNMRZ)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zunmtr,ZUNMTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zupgtr,ZUPGTR)));
    __flexiblas_lapack_addr[k++] = (void *)((size_t) &(FC_GLOBAL(zupmtr,ZUPMTR)));
}