
//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
    This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
    Copyright (C) 2013-2024 Martin Koehler

    This program is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the Free
    Software Foundation, either version 3 of the License, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program. If not, see <https://www.gnu.org/licenses/>.
 */

#include "flexiblas_config.h"
#include "flexiblas_fortran_mangle.h"

void FC_GLOBAL(cbbcsd,CBBCSD)(void);
void FC_GLOBAL(cbdsqr,CBDSQR)(void);
void FC_GLOBAL(cgbbrd,CGBBRD)(void);
void FC_GLOBAL(cgbcon,CGBCON)(void);
void FC_GLOBAL(cgbequ,CGBEQU)(void);
void FC_GLOBAL(cgbequb,CGBEQUB)(void);
void FC_GLOBAL(cgbrfs,CGBRFS)(void);
void FC_GLOBAL(cgbsv,CGBSV)(void);
void FC_GLOBAL(cgbsvx,CGBSVX)(void);
void FC_GLOBAL(cgbtf2,CGBTF2)(void);
void FC_GLOBAL(cgbtrf,CGBTRF)(void);
void FC_GLOBAL(cgbtrs,CGBTRS)(void);
void FC_GLOBAL(cgebak,CGEBAK)(void);
void FC_GLOBAL(cgebal,CGEBAL)(void);
void FC_GLOBAL(cgebd2,CGEBD2)(void);
void FC_GLOBAL(cgebrd,CGEBRD)(void);
void FC_GLOBAL(cgecon,CGECON)(void);
void FC_GLOBAL(cgeequ,CGEEQU)(void);
void FC_GLOBAL(cgeequb,CGEEQUB)(void);
void FC_GLOBAL(cgees,CGEES)(void);
void FC_GLOBAL(cgeesx,CGEESX)(void);
void FC_GLOBAL(cgeev,CGEEV)(void);
void FC_GLOBAL(cgeevx,CGEEVX)(void);
void FC_GLOBAL(cgehd2,CGEHD2)(void);
void FC_GLOBAL(cgehrd,CGEHRD)(void);
void FC_GLOBAL(cgejsv,CGEJSV)(void);
void FC_GLOBAL(cgelq,CGELQ)(void);
void FC_GLOBAL(cgelq2,CGELQ2)(void);
void FC_GLOBAL(cgelqf,CGELQF)(void);
void FC_GLOBAL(cgelqt,CGELQT)(void);
void FC_GLOBAL(cgelqt3,CGELQT3)(void);
void FC_GLOBAL(cgels,CGELS)(void);
void FC_GLOBAL(cgelsd,CGELSD)(void);
void FC_GLOBAL(cgelss,CGELSS)(void);
void FC_GLOBAL(cgelst,CGELST)(void);
void FC_GLOBAL(cgelsy,CGELSY)(void);
void FC_GLOBAL(cgemlq,CGEMLQ)(void);
void FC_GLOBAL(cgemlqt,CGEMLQT)(void);
void FC_GLOBAL(cgemqr,CGEMQR)(void);
void FC_GLOBAL(cgemqrt,CGEMQRT)(void);
void FC_GLOBAL(cgeql2,CGEQL2)(void);
void FC_GLOBAL(cgeqlf,CGEQLF)(void);
void FC_GLOBAL(cgeqp3,CGEQP3)(void);
void FC_GLOBAL(cgeqr,CGEQR)(void);
void FC_GLOBAL(cgeqr2,CGEQR2)(void);
void FC_GLOBAL(cgeqr2p,CGEQR2P)(void);
void FC_GLOBAL(cgeqrf,CGEQRF)(void);
void FC_GLOBAL(cgeqrfp,CGEQRFP)(void);
void FC_GLOBAL(cgeqrt,CGEQRT)(void);
void FC_GLOBAL(cgeqrt2,CGEQRT2)(void);
void FC_GLOBAL(cgeqrt3,CGEQRT3)(void);
void FC_GLOBAL(cgerfs,CGERFS)(void);
void FC_GLOBAL(cgerq2,CGERQ2)(void);
void FC_GLOBAL(cgerqf,CGERQF)(void);
void FC_GLOBAL(cgesc2,CGESC2)(void);
void FC_GLOBAL(cgesdd,CGESDD)(void);
void FC_GLOBAL(cgesv,CGESV)(void);
void FC_GLOBAL(cgesvd,CGESVD)(void);
void FC_GLOBAL(cgesvdq,CGESVDQ)(void);
void FC_GLOBAL(cgesvdx,CGESVDX)(void);
void FC_GLOBAL(cgesvj,CGESVJ)(void);
void FC_GLOBAL(cgesvx,CGESVX)(void);
void FC_GLOBAL(cgetc2,CGETC2)(void);
void FC_GLOBAL(cgetf2,CGETF2)(void);
void FC_GLOBAL(cgetrf,CGETRF)(void);
void FC_GLOBAL(cgetrf2,CGETRF2)(void);
void FC_GLOBAL(cgetri,CGETRI)(void);
void FC_GLOBAL(cgetrs,CGETRS)(void);
void FC_GLOBAL(cgetsls,CGETSLS)(void);
void FC_GLOBAL(cgetsqrhrt,CGETSQRHRT)(void);
void FC_GLOBAL(cggbak,CGGBAK)(void);
void FC_GLOBAL(cggbal,CGGBAL)(void);
void FC_GLOBAL(cgges,CGGES)(void);
void FC_GLOBAL(cgges3,CGGES3)(void);
void FC_GLOBAL(cggesx,CGGESX)(void);
void FC_GLOBAL(cggev,CGGEV)(void);
void FC_GLOBAL(cggev3,CGGEV3)(void);
void FC_GLOBAL(cggevx,CGGEVX)(void);
void FC_GLOBAL(cggglm,CGGGLM)(void);
void FC_GLOBAL(cgghd3,CGGHD3)(void);
void FC_GLOBAL(cgghrd,CGGHRD)(void);
void FC_GLOBAL(cgglse,CGGLSE)(void);
void FC_GLOBAL(cggqrf,CGGQRF)(void);
void FC_GLOBAL(cggrqf,CGGRQF)(void);
void FC_GLOBAL(cggsvd3,CGGSVD3)(void);
void FC_GLOBAL(cggsvp3,CGGSVP3)(void);
void FC_GLOBAL(cgsvj0,CGSVJ0)(void);
void FC_GLOBAL(cgsvj1,CGSVJ1)(void);
void FC_GLOBAL(cgtcon,CGTCON)(void);
void FC_GLOBAL(cgtrfs,CGTRFS)(void);
void FC_GLOBAL(cgtsv,CGTSV)(void);
void FC_GLOBAL(cgtsvx,CGTSVX)(void);
void FC_GLOBAL(cgttrf,CGTTRF)(void);
void FC_GLOBAL(cgttrs,CGTTRS)(void);
void FC_GLOBAL(cgtts2,CGTTS2)(void);
void FC_GLOBAL(chb2st_kernels,CHB2ST_KERNELS)(void);
void FC_GLOBAL(chbev,CHBEV)(void);
void FC_GLOBAL(chbev_2stage,CHBEV_2STAGE)(void);
void FC_GLOBAL(chbevd,CHBEVD)(void);
void FC_GLOBAL(chbevd_2stage,CHBEVD_2STAGE)(void);
void FC_GLOBAL(chbevx,CHBEVX)(void);
void FC_GLOBAL(chbevx_2stage,CHBEVX_2STAGE)(void);
void FC_GLOBAL(chbgst,CHBGST)(void);
void FC_GLOBAL(chbgv,CHBGV)(void);
void FC_GLOBAL(chbgvd,CHBGVD)(void);
void FC_GLOBAL(chbgvx,CHBGVX)(void);
void FC_GLOBAL(chbtrd,CHBTRD)(void);
void FC_GLOBAL(checon,CHECON)(void);
void FC_GLOBAL(checon_3,CHECON_3)(void);
void FC_GLOBAL(checon_rook,CHECON_ROOK)(void);
void FC_GLOBAL(cheequb,CHEEQUB)(void);
void FC_GLOBAL(cheev,CHEEV)(void);
void FC_GLOBAL(cheev_2stage,CHEEV_2STAGE)(void);
void FC_GLOBAL(cheevd,CHEEVD)(void);
void FC_GLOBAL(cheevd_2stage,CHEEVD_2STAGE)(void);
void FC_GLOBAL(cheevr,CHEEVR)(void);
void FC_GLOBAL(cheevr_2stage,CHEEVR_2STAGE)(void);
void FC_GLOBAL(cheevx,CHEEVX)(void);
void FC_GLOBAL(cheevx_2stage,CHEEVX_2STAGE)(void);
void FC_GLOBAL(chegs2,CHEGS2)(void);
void FC_GLOBAL(chegst,CHEGST)(void);
void FC_GLOBAL(chegv,CHEGV)(void);
void FC_GLOBAL(chegv_2stage,CHEGV_2STAGE)(void);
void FC_GLOBAL(chegvd,CHEGVD)(void);
void FC_GLOBAL(chegvx,CHEGVX)(void);
void FC_GLOBAL(cherfs,CHERFS)(void);
void FC_GLOBAL(chesv,CHESV)(void);
void FC_GLOBAL(chesv_aa,CHESV_AA)(void);
void FC_GLOBAL(chesv_aa_2stage,CHESV_AA_2STAGE)(void);
void FC_GLOBAL(chesv_rk,CHESV_RK)(void);
void FC_GLOBAL(chesv_rook,CHESV_ROOK)(void);
void FC_GLOBAL(chesvx,CHESVX)(void);
void FC_GLOBAL(cheswapr,CHESWAPR)(void);
void FC_GLOBAL(chetd2,CHETD2)(void);
void FC_GLOBAL(chetf2,CHETF2)(void);
void FC_GLOBAL(chetf2_rk,CHETF2_RK)(void);
void FC_GLOBAL(chetf2_rook,CHETF2_ROOK)(void);
void FC_GLOBAL(chetrd,CHETRD)(void);
void FC_GLOBAL(chetrd_2stage,CHETRD_2STAGE)(void);
void FC_GLOBAL(chetrd_hb2st,CHETRD_HB2ST)(void);
void FC_GLOBAL(chetrd_he2hb,CHETRD_HE2HB)(void);
void FC_GLOBAL(chetrf,CHETRF)(void);
void FC_GLOBAL(chetrf_aa,CHETRF_AA)(void);
void FC_GLOBAL(chetrf_aa_2stage,CHETRF_AA_2STAGE)(void);
void FC_GLOBAL(chetrf_rk,CHETRF_RK)(void);
void FC_GLOBAL(chetrf_rook,CHETRF_ROOK)(void);
void FC_GLOBAL(chetri,CHETRI)(void);
void FC_GLOBAL(chetri2,CHETRI2)(void);
void FC_GLOBAL(chetri2x,CHETRI2X)(void);
void FC_GLOBAL(chetri_3,CHETRI_3)(void);
void FC_GLOBAL(chetri_3x,CHETRI_3X)(void);
void FC_GLOBAL(chetri_rook,CHETRI_ROOK)(void);
void FC_GLOBAL(chetrs,CHETRS)(void);
void FC_GLOBAL(chetrs2,CHETRS2)(void);
void FC_GLOBAL(chetrs_3,CHETRS_3)(void);
void FC_GLOBAL(chetrs_aa,CHETRS_AA)(void);
void FC_GLOBAL(chetrs_aa_2stage,CHETRS_AA_2STAGE)(void);
void FC_GLOBAL(chetrs_rook,CHETRS_ROOK)(void);
void FC_GLOBAL(chfrk,CHFRK)(void);
void FC_GLOBAL(chgeqz,CHGEQZ)(void);
void FC_GLOBAL(chla_transtype,CHLA_TRANSTYPE)(void);
void FC_GLOBAL(chpcon,CHPCON)(void);
void FC_GLOBAL(chpev,CHPEV)(void);
void FC_GLOBAL(chpevd,CHPEVD)(void);
void FC_GLOBAL(chpevx,CHPEVX)(void);
void FC_GLOBAL(chpgst,CHPGST)(void);
void FC_GLOBAL(chpgv,CHPGV)(void);
void FC_GLOBAL(chpgvd,CHPGVD)(void);
void FC_GLOBAL(chpgvx,CHPGVX)(void);
void FC_GLOBAL(chprfs,CHPRFS)(void);
void FC_GLOBAL(chpsv,CHPSV)(void);
void FC_GLOBAL(chpsvx,CHPSVX)(void);
void FC_GLOBAL(chptrd,CHPTRD)(void);
void FC_GLOBAL(chptrf,CHPTRF)(void);
void FC_GLOBAL(chptri,CHPTRI)(void);
void FC_GLOBAL(chptrs,CHPTRS)(void);
void FC_GLOBAL(chsein,CHSEIN)(void);
void FC_GLOBAL(chseqr,CHSEQR)(void);
void FC_GLOBAL(clabrd,CLABRD)(void);
void FC_GLOBAL(clacgv,CLACGV)(void);
void FC_GLOBAL(clacn2,CLACN2)(void);
void FC_GLOBAL(clacon,CLACON)(void);
void FC_GLOBAL(clacp2,CLACP2)(void);
void FC_GLOBAL(clacpy,CLACPY)(void);
void FC_GLOBAL(clacrm,CLACRM)(void);
void FC_GLOBAL(clacrt,CLACRT)(void);
void FC_GLOBAL(cladiv,CLADIV)(void);
void FC_GLOBAL(claed0,CLAED0)(void);
void FC_GLOBAL(claed7,CLAED7)(void);
void FC_GLOBAL(claed8,CLAED8)(void);
void FC_GLOBAL(claein,CLAEIN)(void);
void FC_GLOBAL(claesy,CLAESY)(void);
void FC_GLOBAL(claev2,CLAEV2)(void);
void FC_GLOBAL(clag2z,CLAG2Z)(void);
void FC_GLOBAL(clags2,CLAGS2)(void);
void FC_GLOBAL(clagtm,CLAGTM)(void);
void FC_GLOBAL(clahef,CLAHEF)(void);
void FC_GLOBAL(clahef_aa,CLAHEF_AA)(void);
void FC_GLOBAL(clahef_rk,CLAHEF_RK)(void);
void FC_GLOBAL(clahef_rook,CLAHEF_ROOK)(void);
void FC_GLOBAL(clahqr,CLAHQR)(void);
void FC_GLOBAL(clahr2,CLAHR2)(void);
void FC_GLOBAL(claic1,CLAIC1)(void);
void FC_GLOBAL(clals0,CLALS0)(void);
void FC_GLOBAL(clalsa,CLALSA)(void);
void FC_GLOBAL(clalsd,CLALSD)(void);
void FC_GLOBAL(clamswlq,CLAMSWLQ)(void);
void FC_GLOBAL(clamtsqr,CLAMTSQR)(void);
void FC_GLOBAL(clangb,CLANGB)(void);
void FC_GLOBAL(clange,CLANGE)(void);
void FC_GLOBAL(clangt,CLANGT)(void);
void FC_GLOBAL(clanhb,CLANHB)(void);
void FC_GLOBAL(clanhe,CLANHE)(void);
void FC_GLOBAL(clanhf,CLANHF)(void);
void FC_GLOBAL(clanhp,CLANHP)(void);
void FC_GLOBAL(clanhs,CLANHS)(void);
void FC_GLOBAL(clanht,CLANHT)(void);
void FC_GLOBAL(clansb,CLANSB)(void);
void FC_GLOBAL(clansp,CLANSP)(void);
void FC_GLOBAL(clansy,CLANSY)(void);
void FC_GLOBAL(clantb,CLANTB)(void);
void FC_GLOBAL(clantp,CLANTP)(void);
void FC_GLOBAL(clantr,CLANTR)(void);
void FC_GLOBAL(clapll,CLAPLL)(void);
void FC_GLOBAL(clapmr,CLAPMR)(void);
void FC_GLOBAL(clapmt,CLAPMT)(void);
void FC_GLOBAL(claqgb,CLAQGB)(void);
void FC_GLOBAL(claqge,CLAQGE)(void);
void FC_GLOBAL(claqhb,CLAQHB)(void);
void FC_GLOBAL(claqhe,CLAQHE)(void);
void FC_GLOBAL(claqhp,CLAQHP)(void);
void FC_GLOBAL(claqp2,CLAQP2)(void);
void FC_GLOBAL(claqps,CLAQPS)(void);
void FC_GLOBAL(claqr0,CLAQR0)(void);
void FC_GLOBAL(claqr1,CLAQR1)(void);
void FC_GLOBAL(claqr2,CLAQR2)(void);
void FC_GLOBAL(claqr3,CLAQR3)(void);
void FC_GLOBAL(claqr4,CLAQR4)(void);
void FC_GLOBAL(claqr5,CLAQR5)(void);
void FC_GLOBAL(claqsb,CLAQSB)(void);
void FC_GLOBAL(claqsp,CLAQSP)(void);
void FC_GLOBAL(claqsy,CLAQSY)(void);
void FC_GLOBAL(claqz0,CLAQZ0)(void);
void FC_GLOBAL(claqz1,CLAQZ1)(void);
void FC_GLOBAL(claqz2,CLAQZ2)(void);
void FC_GLOBAL(claqz3,CLAQZ3)(void);
void FC_GLOBAL(clar1v,CLAR1V)(void);
void FC_GLOBAL(clar2v,CLAR2V)(void);
void FC_GLOBAL(clarcm,CLARCM)(void);
void FC_GLOBAL(clarf,CLARF)(void);
void FC_GLOBAL(clarfb,CLARFB)(void);
void FC_GLOBAL(clarfb_gett,CLARFB_GETT)(void);
void FC_GLOBAL(clarfg,CLARFG)(void);
void FC_GLOBAL(clarfgp,CLARFGP)(void);
void FC_GLOBAL(clarft,CLARFT)(void);
void FC_GLOBAL(clarfx,CLARFX)(void);
void FC_GLOBAL(clarfy,CLARFY)(void);
void FC_GLOBAL(clargv,CLARGV)(void);
void FC_GLOBAL(clarnv,CLARNV)(void);
void FC_GLOBAL(clarrv,CLARRV)(void);
void FC_GLOBAL(clartg,CLARTG)(void);
void FC_GLOBAL(clartv,CLARTV)(void);
void FC_GLOBAL(clarz,CLARZ)(void);
void FC_GLOBAL(clarzb,CLARZB)(void);
void FC_GLOBAL(clarzt,CLARZT)(void);
void FC_GLOBAL(clascl,CLASCL)(void);
void FC_GLOBAL(claset,CLASET)(void);
void FC_GLOBAL(clasr,CLASR)(void);
void FC_GLOBAL(classq,CLASSQ)(void);
void FC_GLOBAL(claswlq,CLASWLQ)(void);
void FC_GLOBAL(claswp,CLASWP)(void);
void FC_GLOBAL(clasyf,CLASYF)(void);
void FC_GLOBAL(clasyf_aa,CLASYF_AA)(void);
void FC_GLOBAL(clasyf_rk,CLASYF_RK)(void);
void FC_GLOBAL(clasyf_rook,CLASYF_ROOK)(void);
void FC_GLOBAL(clatbs,CLATBS)(void);
void FC_GLOBAL(clatdf,CLATDF)(void);
void FC_GLOBAL(clatps,CLATPS)(void);
void FC_GLOBAL(clatrd,CLATRD)(void);
void FC_GLOBAL(clatrs,CLATRS)(void);
void FC_GLOBAL(clatrs3,CLATRS3)(void);
void FC_GLOBAL(clatrz,CLATRZ)(void);
void FC_GLOBAL(clatsqr,CLATSQR)(void);
void FC_GLOBAL(claunhr_col_getrfnp,CLAUNHR_COL_GETRFNP)(void);
void FC_GLOBAL(claunhr_col_getrfnp2,CLAUNHR_COL_GETRFNP2)(void);
void FC_GLOBAL(clauu2,CLAUU2)(void);
void FC_GLOBAL(clauum,CLAUUM)(void);
void FC_GLOBAL(cpbcon,CPBCON)(void);
void FC_GLOBAL(cpbequ,CPBEQU)(void);
void FC_GLOBAL(cpbrfs,CPBRFS)(void);
void FC_GLOBAL(cpbstf,CPBSTF)(void);
void FC_GLOBAL(cpbsv,CPBSV)(void);
void FC_GLOBAL(cpbsvx,CPBSVX)(void);
void FC_GLOBAL(cpbtf2,CPBTF2)(void);
void FC_GLOBAL(cpbtrf,CPBTRF)(void);
void FC_GLOBAL(cpbtrs,CPBTRS)(void);
void FC_GLOBAL(cpftrf,CPFTRF)(void);
void FC_GLOBAL(cpftri,CPFTRI)(void);
void FC_GLOBAL(cpftrs,CPFTRS)(void);
void FC_GLOBAL(cpocon,CPOCON)(void);
void FC_GLOBAL(cpoequ,CPOEQU)(void);
void FC_GLOBAL(cpoequb,CPOEQUB)(void);
void FC_GLOBAL(cporfs,CPORFS)(void);
void FC_GLOBAL(cposv,CPOSV)(void);
void FC_GLOBAL(cposvx,CPOSVX)(void);
void FC_GLOBAL(cpotf2,CPOTF2)(void);
void FC_GLOBAL(cpotrf,CPOTRF)(void);
void FC_GLOBAL(cpotrf2,CPOTRF2)(void);
void FC_GLOBAL(cpotri,CPOTRI)(void);
void FC_GLOBAL(cpotrs,CPOTRS)(void);
void FC_GLOBAL(cppcon,CPPCON)(void);
void FC_GLOBAL(cppequ,CPPEQU)(void);
void FC_GLOBAL(cpprfs,CPPRFS)(void);
void FC_GLOBAL(cppsv,CPPSV)(void);
void FC_GLOBAL(cppsvx,CPPSVX)(void);
void FC_GLOBAL(cpptrf,CPPTRF)(void);
void FC_GLOBAL(cpptri,CPPTRI)(void);
void FC_GLOBAL(cpptrs,CPPTRS)(void);
void FC_GLOBAL(cpstf2,CPSTF2)(void);
void FC_GLOBAL(cpstrf,CPSTRF)(void);
void FC_GLOBAL(cptcon,CPTCON)(void);
void FC_GLOBAL(cpteqr,CPTEQR)(void);
void FC_GLOBAL(cptrfs,CPTRFS)(void);
void FC_GLOBAL(cptsv,CPTSV)(void);
void FC_GLOBAL(cptsvx,CPTSVX)(void);
void FC_GLOBAL(cpttrf,CPTTRF)(void);
void FC_GLOBAL(cpttrs,CPTTRS)(void);
void FC_GLOBAL(cptts2,CPTTS2)(void);
void FC_GLOBAL(crot,CROT)(void);
void FC_GLOBAL(cspcon,CSPCON)(void);
void FC_GLOBAL(cspmv,CSPMV)(void);
void FC_GLOBAL(cspr,CSPR)(void);
void FC_GLOBAL(csprfs,CSPRFS)(void);
void FC_GLOBAL(cspsv,CSPSV)(void);
void FC_GLOBAL(cspsvx,CSPSVX)(void);
void FC_GLOBAL(csptrf,CSPTRF)(void);
void FC_GLOBAL(csptri,CSPTRI)(void);
void FC_GLOBAL(csptrs,CSPTRS)(void);
void FC_GLOBAL(csrscl,CSRSCL)(void);
void FC_GLOBAL(cstedc,CSTEDC)(void);
void FC_GLOBAL(cstegr,CSTEGR)(void);
void FC_GLOBAL(cstein,CSTEIN)(void);
void FC_GLOBAL(cstemr,CSTEMR)(void);
void FC_GLOBAL(csteqr,CSTEQR)(void);
void FC_GLOBAL(csycon,CSYCON)(void);
void FC_GLOBAL(csycon_3,CSYCON_3)(void);
void FC_GLOBAL(csycon_rook,CSYCON_ROOK)(void);
void FC_GLOBAL(csyconv,CSYCONV)(void);
void FC_GLOBAL(csyconvf,CSYCONVF)(void);
void FC_GLOBAL(csyconvf_rook,CSYCONVF_ROOK)(void);
void FC_GLOBAL(csyequb,CSYEQUB)(void);
void FC_GLOBAL(csymv,CSYMV)(void);
void FC_GLOBAL(csyr,CSYR)(void);
void FC_GLOBAL(csyrfs,CSYRFS)(void);
void FC_GLOBAL(csysv,CSYSV)(void);
void FC_GLOBAL(csysv_aa,CSYSV_AA)(void);
void FC_GLOBAL(csysv_aa_2stage,CSYSV_AA_2STAGE)(void);
void FC_GLOBAL(csysv_rk,CSYSV_RK)(void);
void FC_GLOBAL(csysv_rook,CSYSV_ROOK)(void);
void FC_GLOBAL(csysvx,CSYSVX)(void);
void FC_GLOBAL(csyswapr,CSYSWAPR)(void);
void FC_GLOBAL(csytf2,CSYTF2)(void);
void FC_GLOBAL(csytf2_rk,CSYTF2_RK)(void);
void FC_GLOBAL(csytf2_rook,CSYTF2_ROOK)(void);
void FC_GLOBAL(csytrf,CSYTRF)(void);
void FC_GLOBAL(csytrf_aa,CSYTRF_AA)(void);
void FC_GLOBAL(csytrf_aa_2stage,CSYTRF_AA_2STAGE)(void);
void FC_GLOBAL(csytrf_rk,CSYTRF_RK)(void);
void FC_GLOBAL(csytrf_rook,CSYTRF_ROOK)(void);
void FC_GLOBAL(csytri,CSYTRI)(void);
void FC_GLOBAL(csytri2,CSYTRI2)(void);
void FC_GLOBAL(csytri2x,CSYTRI2X)(void);
void FC_GLOBAL(csytri_3,CSYTRI_3)(void);
void FC_GLOBAL(csytri_3x,CSYTRI_3X)(void);
void FC_GLOBAL(csytri_rook,CSYTRI_ROOK)(void);
void FC_GLOBAL(csytrs,CSYTRS)(void);
void FC_GLOBAL(csytrs2,CSYTRS2)(void);
void FC_GLOBAL(csytrs_3,CSYTRS_3)(void);
void FC_GLOBAL(csytrs_aa,CSYTRS_AA)(void);
void FC_GLOBAL(csytrs_aa_2stage,CSYTRS_AA_2STAGE)(void);
void FC_GLOBAL(csytrs_rook,CSYTRS_ROOK)(void);
void FC_GLOBAL(ctbcon,CTBCON)(void);
void FC_GLOBAL(ctbrfs,CTBRFS)(void);
void FC_GLOBAL(ctbtrs,CTBTRS)(void);
void FC_GLOBAL(ctfsm,CTFSM)(void);
void FC_GLOBAL(ctftri,CTFTRI)(void);
void FC_GLOBAL(ctfttp,CTFTTP)(void);
void FC_GLOBAL(ctfttr,CTFTTR)(void);
void FC_GLOBAL(ctgevc,CTGEVC)(void);
void FC_GLOBAL(ctgex2,CTGEX2)(void);
void FC_GLOBAL(ctgexc,CTGEXC)(void);
void FC_GLOBAL(ctgsen,CTGSEN)(void);
void FC_GLOBAL(ctgsja,CTGSJA)(void);
void FC_GLOBAL(ctgsna,CTGSNA)(void);
void FC_GLOBAL(ctgsy2,CTGSY2)(void);
void FC_GLOBAL(ctgsyl,CTGSYL)(void);
void FC_GLOBAL(ctpcon,CTPCON)(void);
void FC_GLOBAL(ctplqt,CTPLQT)(void);
void FC_GLOBAL(ctplqt2,CTPLQT2)(void);
void FC_GLOBAL(ctpmlqt,CTPMLQT)(void);
void FC_GLOBAL(ctpmqrt,CTPMQRT)(void);
void FC_GLOBAL(ctpqrt,CTPQRT)(void);
void FC_GLOBAL(ctpqrt2,CTPQRT2)(void);
void FC_GLOBAL(ctprfb,CTPRFB)(void);
void FC_GLOBAL(ctprfs,CTPRFS)(void);
void FC_GLOBAL(ctptri,CTPTRI)(void);
void FC_GLOBAL(ctptrs,CTPTRS)(void);
void FC_GLOBAL(ctpttf,CTPTTF)(void);
void FC_GLOBAL(ctpttr,CTPTTR)(void);
void FC_GLOBAL(ctrcon,CTRCON)(void);
void FC_GLOBAL(ctrevc,CTREVC)(void);
void FC_GLOBAL(ctrevc3,CTREVC3)(void);
void FC_GLOBAL(ctrexc,CTREXC)(void);
void FC_GLOBAL(ctrrfs,CTRRFS)(void);
void FC_GLOBAL(ctrsen,CTRSEN)(void);
void FC_GLOBAL(ctrsna,CTRSNA)(void);
void FC_GLOBAL(ctrsyl,CTRSYL)(void);
void FC_GLOBAL(ctrsyl3,CTRSYL3)(void);
void FC_GLOBAL(ctrti2,CTRTI2)(void);
void FC_GLOBAL(ctrtri,CTRTRI)(void);
void FC_GLOBAL(ctrtrs,CTRTRS)(void);
void FC_GLOBAL(ctrttf,CTRTTF)(void);
void FC_GLOBAL(ctrttp,CTRTTP)(void);
void FC_GLOBAL(ctzrzf,CTZRZF)(void);
void FC_GLOBAL(cunbdb,CUNBDB)(void);
void FC_GLOBAL(cunbdb1,CUNBDB1)(void);
void FC_GLOBAL(cunbdb2,CUNBDB2)(void);
void FC_GLOBAL(cunbdb3,CUNBDB3)(void);
void FC_GLOBAL(cunbdb4,CUNBDB4)(void);
void FC_GLOBAL(cunbdb5,CUNBDB5)(void);
void FC_GLOBAL(cunbdb6,CUNBDB6)(void);
void FC_GLOBAL(cuncsd,CUNCSD)(void);
void FC_GLOBAL(cuncsd2by1,CUNCSD2BY1)(void);
void FC_GLOBAL(cung2l,CUNG2L)(void);
void FC_GLOBAL(cung2r,CUNG2R)(void);
void FC_GLOBAL(cungbr,CUNGBR)(void);
void FC_GLOBAL(cunghr,CUNGHR)(void);
void FC_GLOBAL(cungl2,CUNGL2)(void);
void FC_GLOBAL(cunglq,CUNGLQ)(void);
void FC_GLOBAL(cungql,CUNGQL)(void);
void FC_GLOBAL(cungqr,CUNGQR)(void);
void FC_GLOBAL(cungr2,CUNGR2)(void);
void FC_GLOBAL(cungrq,CUNGRQ)(void);
void FC_GLOBAL(cungtr,CUNGTR)(void);
void FC_GLOBAL(cungtsqr,CUNGTSQR)(void);
void FC_GLOBAL(cungtsqr_row,CUNGTSQR_ROW)(void);
void FC_GLOBAL(cunhr_col,CUNHR_COL)(void);
void FC_GLOBAL(cunm22,CUNM22)(void);
void FC_GLOBAL(cunm2l,CUNM2L)(void);
void FC_GLOBAL(cunm2r,CUNM2R)(void);
void FC_GLOBAL(cunmbr,CUNMBR)(void);
void FC_GLOBAL(cunmhr,CUNMHR)(void);
void FC_GLOBAL(cunml2,CUNML2)(void);
void FC_GLOBAL(cunmlq,CUNMLQ)(void);
void FC_GLOBAL(cunmql,CUNMQL)(void);
void FC_GLOBAL(cunmqr,CUNMQR)(void);
void FC_GLOBAL(cunmr2,CUNMR2)(void);
void FC_GLOBAL(cunmr3,CUNMR3)(void);
void FC_GLOBAL(cunmrq,CUNMRQ)(void);
void FC_GLOBAL(cunmrz,CUNMRZ)(void);
void FC_GLOBAL(cunmtr,CUNMTR)(void);
void FC_GLOBAL(cupgtr,CUPGTR)(void);
void FC_GLOBAL(cupmtr,CUPMTR)(void);
void FC_GLOBAL(dbbcsd,DBBCSD)(void);
void FC_GLOBAL(dbdsdc,DBDSDC)(void);
void FC_GLOBAL(dbdsqr,DBDSQR)(void);
void FC_GLOBAL(dbdsvdx,DBDSVDX)(void);
void FC_GLOBAL(ddisna,DDISNA)(void);
void FC_GLOBAL(dgbbrd,DGBBRD)(void);
void FC_GLOBAL(dgbcon,DGBCON)(void);
void FC_GLOBAL(dgbequ,DGBEQU)(void);
void FC_GLOBAL(dgbequb,DGBEQUB)(void);
void FC_GLOBAL(dgbrfs,DGBRFS)(void);
void FC_GLOBAL(dgbsv,DGBSV)(void);
void FC_GLOBAL(dgbsvx,DGBSVX)(void);
void FC_GLOBAL(dgbtf2,DGBTF2)(void);
void FC_GLOBAL(dgbtrf,DGBTRF)(void);
void FC_GLOBAL(dgbtrs,DGBTRS)(void);
void FC_GLOBAL(dgebak,DGEBAK)(void);
void FC_GLOBAL(dgebal,DGEBAL)(void);
void FC_GLOBAL(dgebd2,DGEBD2)(void);
void FC_GLOBAL(dgebrd,DGEBRD)(void);
void FC_GLOBAL(dgecon,DGECON)(void);
void FC_GLOBAL(dgeequ,DGEEQU)(void);
void FC_GLOBAL(dgeequb,DGEEQUB)(void);
void FC_GLOBAL(dgees,DGEES)(void);
void FC_GLOBAL(dgeesx,DGEESX)(void);
void FC_GLOBAL(dgeev,DGEEV)(void);
void FC_GLOBAL(dgeevx,DGEEVX)(void);
void FC_GLOBAL(dgehd2,DGEHD2)(void);
void FC_GLOBAL(dgehrd,DGEHRD)(void);
void FC_GLOBAL(dgejsv,DGEJSV)(void);
void FC_GLOBAL(dgelq,DGELQ)(void);
void FC_GLOBAL(dgelq2,DGELQ2)(void);
void FC_GLOBAL(dgelqf,DGELQF)(void);
void FC_GLOBAL(dgelqt,DGELQT)(void);
void FC_GLOBAL(dgelqt3,DGELQT3)(void);
void FC_GLOBAL(dgels,DGELS)(void);
void FC_GLOBAL(dgelsd,DGELSD)(void);
void FC_GLOBAL(dgelss,DGELSS)(void);
void FC_GLOBAL(dgelst,DGELST)(void);
void FC_GLOBAL(dgelsy,DGELSY)(void);
void FC_GLOBAL(dgemlq,DGEMLQ)(void);
void FC_GLOBAL(dgemlqt,DGEMLQT)(void);
void FC_GLOBAL(dgemqr,DGEMQR)(void);
void FC_GLOBAL(dgemqrt,DGEMQRT)(void);
void FC_GLOBAL(dgeql2,DGEQL2)(void);
void FC_GLOBAL(dgeqlf,DGEQLF)(void);
void FC_GLOBAL(dgeqp3,DGEQP3)(void);
void FC_GLOBAL(dgeqr,DGEQR)(void);
void FC_GLOBAL(dgeqr2,DGEQR2)(void);
void FC_GLOBAL(dgeqr2p,DGEQR2P)(void);
void FC_GLOBAL(dgeqrf,DGEQRF)(void);
void FC_GLOBAL(dgeqrfp,DGEQRFP)(void);
void FC_GLOBAL(dgeqrt,DGEQRT)(void);
void FC_GLOBAL(dgeqrt2,DGEQRT2)(void);
void FC_GLOBAL(dgeqrt3,DGEQRT3)(void);
void FC_GLOBAL(dgerfs,DGERFS)(void);
void FC_GLOBAL(dgerq2,DGERQ2)(void);
void FC_GLOBAL(dgerqf,DGERQF)(void);
void FC_GLOBAL(dgesc2,DGESC2)(void);
void FC_GLOBAL(dgesdd,DGESDD)(void);
void FC_GLOBAL(dgesv,DGESV)(void);
void FC_GLOBAL(dgesvd,DGESVD)(void);
void FC_GLOBAL(dgesvdq,DGESVDQ)(void);
void FC_GLOBAL(dgesvdx,DGESVDX)(void);
void FC_GLOBAL(dgesvj,DGESVJ)(void);
void FC_GLOBAL(dgesvx,DGESVX)(void);
void FC_GLOBAL(dgetc2,DGETC2)(void);
void FC_GLOBAL(dgetf2,DGETF2)(void);
void FC_GLOBAL(dgetrf,DGETRF)(void);
void FC_GLOBAL(dgetrf2,DGETRF2)(void);
void FC_GLOBAL(dgetri,DGETRI)(void);
void FC_GLOBAL(dgetrs,DGETRS)(void);
void FC_GLOBAL(dgetsls,DGETSLS)(void);
void FC_GLOBAL(dgetsqrhrt,DGETSQRHRT)(void);
void FC_GLOBAL(dggbak,DGGBAK)(void);
void FC_GLOBAL(dggbal,DGGBAL)(void);
void FC_GLOBAL(dgges,DGGES)(void);
void FC_GLOBAL(dgges3,DGGES3)(void);
void FC_GLOBAL(dggesx,DGGESX)(void);
void FC_GLOBAL(dggev,DGGEV)(void);
void FC_GLOBAL(dggev3,DGGEV3)(void);
void FC_GLOBAL(dggevx,DGGEVX)(void);
void FC_GLOBAL(dggglm,DGGGLM)(void);
void FC_GLOBAL(dgghd3,DGGHD3)(void);
void FC_GLOBAL(dgghrd,DGGHRD)(void);
void FC_GLOBAL(dgglse,DGGLSE)(void);
void FC_GLOBAL(dggqrf,DGGQRF)(void);
void FC_GLOBAL(dggrqf,DGGRQF)(void);
void FC_GLOBAL(dggsvd3,DGGSVD3)(void);
void FC_GLOBAL(dggsvp3,DGGSVP3)(void);
void FC_GLOBAL(dgsvj0,DGSVJ0)(void);
void FC_GLOBAL(dgsvj1,DGSVJ1)(void);
void FC_GLOBAL(dgtcon,DGTCON)(void);
void FC_GLOBAL(dgtrfs,DGTRFS)(void);
void FC_GLOBAL(dgtsv,DGTSV)(void);
void FC_GLOBAL(dgtsvx,DGTSVX)(void);
void FC_GLOBAL(dgttrf,DGTTRF)(void);
void FC_GLOBAL(dgttrs,DGTTRS)(void);
void FC_GLOBAL(dgtts2,DGTTS2)(void);
void FC_GLOBAL(dhgeqz,DHGEQZ)(void);
void FC_GLOBAL(dhsein,DHSEIN)(void);
void FC_GLOBAL(dhseqr,DHSEQR)(void);
void FC_GLOBAL(disnan,DISNAN)(void);
void FC_GLOBAL(dlabad,DLABAD)(void);
void FC_GLOBAL(dlabrd,DLABRD)(void);
void FC_GLOBAL(dlacn2,DLACN2)(void);
void FC_GLOBAL(dlacon,DLACON)(void);
void FC_GLOBAL(dlacpy,DLACPY)(void);
void FC_GLOBAL(dladiv,DLADIV)(void);
void FC_GLOBAL(dladiv1,DLADIV1)(void);
void FC_GLOBAL(dladiv2,DLADIV2)(void);
void FC_GLOBAL(dlae2,DLAE2)(void);
void FC_GLOBAL(dlaebz,DLAEBZ)(void);
void FC_GLOBAL(dlaed0,DLAED0)(void);
void FC_GLOBAL(dlaed1,DLAED1)(void);
void FC_GLOBAL(dlaed2,DLAED2)(void);
void FC_GLOBAL(dlaed3,DLAED3)(void);
void FC_GLOBAL(dlaed4,DLAED4)(void);
void FC_GLOBAL(dlaed5,DLAED5)(void);
void FC_GLOBAL(dlaed6,DLAED6)(void);
void FC_GLOBAL(dlaed7,DLAED7)(void);
void FC_GLOBAL(dlaed8,DLAED8)(void);
void FC_GLOBAL(dlaed9,DLAED9)(void);
void FC_GLOBAL(dlaeda,DLAEDA)(void);
void FC_GLOBAL(dlaein,DLAEIN)(void);
void FC_GLOBAL(dlaev2,DLAEV2)(void);
void FC_GLOBAL(dlaexc,DLAEXC)(void);
void FC_GLOBAL(dlag2,DLAG2)(void);
void FC_GLOBAL(dlag2s,DLAG2S)(void);
void FC_GLOBAL(dlags2,DLAGS2)(void);
void FC_GLOBAL(dlagtf,DLAGTF)(void);
void FC_GLOBAL(dlagtm,DLAGTM)(void);
void FC_GLOBAL(dlagts,DLAGTS)(void);
void FC_GLOBAL(dlagv2,DLAGV2)(void);
void FC_GLOBAL(dlahqr,DLAHQR)(void);
void FC_GLOBAL(dlahr2,DLAHR2)(void);
void FC_GLOBAL(dlaic1,DLAIC1)(void);
void FC_GLOBAL(dlaisnan,DLAISNAN)(void);
void FC_GLOBAL(dlaln2,DLALN2)(void);
void FC_GLOBAL(dlals0,DLALS0)(void);
void FC_GLOBAL(dlalsa,DLALSA)(void);
void FC_GLOBAL(dlalsd,DLALSD)(void);
void FC_GLOBAL(dlamc3,DLAMC3)(void);
void FC_GLOBAL(dlamch,DLAMCH)(void);
void FC_GLOBAL(dlamrg,DLAMRG)(void);
void FC_GLOBAL(dlamswlq,DLAMSWLQ)(void);
void FC_GLOBAL(dlamtsqr,DLAMTSQR)(void);
void FC_GLOBAL(dlaneg,DLANEG)(void);
void FC_GLOBAL(dlangb,DLANGB)(void);
void FC_GLOBAL(dlange,DLANGE)(void);
void FC_GLOBAL(dlangt,DLANGT)(void);
void FC_GLOBAL(dlanhs,DLANHS)(void);
void FC_GLOBAL(dlansb,DLANSB)(void);
void FC_GLOBAL(dlansf,DLANSF)(void);
void FC_GLOBAL(dlansp,DLANSP)(void);
void FC_GLOBAL(dlanst,DLANST)(void);
void FC_GLOBAL(dlansy,DLANSY)(void);
void FC_GLOBAL(dlantb,DLANTB)(void);
void FC_GLOBAL(dlantp,DLANTP)(void);
void FC_GLOBAL(dlantr,DLANTR)(void);
void FC_GLOBAL(dlanv2,DLANV2)(void);
void FC_GLOBAL(dlaorhr_col_getrfnp,DLAORHR_COL_GETRFNP)(void);
void FC_GLOBAL(dlaorhr_col_getrfnp2,DLAORHR_COL_GETRFNP2)(void);
void FC_GLOBAL(dlapll,DLAPLL)(void);
void FC_GLOBAL(dlapmr,DLAPMR)(void);
void FC_GLOBAL(dlapmt,DLAPMT)(void);
void FC_GLOBAL(dlapy2,DLAPY2)(void);
void FC_GLOBAL(dlapy3,DLAPY3)(void);
void FC_GLOBAL(dlaqgb,DLAQGB)(void);
void FC_GLOBAL(dlaqge,DLAQGE)(void);
void FC_GLOBAL(dlaqp2,DLAQP2)(void);
void FC_GLOBAL(dlaqps,DLAQPS)(void);
void FC_GLOBAL(dlaqr0,DLAQR0)(void);
void FC_GLOBAL(dlaqr1,DLAQR1)(void);
void FC_GLOBAL(dlaqr2,DLAQR2)(void);
void FC_GLOBAL(dlaqr3,DLAQR3)(void);
void FC_GLOBAL(dlaqr4,DLAQR4)(void);
void FC_GLOBAL(dlaqr5,DLAQR5)(void);
void FC_GLOBAL(dlaqsb,DLAQSB)(void);
void FC_GLOBAL(dlaqsp,DLAQSP)(void);
void FC_GLOBAL(dlaqsy,DLAQSY)(void);
void FC_GLOBAL(dlaqtr,DLAQTR)(void);
void FC_GLOBAL(dlaqz0,DLAQZ0)(void);
void FC_GLOBAL(dlaqz1,DLAQZ1)(void);
void FC_GLOBAL(dlaqz2,DLAQZ2)(void);
void FC_GLOBAL(dlaqz3,DLAQZ3)(void);
void FC_GLOBAL(dlaqz4,DLAQZ4)(void);
void FC_GLOBAL(dlar1v,DLAR1V)(void);
void FC_GLOBAL(dlar2v,DLAR2V)(void);
void FC_GLOBAL(dlarf,DLARF)(void);
void FC_GLOBAL(dlarfb,DLARFB)(void);
void FC_GLOBAL(dlarfb_gett,DLARFB_GETT)(void);
void FC_GLOBAL(dlarfg,DLARFG)(void);
void FC_GLOBAL(dlarfgp,DLARFGP)(void);
void FC_GLOBAL(dlarft,DLARFT)(void);
void FC_GLOBAL(dlarfx,DLARFX)(void);
void FC_GLOBAL(dlarfy,DLARFY)(void);
void FC_GLOBAL(dlargv,DLARGV)(void);
void FC_GLOBAL(dlarmm,DLARMM)(void);
void FC_GLOBAL(dlarnv,DLARNV)(void);
void FC_GLOBAL(dlarra,DLARRA)(void);
void FC_GLOBAL(dlarrb,DLARRB)(void);
void FC_GLOBAL(dlarrc,DLARRC)(void);
void FC_GLOBAL(dlarrd,DLARRD)(void);
void FC_GLOBAL(dlarre,DLARRE)(void);
void FC_GLOBAL(dlarrf,DLARRF)(void);
void FC_GLOBAL(dlarrj,DLARRJ)(void);
void FC_GLOBAL(dlarrk,DLARRK)(void);
void FC_GLOBAL(dlarrr,DLARRR)(void);
void FC_GLOBAL(dlarrv,DLARRV)(void);
void FC_GLOBAL(dlartg,DLARTG)(void);
void FC_GLOBAL(dlartgp,DLARTGP)(void);
void FC_GLOBAL(dlartgs,DLARTGS)(void);
void FC_GLOBAL(dlartv,DLARTV)(void);
void FC_GLOBAL(dlaruv,DLARUV)(void);
void FC_GLOBAL(dlarz,DLARZ)(void);
void FC_GLOBAL(dlarzb,DLARZB)(void);
void FC_GLOBAL(dlarzt,DLARZT)(void);
void FC_GLOBAL(dlas2,DLAS2)(void);
void FC_GLOBAL(dlascl,DLASCL)(void);
void FC_GLOBAL(dlasd0,DLASD0)(void);
void FC_GLOBAL(dlasd1,DLASD1)(void);
void FC_GLOBAL(dlasd2,DLASD2)(void);
void FC_GLOBAL(dlasd3,DLASD3)(void);
void FC_GLOBAL(dlasd4,DLASD4)(void);
void FC_GLOBAL(dlasd5,DLASD5)(void);
void FC_GLOBAL(dlasd6,DLASD6)(void);
void FC_GLOBAL(dlasd7,DLASD7)(void);
void FC_GLOBAL(dlasd8,DLASD8)(void);
void FC_GLOBAL(dlasda,DLASDA)(void);
void FC_GLOBAL(dlasdq,DLASDQ)(void);
void FC_GLOBAL(dlasdt,DLASDT)(void);
void FC_GLOBAL(dlaset,DLASET)(void);
void FC_GLOBAL(dlasq1,DLASQ1)(void);
void FC_GLOBAL(dlasq2,DLASQ2)(void);
void FC_GLOBAL(dlasq3,DLASQ3)(void);
void FC_GLOBAL(dlasq4,DLASQ4)(void);
void FC_GLOBAL(dlasq5,DLASQ5)(void);
void FC_GLOBAL(dlasq6,DLASQ6)(void);
void FC_GLOBAL(dlasr,DLASR)(void);
void FC_GLOBAL(dlasrt,DLASRT)(void);
void FC_GLOBAL(dlassq,DLASSQ)(void);
void FC_GLOBAL(dlasv2,DLASV2)(void);
void FC_GLOBAL(dlaswlq,DLASWLQ)(void);
void FC_GLOBAL(dlaswp,DLASWP)(void);
void FC_GLOBAL(dlasy2,DLASY2)(void);
void FC_GLOBAL(dlasyf,DLASYF)(void);
void FC_GLOBAL(dlasyf_aa,DLASYF_AA)(void);
void FC_GLOBAL(dlasyf_rk,DLASYF_RK)(void);
void FC_GLOBAL(dlasyf_rook,DLASYF_ROOK)(void);
void FC_GLOBAL(dlat2s,DLAT2S)(void);
void FC_GLOBAL(dlatbs,DLATBS)(void);
void FC_GLOBAL(dlatdf,DLATDF)(void);
void FC_GLOBAL(dlatps,DLATPS)(void);
void FC_GLOBAL(dlatrd,DLATRD)(void);
void FC_GLOBAL(dlatrs,DLATRS)(void);
void FC_GLOBAL(dlatrs3,DLATRS3)(void);
void FC_GLOBAL(dlatrz,DLATRZ)(void);
void FC_GLOBAL(dlatsqr,DLATSQR)(void);
void FC_GLOBAL(dlauu2,DLAUU2)(void);
void FC_GLOBAL(dlauum,DLAUUM)(void);
void FC_GLOBAL(dopgtr,DOPGTR)(void);
void FC_GLOBAL(dopmtr,DOPMTR)(void);
void FC_GLOBAL(dorbdb,DORBDB)(void);
void FC_GLOBAL(dorbdb1,DORBDB1)(void);
void FC_GLOBAL(dorbdb2,DORBDB2)(void);
void FC_GLOBAL(dorbdb3,DORBDB3)(void);
void FC_GLOBAL(dorbdb4,DORBDB4)(void);
void FC_GLOBAL(dorbdb5,DORBDB5)(void);
void FC_GLOBAL(dorbdb6,DORBDB6)(void);
void FC_GLOBAL(dorcsd,DORCSD)(void);
void FC_GLOBAL(dorcsd2by1,DORCSD2BY1)(void);
void FC_GLOBAL(dorg2l,DORG2L)(void);
void FC_GLOBAL(dorg2r,DORG2R)(void);
void FC_GLOBAL(dorgbr,DORGBR)(void);
void FC_GLOBAL(dorghr,DORGHR)(void);
void FC_GLOBAL(dorgl2,DORGL2)(void);
void FC_GLOBAL(dorglq,DORGLQ)(void);
void FC_GLOBAL(dorgql,DORGQL)(void);
void FC_GLOBAL(dorgqr,DORGQR)(void);
void FC_GLOBAL(dorgr2,DORGR2)(void);
void FC_GLOBAL(dorgrq,DORGRQ)(void);
void FC_GLOBAL(dorgtr,DORGTR)(void);
void FC_GLOBAL(dorgtsqr,DORGTSQR)(void);
void FC_GLOBAL(dorgtsqr_row,DORGTSQR_ROW)(void);
void FC_GLOBAL(dorhr_col,DORHR_COL)(void);
void FC_GLOBAL(dorm22,DORM22)(void);
void FC_GLOBAL(dorm2l,DORM2L)(void);
void FC_GLOBAL(dorm2r,DORM2R)(void);
void FC_GLOBAL(dormbr,DORMBR)(void);
void FC_GLOBAL(dormhr,DORMHR)(void);
void FC_GLOBAL(dorml2,DORML2)(void);
void FC_GLOBAL(dormlq,DORMLQ)(void);
void FC_GLOBAL(dormql,DORMQL)(void);
void FC_GLOBAL(dormqr,DORMQR)(void);
void FC_GLOBAL(dormr2,DORMR2)(void);
void FC_GLOBAL(dormr3,DORMR3)(void);
void FC_GLOBAL(dormrq,DORMRQ)(void);
void FC_GLOBAL(dormrz,DORMRZ)(void);
void FC_GLOBAL(dormtr,DORMTR)(void);
void FC_GLOBAL(dpbcon,DPBCON)(void);
void FC_GLOBAL(dpbequ,DPBEQU)(void);
void FC_GLOBAL(dpbrfs,DPBRFS)(void);
void FC_GLOBAL(dpbstf,DPBSTF)(void);
void FC_GLOBAL(dpbsv,DPBSV)(void);
void FC_GLOBAL(dpbsvx,DPBSVX)(void);
void FC_GLOBAL(dpbtf2,DPBTF2)(void);
void FC_GLOBAL(dpbtrf,DPBTRF)(void);
void FC_GLOBAL(dpbtrs,DPBTRS)(void);
void FC_GLOBAL(dpftrf,DPFTRF)(void);
void FC_GLOBAL(dpftri,DPFTRI)(void);
void FC_GLOBAL(dpftrs,DPFTRS)(void);
void FC_GLOBAL(dpocon,DPOCON)(void);
void FC_GLOBAL(dpoequ,DPOEQU)(void);
void FC_GLOBAL(dpoequb,DPOEQUB)(void);
void FC_GLOBAL(dporfs,DPORFS)(void);
void FC_GLOBAL(dposv,DPOSV)(void);
void FC_GLOBAL(dposvx,DPOSVX)(void);
void FC_GLOBAL(dpotf2,DPOTF2)(void);
void FC_GLOBAL(dpotrf,DPOTRF)(void);
void FC_GLOBAL(dpotrf2,DPOTRF2)(void);
void FC_GLOBAL(dpotri,DPOTRI)(void);
void FC_GLOBAL(dpotrs,DPOTRS)(void);
void FC_GLOBAL(dppcon,DPPCON)(void);
void FC_GLOBAL(dppequ,DPPEQU)(void);
void FC_GLOBAL(dpprfs,DPPRFS)(void);
void FC_GLOBAL(dppsv,DPPSV)(void);
void FC_GLOBAL(dppsvx,DPPSVX)(void);
void FC_GLOBAL(dpptrf,DPPTRF)(void);
void FC_GLOBAL(dpptri,DPPTRI)(void);
void FC_GLOBAL(dpptrs,DPPTRS)(void);
void FC_GLOBAL(dpstf2,DPSTF2)(void);
void FC_GLOBAL(dpstrf,DPSTRF)(void);
void FC_GLOBAL(dptcon,DPTCON)(void);
void FC_GLOBAL(dpteqr,DPTEQR)(void);
void FC_GLOBAL(dptrfs,DPTRFS)(void);
void FC_GLOBAL(dptsv,DPTSV)(void);
void FC_GLOBAL(dptsvx,DPTSVX)(void);
void FC_GLOBAL(dpttrf,DPTTRF)(void);
void FC_GLOBAL(dpttrs,DPTTRS)(void);
void FC_GLOBAL(dptts2,DPTTS2)(void);
void FC_GLOBAL(droundup_lwork,DROUNDUP_LWORK)(void);
void FC_GLOBAL(drscl,DRSCL)(void);
void FC_GLOBAL(dsb2st_kernels,DSB2ST_KERNELS)(void);
void FC_GLOBAL(dsbev,DSBEV)(void);
void FC_GLOBAL(dsbev_2stage,DSBEV_2STAGE)(void);
void FC_GLOBAL(dsbevd,DSBEVD)(void);
void FC_GLOBAL(dsbevd_2stage,DSBEVD_2STAGE)(void);
void FC_GLOBAL(dsbevx,DSBEVX)(void);
void FC_GLOBAL(dsbevx_2stage,DSBEVX_2STAGE)(void);
void FC_GLOBAL(dsbgst,DSBGST)(void);
void FC_GLOBAL(dsbgv,DSBGV)(void);
void FC_GLOBAL(dsbgvd,DSBGVD)(void);
void FC_GLOBAL(dsbgvx,DSBGVX)(void);
void FC_GLOBAL(dsbtrd,DSBTRD)(void);
void FC_GLOBAL(dsecnd,DSECND)(void);
void FC_GLOBAL(dsfrk,DSFRK)(void);
void FC_GLOBAL(dsgesv,DSGESV)(void);
void FC_GLOBAL(dspcon,DSPCON)(void);
void FC_GLOBAL(dspev,DSPEV)(void);
void FC_GLOBAL(dspevd,DSPEVD)(void);
void FC_GLOBAL(dspevx,DSPEVX)(void);
void FC_GLOBAL(dspgst,DSPGST)(void);
void FC_GLOBAL(dspgv,DSPGV)(void);
void FC_GLOBAL(dspgvd,DSPGVD)(void);
void FC_GLOBAL(dspgvx,DSPGVX)(void);
void FC_GLOBAL(dsposv,DSPOSV)(void);
void FC_GLOBAL(dsprfs,DSPRFS)(void);
void FC_GLOBAL(dspsv,DSPSV)(void);
void FC_GLOBAL(dspsvx,DSPSVX)(void);
void FC_GLOBAL(dsptrd,DSPTRD)(void);
void FC_GLOBAL(dsptrf,DSPTRF)(void);
void FC_GLOBAL(dsptri,DSPTRI)(void);
void FC_GLOBAL(dsptrs,DSPTRS)(void);
void FC_GLOBAL(dstebz,DSTEBZ)(void);
void FC_GLOBAL(dstedc,DSTEDC)(void);
void FC_GLOBAL(dstegr,DSTEGR)(void);
void FC_GLOBAL(dstein,DSTEIN)(void);
void FC_GLOBAL(dstemr,DSTEMR)(void);
void FC_GLOBAL(dsteqr,DSTEQR)(void);
void FC_GLOBAL(dsterf,DSTERF)(void);
void FC_GLOBAL(dstev,DSTEV)(void);
void FC_GLOBAL(dstevd,DSTEVD)(void);
void FC_GLOBAL(dstevr,DSTEVR)(void);
void FC_GLOBAL(dstevx,DSTEVX)(void);
void FC_GLOBAL(dsycon,DSYCON)(void);
void FC_GLOBAL(dsycon_3,DSYCON_3)(void);
void FC_GLOBAL(dsycon_rook,DSYCON_ROOK)(void);
void FC_GLOBAL(dsyconv,DSYCONV)(void);
void FC_GLOBAL(dsyconvf,DSYCONVF)(void);
void FC_GLOBAL(dsyconvf_rook,DSYCONVF_ROOK)(void);
void FC_GLOBAL(dsyequb,DSYEQUB)(void);
void FC_GLOBAL(dsyev,DSYEV)(void);
void FC_GLOBAL(dsyev_2stage,DSYEV_2STAGE)(void);
void FC_GLOBAL(dsyevd,DSYEVD)(void);
void FC_GLOBAL(dsyevd_2stage,DSYEVD_2STAGE)(void);
void FC_GLOBAL(dsyevr,DSYEVR)(void);
void FC_GLOBAL(dsyevr_2stage,DSYEVR_2STAGE)(void);
void FC_GLOBAL(dsyevx,DSYEVX)(void);
void FC_GLOBAL(dsyevx_2stage,DSYEVX_2STAGE)(void);
void FC_GLOBAL(dsygs2,DSYGS2)(void);
void FC_GLOBAL(dsygst,DSYGST)(void);
void FC_GLOBAL(dsygv,DSYGV)(void);
void FC_GLOBAL(dsygv_2stage,DSYGV_2STAGE)(void);
void FC_GLOBAL(dsygvd,DSYGVD)(void);
void FC_GLOBAL(dsygvx,DSYGVX)(void);
void FC_GLOBAL(dsyrfs,DSYRFS)(void);
void FC_GLOBAL(dsysv,DSYSV)(void);
void FC_GLOBAL(dsysv_aa,DSYSV_AA)(void);
void FC_GLOBAL(dsysv_aa_2stage,DSYSV_AA_2STAGE)(void);
void FC_GLOBAL(dsysv_rk,DSYSV_RK)(void);
void FC_GLOBAL(dsysv_rook,DSYSV_ROOK)(void);
void FC_GLOBAL(dsysvx,DSYSVX)(void);
void FC_GLOBAL(dsyswapr,DSYSWAPR)(void);
void FC_GLOBAL(dsytd2,DSYTD2)(void);
void FC_GLOBAL(dsytf2,DSYTF2)(void);
void FC_GLOBAL(dsytf2_rk,DSYTF2_RK)(void);
void FC_GLOBAL(dsytf2_rook,DSYTF2_ROOK)(void);
void FC_GLOBAL(dsytrd,DSYTRD)(void);
void FC_GLOBAL(dsytrd_2stage,DSYTRD_2STAGE)(void);
void FC_GLOBAL(dsytrd_sb2st,DSYTRD_SB2ST)(void);
void FC_GLOBAL(dsytrd_sy2sb,DSYTRD_SY2SB)(void);
void FC_GLOBAL(dsytrf,DSYTRF)(void);
void FC_GLOBAL(dsytrf_aa,DSYTRF_AA)(void);
void FC_GLOBAL(dsytrf_aa_2stage,DSYTRF_AA_2STAGE)(void);
void FC_GLOBAL(dsytrf_rk,DSYTRF_RK)(void);
void FC_GLOBAL(dsytrf_rook,DSYTRF_ROOK)(void);
void FC_GLOBAL(dsytri,DSYTRI)(void);
void FC_GLOBAL(dsytri2,DSYTRI2)(void);
void FC_GLOBAL(dsytri2x,DSYTRI2X)(void);
void FC_GLOBAL(dsytri_3,DSYTRI_3)(void);
void FC_GLOBAL(dsytri_3x,DSYTRI_3X)(void);
void FC_GLOBAL(dsytri_rook,DSYTRI_ROOK)(void);
void FC_GLOBAL(dsytrs,DSYTRS)(void);
void FC_GLOBAL(dsytrs2,DSYTRS2)(void);
void FC_GLOBAL(dsytrs_3,DSYTRS_3)(void);
void FC_GLOBAL(dsytrs_aa,DSYTRS_AA)(void);
void FC_GLOBAL(dsytrs_aa_2stage,DSYTRS_AA_2STAGE)(void);
void FC_GLOBAL(dsytrs_rook,DSYTRS_ROOK)(void);
void FC_GLOBAL(dtbcon,DTBCON)(void);
void FC_GLOBAL(dtbrfs,DTBRFS)(void);
void FC_GLOBAL(dtbtrs,DTBTRS)(void);
void FC_GLOBAL(dtfsm,DTFSM)(void);
void FC_GLOBAL(dtftri,DTFTRI)(void);
void FC_GLOBAL(dtfttp,DTFTTP)(void);
void FC_GLOBAL(dtfttr,DTFTTR)(void);
void FC_GLOBAL(dtgevc,DTGEVC)(void);
void FC_GLOBAL(dtgex2,DTGEX2)(void);
void FC_GLOBAL(dtgexc,DTGEXC)(void);
void FC_GLOBAL(dtgsen,DTGSEN)(void);
void FC_GLOBAL(dtgsja,DTGSJA)(void);
void FC_GLOBAL(dtgsna,DTGSNA)(void);
void FC_GLOBAL(dtgsy2,DTGSY2)(void);
void FC_GLOBAL(dtgsyl,DTGSYL)(void);
void FC_GLOBAL(dtpcon,DTPCON)(void);
void FC_GLOBAL(dtplqt,DTPLQT)(void);
void FC_GLOBAL(dtplqt2,DTPLQT2)(void);
void FC_GLOBAL(dtpmlqt,DTPMLQT)(void);
void FC_GLOBAL(dtpmqrt,DTPMQRT)(void);
void FC_GLOBAL(dtpqrt,DTPQRT)(void);
void FC_GLOBAL(dtpqrt2,DTPQRT2)(void);
void FC_GLOBAL(dtprfb,DTPRFB)(void);
void FC_GLOBAL(dtprfs,DTPRFS)(void);
void FC_GLOBAL(dtptri,DTPTRI)(void);
void FC_GLOBAL(dtptrs,DTPTRS)(void);
void FC_GLOBAL(dtpttf,DTPTTF)(void);
void FC_GLOBAL(dtpttr,DTPTTR)(void);
void FC_GLOBAL(dtrcon,DTRCON)(void);
void FC_GLOBAL(dtrevc,DTREVC)(void);
void FC_GLOBAL(dtrevc3,DTREVC3)(void);
void FC_GLOBAL(dtrexc,DTREXC)(void);
void FC_GLOBAL(dtrrfs,DTRRFS)(void);
void FC_GLOBAL(dtrsen,DTRSEN)(void);
void FC_GLOBAL(dtrsna,DTRSNA)(void);
void FC_GLOBAL(dtrsyl,DTRSYL)(void);
void FC_GLOBAL(dtrsyl3,DTRSYL3)(void);
void FC_GLOBAL(dtrti2,DTRTI2)(void);
void FC_GLOBAL(dtrtri,DTRTRI)(void);
void FC_GLOBAL(dtrtrs,DTRTRS)(void);
void FC_GLOBAL(dtrttf,DTRTTF)(void);
void FC_GLOBAL(dtrttp,DTRTTP)(void);
void FC_GLOBAL(dtzrzf,DTZRZF)(void);
void FC_GLOBAL(dzsum1,DZSUM1)(void);
void FC_GLOBAL(icmax1,ICMAX1)(void);
void FC_GLOBAL(ieeeck,IEEECK)(void);
void FC_GLOBAL(ilaclc,ILACLC)(void);
void FC_GLOBAL(ilaclr,ILACLR)(void);
void FC_GLOBAL(iladiag,ILADIAG)(void);
void FC_GLOBAL(iladlc,ILADLC)(void);
void FC_GLOBAL(iladlr,ILADLR)(void);
void FC_GLOBAL(ilaenv,ILAENV)(void);
void FC_GLOBAL(ilaenv2stage,ILAENV2STAGE)(void);
void FC_GLOBAL(ilaprec,ILAPREC)(void);
void FC_GLOBAL(ilaslc,ILASLC)(void);
void FC_GLOBAL(ilaslr,ILASLR)(void);
void FC_GLOBAL(ilatrans,ILATRANS)(void);
void FC_GLOBAL(ilauplo,ILAUPLO)(void);
void FC_GLOBAL(ilazlc,ILAZLC)(void);
void FC_GLOBAL(ilazlr,ILAZLR)(void);
void FC_GLOBAL(iparam2stage,IPARAM2STAGE)(void);
void FC_GLOBAL(iparmq,IPARMQ)(void);
void FC_GLOBAL(izmax1,IZMAX1)(void);
void FC_GLOBAL(sbbcsd,SBBCSD)(void);
void FC_GLOBAL(sbdsdc,SBDSDC)(void);
void FC_GLOBAL(sbdsqr,SBDSQR)(void);
void FC_GLOBAL(sbdsvdx,SBDSVDX)(void);
void FC_GLOBAL(scsum1,SCSUM1)(void);
void FC_GLOBAL(sdisna,SDISNA)(void);
void FC_GLOBAL(second,SECOND)(void);
void FC_GLOBAL(sgbbrd,SGBBRD)(void);
void FC_GLOBAL(sgbcon,SGBCON)(void);
void FC_GLOBAL(sgbequ,SGBEQU)(void);
void FC_GLOBAL(sgbequb,SGBEQUB)(void);
void FC_GLOBAL(sgbrfs,SGBRFS)(void);
void FC_GLOBAL(sgbsv,SGBSV)(void);
void FC_GLOBAL(sgbsvx,SGBSVX)(void);
void FC_GLOBAL(sgbtf2,SGBTF2)(void);
void FC_GLOBAL(sgbtrf,SGBTRF)(void);
void FC_GLOBAL(sgbtrs,SGBTRS)(void);
void FC_GLOBAL(sgebak,SGEBAK)(void);
void FC_GLOBAL(sgebal,SGEBAL)(void);
void FC_GLOBAL(sgebd2,SGEBD2)(void);
void FC_GLOBAL(sgebrd,SGEBRD)(void);
void FC_GLOBAL(sgecon,SGECON)(void);
void FC_GLOBAL(sgeequ,SGEEQU)(void);
void FC_GLOBAL(sgeequb,SGEEQUB)(void);
void FC_GLOBAL(sgees,SGEES)(void);
void FC_GLOBAL(sgeesx,SGEESX)(void);
void FC_GLOBAL(sgeev,SGEEV)(void);
void FC_GLOBAL(sgeevx,SGEEVX)(void);
void FC_GLOBAL(sgehd2,SGEHD2)(void);
void FC_GLOBAL(sgehrd,SGEHRD)(void);
void FC_GLOBAL(sgejsv,SGEJSV)(void);
void FC_GLOBAL(sgelq,SGELQ)(void);
void FC_GLOBAL(sgelq2,SGELQ2)(void);
void FC_GLOBAL(sgelqf,SGELQF)(void);
void FC_GLOBAL(sgelqt,SGELQT)(void);
void FC_GLOBAL(sgelqt3,SGELQT3)(void);
void FC_GLOBAL(sgels,SGELS)(void);
void FC_GLOBAL(sgelsd,SGELSD)(void);
void FC_GLOBAL(sgelss,SGELSS)(void);
void FC_GLOBAL(sgelst,SGELST)(void);
void FC_GLOBAL(sgelsy,SGELSY)(void);
void FC_GLOBAL(sgemlq,SGEMLQ)(void);
void FC_GLOBAL(sgemlqt,SGEMLQT)(void);
void FC_GLOBAL(sgemqr,SGEMQR)(void);
void FC_GLOBAL(sgemqrt,SGEMQRT)(void);
void FC_GLOBAL(sgeql2,SGEQL2)(void);
void FC_GLOBAL(sgeqlf,SGEQLF)(void);
void FC_GLOBAL(sgeqp3,SGEQP3)(void);
void FC_GLOBAL(sgeqr,SGEQR)(void);
void FC_GLOBAL(sgeqr2,SGEQR2)(void);
void FC_GLOBAL(sgeqr2p,SGEQR2P)(void);
void FC_GLOBAL(sgeqrf,SGEQRF)(void);
void FC_GLOBAL(sgeqrfp,SGEQRFP)(void);
void FC_GLOBAL(sgeqrt,SGEQRT)(void);
void FC_GLOBAL(sgeqrt2,SGEQRT2)(void);
void FC_GLOBAL(sgeqrt3,SGEQRT3)(void);
void FC_GLOBAL(sgerfs,SGERFS)(void);
void FC_GLOBAL(sgerq2,SGERQ2)(void);
void FC_GLOBAL(sgerqf,SGERQF)(void);
void FC_GLOBAL(sgesc2,SGESC2)(void);
void FC_GLOBAL(sgesdd,SGESDD)(void);
void FC_GLOBAL(sgesv,SGESV)(void);
void FC_GLOBAL(sgesvd,SGESVD)(void);
void FC_GLOBAL(sgesvdq,SGESVDQ)(void);
void FC_GLOBAL(sgesvdx,SGESVDX)(void);
void FC_GLOBAL(sgesvj,SGESVJ)(void);
void FC_GLOBAL(sgesvx,SGESVX)(void);
void FC_GLOBAL(sgetc2,SGETC2)(void);
void FC_GLOBAL(sgetf2,SGETF2)(void);
void FC_GLOBAL(sgetrf,SGETRF)(void);
void FC_GLOBAL(sgetrf2,SGETRF2)(void);
void FC_GLOBAL(sgetri,SGETRI)(void);
void FC_GLOBAL(sgetrs,SGETRS)(void);
void FC_GLOBAL(sgetsls,SGETSLS)(void);
void FC_GLOBAL(sgetsqrhrt,SGETSQRHRT)(void);
void FC_GLOBAL(sggbak,SGGBAK)(void);
void FC_GLOBAL(sggbal,SGGBAL)(void);
void FC_GLOBAL(sgges,SGGES)(void);
void FC_GLOBAL(sgges3,SGGES3)(void);
void FC_GLOBAL(sggesx,SGGESX)(void);
void FC_GLOBAL(sggev,SGGEV)(void);
void FC_GLOBAL(sggev3,SGGEV3)(void);
void FC_GLOBAL(sggevx,SGGEVX)(void);
void FC_GLOBAL(sggglm,SGGGLM)(void);
void FC_GLOBAL(sgghd3,SGGHD3)(void);
void FC_GLOBAL(sgghrd,SGGHRD)(void);
void FC_GLOBAL(sgglse,SGGLSE)(void);
void FC_GLOBAL(sggqrf,SGGQRF)(void);
void FC_GLOBAL(sggrqf,SGGRQF)(void);
void FC_GLOBAL(sggsvd3,SGGSVD3)(void);
void FC_GLOBAL(sggsvp3,SGGSVP3)(void);
void FC_GLOBAL(sgsvj0,SGSVJ0)(void);
void FC_GLOBAL(sgsvj1,SGSVJ1)(void);
void FC_GLOBAL(sgtcon,SGTCON)(void);
void FC_GLOBAL(sgtrfs,SGTRFS)(void);
void FC_GLOBAL(sgtsv,SGTSV)(void);
void FC_GLOBAL(sgtsvx,SGTSVX)(void);
void FC_GLOBAL(sgttrf,SGTTRF)(void);
void FC_GLOBAL(sgttrs,SGTTRS)(void);
void FC_GLOBAL(sgtts2,SGTTS2)(void);
void FC_GLOBAL(shgeqz,SHGEQZ)(void);
void FC_GLOBAL(shsein,SHSEIN)(void);
void FC_GLOBAL(shseqr,SHSEQR)(void);
void FC_GLOBAL(sisnan,SISNAN)(void);
void FC_GLOBAL(slabad,SLABAD)(void);
void FC_GLOBAL(slabrd,SLABRD)(void);
void FC_GLOBAL(slacn2,SLACN2)(void);
void FC_GLOBAL(slacon,SLACON)(void);
void FC_GLOBAL(slacpy,SLACPY)(void);
void FC_GLOBAL(sladiv,SLADIV)(void);
void FC_GLOBAL(sladiv1,SLADIV1)(void);
void FC_GLOBAL(sladiv2,SLADIV2)(void);
void FC_GLOBAL(slae2,SLAE2)(void);
void FC_GLOBAL(slaebz,SLAEBZ)(void);
void FC_GLOBAL(slaed0,SLAED0)(void);
void FC_GLOBAL(slaed1,SLAED1)(void);
void FC_GLOBAL(slaed2,SLAED2)(void);
void FC_GLOBAL(slaed3,SLAED3)(void);
void FC_GLOBAL(slaed4,SLAED4)(void);
void FC_GLOBAL(slaed5,SLAED5)(void);
void FC_GLOBAL(slaed6,SLAED6)(void);
void FC_GLOBAL(slaed7,SLAED7)(void);
void FC_GLOBAL(slaed8,SLAED8)(void);
void FC_GLOBAL(slaed9,SLAED9)(void);
void FC_GLOBAL(slaeda,SLAEDA)(void);
void FC_GLOBAL(slaein,SLAEIN)(void);
void FC_GLOBAL(slaev2,SLAEV2)(void);
void FC_GLOBAL(slaexc,SLAEXC)(void);
void FC_GLOBAL(slag2,SLAG2)(void);
void FC_GLOBAL(slag2d,SLAG2D)(void);
void FC_GLOBAL(slags2,SLAGS2)(void);
void FC_GLOBAL(slagtf,SLAGTF)(void);
void FC_GLOBAL(slagtm,SLAGTM)(void);
void FC_GLOBAL(slagts,SLAGTS)(void);
void FC_GLOBAL(slagv2,SLAGV2)(void);
void FC_GLOBAL(slahqr,SLAHQR)(void);
void FC_GLOBAL(slahr2,SLAHR2)(void);
void FC_GLOBAL(slaic1,SLAIC1)(void);
void FC_GLOBAL(slaisnan,SLAISNAN)(void);
void FC_GLOBAL(slaln2,SLALN2)(void);
void FC_GLOBAL(slals0,SLALS0)(void);
void FC_GLOBAL(slalsa,SLALSA)(void);
void FC_GLOBAL(slalsd,SLALSD)(void);
void FC_GLOBAL(slamc3,SLAMC3)(void);
void FC_GLOBAL(slamch,SLAMCH)(void);
void FC_GLOBAL(slamrg,SLAMRG)(void);
void FC_GLOBAL(slamswlq,SLAMSWLQ)(void);
void FC_GLOBAL(slamtsqr,SLAMTSQR)(void);
void FC_GLOBAL(slaneg,SLANEG)(void);
void FC_GLOBAL(slangb,SLANGB)(void);
void FC_GLOBAL(slange,SLANGE)(void);
void FC_GLOBAL(slangt,SLANGT)(void);
void FC_GLOBAL(slanhs,SLANHS)(void);
void FC_GLOBAL(slansb,SLANSB)(void);
void FC_GLOBAL(slansf,SLANSF)(void);
void FC_GLOBAL(slansp,SLANSP)(void);
void FC_GLOBAL(slanst,SLANST)(void);
void FC_GLOBAL(slansy,SLANSY)(void);
void FC_GLOBAL(slantb,SLANTB)(void);
void FC_GLOBAL(slantp,SLANTP)(void);
void FC_GLOBAL(slantr,SLANTR)(void);
void FC_GLOBAL(slanv2,SLANV2)(void);
void FC_GLOBAL(slaorhr_col_getrfnp,SLAORHR_COL_GETRFNP)(void);
void FC_GLOBAL(slaorhr_col_getrfnp2,SLAORHR_COL_GETRFNP2)(void);
void FC_GLOBAL(slapll,SLAPLL)(void);
void FC_GLOBAL(slapmr,SLAPMR)(void);
void FC_GLOBAL(slapmt,SLAPMT)(void);
void FC_GLOBAL(slapy2,SLAPY2)(void);
void FC_GLOBAL(slapy3,SLAPY3)(void);
void FC_GLOBAL(slaqgb,SLAQGB)(void);
void FC_GLOBAL(slaqge,SLAQGE)(void);
void FC_GLOBAL(slaqp2,SLAQP2)(void);
void FC_GLOBAL(slaqps,SLAQPS)(void);
void FC_GLOBAL(slaqr0,SLAQR0)(void);
void FC_GLOBAL(slaqr1,SLAQR1)(void);
void FC_GLOBAL(slaqr2,SLAQR2)(void);
void FC_GLOBAL(slaqr3,SLAQR3)(void);
void FC_GLOBAL(slaqr4,SLAQR4)(void);
void FC_GLOBAL(slaqr5,SLAQR5)(void);
void FC_GLOBAL(slaqsb,SLAQSB)(void);
void FC_GLOBAL(slaqsp,SLAQSP)(void);
void FC_GLOBAL(slaqsy,SLAQSY)(void);
void FC_GLOBAL(slaqtr,SLAQTR)(void);
void FC_GLOBAL(slaqz0,SLAQZ0)(void);
void FC_GLOBAL(slaqz1,SLAQZ1)(void);
void FC_GLOBAL(slaqz2,SLAQZ2)(void);
void FC_GLOBAL(slaqz3,SLAQZ3)(void);
void FC_GLOBAL(slaqz4,SLAQZ4)(void);
void FC_GLOBAL(slar1v,SLAR1V)(void);
void FC_GLOBAL(slar2v,SLAR2V)(void);
void FC_GLOBAL(slarf,SLARF)(void);
void FC_GLOBAL(slarfb,SLARFB)(void);
void FC_GLOBAL(slarfb_gett,SLARFB_GETT)(void);
void FC_GLOBAL(slarfg,SLARFG)(void);
void FC_GLOBAL(slarfgp,SLARFGP)(void);
void FC_GLOBAL(slarft,SLARFT)(void);
void FC_GLOBAL(slarfx,SLARFX)(void);
void FC_GLOBAL(slarfy,SLARFY)(void);
void FC_GLOBAL(slargv,SLARGV)(void);
void FC_GLOBAL(slarmm,SLARMM)(void);
void FC_GLOBAL(slarnv,SLARNV)(void);
void FC_GLOBAL(slarra,SLARRA)(void);
void FC_GLOBAL(slarrb,SLARRB)(void);
void FC_GLOBAL(slarrc,SLARRC)(void);
void FC_GLOBAL(slarrd,SLARRD)(void);
void FC_GLOBAL(slarre,SLARRE)(void);
void FC_GLOBAL(slarrf,SLARRF)(void);
void FC_GLOBAL(slarrj,SLARRJ)(void);
void FC_GLOBAL(slarrk,SLARRK)(void);
void FC_GLOBAL(slarrr,SLARRR)(void);
void FC_GLOBAL(slarrv,SLARRV)(void);
void FC_GLOBAL(slartg,SLARTG)(void);
void FC_GLOBAL(slartgp,SLARTGP)(void);
void FC_GLOBAL(slartgs,SLARTGS)(void);
void FC_GLOBAL(slartv,SLARTV)(void);
void FC_GLOBAL(slaruv,SLARUV)(void);
void FC_GLOBAL(slarz,SLARZ)(void);
void FC_GLOBAL(slarzb,SLARZB)(void);
void FC_GLOBAL(slarzt,SLARZT)(void);
void FC_GLOBAL(slas2,SLAS2)(void);
void FC_GLOBAL(slascl,SLASCL)(void);
void FC_GLOBAL(slasd0,SLASD0)(void);
void FC_GLOBAL(slasd1,SLASD1)(void);
void FC_GLOBAL(slasd2,SLASD2)(void);
void FC_GLOBAL(slasd3,SLASD3)(void);
void FC_GLOBAL(slasd4,SLASD4)(void);
void FC_GLOBAL(slasd5,SLASD5)(void);
void FC_GLOBAL(slasd6,SLASD6)(void);
void FC_GLOBAL(slasd7,SLASD7)(void);
void FC_GLOBAL(slasd8,SLASD8)(void);
void FC_GLOBAL(slasda,SLASDA)(void);
void FC_GLOBAL(slasdq,SLASDQ)(void);
void FC_GLOBAL(slasdt,SLASDT)(void);
void FC_GLOBAL(slaset,SLASET)(void);
void FC_GLOBAL(slasq1,SLASQ1)(void);
void FC_GLOBAL(slasq2,SLASQ2)(void);
void FC_GLOBAL(slasq3,SLASQ3)(void);
void FC_GLOBAL(slasq4,SLASQ4)(void);
void FC_GLOBAL(slasq5,SLASQ5)(void);
void FC_GLOBAL(slasq6,SLASQ6)(void);
void FC_GLOBAL(slasr,SLASR)(void);
void FC_GLOBAL(slasrt,SLASRT)(void);
void FC_GLOBAL(slassq,SLASSQ)(void);
void FC_GLOBAL(slasv2,SLASV2)(void);
void FC_GLOBAL(slaswlq,SLASWLQ)(void);
void FC_GLOBAL(slaswp,SLASWP)(void);
void FC_GLOBAL(slasy2,SLASY2)(void);
void FC_GLOBAL(slasyf,SLASYF)(void);
void FC_GLOBAL(slasyf_aa,SLASYF_AA)(void);
void FC_GLOBAL(slasyf_rk,SLASYF_RK)(void);
void FC_GLOBAL(slasyf_rook,SLASYF_ROOK)(void);
void FC_GLOBAL(slatbs,SLATBS)(void);
void FC_GLOBAL(slatdf,SLATDF)(void);
void FC_GLOBAL(slatps,SLATPS)(void);
void FC_GLOBAL(slatrd,SLATRD)(void);
void FC_GLOBAL(slatrs,SLATRS)(void);
void FC_GLOBAL(slatrs3,SLATRS3)(void);
void FC_GLOBAL(slatrz,SLATRZ)(void);
void FC_GLOBAL(slatsqr,SLATSQR)(void);
void FC_GLOBAL(slauu2,SLAUU2)(void);
void FC_GLOBAL(slauum,SLAUUM)(void);
void FC_GLOBAL(sopgtr,SOPGTR)(void);
void FC_GLOBAL(sopmtr,SOPMTR)(void);
void FC_GLOBAL(sorbdb,SORBDB)(void);
void FC_GLOBAL(sorbdb1,SORBDB1)(void);
void FC_GLOBAL(sorbdb2,SORBDB2)(void);
void FC_GLOBAL(sorbdb3,SORBDB3)(void);
void FC_GLOBAL(sorbdb4,SORBDB4)(void);
void FC_GLOBAL(sorbdb5,SORBDB5)(void);
void FC_GLOBAL(sorbdb6,SORBDB6)(void);
void FC_GLOBAL(sorcsd,SORCSD)(void);
void FC_GLOBAL(sorcsd2by1,SORCSD2BY1)(void);
void FC_GLOBAL(sorg2l,SORG2L)(void);
void FC_GLOBAL(sorg2r,SORG2R)(void);
void FC_GLOBAL(sorgbr,SORGBR)(void);
void FC_GLOBAL(sorghr,SORGHR)(void);
void FC_GLOBAL(sorgl2,SORGL2)(void);
void FC_GLOBAL(sorglq,SORGLQ)(void);
void FC_GLOBAL(sorgql,SORGQL)(void);
void FC_GLOBAL(sorgqr,SORGQR)(void);
void FC_GLOBAL(sorgr2,SORGR2)(void);
void FC_GLOBAL(sorgrq,SORGRQ)(void);
void FC_GLOBAL(sorgtr,SORGTR)(void);
void FC_GLOBAL(sorgtsqr,SORGTSQR)(void);
void FC_GLOBAL(sorgtsqr_row,SORGTSQR_ROW)(void);
void FC_GLOBAL(sorhr_col,SORHR_COL)(void);
void FC_GLOBAL(sorm22,SORM22)(void);
void FC_GLOBAL(sorm2l,SORM2L)(void);
void FC_GLOBAL(sorm2r,SORM2R)(void);
void FC_GLOBAL(sormbr,SORMBR)(void);
void FC_GLOBAL(sormhr,SORMHR)(void);
void FC_GLOBAL(sorml2,SORML2)(void);
void FC_GLOBAL(sormlq,SORMLQ)(void);
void FC_GLOBAL(sormql,SORMQL)(void);
void FC_GLOBAL(sormqr,SORMQR)(void);
void FC_GLOBAL(sormr2,SORMR2)(void);
void FC_GLOBAL(sormr3,SORMR3)(void);
void FC_GLOBAL(sormrq,SORMRQ)(void);
void FC_GLOBAL(sormrz,SORMRZ)(void);
void FC_GLOBAL(sormtr,SORMTR)(void);
void FC_GLOBAL(spbcon,SPBCON)(void);
void FC_GLOBAL(spbequ,SPBEQU)(void);
void FC_GLOBAL(spbrfs,SPBRFS)(void);
void FC_GLOBAL(spbstf,SPBSTF)(void);
void FC_GLOBAL(spbsv,SPBSV)(void);
void FC_GLOBAL(spbsvx,SPBSVX)(void);
void FC_GLOBAL(spbtf2,SPBTF2)(void);
void FC_GLOBAL(spbtrf,SPBTRF)(void);
void FC_GLOBAL(spbtrs,SPBTRS)(void);
void FC_GLOBAL(spftrf,SPFTRF)(void);
void FC_GLOBAL(spftri,SPFTRI)(void);
void FC_GLOBAL(spftrs,SPFTRS)(void);
void FC_GLOBAL(spocon,SPOCON)(void);
void FC_GLOBAL(spoequ,SPOEQU)(void);
void FC_GLOBAL(spoequb,SPOEQUB)(void);
void FC_GLOBAL(sporfs,SPORFS)(void);
void FC_GLOBAL(sposv,SPOSV)(void);
void FC_GLOBAL(sposvx,SPOSVX)(void);
void FC_GLOBAL(spotf2,SPOTF2)(void);
void FC_GLOBAL(spotrf,SPOTRF)(void);
void FC_GLOBAL(spotrf2,SPOTRF2)(void);
void FC_GLOBAL(spotri,SPOTRI)(void);
void FC_GLOBAL(spotrs,SPOTRS)(void);
void FC_GLOBAL(sppcon,SPPCON)(void);
void FC_GLOBAL(sppequ,SPPEQU)(void);
void FC_GLOBAL(spprfs,SPPRFS)(void);
void FC_GLOBAL(sppsv,SPPSV)(void);
void FC_GLOBAL(sppsvx,SPPSVX)(void);
void FC_GLOBAL(spptrf,SPPTRF)(void);
void FC_GLOBAL(spptri,SPPTRI)(void);
void FC_GLOBAL(spptrs,SPPTRS)(void);
void FC_GLOBAL(spstf2,SPSTF2)(void);
void FC_GLOBAL(spstrf,SPSTRF)(void);
void FC_GLOBAL(sptcon,SPTCON)(void);
void FC_GLOBAL(spteqr,SPTEQR)(void);
void FC_GLOBAL(sptrfs,SPTRFS)(void);
void FC_GLOBAL(sptsv,SPTSV)(void);
void FC_GLOBAL(sptsvx,SPTSVX)(void);
void FC_GLOBAL(spttrf,SPTTRF)(void);
void FC_GLOBAL(spttrs,SPTTRS)(void);
void FC_GLOBAL(sptts2,SPTTS2)(void);
void FC_GLOBAL(sroundup_lwork,SROUNDUP_LWORK)(void);
void FC_GLOBAL(srscl,SRSCL)(void);
void FC_GLOBAL(ssb2st_kernels,SSB2ST_KERNELS)(void);
void FC_GLOBAL(ssbev,SSBEV)(void);
void FC_GLOBAL(ssbev_2stage,SSBEV_2STAGE)(void);
void FC_GLOBAL(ssbevd,SSBEVD)(void);
void FC_GLOBAL(ssbevd_2stage,SSBEVD_2STAGE)(void);
void FC_GLOBAL(ssbevx,SSBEVX)(void);
void FC_GLOBAL(ssbevx_2stage,SSBEVX_2STAGE)(void);
void FC_GLOBAL(ssbgst,SSBGST)(void);
void FC_GLOBAL(ssbgv,SSBGV)(void);
void FC_GLOBAL(ssbgvd,SSBGVD)(void);
void FC_GLOBAL(ssbgvx,SSBGVX)(void);
void FC_GLOBAL(ssbtrd,SSBTRD)(void);
void FC_GLOBAL(ssfrk,SSFRK)(void);
void FC_GLOBAL(sspcon,SSPCON)(void);
void FC_GLOBAL(sspev,SSPEV)(void);
void FC_GLOBAL(sspevd,SSPEVD)(void);
void FC_GLOBAL(sspevx,SSPEVX)(void);
void FC_GLOBAL(sspgst,SSPGST)(void);
void FC_GLOBAL(sspgv,SSPGV)(void);
void FC_GLOBAL(sspgvd,SSPGVD)(void);
void FC_GLOBAL(sspgvx,SSPGVX)(void);
void FC_GLOBAL(ssprfs,SSPRFS)(void);
void FC_GLOBAL(sspsv,SSPSV)(void);
void FC_GLOBAL(sspsvx,SSPSVX)(void);
void FC_GLOBAL(ssptrd,SSPTRD)(void);
void FC_GLOBAL(ssptrf,SSPTRF)(void);
void FC_GLOBAL(ssptri,SSPTRI)(void);
void FC_GLOBAL(ssptrs,SSPTRS)(void);
void FC_GLOBAL(sstebz,SSTEBZ)(void);
void FC_GLOBAL(sstedc,SSTEDC)(void);
void FC_GLOBAL(sstegr,SSTEGR)(void);
void FC_GLOBAL(sstein,SSTEIN)(void);
void FC_GLOBAL(sstemr,SSTEMR)(void);
void FC_GLOBAL(ssteqr,SSTEQR)(void);
void FC_GLOBAL(ssterf,SSTERF)(void);
void FC_GLOBAL(sstev,SSTEV)(void);
void FC_GLOBAL(sstevd,SSTEVD)(void);
void FC_GLOBAL(sstevr,SSTEVR)(void);
void FC_GLOBAL(sstevx,SSTEVX)(void);
void FC_GLOBAL(ssycon,SSYCON)(void);
void FC_GLOBAL(ssycon_3,SSYCON_3)(void);
void FC_GLOBAL(ssycon_rook,SSYCON_ROOK)(void);
void FC_GLOBAL(ssyconv,SSYCONV)(void);
void FC_GLOBAL(ssyconvf,SSYCONVF)(void);
void FC_GLOBAL(ssyconvf_rook,SSYCONVF_ROOK)(void);
void FC_GLOBAL(ssyequb,SSYEQUB)(void);
void FC_GLOBAL(ssyev,SSYEV)(void);
void FC_GLOBAL(ssyev_2stage,SSYEV_2STAGE)(void);
void FC_GLOBAL(ssyevd,SSYEVD)(void);
void FC_GLOBAL(ssyevd_2stage,SSYEVD_2STAGE)(void);
void FC_GLOBAL(ssyevr,SSYEVR)(void);
void FC_GLOBAL(ssyevr_2stage,SSYEVR_2STAGE)(void);
void FC_GLOBAL(ssyevx,SSYEVX)(void);
void FC_GLOBAL(ssyevx_2stage,SSYEVX_2STAGE)(void);
void FC_GLOBAL(ssygs2,SSYGS2)(void);
void FC_GLOBAL(ssygst,SSYGST)(void);
void FC_GLOBAL(ssygv,SSYGV)(void);
void FC_GLOBAL(ssygv_2stage,SSYGV_2STAGE)(void);
void FC_GLOBAL(ssygvd,SSYGVD)(void);
void FC_GLOBAL(ssygvx,SSYGVX)(void);
void FC_GLOBAL(ssyrfs,SSYRFS)(void);
void FC_GLOBAL(ssysv,SSYSV)(void);
void FC_GLOBAL(ssysv_aa,SSYSV_AA)(void);
void FC_GLOBAL(ssysv_aa_2stage,SSYSV_AA_2STAGE)(void);
void FC_GLOBAL(ssysv_rk,SSYSV_RK)(void);
void FC_GLOBAL(ssysv_rook,SSYSV_ROOK)(void);
void FC_GLOBAL(ssysvx,SSYSVX)(void);
void FC_GLOBAL(ssyswapr,SSYSWAPR)(void);
void FC_GLOBAL(ssytd2,SSYTD2)(void);
void FC_GLOBAL(ssytf2,SSYTF2)(void);
void FC_GLOBAL(ssytf2_rk,SSYTF2_RK)(void);
void FC_GLOBAL(ssytf2_rook,SSYTF2_ROOK)(void);
void FC_GLOBAL(ssytrd,SSYTRD)(void);
void FC_GLOBAL(ssytrd_2stage,SSYTRD_2STAGE)(void);
void FC_GLOBAL(ssytrd_sb2st,SSYTRD_SB2ST)(void);
void FC_GLOBAL(ssytrd_sy2sb,SSYTRD_SY2SB)(void);
void FC_GLOBAL(ssytrf,SSYTRF)(void);
void FC_GLOBAL(ssytrf_aa,SSYTRF_AA)(void);
void FC_GLOBAL(ssytrf_aa_2stage,SSYTRF_AA_2STAGE)(void);
void FC_GLOBAL(ssytrf_rk,SSYTRF_RK)(void);
void FC_GLOBAL(ssytrf_rook,SSYTRF_ROOK)(void);
void FC_GLOBAL(ssytri,SSYTRI)(void);
void FC_GLOBAL(ssytri2,SSYTRI2)(void);
void FC_GLOBAL(ssytri2x,SSYTRI2X)(void);
void FC_GLOBAL(ssytri_3,SSYTRI_3)(void);
void FC_GLOBAL(ssytri_3x,SSYTRI_3X)(void);
void FC_GLOBAL(ssytri_rook,SSYTRI_ROOK)(void);
void FC_GLOBAL(ssytrs,SSYTRS)(void);
void FC_GLOBAL(ssytrs2,SSYTRS2)(void);
void FC_GLOBAL(ssytrs_3,SSYTRS_3)(void);
void FC_GLOBAL(ssytrs_aa,SSYTRS_AA)(void);
void FC_GLOBAL(ssytrs_aa_2stage,SSYTRS_AA_2STAGE)(void);
void FC_GLOBAL(ssytrs_rook,SSYTRS_ROOK)(void);
void FC_GLOBAL(stbcon,STBCON)(void);
void FC_GLOBAL(stbrfs,STBRFS)(void);
void FC_GLOBAL(stbtrs,STBTRS)(void);
void FC_GLOBAL(stfsm,STFSM)(void);
void FC_GLOBAL(stftri,STFTRI)(void);
void FC_GLOBAL(stfttp,STFTTP)(void);
void FC_GLOBAL(stfttr,STFTTR)(void);
void FC_GLOBAL(stgevc,STGEVC)(void);
void FC_GLOBAL(stgex2,STGEX2)(void);
void FC_GLOBAL(stgexc,STGEXC)(void);
void FC_GLOBAL(stgsen,STGSEN)(void);
void FC_GLOBAL(stgsja,STGSJA)(void);
void FC_GLOBAL(stgsna,STGSNA)(void);
void FC_GLOBAL(stgsy2,STGSY2)(void);
void FC_GLOBAL(stgsyl,STGSYL)(void);
void FC_GLOBAL(stpcon,STPCON)(void);
void FC_GLOBAL(stplqt,STPLQT)(void);
void FC_GLOBAL(stplqt2,STPLQT2)(void);
void FC_GLOBAL(stpmlqt,STPMLQT)(void);
void FC_GLOBAL(stpmqrt,STPMQRT)(void);
void FC_GLOBAL(stpqrt,STPQRT)(void);
void FC_GLOBAL(stpqrt2,STPQRT2)(void);
void FC_GLOBAL(stprfb,STPRFB)(void);
void FC_GLOBAL(stprfs,STPRFS)(void);
void FC_GLOBAL(stptri,STPTRI)(void);
void FC_GLOBAL(stptrs,STPTRS)(void);
void FC_GLOBAL(stpttf,STPTTF)(void);
void FC_GLOBAL(stpttr,STPTTR)(void);
void FC_GLOBAL(strcon,STRCON)(void);
void FC_GLOBAL(strevc,STREVC)(void);
void FC_GLOBAL(strevc3,STREVC3)(void);
void FC_GLOBAL(strexc,STREXC)(void);
void FC_GLOBAL(strrfs,STRRFS)(void);
void FC_GLOBAL(strsen,STRSEN)(void);
void FC_GLOBAL(strsna,STRSNA)(void);
void FC_GLOBAL(strsyl,STRSYL)(void);
void FC_GLOBAL(strsyl3,STRSYL3)(void);
void FC_GLOBAL(strti2,STRTI2)(void);
void FC_GLOBAL(strtri,STRTRI)(void);
void FC_GLOBAL(strtrs,STRTRS)(void);
void FC_GLOBAL(strttf,STRTTF)(void);
void FC_GLOBAL(strttp,STRTTP)(void);
void FC_GLOBAL(stzrzf,STZRZF)(void);
void FC_GLOBAL(xerbla_array,XERBLA_ARRAY)(void);
void FC_GLOBAL(zbbcsd,ZBBCSD)(void);
void FC_GLOBAL(zbdsqr,ZBDSQR)(void);
void FC_GLOBAL(zcgesv,ZCGESV)(void);
void FC_GLOBAL(zcposv,ZCPOSV)(void);
void FC_GLOBAL(zdrscl,ZDRSCL)(void);
void FC_GLOBAL(zgbbrd,ZGBBRD)(void);
void FC_GLOBAL(zgbcon,ZGBCON)(void);
void FC_GLOBAL(zgbequ,ZGBEQU)(void);
void FC_GLOBAL(zgbequb,ZGBEQUB)(void);
void FC_GLOBAL(zgbrfs,ZGBRFS)(void);
void FC_GLOBAL(zgbsv,ZGBSV)(void);
void FC_GLOBAL(zgbsvx,ZGBSVX)(void);
void FC_GLOBAL(zgbtf2,ZGBTF2)(void);
void FC_GLOBAL(zgbtrf,ZGBTRF)(void);
void FC_GLOBAL(zgbtrs,ZGBTRS)(void);
void FC_GLOBAL(zgebak,ZGEBAK)(void);
void FC_GLOBAL(zgebal,ZGEBAL)(void);
void FC_GLOBAL(zgebd2,ZGEBD2)(void);
void FC_GLOBAL(zgebrd,ZGEBRD)(void);
void FC_GLOBAL(zgecon,ZGECON)(void);
void FC_GLOBAL(zgeequ,ZGEEQU)(void);
void FC_GLOBAL(zgeequb,ZGEEQUB)(void);
void FC_GLOBAL(zgees,ZGEES)(void);
void FC_GLOBAL(zgeesx,ZGEESX)(void);
void FC_GLOBAL(zgeev,ZGEEV)(void);
void FC_GLOBAL(zgeevx,ZGEEVX)(void);
void FC_GLOBAL(zgehd2,ZGEHD2)(void);
void FC_GLOBAL(zgehrd,ZGEHRD)(void);
void FC_GLOBAL(zgejsv,ZGEJSV)(void);
void FC_GLOBAL(zgelq,ZGELQ)(void);
void FC_GLOBAL(zgelq2,ZGELQ2)(void);
void FC_GLOBAL(zgelqf,ZGELQF)(void);
void FC_GLOBAL(zgelqt,ZGELQT)(void);
void FC_GLOBAL(zgelqt3,ZGELQT3)(void);
void FC_GLOBAL(zgels,ZGELS)(void);
void FC_GLOBAL(zgelsd,ZGELSD)(void);
void FC_GLOBAL(zgelss,ZGELSS)(void);
void FC_GLOBAL(zgelst,ZGELST)(void);
void FC_GLOBAL(zgelsy,ZGELSY)(void);
void FC_GLOBAL(zgemlq,ZGEMLQ)(void);
void FC_GLOBAL(zgemlqt,ZGEMLQT)(void);
void FC_GLOBAL(zgemqr,ZGEMQR)(void);
void FC_GLOBAL(zgemqrt,ZGEMQRT)(void);
void FC_GLOBAL(zgeql2,ZGEQL2)(void);
void FC_GLOBAL(zgeqlf,ZGEQLF)(void);
void FC_GLOBAL(zgeqp3,ZGEQP3)(void);
void FC_GLOBAL(zgeqr,ZGEQR)(void);
void FC_GLOBAL(zgeqr2,ZGEQR2)(void);
void FC_GLOBAL(zgeqr2p,ZGEQR2P)(void);
void FC_GLOBAL(zgeqrf,ZGEQRF)(void);
void FC_GLOBAL(zgeqrfp,ZGEQRFP)(void);
void FC_GLOBAL(zgeqrt,ZGEQRT)(void);
void FC_GLOBAL(zgeqrt2,ZGEQRT2)(void);
void FC_GLOBAL(zgeqrt3,ZGEQRT3)(void);
void FC_GLOBAL(zgerfs,ZGERFS)(void);
void FC_GLOBAL(zgerq2,ZGERQ2)(void);
void FC_GLOBAL(zgerqf,ZGERQF)(void);
void FC_GLOBAL(zgesc2,ZGESC2)(void);
void FC_GLOBAL(zgesdd,ZGESDD)(void);
void FC_GLOBAL(zgesv,ZGESV)(void);
void FC_GLOBAL(zgesvd,ZGESVD)(void);
void FC_GLOBAL(zgesvdq,ZGESVDQ)(void);
void FC_GLOBAL(zgesvdx,ZGESVDX)(void);
void FC_GLOBAL(zgesvj,ZGESVJ)(void);
void FC_GLOBAL(zgesvx,ZGESVX)(void);
void FC_GLOBAL(zgetc2,ZGETC2)(void);
void FC_GLOBAL(zgetf2,ZGETF2)(void);
void FC_GLOBAL(zgetrf,ZGETRF)(void);
void FC_GLOBAL(zgetrf2,ZGETRF2)(void);
void FC_GLOBAL(zgetri,ZGETRI)(void);
void FC_GLOBAL(zgetrs,ZGETRS)(void);
void FC_GLOBAL(zgetsls,ZGETSLS)(void);
void FC_GLOBAL(zgetsqrhrt,ZGETSQRHRT)(void);
void FC_GLOBAL(zggbak,ZGGBAK)(void);
void FC_GLOBAL(zggbal,ZGGBAL)(void);
void FC_GLOBAL(zgges,ZGGES)(void);
void FC_GLOBAL(zgges3,ZGGES3)(void);
void FC_GLOBAL(zggesx,ZGGESX)(void);
void FC_GLOBAL(zggev,ZGGEV)(void);
void FC_GLOBAL(zggev3,ZGGEV3)(void);
void FC_GLOBAL(zggevx,ZGGEVX)(void);
void FC_GLOBAL(zggglm,ZGGGLM)(void);
void FC_GLOBAL(zgghd3,ZGGHD3)(void);
void FC_GLOBAL(zgghrd,ZGGHRD)(void);
void FC_GLOBAL(zgglse,ZGGLSE)(void);
void FC_GLOBAL(zggqrf,ZGGQRF)(void);
void FC_GLOBAL(zggrqf,ZGGRQF)(void);
void FC_GLOBAL(zggsvd3,ZGGSVD3)(void);
void FC_GLOBAL(zggsvp3,ZGGSVP3)(void);
void FC_GLOBAL(zgsvj0,ZGSVJ0)(void);
void FC_GLOBAL(zgsvj1,ZGSVJ1)(void);
void FC_GLOBAL(zgtcon,ZGTCON)(void);
void FC_GLOBAL(zgtrfs,ZGTRFS)(void);
void FC_GLOBAL(zgtsv,ZGTSV)(void);
void FC_GLOBAL(zgtsvx,ZGTSVX)(void);
void FC_GLOBAL(zgttrf,ZGTTRF)(void);
void FC_GLOBAL(zgttrs,ZGTTRS)(void);
void FC_GLOBAL(zgtts2,ZGTTS2)(void);
void FC_GLOBAL(zhb2st_kernels,ZHB2ST_KERNELS)(void);
void FC_GLOBAL(zhbev,ZHBEV)(void);
void FC_GLOBAL(zhbev_2stage,ZHBEV_2STAGE)(void);
void FC_GLOBAL(zhbevd,ZHBEVD)(void);
void FC_GLOBAL(zhbevd_2stage,ZHBEVD_2STAGE)(void);
void FC_GLOBAL(zhbevx,ZHBEVX)(void);
void FC_GLOBAL(zhbevx_2stage,ZHBEVX_2STAGE)(void);
void FC_GLOBAL(zhbgst,ZHBGST)(void);
void FC_GLOBAL(zhbgv,ZHBGV)(void);
void FC_GLOBAL(zhbgvd,ZHBGVD)(void);
void FC_GLOBAL(zhbgvx,ZHBGVX)(void);
void FC_GLOBAL(zhbtrd,ZHBTRD)(void);
void FC_GLOBAL(zhecon,ZHECON)(void);
void FC_GLOBAL(zhecon_3,ZHECON_3)(void);
void FC_GLOBAL(zhecon_rook,ZHECON_ROOK)(void);
void FC_GLOBAL(zheequb,ZHEEQUB)(void);
void FC_GLOBAL(zheev,ZHEEV)(void);
void FC_GLOBAL(zheev_2stage,ZHEEV_2STAGE)(void);
void FC_GLOBAL(zheevd,ZHEEVD)(void);
void FC_GLOBAL(zheevd_2stage,ZHEEVD_2STAGE)(void);
void FC_GLOBAL(zheevr,ZHEEVR)(void);
void FC_GLOBAL(zheevr_2stage,ZHEEVR_2STAGE)(void);
void FC_GLOBAL(zheevx,ZHEEVX)(void);
void FC_GLOBAL(zheevx_2stage,ZHEEVX_2STAGE)(void);
void FC_GLOBAL(zhegs2,ZHEGS2)(void);
void FC_GLOBAL(zhegst,ZHEGST)(void);
void FC_GLOBAL(zhegv,ZHEGV)(void);
void FC_GLOBAL(zhegv_2stage,ZHEGV_2STAGE)(void);
void FC_GLOBAL(zhegvd,ZHEGVD)(void);
void FC_GLOBAL(zhegvx,ZHEGVX)(void);
void FC_GLOBAL(zherfs,ZHERFS)(void);
void FC_GLOBAL(zhesv,ZHESV)(void);
void FC_GLOBAL(zhesv_aa,ZHESV_AA)(void);
void FC_GLOBAL(zhesv_aa_2stage,ZHESV_AA_2STAGE)(void);
void FC_GLOBAL(zhesv_rk,ZHESV_RK)(void);
void FC_GLOBAL(zhesv_rook,ZHESV_ROOK)(void);
void FC_GLOBAL(zhesvx,ZHESVX)(void);
void FC_GLOBAL(zheswapr,ZHESWAPR)(void);
void FC_GLOBAL(zhetd2,ZHETD2)(void);
void FC_GLOBAL(zhetf2,ZHETF2)(void);
void FC_GLOBAL(zhetf2_rk,ZHETF2_RK)(void);
void FC_GLOBAL(zhetf2_rook,ZHETF2_ROOK)(void);
void FC_GLOBAL(zhetrd,ZHETRD)(void);
void FC_GLOBAL(zhetrd_2stage,ZHETRD_2STAGE)(void);
void FC_GLOBAL(zhetrd_hb2st,ZHETRD_HB2ST)(void);
void FC_GLOBAL(zhetrd_he2hb,ZHETRD_HE2HB)(void);
void FC_GLOBAL(zhetrf,ZHETRF)(void);
void FC_GLOBAL(zhetrf_aa,ZHETRF_AA)(void);
void FC_GLOBAL(zhetrf_aa_2stage,ZHETRF_AA_2STAGE)(void);
void FC_GLOBAL(zhetrf_rk,ZHETRF_RK)(void);
void FC_GLOBAL(zhetrf_rook,ZHETRF_ROOK)(void);
void FC_GLOBAL(zhetri,ZHETRI)(void);
void FC_GLOBAL(zhetri2,ZHETRI2)(void);
void FC_GLOBAL(zhetri2x,ZHETRI2X)(void);
void FC_GLOBAL(zhetri_3,ZHETRI_3)(void);
void FC_GLOBAL(zhetri_3x,ZHETRI_3X)(void);
void FC_GLOBAL(zhetri_rook,ZHETRI_ROOK)(void);
void FC_GLOBAL(zhetrs,ZHETRS)(void);
void FC_GLOBAL(zhetrs2,ZHETRS2)(void);
void FC_GLOBAL(zhetrs_3,ZHETRS_3)(void);
void FC_GLOBAL(zhetrs_aa,ZHETRS_AA)(void);
void FC_GLOBAL(zhetrs_aa_2stage,ZHETRS_AA_2STAGE)(void);
void FC_GLOBAL(zhetrs_rook,ZHETRS_ROOK)(void);
void FC_GLOBAL(zhfrk,ZHFRK)(void);
void FC_GLOBAL(zhgeqz,ZHGEQZ)(void);
void FC_GLOBAL(zhpcon,ZHPCON)(void);
void FC_GLOBAL(zhpev,ZHPEV)(void);
void FC_GLOBAL(zhpevd,ZHPEVD)(void);
void FC_GLOBAL(zhpevx,ZHPEVX)(void);
void FC_GLOBAL(zhpgst,ZHPGST)(void);
void FC_GLOBAL(zhpgv,ZHPGV)(void);
void FC_GLOBAL(zhpgvd,ZHPGVD)(void);
void FC_GLOBAL(zhpgvx,ZHPGVX)(void);
void FC_GLOBAL(zhprfs,ZHPRFS)(void);
void FC_GLOBAL(zhpsv,ZHPSV)(void);
void FC_GLOBAL(zhpsvx,ZHPSVX)(void);
void FC_GLOBAL(zhptrd,ZHPTRD)(void);
void FC_GLOBAL(zhptrf,ZHPTRF)(void);
void FC_GLOBAL(zhptri,ZHPTRI)(void);
void FC_GLOBAL(zhptrs,ZHPTRS)(void);
void FC_GLOBAL(zhsein,ZHSEIN)(void);
void FC_GLOBAL(zhseqr,ZHSEQR)(void);
void FC_GLOBAL(zlabrd,ZLABRD)(void);
void FC_GLOBAL(zlacgv,ZLACGV)(void);
void FC_GLOBAL(zlacn2,ZLACN2)(void);
void FC_GLOBAL(zlacon,ZLACON)(void);
void FC_GLOBAL(zlacp2,ZLACP2)(void);
void FC_GLOBAL(zlacpy,ZLACPY)(void);
void FC_GLOBAL(zlacrm,ZLACRM)(void);
void FC_GLOBAL(zlacrt,ZLACRT)(void);
void FC_GLOBAL(zladiv,ZLADIV)(void);
void FC_GLOBAL(zlaed0,ZLAED0)(void);
void FC_GLOBAL(zlaed7,ZLAED7)(void);
void FC_GLOBAL(zlaed8,ZLAED8)(void);
void FC_GLOBAL(zlaein,ZLAEIN)(void);
void FC_GLOBAL(zlaesy,ZLAESY)(void);
void FC_GLOBAL(zlaev2,ZLAEV2)(void);
void FC_GLOBAL(zlag2c,ZLAG2C)(void);
void FC_GLOBAL(zlags2,ZLAGS2)(void);
void FC_GLOBAL(zlagtm,ZLAGTM)(void);
void FC_GLOBAL(zlahef,ZLAHEF)(void);
void FC_GLOBAL(zlahef_aa,ZLAHEF_AA)(void);
void FC_GLOBAL(zlahef_rk,ZLAHEF_RK)(void);
void FC_GLOBAL(zlahef_rook,ZLAHEF_ROOK)(void);
void FC_GLOBAL(zlahqr,ZLAHQR)(void);
void FC_GLOBAL(zlahr2,ZLAHR2)(void);
void FC_GLOBAL(zlaic1,ZLAIC1)(void);
void FC_GLOBAL(zlals0,ZLALS0)(void);
void FC_GLOBAL(zlalsa,ZLALSA)(void);
void FC_GLOBAL(zlalsd,ZLALSD)(void);
void FC_GLOBAL(zlamswlq,ZLAMSWLQ)(void);
void FC_GLOBAL(zlamtsqr,ZLAMTSQR)(void);
void FC_GLOBAL(zlangb,ZLANGB)(void);
void FC_GLOBAL(zlange,ZLANGE)(void);
void FC_GLOBAL(zlangt,ZLANGT)(void);
void FC_GLOBAL(zlanhb,ZLANHB)(void);
void FC_GLOBAL(zlanhe,ZLANHE)(void);
void FC_GLOBAL(zlanhf,ZLANHF)(void);
void FC_GLOBAL(zlanhp,ZLANHP)(void);
void FC_GLOBAL(zlanhs,ZLANHS)(void);
void FC_GLOBAL(zlanht,ZLANHT)(void);
void FC_GLOBAL(zlansb,ZLANSB)(void);
void FC_GLOBAL(zlansp,ZLANSP)(void);
void FC_GLOBAL(zlansy,ZLANSY)(void);
void FC_GLOBAL(zlantb,ZLANTB)(void);
void FC_GLOBAL(zlantp,ZLANTP)(void);
void FC_GLOBAL(zlantr,ZLANTR)(void);
void FC_GLOBAL(zlapll,ZLAPLL)(void);
void FC_GLOBAL(zlapmr,ZLAPMR)(void);
void FC_GLOBAL(zlapmt,ZLAPMT)(void);
void FC_GLOBAL(zlaqgb,ZLAQGB)(void);
void FC_GLOBAL(zlaqge,ZLAQGE)(void);
void FC_GLOBAL(zlaqhb,ZLAQHB)(void);
void FC_GLOBAL(zlaqhe,ZLAQHE)(void);
void FC_GLOBAL(zlaqhp,ZLAQHP)(void);
void FC_GLOBAL(zlaqp2,ZLAQP2)(void);
void FC_GLOBAL(zlaqps,ZLAQPS)(void);
void FC_GLOBAL(zlaqr0,ZLAQR0)(void);
void FC_GLOBAL(zlaqr1,ZLAQR1)(void);
void FC_GLOBAL(zlaqr2,ZLAQR2)(void);
void FC_GLOBAL(zlaqr3,ZLAQR3)(void);
void FC_GLOBAL(zlaqr4,ZLAQR4)(void);
void FC_GLOBAL(zlaqr5,ZLAQR5)(void);
void FC_GLOBAL(zlaqsb,ZLAQSB)(void);
void FC_GLOBAL(zlaqsp,ZLAQSP)(void);
void FC_GLOBAL(zlaqsy,ZLAQSY)(void);
void FC_GLOBAL(zlaqz0,ZLAQZ0)(void);
void FC_GLOBAL(zlaqz1,ZLAQZ1)(void);
void FC_GLOBAL(zlaqz2,ZLAQZ2)(void);
void FC_GLOBAL(zlaqz3,ZLAQZ3)(void);
void FC_GLOBAL(zlar1v,ZLAR1V)(void);
void FC_GLOBAL(zlar2v,ZLAR2V)(void);
void FC_GLOBAL(zlarcm,ZLARCM)(void);
void FC_GLOBAL(zlarf,ZLARF)(void);
void FC_GLOBAL(zlarfb,ZLARFB)(void);
void FC_GLOBAL(zlarfb_gett,ZLARFB_GETT)(void);
void FC_GLOBAL(zlarfg,ZLARFG)(void);
void FC_GLOBAL(zlarfgp,ZLARFGP)(void);
void FC_GLOBAL(zlarft,ZLARFT)(void);
void FC_GLOBAL(zlarfx,ZLARFX)(void);
void FC_GLOBAL(zlarfy,ZLARFY)(void);
void FC_GLOBAL(zlargv,ZLARGV)(void);
void FC_GLOBAL(zlarnv,ZLARNV)(void);
void FC_GLOBAL(zlarrv,ZLARRV)(void);
void FC_GLOBAL(zlartg,ZLARTG)(void);
void FC_GLOBAL(zlartv,ZLARTV)(void);
void FC_GLOBAL(zlarz,ZLARZ)(void);
void FC_GLOBAL(zlarzb,ZLARZB)(void);
void FC_GLOBAL(zlarzt,ZLARZT)(void);
void FC_GLOBAL(zlascl,ZLASCL)(void);
void FC_GLOBAL(zlaset,ZLASET)(void);
void FC_GLOBAL(zlasr,ZLASR)(void);
void FC_GLOBAL(zlassq,ZLASSQ)(void);
void FC_GLOBAL(zlaswlq,ZLASWLQ)(void);
void FC_GLOBAL(zlaswp,ZLASWP)(void);
void FC_GLOBAL(zlasyf,ZLASYF)(void);
void FC_GLOBAL(zlasyf_aa,ZLASYF_AA)(void);
void FC_GLOBAL(zlasyf_rk,ZLASYF_RK)(void);
void FC_GLOBAL(zlasyf_rook,ZLASYF_ROOK)(void);
void FC_GLOBAL(zlat2c,ZLAT2C)(void);
void FC_GLOBAL(zlatbs,ZLATBS)(void);
void FC_GLOBAL(zlatdf,ZLATDF)(void);
void FC_GLOBAL(zlatps,ZLATPS)(void);
void FC_GLOBAL(zlatrd,ZLATRD)(void);
void FC_GLOBAL(zlatrs,ZLATRS)(void);
void FC_GLOBAL(zlatrs3,ZLATRS3)(void);
void FC_GLOBAL(zlatrz,ZLATRZ)(void);
void FC_GLOBAL(zlatsqr,ZLATSQR)(void);
void FC_GLOBAL(zlaunhr_col_getrfnp,ZLAUNHR_COL_GETRFNP)(void);
void FC_GLOBAL(zlaunhr_col_getrfnp2,ZLAUNHR_COL_GETRFNP2)(void);
void FC_GLOBAL(zlauu2,ZLAUU2)(void);
void FC_GLOBAL(zlauum,ZLAUUM)(void);
void FC_GLOBAL(zpbcon,ZPBCON)(void);
void FC_GLOBAL(zpbequ,ZPBEQU)(void);
void FC_GLOBAL(zpbrfs,ZPBRFS)(void);
void FC_GLOBAL(zpbstf,ZPBSTF)(void);
void FC_GLOBAL(zpbsv,ZPBSV)(void);
void FC_GLOBAL(zpbsvx,ZPBSVX)(void);
void FC_GLOBAL(zpbtf2,ZPBTF2)(void);
void FC_GLOBAL(zpbtrf,ZPBTRF)(void);
void FC_GLOBAL(zpbtrs,ZPBTRS)(void);
void FC_GLOBAL(zpftrf,ZPFTRF)(void);
void FC_GLOBAL(zpftri,ZPFTRI)(void);
void FC_GLOBAL(zpftrs,ZPFTRS)(void);
void FC_GLOBAL(zpocon,ZPOCON)(void);
void FC_GLOBAL(zpoequ,ZPOEQU)(void);
void FC_GLOBAL(zpoequb,ZPOEQUB)(void);
void FC_GLOBAL(zporfs,ZPORFS)(void);
void FC_GLOBAL(zposv,ZPOSV)(void);
void FC_GLOBAL(zposvx,ZPOSVX)(void);
void FC_GLOBAL(zpotf2,ZPOTF2)(void);
void FC_GLOBAL(zpotrf,ZPOTRF)(void);
void FC_GLOBAL(zpotrf2,ZPOTRF2)(void);
void FC_GLOBAL(zpotri,ZPOTRI)(void);
void FC_GLOBAL(zpotrs,ZPOTRS)(void);
void FC_GLOBAL(zppcon,ZPPCON)(void);
void FC_GLOBAL(zppequ,ZPPEQU)(void);
void FC_GLOBAL(zpprfs,ZPPRFS)(void);
void FC_GLOBAL(zppsv,ZPPSV)(void);
void FC_GLOBAL(zppsvx,ZPPSVX)(void);
void FC_GLOBAL(zpptrf,ZPPTRF)(void);
void FC_GLOBAL(zpptri,ZPPTRI)(void);
void FC_GLOBAL(zpptrs,ZPPTRS)(void);
void FC_GLOBAL(zpstf2,ZPSTF2)(void);
void FC_GLOBAL(zpstrf,ZPSTRF)(void);
void FC_GLOBAL(zptcon,ZPTCON)(void);
void FC_GLOBAL(zpteqr,ZPTEQR)(void);
void FC_GLOBAL(zptrfs,ZPTRFS)(void);
void FC_GLOBAL(zptsv,ZPTSV)(void);
void FC_GLOBAL(zptsvx,ZPTSVX)(void);
void FC_GLOBAL(zpttrf,ZPTTRF)(void);
void FC_GLOBAL(zpttrs,ZPTTRS)(void);
void FC_GLOBAL(zptts2,ZPTTS2)(void);
void FC_GLOBAL(zrot,ZROT)(void);
void FC_GLOBAL(zspcon,ZSPCON)(void);
void FC_GLOBAL(zspmv,ZSPMV)(void);
void FC_GLOBAL(zspr,ZSPR)(void);
void FC_GLOBAL(zsprfs,ZSPRFS)(void);
void FC_GLOBAL(zspsv,ZSPSV)(void);
void FC_GLOBAL(zspsvx,ZSPSVX)(void);
void FC_GLOBAL(zsptrf,ZSPTRF)(void);
void FC_GLOBAL(zsptri,ZSPTRI)(void);
void FC_GLOBAL(zsptrs,ZSPTRS)(void);
void FC_GLOBAL(zstedc,ZSTEDC)(void);
void FC_GLOBAL(zstegr,ZSTEGR)(void);
void FC_GLOBAL(zstein,ZSTEIN)(void);
void FC_GLOBAL(zstemr,ZSTEMR)(void);
void FC_GLOBAL(zsteqr,ZSTEQR)(void);
void FC_GLOBAL(zsycon,ZSYCON)(void);
void FC_GLOBAL(zsycon_3,ZSYCON_3)(void);
void FC_GLOBAL(zsycon_rook,ZSYCON_ROOK)(void);
void FC_GLOBAL(zsyconv,ZSYCONV)(void);
void FC_GLOBAL(zsyconvf,ZSYCONVF)(void);
void FC_GLOBAL(zsyconvf_rook,ZSYCONVF_ROOK)(void);
void FC_GLOBAL(zsyequb,ZSYEQUB)(void);
void FC_GLOBAL(zsymv,ZSYMV)(void);
void FC_GLOBAL(zsyr,ZSYR)(void);
void FC_GLOBAL(zsyrfs,ZSYRFS)(void);
void FC_GLOBAL(zsysv,ZSYSV)(void);
void FC_GLOBAL(zsysv_aa,ZSYSV_AA)(void);
void FC_GLOBAL(zsysv_aa_2stage,ZSYSV_AA_2STAGE)(void);
void FC_GLOBAL(zsysv_rk,ZSYSV_RK)(void);
void FC_GLOBAL(zsysv_rook,ZSYSV_ROOK)(void);
void FC_GLOBAL(zsysvx,ZSYSVX)(void);
void FC_GLOBAL(zsyswapr,ZSYSWAPR)(void);
void FC_GLOBAL(zsytf2,ZSYTF2)(void);
void FC_GLOBAL(zsytf2_rk,ZSYTF2_RK)(void);
void FC_GLOBAL(zsytf2_rook,ZSYTF2_ROOK)(void);
void FC_GLOBAL(zsytrf,ZSYTRF)(void);
void FC_GLOBAL(zsytrf_aa,ZSYTRF_AA)(void);
void FC_GLOBAL(zsytrf_aa_2stage,ZSYTRF_AA_2STAGE)(void);
void FC_GLOBAL(zsytrf_rk,ZSYTRF_RK)(void);
void FC_GLOBAL(zsytrf_rook,ZSYTRF_ROOK)(void);
void FC_GLOBAL(zsytri,ZSYTRI)(void);
void FC_GLOBAL(zsytri2,ZSYTRI2)(void);
void FC_GLOBAL(zsytri2x,ZSYTRI2X)(void);
void FC_GLOBAL(zsytri_3,ZSYTRI_3)(void);
void FC_GLOBAL(zsytri_3x,ZSYTRI_3X)(void);
void FC_GLOBAL(zsytri_rook,ZSYTRI_ROOK)(void);
void FC_GLOBAL(zsytrs,ZSYTRS)(void);
void FC_GLOBAL(zsytrs2,ZSYTRS2)(void);
void FC_GLOBAL(zsytrs_3,ZSYTRS_3)(void);
void FC_GLOBAL(zsytrs_aa,ZSYTRS_AA)(void);
void FC_GLOBAL(zsytrs_aa_2stage,ZSYTRS_AA_2STAGE)(void);
void FC_GLOBAL(zsytrs_rook,ZSYTRS_ROOK)(void);
void FC_GLOBAL(ztbcon,ZTBCON)(void);
void FC_GLOBAL(ztbrfs,ZTBRFS)(void);
void FC_GLOBAL(ztbtrs,ZTBTRS)(void);
void FC_GLOBAL(ztfsm,ZTFSM)(void);
void FC_GLOBAL(ztftri,ZTFTRI)(void);
void FC_GLOBAL(ztfttp,ZTFTTP)(void);
void FC_GLOBAL(ztfttr,ZTFTTR)(void);
void FC_GLOBAL(ztgevc,ZTGEVC)(void);
void FC_GLOBAL(ztgex2,ZTGEX2)(void);
void FC_GLOBAL(ztgexc,ZTGEXC)(void);
void FC_GLOBAL(ztgsen,ZTGSEN)(void);
void FC_GLOBAL(ztgsja,ZTGSJA)(void);
void FC_GLOBAL(ztgsna,ZTGSNA)(void);
void FC_GLOBAL(ztgsy2,ZTGSY2)(void);
void FC_GLOBAL(ztgsyl,ZTGSYL)(void);
void FC_GLOBAL(ztpcon,ZTPCON)(void);
void FC_GLOBAL(ztplqt,ZTPLQT)(void);
void FC_GLOBAL(ztplqt2,ZTPLQT2)(void);
void FC_GLOBAL(ztpmlqt,ZTPMLQT)(void);
void FC_GLOBAL(ztpmqrt,ZTPMQRT)(void);
void FC_GLOBAL(ztpqrt,ZTPQRT)(void);
void FC_GLOBAL(ztpqrt2,ZTPQRT2)(void);
void FC_GLOBAL(ztprfb,ZTPRFB)(void);
void FC_GLOBAL(ztprfs,ZTPRFS)(void);
void FC_GLOBAL(ztptri,ZTPTRI)(void);
void FC_GLOBAL(ztptrs,ZTPTRS)(void);
void FC_GLOBAL(ztpttf,ZTPTTF)(void);
void FC_GLOBAL(ztpttr,ZTPTTR)(void);
void FC_GLOBAL(ztrcon,ZTRCON)(void);
void FC_GLOBAL(ztrevc,ZTREVC)(void);
void FC_GLOBAL(ztrevc3,ZTREVC3)(void);
void FC_GLOBAL(ztrexc,ZTREXC)(void);
void FC_GLOBAL(ztrrfs,ZTRRFS)(void);
void FC_GLOBAL(ztrsen,ZTRSEN)(void);
void FC_GLOBAL(ztrsna,ZTRSNA)(void);
void FC_GLOBAL(ztrsyl,ZTRSYL)(void);
void FC_GLOBAL(ztrsyl3,ZTRSYL3)(void);
void FC_GLOBAL(ztrti2,ZTRTI2)(void);
void FC_GLOBAL(ztrtri,ZTRTRI)(void);
void FC_GLOBAL(ztrtrs,ZTRTRS)(void);
void FC_GLOBAL(ztrttf,ZTRTTF)(void);
void FC_GLOBAL(ztrttp,ZTRTTP)(void);
void FC_GLOBAL(ztzrzf,ZTZRZF)(void);
void FC_GLOBAL(zunbdb,ZUNBDB)(void);
void FC_GLOBAL(zunbdb1,ZUNBDB1)(void);
void FC_GLOBAL(zunbdb2,ZUNBDB2)(void);
void FC_GLOBAL(zunbdb3,ZUNBDB3)(void);
void FC_GLOBAL(zunbdb4,ZUNBDB4)(void);
void FC_GLOBAL(zunbdb5,ZUNBDB5)(void);
void FC_GLOBAL(zunbdb6,ZUNBDB6)(void);
void FC_GLOBAL(zuncsd,ZUNCSD)(void);
void FC_GLOBAL(zuncsd2by1,ZUNCSD2BY1)(void);
void FC_GLOBAL(zung2l,ZUNG2L)(void);
void FC_GLOBAL(zung2r,ZUNG2R)(void);
void FC_GLOBAL(zungbr,ZUNGBR)(void);
void FC_GLOBAL(zunghr,ZUNGHR)(void);
void FC_GLOBAL(zungl2,ZUNGL2)(void);
void FC_GLOBAL(zunglq,ZUNGLQ)(void);
void FC_GLOBAL(zungql,ZUNGQL)(void);
void FC_GLOBAL(zungqr,ZUNGQR)(void);
void FC_GLOBAL(zungr2,ZUNGR2)(void);
void FC_GLOBAL(zungrq,ZUNGRQ)(void);
void FC_GLOBAL(zungtr,ZUNGTR)(void);
void FC_GLOBAL(zungtsqr,ZUNGTSQR)(void);
void FC_GLOBAL(zungtsqr_row,ZUNGTSQR_ROW)(void);
void FC_GLOBAL(zunhr_col,ZUNHR_COL)(void);
void FC_GLOBAL(zunm22,ZUNM22)(void);
void FC_GLOBAL(zunm2l,ZUNM2L)(void);
void FC_GLOBAL(zunm2r,ZUNM2R)(void);
void FC_GLOBAL(zunmbr,ZUNMBR)(void);
void FC_GLOBAL(zunmhr,ZUNMHR)(void);
void FC_GLOBAL(zunml2,ZUNML2)(void);
void FC_GLOBAL(zunmlq,ZUNMLQ)(void);
void FC_GLOBAL(zunmql,ZUNMQL)(void);
void FC_GLOBAL(zunmqr,ZUNMQR)(void);
void FC_GLOBAL(zunmr2,ZUNMR2)(void);
void FC_GLOBAL(zunmr3,ZUNMR3)(void);
void FC_GLOBAL(zunmrq,ZUNMRQ)(void);
void FC_GLOBAL(zunmrz,ZUNMRZ)(void);
void FC_GLOBAL(zunmtr,ZUNMTR)(void);
void FC_GLOBAL(zupgtr,ZUPGTR)(void);
void FC_GLOBAL(zupmtr,ZUPMTR)(void);

HIDDEN void flexiblas_lapack_dummy_function_not_called(void)
{
    FC_GLOBAL(cbbcsd,CBBCSD)();
    FC_GLOBAL(cbdsqr,CBDSQR)();
    FC_GLOBAL(cgbbrd,CGBBRD)();
    FC_GLOBAL(cgbcon,CGBCON)();
    FC_GLOBAL(cgbequ,CGBEQU)();
    FC_GLOBAL(cgbequb,CGBEQUB)();
    FC_GLOBAL(cgbrfs,CGBRFS)();
    FC_GLOBAL(cgbsv,CGBSV)();
    FC_GLOBAL(cgbsvx,CGBSVX)();
    FC_GLOBAL(cgbtf2,CGBTF2)();
    FC_GLOBAL(cgbtrf,CGBTRF)();
    FC_GLOBAL(cgbtrs,CGBTRS)();
    FC_GLOBAL(cgebak,CGEBAK)();
    FC_GLOBAL(cgebal,CGEBAL)();
    FC_GLOBAL(cgebd2,CGEBD2)();
    FC_GLOBAL(cgebrd,CGEBRD)();
    FC_GLOBAL(cgecon,CGECON)();
    FC_GLOBAL(cgeequ,CGEEQU)();
    FC_GLOBAL(cgeequb,CGEEQUB)();
    FC_GLOBAL(cgees,CGEES)();
    FC_GLOBAL(cgeesx,CGEESX)();
    FC_GLOBAL(cgeev,CGEEV)();
    FC_GLOBAL(cgeevx,CGEEVX)();
    FC_GLOBAL(cgehd2,CGEHD2)();
    FC_GLOBAL(cgehrd,CGEHRD)();
    FC_GLOBAL(cgejsv,CGEJSV)();
    FC_GLOBAL(cgelq,CGELQ)();
    FC_GLOBAL(cgelq2,CGELQ2)();
    FC_GLOBAL(cgelqf,CGELQF)();
    FC_GLOBAL(cgelqt,CGELQT)();
    FC_GLOBAL(cgelqt3,CGELQT3)();
    FC_GLOBAL(cgels,CGELS)();
    FC_GLOBAL(cgelsd,CGELSD)();
    FC_GLOBAL(cgelss,CGELSS)();
    FC_GLOBAL(cgelst,CGELST)();
    FC_GLOBAL(cgelsy,CGELSY)();
    FC_GLOBAL(cgemlq,CGEMLQ)();
    FC_GLOBAL(cgemlqt,CGEMLQT)();
    FC_GLOBAL(cgemqr,CGEMQR)();
    FC_GLOBAL(cgemqrt,CGEMQRT)();
    FC_GLOBAL(cgeql2,CGEQL2)();
    FC_GLOBAL(cgeqlf,CGEQLF)();
    FC_GLOBAL(cgeqp3,CGEQP3)();
    FC_GLOBAL(cgeqr,CGEQR)();
    FC_GLOBAL(cgeqr2,CGEQR2)();
    FC_GLOBAL(cgeqr2p,CGEQR2P)();
    FC_GLOBAL(cgeqrf,CGEQRF)();
    FC_GLOBAL(cgeqrfp,CGEQRFP)();
    FC_GLOBAL(cgeqrt,CGEQRT)();
    FC_GLOBAL(cgeqrt2,CGEQRT2)();
    FC_GLOBAL(cgeqrt3,CGEQRT3)();
    FC_GLOBAL(cgerfs,CGERFS)();
    FC_GLOBAL(cgerq2,CGERQ2)();
    FC_GLOBAL(cgerqf,CGERQF)();
    FC_GLOBAL(cgesc2,CGESC2)();
    FC_GLOBAL(cgesdd,CGESDD)();
    FC_GLOBAL(cgesv,CGESV)();
    FC_GLOBAL(cgesvd,CGESVD)();
    FC_GLOBAL(cgesvdq,CGESVDQ)();
    FC_GLOBAL(cgesvdx,CGESVDX)();
    FC_GLOBAL(cgesvj,CGESVJ)();
    FC_GLOBAL(cgesvx,CGESVX)();
    FC_GLOBAL(cgetc2,CGETC2)();
    FC_GLOBAL(cgetf2,CGETF2)();
    FC_GLOBAL(cgetrf,CGETRF)();
    FC_GLOBAL(cgetrf2,CGETRF2)();
    FC_GLOBAL(cgetri,CGETRI)();
    FC_GLOBAL(cgetrs,CGETRS)();
    FC_GLOBAL(cgetsls,CGETSLS)();
    FC_GLOBAL(cgetsqrhrt,CGETSQRHRT)();
    FC_GLOBAL(cggbak,CGGBAK)();
    FC_GLOBAL(cggbal,CGGBAL)();
    FC_GLOBAL(cgges,CGGES)();
    FC_GLOBAL(cgges3,CGGES3)();
    FC_GLOBAL(cggesx,CGGESX)();
    FC_GLOBAL(cggev,CGGEV)();
    FC_GLOBAL(cggev3,CGGEV3)();
    FC_GLOBAL(cggevx,CGGEVX)();
    FC_GLOBAL(cggglm,CGGGLM)();
    FC_GLOBAL(cgghd3,CGGHD3)();
    FC_GLOBAL(cgghrd,CGGHRD)();
    FC_GLOBAL(cgglse,CGGLSE)();
    FC_GLOBAL(cggqrf,CGGQRF)();
    FC_GLOBAL(cggrqf,CGGRQF)();
    FC_GLOBAL(cggsvd3,CGGSVD3)();
    FC_GLOBAL(cggsvp3,CGGSVP3)();
    FC_GLOBAL(cgsvj0,CGSVJ0)();
    FC_GLOBAL(cgsvj1,CGSVJ1)();
    FC_GLOBAL(cgtcon,CGTCON)();
    FC_GLOBAL(cgtrfs,CGTRFS)();
    FC_GLOBAL(cgtsv,CGTSV)();
    FC_GLOBAL(cgtsvx,CGTSVX)();
    FC_GLOBAL(cgttrf,CGTTRF)();
    FC_GLOBAL(cgttrs,CGTTRS)();
    FC_GLOBAL(cgtts2,CGTTS2)();
    FC_GLOBAL(chb2st_kernels,CHB2ST_KERNELS)();
    FC_GLOBAL(chbev,CHBEV)();
    FC_GLOBAL(chbev_2stage,CHBEV_2STAGE)();
    FC_GLOBAL(chbevd,CHBEVD)();
    FC_GLOBAL(chbevd_2stage,CHBEVD_2STAGE)();
    FC_GLOBAL(chbevx,CHBEVX)();
    FC_GLOBAL(chbevx_2stage,CHBEVX_2STAGE)();
    FC_GLOBAL(chbgst,CHBGST)();
    FC_GLOBAL(chbgv,CHBGV)();
    FC_GLOBAL(chbgvd,CHBGVD)();
    FC_GLOBAL(chbgvx,CHBGVX)();
    FC_GLOBAL(chbtrd,CHBTRD)();
    FC_GLOBAL(checon,CHECON)();
    FC_GLOBAL(checon_3,CHECON_3)();
    FC_GLOBAL(checon_rook,CHECON_ROOK)();
    FC_GLOBAL(cheequb,CHEEQUB)();
    FC_GLOBAL(cheev,CHEEV)();
    FC_GLOBAL(cheev_2stage,CHEEV_2STAGE)();
    FC_GLOBAL(cheevd,CHEEVD)();
    FC_GLOBAL(cheevd_2stage,CHEEVD_2STAGE)();
    FC_GLOBAL(cheevr,CHEEVR)();
    FC_GLOBAL(cheevr_2stage,CHEEVR_2STAGE)();
    FC_GLOBAL(cheevx,CHEEVX)();
    FC_GLOBAL(cheevx_2stage,CHEEVX_2STAGE)();
    FC_GLOBAL(chegs2,CHEGS2)();
    FC_GLOBAL(chegst,CHEGST)();
    FC_GLOBAL(chegv,CHEGV)();
    FC_GLOBAL(chegv_2stage,CHEGV_2STAGE)();
    FC_GLOBAL(chegvd,CHEGVD)();
    FC_GLOBAL(chegvx,CHEGVX)();
    FC_GLOBAL(cherfs,CHERFS)();
    FC_GLOBAL(chesv,CHESV)();
    FC_GLOBAL(chesv_aa,CHESV_AA)();
    FC_GLOBAL(chesv_aa_2stage,CHESV_AA_2STAGE)();
    FC_GLOBAL(chesv_rk,CHESV_RK)();
    FC_GLOBAL(chesv_rook,CHESV_ROOK)();
    FC_GLOBAL(chesvx,CHESVX)();
    FC_GLOBAL(cheswapr,CHESWAPR)();
    FC_GLOBAL(chetd2,CHETD2)();
    FC_GLOBAL(chetf2,CHETF2)();
    FC_GLOBAL(chetf2_rk,CHETF2_RK)();
    FC_GLOBAL(chetf2_rook,CHETF2_ROOK)();
    FC_GLOBAL(chetrd,CHETRD)();
    FC_GLOBAL(chetrd_2stage,CHETRD_2STAGE)();
    FC_GLOBAL(chetrd_hb2st,CHETRD_HB2ST)();
    FC_GLOBAL(chetrd_he2hb,CHETRD_HE2HB)();
    FC_GLOBAL(chetrf,CHETRF)();
    FC_GLOBAL(chetrf_aa,CHETRF_AA)();
    FC_GLOBAL(chetrf_aa_2stage,CHETRF_AA_2STAGE)();
    FC_GLOBAL(chetrf_rk,CHETRF_RK)();
    FC_GLOBAL(chetrf_rook,CHETRF_ROOK)();
    FC_GLOBAL(chetri,CHETRI)();
    FC_GLOBAL(chetri2,CHETRI2)();
    FC_GLOBAL(chetri2x,CHETRI2X)();
    FC_GLOBAL(chetri_3,CHETRI_3)();
    FC_GLOBAL(chetri_3x,CHETRI_3X)();
    FC_GLOBAL(chetri_rook,CHETRI_ROOK)();
    FC_GLOBAL(chetrs,CHETRS)();
    FC_GLOBAL(chetrs2,CHETRS2)();
    FC_GLOBAL(chetrs_3,CHETRS_3)();
    FC_GLOBAL(chetrs_aa,CHETRS_AA)();
    FC_GLOBAL(chetrs_aa_2stage,CHETRS_AA_2STAGE)();
    FC_GLOBAL(chetrs_rook,CHETRS_ROOK)();
    FC_GLOBAL(chfrk,CHFRK)();
    FC_GLOBAL(chgeqz,CHGEQZ)();
    FC_GLOBAL(chla_transtype,CHLA_TRANSTYPE)();
    FC_GLOBAL(chpcon,CHPCON)();
    FC_GLOBAL(chpev,CHPEV)();
    FC_GLOBAL(chpevd,CHPEVD)();
    FC_GLOBAL(chpevx,CHPEVX)();
    FC_GLOBAL(chpgst,CHPGST)();
    FC_GLOBAL(chpgv,CHPGV)();
    FC_GLOBAL(chpgvd,CHPGVD)();
    FC_GLOBAL(chpgvx,CHPGVX)();
    FC_GLOBAL(chprfs,CHPRFS)();
    FC_GLOBAL(chpsv,CHPSV)();
    FC_GLOBAL(chpsvx,CHPSVX)();
    FC_GLOBAL(chptrd,CHPTRD)();
    FC_GLOBAL(chptrf,CHPTRF)();
    FC_GLOBAL(chptri,CHPTRI)();
    FC_GLOBAL(chptrs,CHPTRS)();
    FC_GLOBAL(chsein,CHSEIN)();
    FC_GLOBAL(chseqr,CHSEQR)();
    FC_GLOBAL(clabrd,CLABRD)();
    FC_GLOBAL(clacgv,CLACGV)();
    FC_GLOBAL(clacn2,CLACN2)();
    FC_GLOBAL(clacon,CLACON)();
    FC_GLOBAL(clacp2,CLACP2)();
    FC_GLOBAL(clacpy,CLACPY)();
    FC_GLOBAL(clacrm,CLACRM)();
    FC_GLOBAL(clacrt,CLACRT)();
    FC_GLOBAL(cladiv,CLADIV)();
    FC_GLOBAL(claed0,CLAED0)();
    FC_GLOBAL(claed7,CLAED7)();
    FC_GLOBAL(claed8,CLAED8)();
    FC_GLOBAL(claein,CLAEIN)();
    FC_GLOBAL(claesy,CLAESY)();
    FC_GLOBAL(claev2,CLAEV2)();
    FC_GLOBAL(clag2z,CLAG2Z)();
    FC_GLOBAL(clags2,CLAGS2)();
    FC_GLOBAL(clagtm,CLAGTM)();
    FC_GLOBAL(clahef,CLAHEF)();
    FC_GLOBAL(clahef_aa,CLAHEF_AA)();
    FC_GLOBAL(clahef_rk,CLAHEF_RK)();
    FC_GLOBAL(clahef_rook,CLAHEF_ROOK)();
    FC_GLOBAL(clahqr,CLAHQR)();
    FC_GLOBAL(clahr2,CLAHR2)();
    FC_GLOBAL(claic1,CLAIC1)();
    FC_GLOBAL(clals0,CLALS0)();
    FC_GLOBAL(clalsa,CLALSA)();
    FC_GLOBAL(clalsd,CLALSD)();
    FC_GLOBAL(clamswlq,CLAMSWLQ)();
    FC_GLOBAL(clamtsqr,CLAMTSQR)();
    FC_GLOBAL(clangb,CLANGB)();
    FC_GLOBAL(clange,CLANGE)();
    FC_GLOBAL(clangt,CLANGT)();
    FC_GLOBAL(clanhb,CLANHB)();
    FC_GLOBAL(clanhe,CLANHE)();
    FC_GLOBAL(clanhf,CLANHF)();
    FC_GLOBAL(clanhp,CLANHP)();
    FC_GLOBAL(clanhs,CLANHS)();
    FC_GLOBAL(clanht,CLANHT)();
    FC_GLOBAL(clansb,CLANSB)();
    FC_GLOBAL(clansp,CLANSP)();
    FC_GLOBAL(clansy,CLANSY)();
    FC_GLOBAL(clantb,CLANTB)();
    FC_GLOBAL(clantp,CLANTP)();
    FC_GLOBAL(clantr,CLANTR)();
    FC_GLOBAL(clapll,CLAPLL)();
    FC_GLOBAL(clapmr,CLAPMR)();
    FC_GLOBAL(clapmt,CLAPMT)();
    FC_GLOBAL(claqgb,CLAQGB)();
    FC_GLOBAL(claqge,CLAQGE)();
    FC_GLOBAL(claqhb,CLAQHB)();
    FC_GLOBAL(claqhe,CLAQHE)();
    FC_GLOBAL(claqhp,CLAQHP)();
    FC_GLOBAL(claqp2,CLAQP2)();
    FC_GLOBAL(claqps,CLAQPS)();
    FC_GLOBAL(claqr0,CLAQR0)();
    FC_GLOBAL(claqr1,CLAQR1)();
    FC_GLOBAL(claqr2,CLAQR2)();
    FC_GLOBAL(claqr3,CLAQR3)();
    FC_GLOBAL(claqr4,CLAQR4)();
    FC_GLOBAL(claqr5,CLAQR5)();
    FC_GLOBAL(claqsb,CLAQSB)();
    FC_GLOBAL(claqsp,CLAQSP)();
    FC_GLOBAL(claqsy,CLAQSY)();
    FC_GLOBAL(claqz0,CLAQZ0)();
    FC_GLOBAL(claqz1,CLAQZ1)();
    FC_GLOBAL(claqz2,CLAQZ2)();
    FC_GLOBAL(claqz3,CLAQZ3)();
    FC_GLOBAL(clar1v,CLAR1V)();
    FC_GLOBAL(clar2v,CLAR2V)();
    FC_GLOBAL(clarcm,CLARCM)();
    FC_GLOBAL(clarf,CLARF)();
    FC_GLOBAL(clarfb,CLARFB)();
    FC_GLOBAL(clarfb_gett,CLARFB_GETT)();
    FC_GLOBAL(clarfg,CLARFG)();
    FC_GLOBAL(clarfgp,CLARFGP)();
    FC_GLOBAL(clarft,CLARFT)();
    FC_GLOBAL(clarfx,CLARFX)();
    FC_GLOBAL(clarfy,CLARFY)();
    FC_GLOBAL(clargv,CLARGV)();
    FC_GLOBAL(clarnv,CLARNV)();
    FC_GLOBAL(clarrv,CLARRV)();
    FC_GLOBAL(clartg,CLARTG)();
    FC_GLOBAL(clartv,CLARTV)();
    FC_GLOBAL(clarz,CLARZ)();
    FC_GLOBAL(clarzb,CLARZB)();
    FC_GLOBAL(clarzt,CLARZT)();
    FC_GLOBAL(clascl,CLASCL)();
    FC_GLOBAL(claset,CLASET)();
    FC_GLOBAL(clasr,CLASR)();
    FC_GLOBAL(classq,CLASSQ)();
    FC_GLOBAL(claswlq,CLASWLQ)();
    FC_GLOBAL(claswp,CLASWP)();
    FC_GLOBAL(clasyf,CLASYF)();
    FC_GLOBAL(clasyf_aa,CLASYF_AA)();
    FC_GLOBAL(clasyf_rk,CLASYF_RK)();
    FC_GLOBAL(clasyf_rook,CLASYF_ROOK)();
    FC_GLOBAL(clatbs,CLATBS)();
    FC_GLOBAL(clatdf,CLATDF)();
    FC_GLOBAL(clatps,CLATPS)();
    FC_GLOBAL(clatrd,CLATRD)();
    FC_GLOBAL(clatrs,CLATRS)();
    FC_GLOBAL(clatrs3,CLATRS3)();
    FC_GLOBAL(clatrz,CLATRZ)();
    FC_GLOBAL(clatsqr,CLATSQR)();
    FC_GLOBAL(claunhr_col_getrfnp,CLAUNHR_COL_GETRFNP)();
    FC_GLOBAL(claunhr_col_getrfnp2,CLAUNHR_COL_GETRFNP2)();
    FC_GLOBAL(clauu2,CLAUU2)();
    FC_GLOBAL(clauum,CLAUUM)();
    FC_GLOBAL(cpbcon,CPBCON)();
    FC_GLOBAL(cpbequ,CPBEQU)();
    FC_GLOBAL(cpbrfs,CPBRFS)();
    FC_GLOBAL(cpbstf,CPBSTF)();
    FC_GLOBAL(cpbsv,CPBSV)();
    FC_GLOBAL(cpbsvx,CPBSVX)();
    FC_GLOBAL(cpbtf2,CPBTF2)();
    FC_GLOBAL(cpbtrf,CPBTRF)();
    FC_GLOBAL(cpbtrs,CPBTRS)();
    FC_GLOBAL(cpftrf,CPFTRF)();
    FC_GLOBAL(cpftri,CPFTRI)();
    FC_GLOBAL(cpftrs,CPFTRS)();
    FC_GLOBAL(cpocon,CPOCON)();
    FC_GLOBAL(cpoequ,CPOEQU)();
    FC_GLOBAL(cpoequb,CPOEQUB)();
    FC_GLOBAL(cporfs,CPORFS)();
    FC_GLOBAL(cposv,CPOSV)();
    FC_GLOBAL(cposvx,CPOSVX)();
    FC_GLOBAL(cpotf2,CPOTF2)();
    FC_GLOBAL(cpotrf,CPOTRF)();
    FC_GLOBAL(cpotrf2,CPOTRF2)();
    FC_GLOBAL(cpotri,CPOTRI)();
    FC_GLOBAL(cpotrs,CPOTRS)();
    FC_GLOBAL(cppcon,CPPCON)();
    FC_GLOBAL(cppequ,CPPEQU)();
    FC_GLOBAL(cpprfs,CPPRFS)();
    FC_GLOBAL(cppsv,CPPSV)();
    FC_GLOBAL(cppsvx,CPPSVX)();
    FC_GLOBAL(cpptrf,CPPTRF)();
    FC_GLOBAL(cpptri,CPPTRI)();
    FC_GLOBAL(cpptrs,CPPTRS)();
    FC_GLOBAL(cpstf2,CPSTF2)();
    FC_GLOBAL(cpstrf,CPSTRF)();
    FC_GLOBAL(cptcon,CPTCON)();
    FC_GLOBAL(cpteqr,CPTEQR)();
    FC_GLOBAL(cptrfs,CPTRFS)();
    FC_GLOBAL(cptsv,CPTSV)();
    FC_GLOBAL(cptsvx,CPTSVX)();
    FC_GLOBAL(cpttrf,CPTTRF)();
    FC_GLOBAL(cpttrs,CPTTRS)();
    FC_GLOBAL(cptts2,CPTTS2)();
    FC_GLOBAL(crot,CROT)();
    FC_GLOBAL(cspcon,CSPCON)();
    FC_GLOBAL(cspmv,CSPMV)();
    FC_GLOBAL(cspr,CSPR)();
    FC_GLOBAL(csprfs,CSPRFS)();
    FC_GLOBAL(cspsv,CSPSV)();
    FC_GLOBAL(cspsvx,CSPSVX)();
    FC_GLOBAL(csptrf,CSPTRF)();
    FC_GLOBAL(csptri,CSPTRI)();
    FC_GLOBAL(csptrs,CSPTRS)();
    FC_GLOBAL(csrscl,CSRSCL)();
    FC_GLOBAL(cstedc,CSTEDC)();
    FC_GLOBAL(cstegr,CSTEGR)();
    FC_GLOBAL(cstein,CSTEIN)();
    FC_GLOBAL(cstemr,CSTEMR)();
    FC_GLOBAL(csteqr,CSTEQR)();
    FC_GLOBAL(csycon,CSYCON)();
    FC_GLOBAL(csycon_3,CSYCON_3)();
    FC_GLOBAL(csycon_rook,CSYCON_ROOK)();
    FC_GLOBAL(csyconv,CSYCONV)();
    FC_GLOBAL(csyconvf,CSYCONVF)();
    FC_GLOBAL(csyconvf_rook,CSYCONVF_ROOK)();
    FC_GLOBAL(csyequb,CSYEQUB)();
    FC_GLOBAL(csymv,CSYMV)();
    FC_GLOBAL(csyr,CSYR)();
    FC_GLOBAL(csyrfs,CSYRFS)();
    FC_GLOBAL(csysv,CSYSV)();
    FC_GLOBAL(csysv_aa,CSYSV_AA)();
    FC_GLOBAL(csysv_aa_2stage,CSYSV_AA_2STAGE)();
    FC_GLOBAL(csysv_rk,CSYSV_RK)();
    FC_GLOBAL(csysv_rook,CSYSV_ROOK)();
    FC_GLOBAL(csysvx,CSYSVX)();
    FC_GLOBAL(csyswapr,CSYSWAPR)();
    FC_GLOBAL(csytf2,CSYTF2)();
    FC_GLOBAL(csytf2_rk,CSYTF2_RK)();
    FC_GLOBAL(csytf2_rook,CSYTF2_ROOK)();
    FC_GLOBAL(csytrf,CSYTRF)();
    FC_GLOBAL(csytrf_aa,CSYTRF_AA)();
    FC_GLOBAL(csytrf_aa_2stage,CSYTRF_AA_2STAGE)();
    FC_GLOBAL(csytrf_rk,CSYTRF_RK)();
    FC_GLOBAL(csytrf_rook,CSYTRF_ROOK)();
    FC_GLOBAL(csytri,CSYTRI)();
    FC_GLOBAL(csytri2,CSYTRI2)();
    FC_GLOBAL(csytri2x,CSYTRI2X)();
    FC_GLOBAL(csytri_3,CSYTRI_3)();
    FC_GLOBAL(csytri_3x,CSYTRI_3X)();
    FC_GLOBAL(csytri_rook,CSYTRI_ROOK)();
    FC_GLOBAL(csytrs,CSYTRS)();
    FC_GLOBAL(csytrs2,CSYTRS2)();
    FC_GLOBAL(csytrs_3,CSYTRS_3)();
    FC_GLOBAL(csytrs_aa,CSYTRS_AA)();
    FC_GLOBAL(csytrs_aa_2stage,CSYTRS_AA_2STAGE)();
    FC_GLOBAL(csytrs_rook,CSYTRS_ROOK)();
    FC_GLOBAL(ctbcon,CTBCON)();
    FC_GLOBAL(ctbrfs,CTBRFS)();
    FC_GLOBAL(ctbtrs,CTBTRS)();
    FC_GLOBAL(ctfsm,CTFSM)();
    FC_GLOBAL(ctftri,CTFTRI)();
    FC_GLOBAL(ctfttp,CTFTTP)();
    FC_GLOBAL(ctfttr,CTFTTR)();
    FC_GLOBAL(ctgevc,CTGEVC)();
    FC_GLOBAL(ctgex2,CTGEX2)();
    FC_GLOBAL(ctgexc,CTGEXC)();
    FC_GLOBAL(ctgsen,CTGSEN)();
    FC_GLOBAL(ctgsja,CTGSJA)();
    FC_GLOBAL(ctgsna,CTGSNA)();
    FC_GLOBAL(ctgsy2,CTGSY2)();
    FC_GLOBAL(ctgsyl,CTGSYL)();
    FC_GLOBAL(ctpcon,CTPCON)();
    FC_GLOBAL(ctplqt,CTPLQT)();
    FC_GLOBAL(ctplqt2,CTPLQT2)();
    FC_GLOBAL(ctpmlqt,CTPMLQT)();
    FC_GLOBAL(ctpmqrt,CTPMQRT)();
    FC_GLOBAL(ctpqrt,CTPQRT)();
    FC_GLOBAL(ctpqrt2,CTPQRT2)();
    FC_GLOBAL(ctprfb,CTPRFB)();
    FC_GLOBAL(ctprfs,CTPRFS)();
    FC_GLOBAL(ctptri,CTPTRI)();
    FC_GLOBAL(ctptrs,CTPTRS)();
    FC_GLOBAL(ctpttf,CTPTTF)();
    FC_GLOBAL(ctpttr,CTPTTR)();
    FC_GLOBAL(ctrcon,CTRCON)();
    FC_GLOBAL(ctrevc,CTREVC)();
    FC_GLOBAL(ctrevc3,CTREVC3)();
    FC_GLOBAL(ctrexc,CTREXC)();
    FC_GLOBAL(ctrrfs,CTRRFS)();
    FC_GLOBAL(ctrsen,CTRSEN)();
    FC_GLOBAL(ctrsna,CTRSNA)();
    FC_GLOBAL(ctrsyl,CTRSYL)();
    FC_GLOBAL(ctrsyl3,CTRSYL3)();
    FC_GLOBAL(ctrti2,CTRTI2)();
    FC_GLOBAL(ctrtri,CTRTRI)();
    FC_GLOBAL(ctrtrs,CTRTRS)();
    FC_GLOBAL(ctrttf,CTRTTF)();
    FC_GLOBAL(ctrttp,CTRTTP)();
    FC_GLOBAL(ctzrzf,CTZRZF)();
    FC_GLOBAL(cunbdb,CUNBDB)();
    FC_GLOBAL(cunbdb1,CUNBDB1)();
    FC_GLOBAL(cunbdb2,CUNBDB2)();
    FC_GLOBAL(cunbdb3,CUNBDB3)();
    FC_GLOBAL(cunbdb4,CUNBDB4)();
    FC_GLOBAL(cunbdb5,CUNBDB5)();
    FC_GLOBAL(cunbdb6,CUNBDB6)();
    FC_GLOBAL(cuncsd,CUNCSD)();
    FC_GLOBAL(cuncsd2by1,CUNCSD2BY1)();
    FC_GLOBAL(cung2l,CUNG2L)();
    FC_GLOBAL(cung2r,CUNG2R)();
    FC_GLOBAL(cungbr,CUNGBR)();
    FC_GLOBAL(cunghr,CUNGHR)();
    FC_GLOBAL(cungl2,CUNGL2)();
    FC_GLOBAL(cunglq,CUNGLQ)();
    FC_GLOBAL(cungql,CUNGQL)();
    FC_GLOBAL(cungqr,CUNGQR)();
    FC_GLOBAL(cungr2,CUNGR2)();
    FC_GLOBAL(cungrq,CUNGRQ)();
    FC_GLOBAL(cungtr,CUNGTR)();
    FC_GLOBAL(cungtsqr,CUNGTSQR)();
    FC_GLOBAL(cungtsqr_row,CUNGTSQR_ROW)();
    FC_GLOBAL(cunhr_col,CUNHR_COL)();
    FC_GLOBAL(cunm22,CUNM22)();
    FC_GLOBAL(cunm2l,CUNM2L)();
    FC_GLOBAL(cunm2r,CUNM2R)();
    FC_GLOBAL(cunmbr,CUNMBR)();
    FC_GLOBAL(cunmhr,CUNMHR)();
    FC_GLOBAL(cunml2,CUNML2)();
    FC_GLOBAL(cunmlq,CUNMLQ)();
    FC_GLOBAL(cunmql,CUNMQL)();
    FC_GLOBAL(cunmqr,CUNMQR)();
    FC_GLOBAL(cunmr2,CUNMR2)();
    FC_GLOBAL(cunmr3,CUNMR3)();
    FC_GLOBAL(cunmrq,CUNMRQ)();
    FC_GLOBAL(cunmrz,CUNMRZ)();
    FC_GLOBAL(cunmtr,CUNMTR)();
    FC_GLOBAL(cupgtr,CUPGTR)();
    FC_GLOBAL(cupmtr,CUPMTR)();
    FC_GLOBAL(dbbcsd,DBBCSD)();
    FC_GLOBAL(dbdsdc,DBDSDC)();
    FC_GLOBAL(dbdsqr,DBDSQR)();
    FC_GLOBAL(dbdsvdx,DBDSVDX)();
    FC_GLOBAL(ddisna,DDISNA)();
    FC_GLOBAL(dgbbrd,DGBBRD)();
    FC_GLOBAL(dgbcon,DGBCON)();
    FC_GLOBAL(dgbequ,DGBEQU)();
    FC_GLOBAL(dgbequb,DGBEQUB)();
    FC_GLOBAL(dgbrfs,DGBRFS)();
    FC_GLOBAL(dgbsv,DGBSV)();
    FC_GLOBAL(dgbsvx,DGBSVX)();
    FC_GLOBAL(dgbtf2,DGBTF2)();
    FC_GLOBAL(dgbtrf,DGBTRF)();
    FC_GLOBAL(dgbtrs,DGBTRS)();
    FC_GLOBAL(dgebak,DGEBAK)();
    FC_GLOBAL(dgebal,DGEBAL)();
    FC_GLOBAL(dgebd2,DGEBD2)();
    FC_GLOBAL(dgebrd,DGEBRD)();
    FC_GLOBAL(dgecon,DGECON)();
    FC_GLOBAL(dgeequ,DGEEQU)();
    FC_GLOBAL(dgeequb,DGEEQUB)();
    FC_GLOBAL(dgees,DGEES)();
    FC_GLOBAL(dgeesx,DGEESX)();
    FC_GLOBAL(dgeev,DGEEV)();
    FC_GLOBAL(dgeevx,DGEEVX)();
    FC_GLOBAL(dgehd2,DGEHD2)();
    FC_GLOBAL(dgehrd,DGEHRD)();
    FC_GLOBAL(dgejsv,DGEJSV)();
    FC_GLOBAL(dgelq,DGELQ)();
    FC_GLOBAL(dgelq2,DGELQ2)();
    FC_GLOBAL(dgelqf,DGELQF)();
    FC_GLOBAL(dgelqt,DGELQT)();
    FC_GLOBAL(dgelqt3,DGELQT3)();
    FC_GLOBAL(dgels,DGELS)();
    FC_GLOBAL(dgelsd,DGELSD)();
    FC_GLOBAL(dgelss,DGELSS)();
    FC_GLOBAL(dgelst,DGELST)();
    FC_GLOBAL(dgelsy,DGELSY)();
    FC_GLOBAL(dgemlq,DGEMLQ)();
    FC_GLOBAL(dgemlqt,DGEMLQT)();
    FC_GLOBAL(dgemqr,DGEMQR)();
    FC_GLOBAL(dgemqrt,DGEMQRT)();
    FC_GLOBAL(dgeql2,DGEQL2)();
    FC_GLOBAL(dgeqlf,DGEQLF)();
    FC_GLOBAL(dgeqp3,DGEQP3)();
    FC_GLOBAL(dgeqr,DGEQR)();
    FC_GLOBAL(dgeqr2,DGEQR2)();
    FC_GLOBAL(dgeqr2p,DGEQR2P)();
    FC_GLOBAL(dgeqrf,DGEQRF)();
    FC_GLOBAL(dgeqrfp,DGEQRFP)();
    FC_GLOBAL(dgeqrt,DGEQRT)();
    FC_GLOBAL(dgeqrt2,DGEQRT2)();
    FC_GLOBAL(dgeqrt3,DGEQRT3)();
    FC_GLOBAL(dgerfs,DGERFS)();
    FC_GLOBAL(dgerq2,DGERQ2)();
    FC_GLOBAL(dgerqf,DGERQF)();
    FC_GLOBAL(dgesc2,DGESC2)();
    FC_GLOBAL(dgesdd,DGESDD)();
    FC_GLOBAL(dgesv,DGESV)();
    FC_GLOBAL(dgesvd,DGESVD)();
    FC_GLOBAL(dgesvdq,DGESVDQ)();
    FC_GLOBAL(dgesvdx,DGESVDX)();
    FC_GLOBAL(dgesvj,DGESVJ)();
    FC_GLOBAL(dgesvx,DGESVX)();
    FC_GLOBAL(dgetc2,DGETC2)();
    FC_GLOBAL(dgetf2,DGETF2)();
    FC_GLOBAL(dgetrf,DGETRF)();
    FC_GLOBAL(dgetrf2,DGETRF2)();
    FC_GLOBAL(dgetri,DGETRI)();
    FC_GLOBAL(dgetrs,DGETRS)();
    FC_GLOBAL(dgetsls,DGETSLS)();
    FC_GLOBAL(dgetsqrhrt,DGETSQRHRT)();
    FC_GLOBAL(dggbak,DGGBAK)();
    FC_GLOBAL(dggbal,DGGBAL)();
    FC_GLOBAL(dgges,DGGES)();
    FC_GLOBAL(dgges3,DGGES3)();
    FC_GLOBAL(dggesx,DGGESX)();
    FC_GLOBAL(dggev,DGGEV)();
    FC_GLOBAL(dggev3,DGGEV3)();
    FC_GLOBAL(dggevx,DGGEVX)();
    FC_GLOBAL(dggglm,DGGGLM)();
    FC_GLOBAL(dgghd3,DGGHD3)();
    FC_GLOBAL(dgghrd,DGGHRD)();
    FC_GLOBAL(dgglse,DGGLSE)();
    FC_GLOBAL(dggqrf,DGGQRF)();
    FC_GLOBAL(dggrqf,DGGRQF)();
    FC_GLOBAL(dggsvd3,DGGSVD3)();
    FC_GLOBAL(dggsvp3,DGGSVP3)();
    FC_GLOBAL(dgsvj0,DGSVJ0)();
    FC_GLOBAL(dgsvj1,DGSVJ1)();
    FC_GLOBAL(dgtcon,DGTCON)();
    FC_GLOBAL(dgtrfs,DGTRFS)();
    FC_GLOBAL(dgtsv,DGTSV)();
    FC_GLOBAL(dgtsvx,DGTSVX)();
    FC_GLOBAL(dgttrf,DGTTRF)();
    FC_GLOBAL(dgttrs,DGTTRS)();
    FC_GLOBAL(dgtts2,DGTTS2)();
    FC_GLOBAL(dhgeqz,DHGEQZ)();
    FC_GLOBAL(dhsein,DHSEIN)();
    FC_GLOBAL(dhseqr,DHSEQR)();
    FC_GLOBAL(disnan,DISNAN)();
    FC_GLOBAL(dlabad,DLABAD)();
    FC_GLOBAL(dlabrd,DLABRD)();
    FC_GLOBAL(dlacn2,DLACN2)();
    FC_GLOBAL(dlacon,DLACON)();
    FC_GLOBAL(dlacpy,DLACPY)();
    FC_GLOBAL(dladiv,DLADIV)();
    FC_GLOBAL(dladiv1,DLADIV1)();
    FC_GLOBAL(dladiv2,DLADIV2)();
    FC_GLOBAL(dlae2,DLAE2)();
    FC_GLOBAL(dlaebz,DLAEBZ)();
    FC_GLOBAL(dlaed0,DLAED0)();
    FC_GLOBAL(dlaed1,DLAED1)();
    FC_GLOBAL(dlaed2,DLAED2)();
    FC_GLOBAL(dlaed3,DLAED3)();
    FC_GLOBAL(dlaed4,DLAED4)();
    FC_GLOBAL(dlaed5,DLAED5)();
    FC_GLOBAL(dlaed6,DLAED6)();
    FC_GLOBAL(dlaed7,DLAED7)();
    FC_GLOBAL(dlaed8,DLAED8)();
    FC_GLOBAL(dlaed9,DLAED9)();
    FC_GLOBAL(dlaeda,DLAEDA)();
    FC_GLOBAL(dlaein,DLAEIN)();
    FC_GLOBAL(dlaev2,DLAEV2)();
    FC_GLOBAL(dlaexc,DLAEXC)();
    FC_GLOBAL(dlag2,DLAG2)();
    FC_GLOBAL(dlag2s,DLAG2S)();
    FC_GLOBAL(dlags2,DLAGS2)();
    FC_GLOBAL(dlagtf,DLAGTF)();
    FC_GLOBAL(dlagtm,DLAGTM)();
    FC_GLOBAL(dlagts,DLAGTS)();
    FC_GLOBAL(dlagv2,DLAGV2)();
    FC_GLOBAL(dlahqr,DLAHQR)();
    FC_GLOBAL(dlahr2,DLAHR2)();
    FC_GLOBAL(dlaic1,DLAIC1)();
    FC_GLOBAL(dlaisnan,DLAISNAN)();
    FC_GLOBAL(dlaln2,DLALN2)();
    FC_GLOBAL(dlals0,DLALS0)();
    FC_GLOBAL(dlalsa,DLALSA)();
    FC_GLOBAL(dlalsd,DLALSD)();
    FC_GLOBAL(dlamc3,DLAMC3)();
    FC_GLOBAL(dlamch,DLAMCH)();
    FC_GLOBAL(dlamrg,DLAMRG)();
    FC_GLOBAL(dlamswlq,DLAMSWLQ)();
    FC_GLOBAL(dlamtsqr,DLAMTSQR)();
    FC_GLOBAL(dlaneg,DLANEG)();
    FC_GLOBAL(dlangb,DLANGB)();
    FC_GLOBAL(dlange,DLANGE)();
    FC_GLOBAL(dlangt,DLANGT)();
    FC_GLOBAL(dlanhs,DLANHS)();
    FC_GLOBAL(dlansb,DLANSB)();
    FC_GLOBAL(dlansf,DLANSF)();
    FC_GLOBAL(dlansp,DLANSP)();
    FC_GLOBAL(dlanst,DLANST)();
    FC_GLOBAL(dlansy,DLANSY)();
    FC_GLOBAL(dlantb,DLANTB)();
    FC_GLOBAL(dlantp,DLANTP)();
    FC_GLOBAL(dlantr,DLANTR)();
    FC_GLOBAL(dlanv2,DLANV2)();
    FC_GLOBAL(dlaorhr_col_getrfnp,DLAORHR_COL_GETRFNP)();
    FC_GLOBAL(dlaorhr_col_getrfnp2,DLAORHR_COL_GETRFNP2)();
    FC_GLOBAL(dlapll,DLAPLL)();
    FC_GLOBAL(dlapmr,DLAPMR)();
    FC_GLOBAL(dlapmt,DLAPMT)();
    FC_GLOBAL(dlapy2,DLAPY2)();
    FC_GLOBAL(dlapy3,DLAPY3)();
    FC_GLOBAL(dlaqgb,DLAQGB)();
    FC_GLOBAL(dlaqge,DLAQGE)();
    FC_GLOBAL(dlaqp2,DLAQP2)();
    FC_GLOBAL(dlaqps,DLAQPS)();
    FC_GLOBAL(dlaqr0,DLAQR0)();
    FC_GLOBAL(dlaqr1,DLAQR1)();
    FC_GLOBAL(dlaqr2,DLAQR2)();
    FC_GLOBAL(dlaqr3,DLAQR3)();
    FC_GLOBAL(dlaqr4,DLAQR4)();
    FC_GLOBAL(dlaqr5,DLAQR5)();
    FC_GLOBAL(dlaqsb,DLAQSB)();
    FC_GLOBAL(dlaqsp,DLAQSP)();
    FC_GLOBAL(dlaqsy,DLAQSY)();
    FC_GLOBAL(dlaqtr,DLAQTR)();
    FC_GLOBAL(dlaqz0,DLAQZ0)();
    FC_GLOBAL(dlaqz1,DLAQZ1)();
    FC_GLOBAL(dlaqz2,DLAQZ2)();
    FC_GLOBAL(dlaqz3,DLAQZ3)();
    FC_GLOBAL(dlaqz4,DLAQZ4)();
    FC_GLOBAL(dlar1v,DLAR1V)();
    FC_GLOBAL(dlar2v,DLAR2V)();
    FC_GLOBAL(dlarf,DLARF)();
    FC_GLOBAL(dlarfb,DLARFB)();
    FC_GLOBAL(dlarfb_gett,DLARFB_GETT)();
    FC_GLOBAL(dlarfg,DLARFG)();
    FC_GLOBAL(dlarfgp,DLARFGP)();
    FC_GLOBAL(dlarft,DLARFT)();
    FC_GLOBAL(dlarfx,DLARFX)();
    FC_GLOBAL(dlarfy,DLARFY)();
    FC_GLOBAL(dlargv,DLARGV)();
    FC_GLOBAL(dlarmm,DLARMM)();
    FC_GLOBAL(dlarnv,DLARNV)();
    FC_GLOBAL(dlarra,DLARRA)();
    FC_GLOBAL(dlarrb,DLARRB)();
    FC_GLOBAL(dlarrc,DLARRC)();
    FC_GLOBAL(dlarrd,DLARRD)();
    FC_GLOBAL(dlarre,DLARRE)();
    FC_GLOBAL(dlarrf,DLARRF)();
    FC_GLOBAL(dlarrj,DLARRJ)();
    FC_GLOBAL(dlarrk,DLARRK)();
    FC_GLOBAL(dlarrr,DLARRR)();
    FC_GLOBAL(dlarrv,DLARRV)();
    FC_GLOBAL(dlartg,DLARTG)();
    FC_GLOBAL(dlartgp,DLARTGP)();
    FC_GLOBAL(dlartgs,DLARTGS)();
    FC_GLOBAL(dlartv,DLARTV)();
    FC_GLOBAL(dlaruv,DLARUV)();
    FC_GLOBAL(dlarz,DLARZ)();
    FC_GLOBAL(dlarzb,DLARZB)();
    FC_GLOBAL(dlarzt,DLARZT)();
    FC_GLOBAL(dlas2,DLAS2)();
    FC_GLOBAL(dlascl,DLASCL)();
    FC_GLOBAL(dlasd0,DLASD0)();
    FC_GLOBAL(dlasd1,DLASD1)();
    FC_GLOBAL(dlasd2,DLASD2)();
    FC_GLOBAL(dlasd3,DLASD3)();
    FC_GLOBAL(dlasd4,DLASD4)();
    FC_GLOBAL(dlasd5,DLASD5)();
    FC_GLOBAL(dlasd6,DLASD6)();
    FC_GLOBAL(dlasd7,DLASD7)();
    FC_GLOBAL(dlasd8,DLASD8)();
    FC_GLOBAL(dlasda,DLASDA)();
    FC_GLOBAL(dlasdq,DLASDQ)();
    FC_GLOBAL(dlasdt,DLASDT)();
    FC_GLOBAL(dlaset,DLASET)();
    FC_GLOBAL(dlasq1,DLASQ1)();
    FC_GLOBAL(dlasq2,DLASQ2)();
    FC_GLOBAL(dlasq3,DLASQ3)();
    FC_GLOBAL(dlasq4,DLASQ4)();
    FC_GLOBAL(dlasq5,DLASQ5)();
    FC_GLOBAL(dlasq6,DLASQ6)();
    FC_GLOBAL(dlasr,DLASR)();
    FC_GLOBAL(dlasrt,DLASRT)();
    FC_GLOBAL(dlassq,DLASSQ)();
    FC_GLOBAL(dlasv2,DLASV2)();
    FC_GLOBAL(dlaswlq,DLASWLQ)();
    FC_GLOBAL(dlaswp,DLASWP)();
    FC_GLOBAL(dlasy2,DLASY2)();
    FC_GLOBAL(dlasyf,DLASYF)();
    FC_GLOBAL(dlasyf_aa,DLASYF_AA)();
    FC_GLOBAL(dlasyf_rk,DLASYF_RK)();
    FC_GLOBAL(dlasyf_rook,DLASYF_ROOK)();
    FC_GLOBAL(dlat2s,DLAT2S)();
    FC_GLOBAL(dlatbs,DLATBS)();
    FC_GLOBAL(dlatdf,DLATDF)();
    FC_GLOBAL(dlatps,DLATPS)();
    FC_GLOBAL(dlatrd,DLATRD)();
    FC_GLOBAL(dlatrs,DLATRS)();
    FC_GLOBAL(dlatrs3,DLATRS3)();
    FC_GLOBAL(dlatrz,DLATRZ)();
    FC_GLOBAL(dlatsqr,DLATSQR)();
    FC_GLOBAL(dlauu2,DLAUU2)();
    FC_GLOBAL(dlauum,DLAUUM)();
    FC_GLOBAL(dopgtr,DOPGTR)();
    FC_GLOBAL(dopmtr,DOPMTR)();
    FC_GLOBAL(dorbdb,DORBDB)();
    FC_GLOBAL(dorbdb1,DORBDB1)();
    FC_GLOBAL(dorbdb2,DORBDB2)();
    FC_GLOBAL(dorbdb3,DORBDB3)();
    FC_GLOBAL(dorbdb4,DORBDB4)();
    FC_GLOBAL(dorbdb5,DORBDB5)();
    FC_GLOBAL(dorbdb6,DORBDB6)();
    FC_GLOBAL(dorcsd,DORCSD)();
    FC_GLOBAL(dorcsd2by1,DORCSD2BY1)();
    FC_GLOBAL(dorg2l,DORG2L)();
    FC_GLOBAL(dorg2r,DORG2R)();
    FC_GLOBAL(dorgbr,DORGBR)();
    FC_GLOBAL(dorghr,DORGHR)();
    FC_GLOBAL(dorgl2,DORGL2)();
    FC_GLOBAL(dorglq,DORGLQ)();
    FC_GLOBAL(dorgql,DORGQL)();
    FC_GLOBAL(dorgqr,DORGQR)();
    FC_GLOBAL(dorgr2,DORGR2)();
    FC_GLOBAL(dorgrq,DORGRQ)();
    FC_GLOBAL(dorgtr,DORGTR)();
    FC_GLOBAL(dorgtsqr,DORGTSQR)();
    FC_GLOBAL(dorgtsqr_row,DORGTSQR_ROW)();
    FC_GLOBAL(dorhr_col,DORHR_COL)();
    FC_GLOBAL(dorm22,DORM22)();
    FC_GLOBAL(dorm2l,DORM2L)();
    FC_GLOBAL(dorm2r,DORM2R)();
    FC_GLOBAL(dormbr,DORMBR)();
    FC_GLOBAL(dormhr,DORMHR)();
    FC_GLOBAL(dorml2,DORML2)();
    FC_GLOBAL(dormlq,DORMLQ)();
    FC_GLOBAL(dormql,DORMQL)();
    FC_GLOBAL(dormqr,DORMQR)();
    FC_GLOBAL(dormr2,DORMR2)();
    FC_GLOBAL(dormr3,DORMR3)();
    FC_GLOBAL(dormrq,DORMRQ)();
    FC_GLOBAL(dormrz,DORMRZ)();
    FC_GLOBAL(dormtr,DORMTR)();
    FC_GLOBAL(dpbcon,DPBCON)();
    FC_GLOBAL(dpbequ,DPBEQU)();
    FC_GLOBAL(dpbrfs,DPBRFS)();
    FC_GLOBAL(dpbstf,DPBSTF)();
    FC_GLOBAL(dpbsv,DPBSV)();
    FC_GLOBAL(dpbsvx,DPBSVX)();
    FC_GLOBAL(dpbtf2,DPBTF2)();
    FC_GLOBAL(dpbtrf,DPBTRF)();
    FC_GLOBAL(dpbtrs,DPBTRS)();
    FC_GLOBAL(dpftrf,DPFTRF)();
    FC_GLOBAL(dpftri,DPFTRI)();
    FC_GLOBAL(dpftrs,DPFTRS)();
    FC_GLOBAL(dpocon,DPOCON)();
    FC_GLOBAL(dpoequ,DPOEQU)();
    FC_GLOBAL(dpoequb,DPOEQUB)();
    FC_GLOBAL(dporfs,DPORFS)();
    FC_GLOBAL(dposv,DPOSV)();
    FC_GLOBAL(dposvx,DPOSVX)();
    FC_GLOBAL(dpotf2,DPOTF2)();
    FC_GLOBAL(dpotrf,DPOTRF)();
    FC_GLOBAL(dpotrf2,DPOTRF2)();
    FC_GLOBAL(dpotri,DPOTRI)();
    FC_GLOBAL(dpotrs,DPOTRS)();
    FC_GLOBAL(dppcon,DPPCON)();
    FC_GLOBAL(dppequ,DPPEQU)();
    FC_GLOBAL(dpprfs,DPPRFS)();
    FC_GLOBAL(dppsv,DPPSV)();
    FC_GLOBAL(dppsvx,DPPSVX)();
    FC_GLOBAL(dpptrf,DPPTRF)();
    FC_GLOBAL(dpptri,DPPTRI)();
    FC_GLOBAL(dpptrs,DPPTRS)();
    FC_GLOBAL(dpstf2,DPSTF2)();
    FC_GLOBAL(dpstrf,DPSTRF)();
    FC_GLOBAL(dptcon,DPTCON)();
    FC_GLOBAL(dpteqr,DPTEQR)();
    FC_GLOBAL(dptrfs,DPTRFS)();
    FC_GLOBAL(dptsv,DPTSV)();
    FC_GLOBAL(dptsvx,DPTSVX)();
    FC_GLOBAL(dpttrf,DPTTRF)();
    FC_GLOBAL(dpttrs,DPTTRS)();
    FC_GLOBAL(dptts2,DPTTS2)();
    FC_GLOBAL(droundup_lwork,DROUNDUP_LWORK)();
    FC_GLOBAL(drscl,DRSCL)();
    FC_GLOBAL(dsb2st_kernels,DSB2ST_KERNELS)();
    FC_GLOBAL(dsbev,DSBEV)();
    FC_GLOBAL(dsbev_2stage,DSBEV_2STAGE)();
    FC_GLOBAL(dsbevd,DSBEVD)();
    FC_GLOBAL(dsbevd_2stage,DSBEVD_2STAGE)();
    FC_GLOBAL(dsbevx,DSBEVX)();
    FC_GLOBAL(dsbevx_2stage,DSBEVX_2STAGE)();
    FC_GLOBAL(dsbgst,DSBGST)();
    FC_GLOBAL(dsbgv,DSBGV)();
    FC_GLOBAL(dsbgvd,DSBGVD)();
    FC_GLOBAL(dsbgvx,DSBGVX)();
    FC_GLOBAL(dsbtrd,DSBTRD)();
    FC_GLOBAL(dsecnd,DSECND)();
    FC_GLOBAL(dsfrk,DSFRK)();
    FC_GLOBAL(dsgesv,DSGESV)();
    FC_GLOBAL(dspcon,DSPCON)();
    FC_GLOBAL(dspev,DSPEV)();
    FC_GLOBAL(dspevd,DSPEVD)();
    FC_GLOBAL(dspevx,DSPEVX)();
    FC_GLOBAL(dspgst,DSPGST)();
    FC_GLOBAL(dspgv,DSPGV)();
    FC_GLOBAL(dspgvd,DSPGVD)();
    FC_GLOBAL(dspgvx,DSPGVX)();
    FC_GLOBAL(dsposv,DSPOSV)();
    FC_GLOBAL(dsprfs,DSPRFS)();
    FC_GLOBAL(dspsv,DSPSV)();
    FC_GLOBAL(dspsvx,DSPSVX)();
    FC_GLOBAL(dsptrd,DSPTRD)();
    FC_GLOBAL(dsptrf,DSPTRF)();
    FC_GLOBAL(dsptri,DSPTRI)();
    FC_GLOBAL(dsptrs,DSPTRS)();
    FC_GLOBAL(dstebz,DSTEBZ)();
    FC_GLOBAL(dstedc,DSTEDC)();
    FC_GLOBAL(dstegr,DSTEGR)();
    FC_GLOBAL(dstein,DSTEIN)();
    FC_GLOBAL(dstemr,DSTEMR)();
    FC_GLOBAL(dsteqr,DSTEQR)();
    FC_GLOBAL(dsterf,DSTERF)();
    FC_GLOBAL(dstev,DSTEV)();
    FC_GLOBAL(dstevd,DSTEVD)();
    FC_GLOBAL(dstevr,DSTEVR)();
    FC_GLOBAL(dstevx,DSTEVX)();
    FC_GLOBAL(dsycon,DSYCON)();
    FC_GLOBAL(dsycon_3,DSYCON_3)();
    FC_GLOBAL(dsycon_rook,DSYCON_ROOK)();
    FC_GLOBAL(dsyconv,DSYCONV)();
    FC_GLOBAL(dsyconvf,DSYCONVF)();
    FC_GLOBAL(dsyconvf_rook,DSYCONVF_ROOK)();
    FC_GLOBAL(dsyequb,DSYEQUB)();
    FC_GLOBAL(dsyev,DSYEV)();
    FC_GLOBAL(dsyev_2stage,DSYEV_2STAGE)();
    FC_GLOBAL(dsyevd,DSYEVD)();
    FC_GLOBAL(dsyevd_2stage,DSYEVD_2STAGE)();
    FC_GLOBAL(dsyevr,DSYEVR)();
    FC_GLOBAL(dsyevr_2stage,DSYEVR_2STAGE)();
    FC_GLOBAL(dsyevx,DSYEVX)();
    FC_GLOBAL(dsyevx_2stage,DSYEVX_2STAGE)();
    FC_GLOBAL(dsygs2,DSYGS2)();
    FC_GLOBAL(dsygst,DSYGST)();
    FC_GLOBAL(dsygv,DSYGV)();
    FC_GLOBAL(dsygv_2stage,DSYGV_2STAGE)();
    FC_GLOBAL(dsygvd,DSYGVD)();
    FC_GLOBAL(dsygvx,DSYGVX)();
    FC_GLOBAL(dsyrfs,DSYRFS)();
    FC_GLOBAL(dsysv,DSYSV)();
    FC_GLOBAL(dsysv_aa,DSYSV_AA)();
    FC_GLOBAL(dsysv_aa_2stage,DSYSV_AA_2STAGE)();
    FC_GLOBAL(dsysv_rk,DSYSV_RK)();
    FC_GLOBAL(dsysv_rook,DSYSV_ROOK)();
    FC_GLOBAL(dsysvx,DSYSVX)();
    FC_GLOBAL(dsyswapr,DSYSWAPR)();
    FC_GLOBAL(dsytd2,DSYTD2)();
    FC_GLOBAL(dsytf2,DSYTF2)();
    FC_GLOBAL(dsytf2_rk,DSYTF2_RK)();
    FC_GLOBAL(dsytf2_rook,DSYTF2_ROOK)();
    FC_GLOBAL(dsytrd,DSYTRD)();
    FC_GLOBAL(dsytrd_2stage,DSYTRD_2STAGE)();
    FC_GLOBAL(dsytrd_sb2st,DSYTRD_SB2ST)();
    FC_GLOBAL(dsytrd_sy2sb,DSYTRD_SY2SB)();
    FC_GLOBAL(dsytrf,DSYTRF)();
    FC_GLOBAL(dsytrf_aa,DSYTRF_AA)();
    FC_GLOBAL(dsytrf_aa_2stage,DSYTRF_AA_2STAGE)();
    FC_GLOBAL(dsytrf_rk,DSYTRF_RK)();
    FC_GLOBAL(dsytrf_rook,DSYTRF_ROOK)();
    FC_GLOBAL(dsytri,DSYTRI)();
    FC_GLOBAL(dsytri2,DSYTRI2)();
    FC_GLOBAL(dsytri2x,DSYTRI2X)();
    FC_GLOBAL(dsytri_3,DSYTRI_3)();
    FC_GLOBAL(dsytri_3x,DSYTRI_3X)();
    FC_GLOBAL(dsytri_rook,DSYTRI_ROOK)();
    FC_GLOBAL(dsytrs,DSYTRS)();
    FC_GLOBAL(dsytrs2,DSYTRS2)();
    FC_GLOBAL(dsytrs_3,DSYTRS_3)();
    FC_GLOBAL(dsytrs_aa,DSYTRS_AA)();
    FC_GLOBAL(dsytrs_aa_2stage,DSYTRS_AA_2STAGE)();
    FC_GLOBAL(dsytrs_rook,DSYTRS_ROOK)();
    FC_GLOBAL(dtbcon,DTBCON)();
    FC_GLOBAL(dtbrfs,DTBRFS)();
    FC_GLOBAL(dtbtrs,DTBTRS)();
    FC_GLOBAL(dtfsm,DTFSM)();
    FC_GLOBAL(dtftri,DTFTRI)();
    FC_GLOBAL(dtfttp,DTFTTP)();
    FC_GLOBAL(dtfttr,DTFTTR)();
    FC_GLOBAL(dtgevc,DTGEVC)();
    FC_GLOBAL(dtgex2,DTGEX2)();
    FC_GLOBAL(dtgexc,DTGEXC)();
    FC_GLOBAL(dtgsen,DTGSEN)();
    FC_GLOBAL(dtgsja,DTGSJA)();
    FC_GLOBAL(dtgsna,DTGSNA)();
    FC_GLOBAL(dtgsy2,DTGSY2)();
    FC_GLOBAL(dtgsyl,DTGSYL)();
    FC_GLOBAL(dtpcon,DTPCON)();
    FC_GLOBAL(dtplqt,DTPLQT)();
    FC_GLOBAL(dtplqt2,DTPLQT2)();
    FC_GLOBAL(dtpmlqt,DTPMLQT)();
    FC_GLOBAL(dtpmqrt,DTPMQRT)();
    FC_GLOBAL(dtpqrt,DTPQRT)();
    FC_GLOBAL(dtpqrt2,DTPQRT2)();
    FC_GLOBAL(dtprfb,DTPRFB)();
    FC_GLOBAL(dtprfs,DTPRFS)();
    FC_GLOBAL(dtptri,DTPTRI)();
    FC_GLOBAL(dtptrs,DTPTRS)();
    FC_GLOBAL(dtpttf,DTPTTF)();
    FC_GLOBAL(dtpttr,DTPTTR)();
    FC_GLOBAL(dtrcon,DTRCON)();
    FC_GLOBAL(dtrevc,DTREVC)();
    FC_GLOBAL(dtrevc3,DTREVC3)();
    FC_GLOBAL(dtrexc,DTREXC)();
    FC_GLOBAL(dtrrfs,DTRRFS)();
    FC_GLOBAL(dtrsen,DTRSEN)();
    FC_GLOBAL(dtrsna,DTRSNA)();
    FC_GLOBAL(dtrsyl,DTRSYL)();
    FC_GLOBAL(dtrsyl3,DTRSYL3)();
    FC_GLOBAL(dtrti2,DTRTI2)();
    FC_GLOBAL(dtrtri,DTRTRI)();
    FC_GLOBAL(dtrtrs,DTRTRS)();
    FC_GLOBAL(dtrttf,DTRTTF)();
    FC_GLOBAL(dtrttp,DTRTTP)();
    FC_GLOBAL(dtzrzf,DTZRZF)();
    FC_GLOBAL(dzsum1,DZSUM1)();
    FC_GLOBAL(icmax1,ICMAX1)();
    FC_GLOBAL(ieeeck,IEEECK)();
    FC_GLOBAL(ilaclc,ILACLC)();
    FC_GLOBAL(ilaclr,ILACLR)();
    FC_GLOBAL(iladiag,ILADIAG)();
    FC_GLOBAL(iladlc,ILADLC)();
    FC_GLOBAL(iladlr,ILADLR)();
    FC_GLOBAL(ilaenv,ILAENV)();
    FC_GLOBAL(ilaenv2stage,ILAENV2STAGE)();
    FC_GLOBAL(ilaprec,ILAPREC)();
    FC_GLOBAL(ilaslc,ILASLC)();
    FC_GLOBAL(ilaslr,ILASLR)();
    FC_GLOBAL(ilatrans,ILATRANS)();
    FC_GLOBAL(ilauplo,ILAUPLO)();
    FC_GLOBAL(ilazlc,ILAZLC)();
    FC_GLOBAL(ilazlr,ILAZLR)();
    FC_GLOBAL(iparam2stage,IPARAM2STAGE)();
    FC_GLOBAL(iparmq,IPARMQ)();
    FC_GLOBAL(izmax1,IZMAX1)();
    FC_GLOBAL(sbbcsd,SBBCSD)();
    FC_GLOBAL(sbdsdc,SBDSDC)();
    FC_GLOBAL(sbdsqr,SBDSQR)();
    FC_GLOBAL(sbdsvdx,SBDSVDX)();
    FC_GLOBAL(scsum1,SCSUM1)();
    FC_GLOBAL(sdisna,SDISNA)();
    FC_GLOBAL(second,SECOND)();
    FC_GLOBAL(sgbbrd,SGBBRD)();
    FC_GLOBAL(sgbcon,SGBCON)();
    FC_GLOBAL(sgbequ,SGBEQU)();
    FC_GLOBAL(sgbequb,SGBEQUB)();
    FC_GLOBAL(sgbrfs,SGBRFS)();
    FC_GLOBAL(sgbsv,SGBSV)();
    FC_GLOBAL(sgbsvx,SGBSVX)();
    FC_GLOBAL(sgbtf2,SGBTF2)();
    FC_GLOBAL(sgbtrf,SGBTRF)();
    FC_GLOBAL(sgbtrs,SGBTRS)();
    FC_GLOBAL(sgebak,SGEBAK)();
    FC_GLOBAL(sgebal,SGEBAL)();
    FC_GLOBAL(sgebd2,SGEBD2)();
    FC_GLOBAL(sgebrd,SGEBRD)();
    FC_GLOBAL(sgecon,SGECON)();
    FC_GLOBAL(sgeequ,SGEEQU)();
    FC_GLOBAL(sgeequb,SGEEQUB)();
    FC_GLOBAL(sgees,SGEES)();
    FC_GLOBAL(sgeesx,SGEESX)();
    FC_GLOBAL(sgeev,SGEEV)();
    FC_GLOBAL(sgeevx,SGEEVX)();
    FC_GLOBAL(sgehd2,SGEHD2)();
    FC_GLOBAL(sgehrd,SGEHRD)();
    FC_GLOBAL(sgejsv,SGEJSV)();
    FC_GLOBAL(sgelq,SGELQ)();
    FC_GLOBAL(sgelq2,SGELQ2)();
    FC_GLOBAL(sgelqf,SGELQF)();
    FC_GLOBAL(sgelqt,SGELQT)();
    FC_GLOBAL(sgelqt3,SGELQT3)();
    FC_GLOBAL(sgels,SGELS)();
    FC_GLOBAL(sgelsd,SGELSD)();
    FC_GLOBAL(sgelss,SGELSS)();
    FC_GLOBAL(sgelst,SGELST)();
    FC_GLOBAL(sgelsy,SGELSY)();
    FC_GLOBAL(sgemlq,SGEMLQ)();
    FC_GLOBAL(sgemlqt,SGEMLQT)();
    FC_GLOBAL(sgemqr,SGEMQR)();
    FC_GLOBAL(sgemqrt,SGEMQRT)();
    FC_GLOBAL(sgeql2,SGEQL2)();
    FC_GLOBAL(sgeqlf,SGEQLF)();
    FC_GLOBAL(sgeqp3,SGEQP3)();
    FC_GLOBAL(sgeqr,SGEQR)();
    FC_GLOBAL(sgeqr2,SGEQR2)();
    FC_GLOBAL(sgeqr2p,SGEQR2P)();
    FC_GLOBAL(sgeqrf,SGEQRF)();
    FC_GLOBAL(sgeqrfp,SGEQRFP)();
    FC_GLOBAL(sgeqrt,SGEQRT)();
    FC_GLOBAL(sgeqrt2,SGEQRT2)();
    FC_GLOBAL(sgeqrt3,SGEQRT3)();
    FC_GLOBAL(sgerfs,SGERFS)();
    FC_GLOBAL(sgerq2,SGERQ2)();
    FC_GLOBAL(sgerqf,SGERQF)();
    FC_GLOBAL(sgesc2,SGESC2)();
    FC_GLOBAL(sgesdd,SGESDD)();
    FC_GLOBAL(sgesv,SGESV)();
    FC_GLOBAL(sgesvd,SGESVD)();
    FC_GLOBAL(sgesvdq,SGESVDQ)();
    FC_GLOBAL(sgesvdx,SGESVDX)();
    FC_GLOBAL(sgesvj,SGESVJ)();
    FC_GLOBAL(sgesvx,SGESVX)();
    FC_GLOBAL(sgetc2,SGETC2)();
    FC_GLOBAL(sgetf2,SGETF2)();
    FC_GLOBAL(sgetrf,SGETRF)();
    FC_GLOBAL(sgetrf2,SGETRF2)();
    FC_GLOBAL(sgetri,SGETRI)();
    FC_GLOBAL(sgetrs,SGETRS)();
    FC_GLOBAL(sgetsls,SGETSLS)();
    FC_GLOBAL(sgetsqrhrt,SGETSQRHRT)();
    FC_GLOBAL(sggbak,SGGBAK)();
    FC_GLOBAL(sggbal,SGGBAL)();
    FC_GLOBAL(sgges,SGGES)();
    FC_GLOBAL(sgges3,SGGES3)();
    FC_GLOBAL(sggesx,SGGESX)();
    FC_GLOBAL(sggev,SGGEV)();
    FC_GLOBAL(sggev3,SGGEV3)();
    FC_GLOBAL(sggevx,SGGEVX)();
    FC_GLOBAL(sggglm,SGGGLM)();
    FC_GLOBAL(sgghd3,SGGHD3)();
    FC_GLOBAL(sgghrd,SGGHRD)();
    FC_GLOBAL(sgglse,SGGLSE)();
    FC_GLOBAL(sggqrf,SGGQRF)();
    FC_GLOBAL(sggrqf,SGGRQF)();
    FC_GLOBAL(sggsvd3,SGGSVD3)();
    FC_GLOBAL(sggsvp3,SGGSVP3)();
    FC_GLOBAL(sgsvj0,SGSVJ0)();
    FC_GLOBAL(sgsvj1,SGSVJ1)();
    FC_GLOBAL(sgtcon,SGTCON)();
    FC_GLOBAL(sgtrfs,SGTRFS)();
    FC_GLOBAL(sgtsv,SGTSV)();
    FC_GLOBAL(sgtsvx,SGTSVX)();
    FC_GLOBAL(sgttrf,SGTTRF)();
    FC_GLOBAL(sgttrs,SGTTRS)();
    FC_GLOBAL(sgtts2,SGTTS2)();
    FC_GLOBAL(shgeqz,SHGEQZ)();
    FC_GLOBAL(shsein,SHSEIN)();
    FC_GLOBAL(shseqr,SHSEQR)();
    FC_GLOBAL(sisnan,SISNAN)();
    FC_GLOBAL(slabad,SLABAD)();
    FC_GLOBAL(slabrd,SLABRD)();
    FC_GLOBAL(slacn2,SLACN2)();
    FC_GLOBAL(slacon,SLACON)();
    FC_GLOBAL(slacpy,SLACPY)();
    FC_GLOBAL(sladiv,SLADIV)();
    FC_GLOBAL(sladiv1,SLADIV1)();
    FC_GLOBAL(sladiv2,SLADIV2)();
    FC_GLOBAL(slae2,SLAE2)();
    FC_GLOBAL(slaebz,SLAEBZ)();
    FC_GLOBAL(slaed0,SLAED0)();
    FC_GLOBAL(slaed1,SLAED1)();
    FC_GLOBAL(slaed2,SLAED2)();
    FC_GLOBAL(slaed3,SLAED3)();
    FC_GLOBAL(slaed4,SLAED4)();
    FC_GLOBAL(slaed5,SLAED5)();
    FC_GLOBAL(slaed6,SLAED6)();
    FC_GLOBAL(slaed7,SLAED7)();
    FC_GLOBAL(slaed8,SLAED8)();
    FC_GLOBAL(slaed9,SLAED9)();
    FC_GLOBAL(slaeda,SLAEDA)();
    FC_GLOBAL(slaein,SLAEIN)();
    FC_GLOBAL(slaev2,SLAEV2)();
    FC_GLOBAL(slaexc,SLAEXC)();
    FC_GLOBAL(slag2,SLAG2)();
    FC_GLOBAL(slag2d,SLAG2D)();
    FC_GLOBAL(slags2,SLAGS2)();
    FC_GLOBAL(slagtf,SLAGTF)();
    FC_GLOBAL(slagtm,SLAGTM)();
    FC_GLOBAL(slagts,SLAGTS)();
    FC_GLOBAL(slagv2,SLAGV2)();
    FC_GLOBAL(slahqr,SLAHQR)();
    FC_GLOBAL(slahr2,SLAHR2)();
    FC_GLOBAL(slaic1,SLAIC1)();
    FC_GLOBAL(slaisnan,SLAISNAN)();
    FC_GLOBAL(slaln2,SLALN2)();
    FC_GLOBAL(slals0,SLALS0)();
    FC_GLOBAL(slalsa,SLALSA)();
    FC_GLOBAL(slalsd,SLALSD)();
    FC_GLOBAL(slamc3,SLAMC3)();
    FC_GLOBAL(slamch,SLAMCH)();
    FC_GLOBAL(slamrg,SLAMRG)();
    FC_GLOBAL(slamswlq,SLAMSWLQ)();
    FC_GLOBAL(slamtsqr,SLAMTSQR)();
    FC_GLOBAL(slaneg,SLANEG)();
    FC_GLOBAL(slangb,SLANGB)();
    FC_GLOBAL(slange,SLANGE)();
    FC_GLOBAL(slangt,SLANGT)();
    FC_GLOBAL(slanhs,SLANHS)();
    FC_GLOBAL(slansb,SLANSB)();
    FC_GLOBAL(slansf,SLANSF)();
    FC_GLOBAL(slansp,SLANSP)();
    FC_GLOBAL(slanst,SLANST)();
    FC_GLOBAL(slansy,SLANSY)();
    FC_GLOBAL(slantb,SLANTB)();
    FC_GLOBAL(slantp,SLANTP)();
    FC_GLOBAL(slantr,SLANTR)();
    FC_GLOBAL(slanv2,SLANV2)();
    FC_GLOBAL(slaorhr_col_getrfnp,SLAORHR_COL_GETRFNP)();
    FC_GLOBAL(slaorhr_col_getrfnp2,SLAORHR_COL_GETRFNP2)();
    FC_GLOBAL(slapll,SLAPLL)();
    FC_GLOBAL(slapmr,SLAPMR)();
    FC_GLOBAL(slapmt,SLAPMT)();
    FC_GLOBAL(slapy2,SLAPY2)();
    FC_GLOBAL(slapy3,SLAPY3)();
    FC_GLOBAL(slaqgb,SLAQGB)();
    FC_GLOBAL(slaqge,SLAQGE)();
    FC_GLOBAL(slaqp2,SLAQP2)();
    FC_GLOBAL(slaqps,SLAQPS)();
    FC_GLOBAL(slaqr0,SLAQR0)();
    FC_GLOBAL(slaqr1,SLAQR1)();
    FC_GLOBAL(slaqr2,SLAQR2)();
    FC_GLOBAL(slaqr3,SLAQR3)();
    FC_GLOBAL(slaqr4,SLAQR4)();
    FC_GLOBAL(slaqr5,SLAQR5)();
    FC_GLOBAL(slaqsb,SLAQSB)();
    FC_GLOBAL(slaqsp,SLAQSP)();
    FC_GLOBAL(slaqsy,SLAQSY)();
    FC_GLOBAL(slaqtr,SLAQTR)();
    FC_GLOBAL(slaqz0,SLAQZ0)();
    FC_GLOBAL(slaqz1,SLAQZ1)();
    FC_GLOBAL(slaqz2,SLAQZ2)();
    FC_GLOBAL(slaqz3,SLAQZ3)();
    FC_GLOBAL(slaqz4,SLAQZ4)();
    FC_GLOBAL(slar1v,SLAR1V)();
    FC_GLOBAL(slar2v,SLAR2V)();
    FC_GLOBAL(slarf,SLARF)();
    FC_GLOBAL(slarfb,SLARFB)();
    FC_GLOBAL(slarfb_gett,SLARFB_GETT)();
    FC_GLOBAL(slarfg,SLARFG)();
    FC_GLOBAL(slarfgp,SLARFGP)();
    FC_GLOBAL(slarft,SLARFT)();
    FC_GLOBAL(slarfx,SLARFX)();
    FC_GLOBAL(slarfy,SLARFY)();
    FC_GLOBAL(slargv,SLARGV)();
    FC_GLOBAL(slarmm,SLARMM)();
    FC_GLOBAL(slarnv,SLARNV)();
    FC_GLOBAL(slarra,SLARRA)();
    FC_GLOBAL(slarrb,SLARRB)();
    FC_GLOBAL(slarrc,SLARRC)();
    FC_GLOBAL(slarrd,SLARRD)();
    FC_GLOBAL(slarre,SLARRE)();
    FC_GLOBAL(slarrf,SLARRF)();
    FC_GLOBAL(slarrj,SLARRJ)();
    FC_GLOBAL(slarrk,SLARRK)();
    FC_GLOBAL(slarrr,SLARRR)();
    FC_GLOBAL(slarrv,SLARRV)();
    FC_GLOBAL(slartg,SLARTG)();
    FC_GLOBAL(slartgp,SLARTGP)();
    FC_GLOBAL(slartgs,SLARTGS)();
    FC_GLOBAL(slartv,SLARTV)();
    FC_GLOBAL(slaruv,SLARUV)();
    FC_GLOBAL(slarz,SLARZ)();
    FC_GLOBAL(slarzb,SLARZB)();
    FC_GLOBAL(slarzt,SLARZT)();
    FC_GLOBAL(slas2,SLAS2)();
    FC_GLOBAL(slascl,SLASCL)();
    FC_GLOBAL(slasd0,SLASD0)();
    FC_GLOBAL(slasd1,SLASD1)();
    FC_GLOBAL(slasd2,SLASD2)();
    FC_GLOBAL(slasd3,SLASD3)();
    FC_GLOBAL(slasd4,SLASD4)();
    FC_GLOBAL(slasd5,SLASD5)();
    FC_GLOBAL(slasd6,SLASD6)();
    FC_GLOBAL(slasd7,SLASD7)();
    FC_GLOBAL(slasd8,SLASD8)();
    FC_GLOBAL(slasda,SLASDA)();
    FC_GLOBAL(slasdq,SLASDQ)();
    FC_GLOBAL(slasdt,SLASDT)();
    FC_GLOBAL(slaset,SLASET)();
    FC_GLOBAL(slasq1,SLASQ1)();
    FC_GLOBAL(slasq2,SLASQ2)();
    FC_GLOBAL(slasq3,SLASQ3)();
    FC_GLOBAL(slasq4,SLASQ4)();
    FC_GLOBAL(slasq5,SLASQ5)();
    FC_GLOBAL(slasq6,SLASQ6)();
    FC_GLOBAL(slasr,SLASR)();
    FC_GLOBAL(slasrt,SLASRT)();
    FC_GLOBAL(slassq,SLASSQ)();
    FC_GLOBAL(slasv2,SLASV2)();
    FC_GLOBAL(slaswlq,SLASWLQ)();
    FC_GLOBAL(slaswp,SLASWP)();
    FC_GLOBAL(slasy2,SLASY2)();
    FC_GLOBAL(slasyf,SLASYF)();
    FC_GLOBAL(slasyf_aa,SLASYF_AA)();
    FC_GLOBAL(slasyf_rk,SLASYF_RK)();
    FC_GLOBAL(slasyf_rook,SLASYF_ROOK)();
    FC_GLOBAL(slatbs,SLATBS)();
    FC_GLOBAL(slatdf,SLATDF)();
    FC_GLOBAL(slatps,SLATPS)();
    FC_GLOBAL(slatrd,SLATRD)();
    FC_GLOBAL(slatrs,SLATRS)();
    FC_GLOBAL(slatrs3,SLATRS3)();
    FC_GLOBAL(slatrz,SLATRZ)();
    FC_GLOBAL(slatsqr,SLATSQR)();
    FC_GLOBAL(slauu2,SLAUU2)();
    FC_GLOBAL(slauum,SLAUUM)();
    FC_GLOBAL(sopgtr,SOPGTR)();
    FC_GLOBAL(sopmtr,SOPMTR)();
    FC_GLOBAL(sorbdb,SORBDB)();
    FC_GLOBAL(sorbdb1,SORBDB1)();
    FC_GLOBAL(sorbdb2,SORBDB2)();
    FC_GLOBAL(sorbdb3,SORBDB3)();
    FC_GLOBAL(sorbdb4,SORBDB4)();
    FC_GLOBAL(sorbdb5,SORBDB5)();
    FC_GLOBAL(sorbdb6,SORBDB6)();
    FC_GLOBAL(sorcsd,SORCSD)();
    FC_GLOBAL(sorcsd2by1,SORCSD2BY1)();
    FC_GLOBAL(sorg2l,SORG2L)();
    FC_GLOBAL(sorg2r,SORG2R)();
    FC_GLOBAL(sorgbr,SORGBR)();
    FC_GLOBAL(sorghr,SORGHR)();
    FC_GLOBAL(sorgl2,SORGL2)();
    FC_GLOBAL(sorglq,SORGLQ)();
    FC_GLOBAL(sorgql,SORGQL)();
    FC_GLOBAL(sorgqr,SORGQR)();
    FC_GLOBAL(sorgr2,SORGR2)();
    FC_GLOBAL(sorgrq,SORGRQ)();
    FC_GLOBAL(sorgtr,SORGTR)();
    FC_GLOBAL(sorgtsqr,SORGTSQR)();
    FC_GLOBAL(sorgtsqr_row,SORGTSQR_ROW)();
    FC_GLOBAL(sorhr_col,SORHR_COL)();
    FC_GLOBAL(sorm22,SORM22)();
    FC_GLOBAL(sorm2l,SORM2L)();
    FC_GLOBAL(sorm2r,SORM2R)();
    FC_GLOBAL(sormbr,SORMBR)();
    FC_GLOBAL(sormhr,SORMHR)();
    FC_GLOBAL(sorml2,SORML2)();
    FC_GLOBAL(sormlq,SORMLQ)();
    FC_GLOBAL(sormql,SORMQL)();
    FC_GLOBAL(sormqr,SORMQR)();
    FC_GLOBAL(sormr2,SORMR2)();
    FC_GLOBAL(sormr3,SORMR3)();
    FC_GLOBAL(sormrq,SORMRQ)();
    FC_GLOBAL(sormrz,SORMRZ)();
    FC_GLOBAL(sormtr,SORMTR)();
    FC_GLOBAL(spbcon,SPBCON)();
    FC_GLOBAL(spbequ,SPBEQU)();
    FC_GLOBAL(spbrfs,SPBRFS)();
    FC_GLOBAL(spbstf,SPBSTF)();
    FC_GLOBAL(spbsv,SPBSV)();
    FC_GLOBAL(spbsvx,SPBSVX)();
    FC_GLOBAL(spbtf2,SPBTF2)();
    FC_GLOBAL(spbtrf,SPBTRF)();
    FC_GLOBAL(spbtrs,SPBTRS)();
    FC_GLOBAL(spftrf,SPFTRF)();
    FC_GLOBAL(spftri,SPFTRI)();
    FC_GLOBAL(spftrs,SPFTRS)();
    FC_GLOBAL(spocon,SPOCON)();
    FC_GLOBAL(spoequ,SPOEQU)();
    FC_GLOBAL(spoequb,SPOEQUB)();
    FC_GLOBAL(sporfs,SPORFS)();
    FC_GLOBAL(sposv,SPOSV)();
    FC_GLOBAL(sposvx,SPOSVX)();
    FC_GLOBAL(spotf2,SPOTF2)();
    FC_GLOBAL(spotrf,SPOTRF)();
    FC_GLOBAL(spotrf2,SPOTRF2)();
    FC_GLOBAL(spotri,SPOTRI)();
    FC_GLOBAL(spotrs,SPOTRS)();
    FC_GLOBAL(sppcon,SPPCON)();
    FC_GLOBAL(sppequ,SPPEQU)();
    FC_GLOBAL(spprfs,SPPRFS)();
    FC_GLOBAL(sppsv,SPPSV)();
    FC_GLOBAL(sppsvx,SPPSVX)();
    FC_GLOBAL(spptrf,SPPTRF)();
    FC_GLOBAL(spptri,SPPTRI)();
    FC_GLOBAL(spptrs,SPPTRS)();
    FC_GLOBAL(spstf2,SPSTF2)();
    FC_GLOBAL(spstrf,SPSTRF)();
    FC_GLOBAL(sptcon,SPTCON)();
    FC_GLOBAL(spteqr,SPTEQR)();
    FC_GLOBAL(sptrfs,SPTRFS)();
    FC_GLOBAL(sptsv,SPTSV)();
    FC_GLOBAL(sptsvx,SPTSVX)();
    FC_GLOBAL(spttrf,SPTTRF)();
    FC_GLOBAL(spttrs,SPTTRS)();
    FC_GLOBAL(sptts2,SPTTS2)();
    FC_GLOBAL(sroundup_lwork,SROUNDUP_LWORK)();
    FC_GLOBAL(srscl,SRSCL)();
    FC_GLOBAL(ssb2st_kernels,SSB2ST_KERNELS)();
    FC_GLOBAL(ssbev,SSBEV)();
    FC_GLOBAL(ssbev_2stage,SSBEV_2STAGE)();
    FC_GLOBAL(ssbevd,SSBEVD)();
    FC_GLOBAL(ssbevd_2stage,SSBEVD_2STAGE)();
    FC_GLOBAL(ssbevx,SSBEVX)();
    FC_GLOBAL(ssbevx_2stage,SSBEVX_2STAGE)();
    FC_GLOBAL(ssbgst,SSBGST)();
    FC_GLOBAL(ssbgv,SSBGV)();
    FC_GLOBAL(ssbgvd,SSBGVD)();
    FC_GLOBAL(ssbgvx,SSBGVX)();
    FC_GLOBAL(ssbtrd,SSBTRD)();
    FC_GLOBAL(ssfrk,SSFRK)();
    FC_GLOBAL(sspcon,SSPCON)();
    FC_GLOBAL(sspev,SSPEV)();
    FC_GLOBAL(sspevd,SSPEVD)();
    FC_GLOBAL(sspevx,SSPEVX)();
    FC_GLOBAL(sspgst,SSPGST)();
    FC_GLOBAL(sspgv,SSPGV)();
    FC_GLOBAL(sspgvd,SSPGVD)();
    FC_GLOBAL(sspgvx,SSPGVX)();
    FC_GLOBAL(ssprfs,SSPRFS)();
    FC_GLOBAL(sspsv,SSPSV)();
    FC_GLOBAL(sspsvx,SSPSVX)();
    FC_GLOBAL(ssptrd,SSPTRD)();
    FC_GLOBAL(ssptrf,SSPTRF)();
    FC_GLOBAL(ssptri,SSPTRI)();
    FC_GLOBAL(ssptrs,SSPTRS)();
    FC_GLOBAL(sstebz,SSTEBZ)();
    FC_GLOBAL(sstedc,SSTEDC)();
    FC_GLOBAL(sstegr,SSTEGR)();
    FC_GLOBAL(sstein,SSTEIN)();
    FC_GLOBAL(sstemr,SSTEMR)();
    FC_GLOBAL(ssteqr,SSTEQR)();
    FC_GLOBAL(ssterf,SSTERF)();
    FC_GLOBAL(sstev,SSTEV)();
    FC_GLOBAL(sstevd,SSTEVD)();
    FC_GLOBAL(sstevr,SSTEVR)();
    FC_GLOBAL(sstevx,SSTEVX)();
    FC_GLOBAL(ssycon,SSYCON)();
    FC_GLOBAL(ssycon_3,SSYCON_3)();
    FC_GLOBAL(ssycon_rook,SSYCON_ROOK)();
    FC_GLOBAL(ssyconv,SSYCONV)();
    FC_GLOBAL(ssyconvf,SSYCONVF)();
    FC_GLOBAL(ssyconvf_rook,SSYCONVF_ROOK)();
    FC_GLOBAL(ssyequb,SSYEQUB)();
    FC_GLOBAL(ssyev,SSYEV)();
    FC_GLOBAL(ssyev_2stage,SSYEV_2STAGE)();
    FC_GLOBAL(ssyevd,SSYEVD)();
    FC_GLOBAL(ssyevd_2stage,SSYEVD_2STAGE)();
    FC_GLOBAL(ssyevr,SSYEVR)();
    FC_GLOBAL(ssyevr_2stage,SSYEVR_2STAGE)();
    FC_GLOBAL(ssyevx,SSYEVX)();
    FC_GLOBAL(ssyevx_2stage,SSYEVX_2STAGE)();
    FC_GLOBAL(ssygs2,SSYGS2)();
    FC_GLOBAL(ssygst,SSYGST)();
    FC_GLOBAL(ssygv,SSYGV)();
    FC_GLOBAL(ssygv_2stage,SSYGV_2STAGE)();
    FC_GLOBAL(ssygvd,SSYGVD)();
    FC_GLOBAL(ssygvx,SSYGVX)();
    FC_GLOBAL(ssyrfs,SSYRFS)();
    FC_GLOBAL(ssysv,SSYSV)();
    FC_GLOBAL(ssysv_aa,SSYSV_AA)();
    FC_GLOBAL(ssysv_aa_2stage,SSYSV_AA_2STAGE)();
    FC_GLOBAL(ssysv_rk,SSYSV_RK)();
    FC_GLOBAL(ssysv_rook,SSYSV_ROOK)();
    FC_GLOBAL(ssysvx,SSYSVX)();
    FC_GLOBAL(ssyswapr,SSYSWAPR)();
    FC_GLOBAL(ssytd2,SSYTD2)();
    FC_GLOBAL(ssytf2,SSYTF2)();
    FC_GLOBAL(ssytf2_rk,SSYTF2_RK)();
    FC_GLOBAL(ssytf2_rook,SSYTF2_ROOK)();
    FC_GLOBAL(ssytrd,SSYTRD)();
    FC_GLOBAL(ssytrd_2stage,SSYTRD_2STAGE)();
    FC_GLOBAL(ssytrd_sb2st,SSYTRD_SB2ST)();
    FC_GLOBAL(ssytrd_sy2sb,SSYTRD_SY2SB)();
    FC_GLOBAL(ssytrf,SSYTRF)();
    FC_GLOBAL(ssytrf_aa,SSYTRF_AA)();
    FC_GLOBAL(ssytrf_aa_2stage,SSYTRF_AA_2STAGE)();
    FC_GLOBAL(ssytrf_rk,SSYTRF_RK)();
    FC_GLOBAL(ssytrf_rook,SSYTRF_ROOK)();
    FC_GLOBAL(ssytri,SSYTRI)();
    FC_GLOBAL(ssytri2,SSYTRI2)();
    FC_GLOBAL(ssytri2x,SSYTRI2X)();
    FC_GLOBAL(ssytri_3,SSYTRI_3)();
    FC_GLOBAL(ssytri_3x,SSYTRI_3X)();
    FC_GLOBAL(ssytri_rook,SSYTRI_ROOK)();
    FC_GLOBAL(ssytrs,SSYTRS)();
    FC_GLOBAL(ssytrs2,SSYTRS2)();
    FC_GLOBAL(ssytrs_3,SSYTRS_3)();
    FC_GLOBAL(ssytrs_aa,SSYTRS_AA)();
    FC_GLOBAL(ssytrs_aa_2stage,SSYTRS_AA_2STAGE)();
    FC_GLOBAL(ssytrs_rook,SSYTRS_ROOK)();
    FC_GLOBAL(stbcon,STBCON)();
    FC_GLOBAL(stbrfs,STBRFS)();
    FC_GLOBAL(stbtrs,STBTRS)();
    FC_GLOBAL(stfsm,STFSM)();
    FC_GLOBAL(stftri,STFTRI)();
    FC_GLOBAL(stfttp,STFTTP)();
    FC_GLOBAL(stfttr,STFTTR)();
    FC_GLOBAL(stgevc,STGEVC)();
    FC_GLOBAL(stgex2,STGEX2)();
    FC_GLOBAL(stgexc,STGEXC)();
    FC_GLOBAL(stgsen,STGSEN)();
    FC_GLOBAL(stgsja,STGSJA)();
    FC_GLOBAL(stgsna,STGSNA)();
    FC_GLOBAL(stgsy2,STGSY2)();
    FC_GLOBAL(stgsyl,STGSYL)();
    FC_GLOBAL(stpcon,STPCON)();
    FC_GLOBAL(stplqt,STPLQT)();
    FC_GLOBAL(stplqt2,STPLQT2)();
    FC_GLOBAL(stpmlqt,STPMLQT)();
    FC_GLOBAL(stpmqrt,STPMQRT)();
    FC_GLOBAL(stpqrt,STPQRT)();
    FC_GLOBAL(stpqrt2,STPQRT2)();
    FC_GLOBAL(stprfb,STPRFB)();
    FC_GLOBAL(stprfs,STPRFS)();
    FC_GLOBAL(stptri,STPTRI)();
    FC_GLOBAL(stptrs,STPTRS)();
    FC_GLOBAL(stpttf,STPTTF)();
    FC_GLOBAL(stpttr,STPTTR)();
    FC_GLOBAL(strcon,STRCON)();
    FC_GLOBAL(strevc,STREVC)();
    FC_GLOBAL(strevc3,STREVC3)();
    FC_GLOBAL(strexc,STREXC)();
    FC_GLOBAL(strrfs,STRRFS)();
    FC_GLOBAL(strsen,STRSEN)();
    FC_GLOBAL(strsna,STRSNA)();
    FC_GLOBAL(strsyl,STRSYL)();
    FC_GLOBAL(strsyl3,STRSYL3)();
    FC_GLOBAL(strti2,STRTI2)();
    FC_GLOBAL(strtri,STRTRI)();
    FC_GLOBAL(strtrs,STRTRS)();
    FC_GLOBAL(strttf,STRTTF)();
    FC_GLOBAL(strttp,STRTTP)();
    FC_GLOBAL(stzrzf,STZRZF)();
    FC_GLOBAL(xerbla_array,XERBLA_ARRAY)();
    FC_GLOBAL(zbbcsd,ZBBCSD)();
    FC_GLOBAL(zbdsqr,ZBDSQR)();
    FC_GLOBAL(zcgesv,ZCGESV)();
    FC_GLOBAL(zcposv,ZCPOSV)();
    FC_GLOBAL(zdrscl,ZDRSCL)();
    FC_GLOBAL(zgbbrd,ZGBBRD)();
    FC_GLOBAL(zgbcon,ZGBCON)();
    FC_GLOBAL(zgbequ,ZGBEQU)();
    FC_GLOBAL(zgbequb,ZGBEQUB)();
    FC_GLOBAL(zgbrfs,ZGBRFS)();
    FC_GLOBAL(zgbsv,ZGBSV)();
    FC_GLOBAL(zgbsvx,ZGBSVX)();
    FC_GLOBAL(zgbtf2,ZGBTF2)();
    FC_GLOBAL(zgbtrf,ZGBTRF)();
    FC_GLOBAL(zgbtrs,ZGBTRS)();
    FC_GLOBAL(zgebak,ZGEBAK)();
    FC_GLOBAL(zgebal,ZGEBAL)();
    FC_GLOBAL(zgebd2,ZGEBD2)();
    FC_GLOBAL(zgebrd,ZGEBRD)();
    FC_GLOBAL(zgecon,ZGECON)();
    FC_GLOBAL(zgeequ,ZGEEQU)();
    FC_GLOBAL(zgeequb,ZGEEQUB)();
    FC_GLOBAL(zgees,ZGEES)();
    FC_GLOBAL(zgeesx,ZGEESX)();
    FC_GLOBAL(zgeev,ZGEEV)();
    FC_GLOBAL(zgeevx,ZGEEVX)();
    FC_GLOBAL(zgehd2,ZGEHD2)();
    FC_GLOBAL(zgehrd,ZGEHRD)();
    FC_GLOBAL(zgejsv,ZGEJSV)();
    FC_GLOBAL(zgelq,ZGELQ)();
    FC_GLOBAL(zgelq2,ZGELQ2)();
    FC_GLOBAL(zgelqf,ZGELQF)();
    FC_GLOBAL(zgelqt,ZGELQT)();
    FC_GLOBAL(zgelqt3,ZGELQT3)();
    FC_GLOBAL(zgels,ZGELS)();
    FC_GLOBAL(zgelsd,ZGELSD)();
    FC_GLOBAL(zgelss,ZGELSS)();
    FC_GLOBAL(zgelst,ZGELST)();
    FC_GLOBAL(zgelsy,ZGELSY)();
    FC_GLOBAL(zgemlq,ZGEMLQ)();
    FC_GLOBAL(zgemlqt,ZGEMLQT)();
    FC_GLOBAL(zgemqr,ZGEMQR)();
    FC_GLOBAL(zgemqrt,ZGEMQRT)();
    FC_GLOBAL(zgeql2,ZGEQL2)();
    FC_GLOBAL(zgeqlf,ZGEQLF)();
    FC_GLOBAL(zgeqp3,ZGEQP3)();
    FC_GLOBAL(zgeqr,ZGEQR)();
    FC_GLOBAL(zgeqr2,ZGEQR2)();
    FC_GLOBAL(zgeqr2p,ZGEQR2P)();
    FC_GLOBAL(zgeqrf,ZGEQRF)();
    FC_GLOBAL(zgeqrfp,ZGEQRFP)();
    FC_GLOBAL(zgeqrt,ZGEQRT)();
    FC_GLOBAL(zgeqrt2,ZGEQRT2)();
    FC_GLOBAL(zgeqrt3,ZGEQRT3)();
    FC_GLOBAL(zgerfs,ZGERFS)();
    FC_GLOBAL(zgerq2,ZGERQ2)();
    FC_GLOBAL(zgerqf,ZGERQF)();
    FC_GLOBAL(zgesc2,ZGESC2)();
    FC_GLOBAL(zgesdd,ZGESDD)();
    FC_GLOBAL(zgesv,ZGESV)();
    FC_GLOBAL(zgesvd,ZGESVD)();
    FC_GLOBAL(zgesvdq,ZGESVDQ)();
    FC_GLOBAL(zgesvdx,ZGESVDX)();
    FC_GLOBAL(zgesvj,ZGESVJ)();
    FC_GLOBAL(zgesvx,ZGESVX)();
    FC_GLOBAL(zgetc2,ZGETC2)();
    FC_GLOBAL(zgetf2,ZGETF2)();
    FC_GLOBAL(zgetrf,ZGETRF)();
    FC_GLOBAL(zgetrf2,ZGETRF2)();
    FC_GLOBAL(zgetri,ZGETRI)();
    FC_GLOBAL(zgetrs,ZGETRS)();
    FC_GLOBAL(zgetsls,ZGETSLS)();
    FC_GLOBAL(zgetsqrhrt,ZGETSQRHRT)();
    FC_GLOBAL(zggbak,ZGGBAK)();
    FC_GLOBAL(zggbal,ZGGBAL)();
    FC_GLOBAL(zgges,ZGGES)();
    FC_GLOBAL(zgges3,ZGGES3)();
    FC_GLOBAL(zggesx,ZGGESX)();
    FC_GLOBAL(zggev,ZGGEV)();
    FC_GLOBAL(zggev3,ZGGEV3)();
    FC_GLOBAL(zggevx,ZGGEVX)();
    FC_GLOBAL(zggglm,ZGGGLM)();
    FC_GLOBAL(zgghd3,ZGGHD3)();
    FC_GLOBAL(zgghrd,ZGGHRD)();
    FC_GLOBAL(zgglse,ZGGLSE)();
    FC_GLOBAL(zggqrf,ZGGQRF)();
    FC_GLOBAL(zggrqf,ZGGRQF)();
    FC_GLOBAL(zggsvd3,ZGGSVD3)();
    FC_GLOBAL(zggsvp3,ZGGSVP3)();
    FC_GLOBAL(zgsvj0,ZGSVJ0)();
    FC_GLOBAL(zgsvj1,ZGSVJ1)();
    FC_GLOBAL(zgtcon,ZGTCON)();
    FC_GLOBAL(zgtrfs,ZGTRFS)();
    FC_GLOBAL(zgtsv,ZGTSV)();
    FC_GLOBAL(zgtsvx,ZGTSVX)();
    FC_GLOBAL(zgttrf,ZGTTRF)();
    FC_GLOBAL(zgttrs,ZGTTRS)();
    FC_GLOBAL(zgtts2,ZGTTS2)();
    FC_GLOBAL(zhb2st_kernels,ZHB2ST_KERNELS)();
    FC_GLOBAL(zhbev,ZHBEV)();
    FC_GLOBAL(zhbev_2stage,ZHBEV_2STAGE)();
    FC_GLOBAL(zhbevd,ZHBEVD)();
    FC_GLOBAL(zhbevd_2stage,ZHBEVD_2STAGE)();
    FC_GLOBAL(zhbevx,ZHBEVX)();
    FC_GLOBAL(zhbevx_2stage,ZHBEVX_2STAGE)();
    FC_GLOBAL(zhbgst,ZHBGST)();
    FC_GLOBAL(zhbgv,ZHBGV)();
    FC_GLOBAL(zhbgvd,ZHBGVD)();
    FC_GLOBAL(zhbgvx,ZHBGVX)();
    FC_GLOBAL(zhbtrd,ZHBTRD)();
    FC_GLOBAL(zhecon,ZHECON)();
    FC_GLOBAL(zhecon_3,ZHECON_3)();
    FC_GLOBAL(zhecon_rook,ZHECON_ROOK)();
    FC_GLOBAL(zheequb,ZHEEQUB)();
    FC_GLOBAL(zheev,ZHEEV)();
    FC_GLOBAL(zheev_2stage,ZHEEV_2STAGE)();
    FC_GLOBAL(zheevd,ZHEEVD)();
    FC_GLOBAL(zheevd_2stage,ZHEEVD_2STAGE)();
    FC_GLOBAL(zheevr,ZHEEVR)();
    FC_GLOBAL(zheevr_2stage,ZHEEVR_2STAGE)();
    FC_GLOBAL(zheevx,ZHEEVX)();
    FC_GLOBAL(zheevx_2stage,ZHEEVX_2STAGE)();
    FC_GLOBAL(zhegs2,ZHEGS2)();
    FC_GLOBAL(zhegst,ZHEGST)();
    FC_GLOBAL(zhegv,ZHEGV)();
    FC_GLOBAL(zhegv_2stage,ZHEGV_2STAGE)();
    FC_GLOBAL(zhegvd,ZHEGVD)();
    FC_GLOBAL(zhegvx,ZHEGVX)();
    FC_GLOBAL(zherfs,ZHERFS)();
    FC_GLOBAL(zhesv,ZHESV)();
    FC_GLOBAL(zhesv_aa,ZHESV_AA)();
    FC_GLOBAL(zhesv_aa_2stage,ZHESV_AA_2STAGE)();
    FC_GLOBAL(zhesv_rk,ZHESV_RK)();
    FC_GLOBAL(zhesv_rook,ZHESV_ROOK)();
    FC_GLOBAL(zhesvx,ZHESVX)();
    FC_GLOBAL(zheswapr,ZHESWAPR)();
    FC_GLOBAL(zhetd2,ZHETD2)();
    FC_GLOBAL(zhetf2,ZHETF2)();
    FC_GLOBAL(zhetf2_rk,ZHETF2_RK)();
    FC_GLOBAL(zhetf2_rook,ZHETF2_ROOK)();
    FC_GLOBAL(zhetrd,ZHETRD)();
    FC_GLOBAL(zhetrd_2stage,ZHETRD_2STAGE)();
    FC_GLOBAL(zhetrd_hb2st,ZHETRD_HB2ST)();
    FC_GLOBAL(zhetrd_he2hb,ZHETRD_HE2HB)();
    FC_GLOBAL(zhetrf,ZHETRF)();
    FC_GLOBAL(zhetrf_aa,ZHETRF_AA)();
    FC_GLOBAL(zhetrf_aa_2stage,ZHETRF_AA_2STAGE)();
    FC_GLOBAL(zhetrf_rk,ZHETRF_RK)();
    FC_GLOBAL(zhetrf_rook,ZHETRF_ROOK)();
    FC_GLOBAL(zhetri,ZHETRI)();
    FC_GLOBAL(zhetri2,ZHETRI2)();
    FC_GLOBAL(zhetri2x,ZHETRI2X)();
    FC_GLOBAL(zhetri_3,ZHETRI_3)();
    FC_GLOBAL(zhetri_3x,ZHETRI_3X)();
    FC_GLOBAL(zhetri_rook,ZHETRI_ROOK)();
    FC_GLOBAL(zhetrs,ZHETRS)();
    FC_GLOBAL(zhetrs2,ZHETRS2)();
    FC_GLOBAL(zhetrs_3,ZHETRS_3)();
    FC_GLOBAL(zhetrs_aa,ZHETRS_AA)();
    FC_GLOBAL(zhetrs_aa_2stage,ZHETRS_AA_2STAGE)();
    FC_GLOBAL(zhetrs_rook,ZHETRS_ROOK)();
    FC_GLOBAL(zhfrk,ZHFRK)();
    FC_GLOBAL(zhgeqz,ZHGEQZ)();
    FC_GLOBAL(zhpcon,ZHPCON)();
    FC_GLOBAL(zhpev,ZHPEV)();
    FC_GLOBAL(zhpevd,ZHPEVD)();
    FC_GLOBAL(zhpevx,ZHPEVX)();
    FC_GLOBAL(zhpgst,ZHPGST)();
    FC_GLOBAL(zhpgv,ZHPGV)();
    FC_GLOBAL(zhpgvd,ZHPGVD)();
    FC_GLOBAL(zhpgvx,ZHPGVX)();
    FC_GLOBAL(zhprfs,ZHPRFS)();
    FC_GLOBAL(zhpsv,ZHPSV)();
    FC_GLOBAL(zhpsvx,ZHPSVX)();
    FC_GLOBAL(zhptrd,ZHPTRD)();
    FC_GLOBAL(zhptrf,ZHPTRF)();
    FC_GLOBAL(zhptri,ZHPTRI)();
    FC_GLOBAL(zhptrs,ZHPTRS)();
    FC_GLOBAL(zhsein,ZHSEIN)();
    FC_GLOBAL(zhseqr,ZHSEQR)();
    FC_GLOBAL(zlabrd,ZLABRD)();
    FC_GLOBAL(zlacgv,ZLACGV)();
    FC_GLOBAL(zlacn2,ZLACN2)();
    FC_GLOBAL(zlacon,ZLACON)();
    FC_GLOBAL(zlacp2,ZLACP2)();
    FC_GLOBAL(zlacpy,ZLACPY)();
    FC_GLOBAL(zlacrm,ZLACRM)();
    FC_GLOBAL(zlacrt,ZLACRT)();
    FC_GLOBAL(zladiv,ZLADIV)();
    FC_GLOBAL(zlaed0,ZLAED0)();
    FC_GLOBAL(zlaed7,ZLAED7)();
    FC_GLOBAL(zlaed8,ZLAED8)();
    FC_GLOBAL(zlaein,ZLAEIN)();
    FC_GLOBAL(zlaesy,ZLAESY)();
    FC_GLOBAL(zlaev2,ZLAEV2)();
    FC_GLOBAL(zlag2c,ZLAG2C)();
    FC_GLOBAL(zlags2,ZLAGS2)();
    FC_GLOBAL(zlagtm,ZLAGTM)();
    FC_GLOBAL(zlahef,ZLAHEF)();
    FC_GLOBAL(zlahef_aa,ZLAHEF_AA)();
    FC_GLOBAL(zlahef_rk,ZLAHEF_RK)();
    FC_GLOBAL(zlahef_rook,ZLAHEF_ROOK)();
    FC_GLOBAL(zlahqr,ZLAHQR)();
    FC_GLOBAL(zlahr2,ZLAHR2)();
    FC_GLOBAL(zlaic1,ZLAIC1)();
    FC_GLOBAL(zlals0,ZLALS0)();
    FC_GLOBAL(zlalsa,ZLALSA)();
    FC_GLOBAL(zlalsd,ZLALSD)();
    FC_GLOBAL(zlamswlq,ZLAMSWLQ)();
    FC_GLOBAL(zlamtsqr,ZLAMTSQR)();
    FC_GLOBAL(zlangb,ZLANGB)();
    FC_GLOBAL(zlange,ZLANGE)();
    FC_GLOBAL(zlangt,ZLANGT)();
    FC_GLOBAL(zlanhb,ZLANHB)();
    FC_GLOBAL(zlanhe,ZLANHE)();
    FC_GLOBAL(zlanhf,ZLANHF)();
    FC_GLOBAL(zlanhp,ZLANHP)();
    FC_GLOBAL(zlanhs,ZLANHS)();
    FC_GLOBAL(zlanht,ZLANHT)();
    FC_GLOBAL(zlansb,ZLANSB)();
    FC_GLOBAL(zlansp,ZLANSP)();
    FC_GLOBAL(zlansy,ZLANSY)();
    FC_GLOBAL(zlantb,ZLANTB)();
    FC_GLOBAL(zlantp,ZLANTP)();
    FC_GLOBAL(zlantr,ZLANTR)();
    FC_GLOBAL(zlapll,ZLAPLL)();
    FC_GLOBAL(zlapmr,ZLAPMR)();
    FC_GLOBAL(zlapmt,ZLAPMT)();
    FC_GLOBAL(zlaqgb,ZLAQGB)();
    FC_GLOBAL(zlaqge,ZLAQGE)();
    FC_GLOBAL(zlaqhb,ZLAQHB)();
    FC_GLOBAL(zlaqhe,ZLAQHE)();
    FC_GLOBAL(zlaqhp,ZLAQHP)();
    FC_GLOBAL(zlaqp2,ZLAQP2)();
    FC_GLOBAL(zlaqps,ZLAQPS)();
    FC_GLOBAL(zlaqr0,ZLAQR0)();
    FC_GLOBAL(zlaqr1,ZLAQR1)();
    FC_GLOBAL(zlaqr2,ZLAQR2)();
    FC_GLOBAL(zlaqr3,ZLAQR3)();
    FC_GLOBAL(zlaqr4,ZLAQR4)();
    FC_GLOBAL(zlaqr5,ZLAQR5)();
    FC_GLOBAL(zlaqsb,ZLAQSB)();
    FC_GLOBAL(zlaqsp,ZLAQSP)();
    FC_GLOBAL(zlaqsy,ZLAQSY)();
    FC_GLOBAL(zlaqz0,ZLAQZ0)();
    FC_GLOBAL(zlaqz1,ZLAQZ1)();
    FC_GLOBAL(zlaqz2,ZLAQZ2)();
    FC_GLOBAL(zlaqz3,ZLAQZ3)();
    FC_GLOBAL(zlar1v,ZLAR1V)();
    FC_GLOBAL(zlar2v,ZLAR2V)();
    FC_GLOBAL(zlarcm,ZLARCM)();
    FC_GLOBAL(zlarf,ZLARF)();
    FC_GLOBAL(zlarfb,ZLARFB)();
    FC_GLOBAL(zlarfb_gett,ZLARFB_GETT)();
    FC_GLOBAL(zlarfg,ZLARFG)();
    FC_GLOBAL(zlarfgp,ZLARFGP)();
    FC_GLOBAL(zlarft,ZLARFT)();
    FC_GLOBAL(zlarfx,ZLARFX)();
    FC_GLOBAL(zlarfy,ZLARFY)();
    FC_GLOBAL(zlargv,ZLARGV)();
    FC_GLOBAL(zlarnv,ZLARNV)();
    FC_GLOBAL(zlarrv,ZLARRV)();
    FC_GLOBAL(zlartg,ZLARTG)();
    FC_GLOBAL(zlartv,ZLARTV)();
    FC_GLOBAL(zlarz,ZLARZ)();
    FC_GLOBAL(zlarzb,ZLARZB)();
    FC_GLOBAL(zlarzt,ZLARZT)();
    FC_GLOBAL(zlascl,ZLASCL)();
    FC_GLOBAL(zlaset,ZLASET)();
    FC_GLOBAL(zlasr,ZLASR)();
    FC_GLOBAL(zlassq,ZLASSQ)();
    FC_GLOBAL(zlaswlq,ZLASWLQ)();
    FC_GLOBAL(zlaswp,ZLASWP)();
    FC_GLOBAL(zlasyf,ZLASYF)();
    FC_GLOBAL(zlasyf_aa,ZLASYF_AA)();
    FC_GLOBAL(zlasyf_rk,ZLASYF_RK)();
    FC_GLOBAL(zlasyf_rook,ZLASYF_ROOK)();
    FC_GLOBAL(zlat2c,ZLAT2C)();
    FC_GLOBAL(zlatbs,ZLATBS)();
    FC_GLOBAL(zlatdf,ZLATDF)();
    FC_GLOBAL(zlatps,ZLATPS)();
    FC_GLOBAL(zlatrd,ZLATRD)();
    FC_GLOBAL(zlatrs,ZLATRS)();
    FC_GLOBAL(zlatrs3,ZLATRS3)();
    FC_GLOBAL(zlatrz,ZLATRZ)();
    FC_GLOBAL(zlatsqr,ZLATSQR)();
    FC_GLOBAL(zlaunhr_col_getrfnp,ZLAUNHR_COL_GETRFNP)();
    FC_GLOBAL(zlaunhr_col_getrfnp2,ZLAUNHR_COL_GETRFNP2)();
    FC_GLOBAL(zlauu2,ZLAUU2)();
    FC_GLOBAL(zlauum,ZLAUUM)();
    FC_GLOBAL(zpbcon,ZPBCON)();
    FC_GLOBAL(zpbequ,ZPBEQU)();
    FC_GLOBAL(zpbrfs,ZPBRFS)();
    FC_GLOBAL(zpbstf,ZPBSTF)();
    FC_GLOBAL(zpbsv,ZPBSV)();
    FC_GLOBAL(zpbsvx,ZPBSVX)();
    FC_GLOBAL(zpbtf2,ZPBTF2)();
    FC_GLOBAL(zpbtrf,ZPBTRF)();
    FC_GLOBAL(zpbtrs,ZPBTRS)();
    FC_GLOBAL(zpftrf,ZPFTRF)();
    FC_GLOBAL(zpftri,ZPFTRI)();
    FC_GLOBAL(zpftrs,ZPFTRS)();
    FC_GLOBAL(zpocon,ZPOCON)();
    FC_GLOBAL(zpoequ,ZPOEQU)();
    FC_GLOBAL(zpoequb,ZPOEQUB)();
    FC_GLOBAL(zporfs,ZPORFS)();
    FC_GLOBAL(zposv,ZPOSV)();
    FC_GLOBAL(zposvx,ZPOSVX)();
    FC_GLOBAL(zpotf2,ZPOTF2)();
    FC_GLOBAL(zpotrf,ZPOTRF)();
    FC_GLOBAL(zpotrf2,ZPOTRF2)();
    FC_GLOBAL(zpotri,ZPOTRI)();
    FC_GLOBAL(zpotrs,ZPOTRS)();
    FC_GLOBAL(zppcon,ZPPCON)();
    FC_GLOBAL(zppequ,ZPPEQU)();
    FC_GLOBAL(zpprfs,ZPPRFS)();
    FC_GLOBAL(zppsv,ZPPSV)();
    FC_GLOBAL(zppsvx,ZPPSVX)();
    FC_GLOBAL(zpptrf,ZPPTRF)();
    FC_GLOBAL(zpptri,ZPPTRI)();
    FC_GLOBAL(zpptrs,ZPPTRS)();
    FC_GLOBAL(zpstf2,ZPSTF2)();
    FC_GLOBAL(zpstrf,ZPSTRF)();
    FC_GLOBAL(zptcon,ZPTCON)();
    FC_GLOBAL(zpteqr,ZPTEQR)();
    FC_GLOBAL(zptrfs,ZPTRFS)();
    FC_GLOBAL(zptsv,ZPTSV)();
    FC_GLOBAL(zptsvx,ZPTSVX)();
    FC_GLOBAL(zpttrf,ZPTTRF)();
    FC_GLOBAL(zpttrs,ZPTTRS)();
    FC_GLOBAL(zptts2,ZPTTS2)();
    FC_GLOBAL(zrot,ZROT)();
    FC_GLOBAL(zspcon,ZSPCON)();
    FC_GLOBAL(zspmv,ZSPMV)();
    FC_GLOBAL(zspr,ZSPR)();
    FC_GLOBAL(zsprfs,ZSPRFS)();
    FC_GLOBAL(zspsv,ZSPSV)();
    FC_GLOBAL(zspsvx,ZSPSVX)();
    FC_GLOBAL(zsptrf,ZSPTRF)();
    FC_GLOBAL(zsptri,ZSPTRI)();
    FC_GLOBAL(zsptrs,ZSPTRS)();
    FC_GLOBAL(zstedc,ZSTEDC)();
    FC_GLOBAL(zstegr,ZSTEGR)();
    FC_GLOBAL(zstein,ZSTEIN)();
    FC_GLOBAL(zstemr,ZSTEMR)();
    FC_GLOBAL(zsteqr,ZSTEQR)();
    FC_GLOBAL(zsycon,ZSYCON)();
    FC_GLOBAL(zsycon_3,ZSYCON_3)();
    FC_GLOBAL(zsycon_rook,ZSYCON_ROOK)();
    FC_GLOBAL(zsyconv,ZSYCONV)();
    FC_GLOBAL(zsyconvf,ZSYCONVF)();
    FC_GLOBAL(zsyconvf_rook,ZSYCONVF_ROOK)();
    FC_GLOBAL(zsyequb,ZSYEQUB)();
    FC_GLOBAL(zsymv,ZSYMV)();
    FC_GLOBAL(zsyr,ZSYR)();
    FC_GLOBAL(zsyrfs,ZSYRFS)();
    FC_GLOBAL(zsysv,ZSYSV)();
    FC_GLOBAL(zsysv_aa,ZSYSV_AA)();
    FC_GLOBAL(zsysv_aa_2stage,ZSYSV_AA_2STAGE)();
    FC_GLOBAL(zsysv_rk,ZSYSV_RK)();
    FC_GLOBAL(zsysv_rook,ZSYSV_ROOK)();
    FC_GLOBAL(zsysvx,ZSYSVX)();
    FC_GLOBAL(zsyswapr,ZSYSWAPR)();
    FC_GLOBAL(zsytf2,ZSYTF2)();
    FC_GLOBAL(zsytf2_rk,ZSYTF2_RK)();
    FC_GLOBAL(zsytf2_rook,ZSYTF2_ROOK)();
    FC_GLOBAL(zsytrf,ZSYTRF)();
    FC_GLOBAL(zsytrf_aa,ZSYTRF_AA)();
    FC_GLOBAL(zsytrf_aa_2stage,ZSYTRF_AA_2STAGE)();
    FC_GLOBAL(zsytrf_rk,ZSYTRF_RK)();
    FC_GLOBAL(zsytrf_rook,ZSYTRF_ROOK)();
    FC_GLOBAL(zsytri,ZSYTRI)();
    FC_GLOBAL(zsytri2,ZSYTRI2)();
    FC_GLOBAL(zsytri2x,ZSYTRI2X)();
    FC_GLOBAL(zsytri_3,ZSYTRI_3)();
    FC_GLOBAL(zsytri_3x,ZSYTRI_3X)();
    FC_GLOBAL(zsytri_rook,ZSYTRI_ROOK)();
    FC_GLOBAL(zsytrs,ZSYTRS)();
    FC_GLOBAL(zsytrs2,ZSYTRS2)();
    FC_GLOBAL(zsytrs_3,ZSYTRS_3)();
    FC_GLOBAL(zsytrs_aa,ZSYTRS_AA)();
    FC_GLOBAL(zsytrs_aa_2stage,ZSYTRS_AA_2STAGE)();
    FC_GLOBAL(zsytrs_rook,ZSYTRS_ROOK)();
    FC_GLOBAL(ztbcon,ZTBCON)();
    FC_GLOBAL(ztbrfs,ZTBRFS)();
    FC_GLOBAL(ztbtrs,ZTBTRS)();
    FC_GLOBAL(ztfsm,ZTFSM)();
    FC_GLOBAL(ztftri,ZTFTRI)();
    FC_GLOBAL(ztfttp,ZTFTTP)();
    FC_GLOBAL(ztfttr,ZTFTTR)();
    FC_GLOBAL(ztgevc,ZTGEVC)();
    FC_GLOBAL(ztgex2,ZTGEX2)();
    FC_GLOBAL(ztgexc,ZTGEXC)();
    FC_GLOBAL(ztgsen,ZTGSEN)();
    FC_GLOBAL(ztgsja,ZTGSJA)();
    FC_GLOBAL(ztgsna,ZTGSNA)();
    FC_GLOBAL(ztgsy2,ZTGSY2)();
    FC_GLOBAL(ztgsyl,ZTGSYL)();
    FC_GLOBAL(ztpcon,ZTPCON)();
    FC_GLOBAL(ztplqt,ZTPLQT)();
    FC_GLOBAL(ztplqt2,ZTPLQT2)();
    FC_GLOBAL(ztpmlqt,ZTPMLQT)();
    FC_GLOBAL(ztpmqrt,ZTPMQRT)();
    FC_GLOBAL(ztpqrt,ZTPQRT)();
    FC_GLOBAL(ztpqrt2,ZTPQRT2)();
    FC_GLOBAL(ztprfb,ZTPRFB)();
    FC_GLOBAL(ztprfs,ZTPRFS)();
    FC_GLOBAL(ztptri,ZTPTRI)();
    FC_GLOBAL(ztptrs,ZTPTRS)();
    FC_GLOBAL(ztpttf,ZTPTTF)();
    FC_GLOBAL(ztpttr,ZTPTTR)();
    FC_GLOBAL(ztrcon,ZTRCON)();
    FC_GLOBAL(ztrevc,ZTREVC)();
    FC_GLOBAL(ztrevc3,ZTREVC3)();
    FC_GLOBAL(ztrexc,ZTREXC)();
    FC_GLOBAL(ztrrfs,ZTRRFS)();
    FC_GLOBAL(ztrsen,ZTRSEN)();
    FC_GLOBAL(ztrsna,ZTRSNA)();
    FC_GLOBAL(ztrsyl,ZTRSYL)();
    FC_GLOBAL(ztrsyl3,ZTRSYL3)();
    FC_GLOBAL(ztrti2,ZTRTI2)();
    FC_GLOBAL(ztrtri,ZTRTRI)();
    FC_GLOBAL(ztrtrs,ZTRTRS)();
    FC_GLOBAL(ztrttf,ZTRTTF)();
    FC_GLOBAL(ztrttp,ZTRTTP)();
    FC_GLOBAL(ztzrzf,ZTZRZF)();
    FC_GLOBAL(zunbdb,ZUNBDB)();
    FC_GLOBAL(zunbdb1,ZUNBDB1)();
    FC_GLOBAL(zunbdb2,ZUNBDB2)();
    FC_GLOBAL(zunbdb3,ZUNBDB3)();
    FC_GLOBAL(zunbdb4,ZUNBDB4)();
    FC_GLOBAL(zunbdb5,ZUNBDB5)();
    FC_GLOBAL(zunbdb6,ZUNBDB6)();
    FC_GLOBAL(zuncsd,ZUNCSD)();
    FC_GLOBAL(zuncsd2by1,ZUNCSD2BY1)();
    FC_GLOBAL(zung2l,ZUNG2L)();
    FC_GLOBAL(zung2r,ZUNG2R)();
    FC_GLOBAL(zungbr,ZUNGBR)();
    FC_GLOBAL(zunghr,ZUNGHR)();
    FC_GLOBAL(zungl2,ZUNGL2)();
    FC_GLOBAL(zunglq,ZUNGLQ)();
    FC_GLOBAL(zungql,ZUNGQL)();
    FC_GLOBAL(zungqr,ZUNGQR)();
    FC_GLOBAL(zungr2,ZUNGR2)();
    FC_GLOBAL(zungrq,ZUNGRQ)();
    FC_GLOBAL(zungtr,ZUNGTR)();
    FC_GLOBAL(zungtsqr,ZUNGTSQR)();
    FC_GLOBAL(zungtsqr_row,ZUNGTSQR_ROW)();
    FC_GLOBAL(zunhr_col,ZUNHR_COL)();
    FC_GLOBAL(zunm22,ZUNM22)();
    FC_GLOBAL(zunm2l,ZUNM2L)();
    FC_GLOBAL(zunm2r,ZUNM2R)();
    FC_GLOBAL(zunmbr,ZUNMBR)();
    FC_GLOBAL(zunmhr,ZUNMHR)();
    FC_GLOBAL(zunml2,ZUNML2)();
    FC_GLOBAL(zunmlq,ZUNMLQ)();
    FC_GLOBAL(zunmql,ZUNMQL)();
    FC_GLOBAL(zunmqr,ZUNMQR)();
    FC_GLOBAL(zunmr2,ZUNMR2)();
    FC_GLOBAL(zunmr3,ZUNMR3)();
    FC_GLOBAL(zunmrq,ZUNMRQ)();
    FC_GLOBAL(zunmrz,ZUNMRZ)();
    FC_GLOBAL(zunmtr,ZUNMTR)();
    FC_GLOBAL(zupgtr,ZUPGTR)();
    FC_GLOBAL(zupmtr,ZUPMTR)();

}
