
/* libfizmo_locales.h
 *
 * This file is part of fizmo.
 *
 * Copyright (c) 2009-2016 Christoph Ender.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef libfizmo_locales_h_INCLUDED 
#define libfizmo_locales_h_INCLUDED

#define i18n_libfizmo_COULD_NOT_OPEN_TRACE_FILE_P0S 0
#define i18n_libfizmo_INVALID_PARAMETER_TYPE_P0S 1
#define i18n_libfizmo_FUNCTION_CALL_P0S_ABORTED_DUE_TO_ERROR 2
#define i18n_libfizmo_INVALID_BACKSLASH_SEQUENCE_IN_LOCALIZATION_DATA 3
#define i18n_libfizmo_WARNING_FOR_P0S_AT_P0X 4
#define i18n_libfizmo_FUNCTION_CALL_P0S_RETURNED_ERROR_CODE_P1D 5
#define i18n_libfizmo_ERROR_WHILE_READING_FILE_P0S 6
#define i18n_libfizmo_COULD_NOT_OPEN_FILE_NAMED_P0S 7
#define i18n_libfizmo_ERROR_READING_FIRST_STORY_BYTE_FROM_P0S 8
#define i18n_libfizmo_UNKNOWN_STORY_VERSION_P0D 9
#define i18n_libfizmo_ERROR_WHILE_CLOSING_FILE_P0S 10
#define i18n_libfizmo_FUNCTION_CALL_MALLOC_P0D_RETURNED_NULL_PROBABLY_OUT_OF_MEMORY 11
#define i18n_libfizmo_FUNCTION_CALL_REALLOC_P0D_RETURNED_NULL_PROBABLY_OUT_OF_MEMORY 12
#define i18n_libfizmo_FATAL_ERROR_READING_STORY_FILE 13
#define i18n_libfizmo_NOT_YET_IMPLEMENTED 14
#define i18n_libfizmo_INSTRUCTION_FORM_NOT_INITIALIZED 15
#define i18n_libfizmo_UNKNOWN_OPERAND_TYPE_P0D 16
#define i18n_libfizmo_OPCODE_P0D_IN_FORM_P1D_NOT_IMPLEMENTED 17
#define i18n_libfizmo_CANNOT_PULL_FROM_EMPTY_STACK 18
#define i18n_libfizmo_CANNOT_DROP_P0D_WORDS_FROM_STACK_NOT_ENOUGH_WORDS_STORED 19
#define i18n_libfizmo_PLEASE_ENTER_NAME_FOR_COMMANDFILE 20
#define i18n_libfizmo_FILENAME_MUST_NOT_BE_EMPTY 21
#define i18n_libfizmo_PLEASE_ENTER_SCRIPT_FILENAME 22
#define i18n_libfizmo_INVALID_OUTPUT_STREAM_NUMBER_P0D 23
#define i18n_libfizmo_MAXIMUM_STREAM_3_DEPTH_P0D_EXCEEDED 24
#define i18n_libfizmo_THIS_FUNCTION_HAS_BEEN_DISABLED 25
#define i18n_libfizmo_MORE_THAN_15_LOCALS_ARE_NOT_ALLOWED 26
#define i18n_libfizmo_INVALID_THROW_DESTINATION_STACK_INDEX_P0D 27
#define i18n_libfizmo_MAXIMUM_NUMBER_OF_STACK_ENTRIES_PER_ROUTINE_P0D_EXCEEDED 28
#define i18n_libfizmo_TRYING_TO_STORE_VARIABLE_L_P0D_BUT_ONLY_P1D_VARIABLES_ACTIVE 29
#define i18n_libfizmo_NOT_ENOUGH_STACK_WORDS_FROM_LOCAL_ROUTINE_ON_STACK 30
#define i18n_libfizmo_NULL_POINTER_RECEIVED 31
#define i18n_libfizmo_PROPERTY_NUMBER_0_IS_NOT_VALID 32
#define i18n_libfizmo_PROPERTY_NUMBER_P0D_NOT_ALLOWED_IN_STORY_VERSION_P1D 33
#define i18n_libfizmo_OBJECT_NUMBER_0_IS_NOT_VALID 34
#define i18n_libfizmo_OBJECT_NUMBER_P0D_NOT_ALLOWED_IN_STORY_VERSION_P1D 35
#define i18n_libfizmo_NO_PROPERTY_P0D_FOR_OBJECT_P1D 36
#define i18n_libfizmo_CANNOT_READ_PROPERTIES_WITH_A_LENGTH_GREATER_THAN_2 37
#define i18n_libfizmo_ATTRIBUTE_NUMBER_P0D_NOT_ALLOWED_IN_STORY_VERSION_P1D 38
#define i18n_libfizmo_INVALID_NODE_TYPE_P0D 39
#define i18n_libfizmo_UNKNOWN_CHAR_CODE_P0D 40
#define i18n_libfizmo_MAXIMUM_ABBREVIATION_DEPTH_IS_P0D 41
#define i18n_libfizmo_UNKNOWN_ERROR_CASE 42
#define i18n_libfizmo_INVALID_ZSCII_INPUT_CODE_P0D 43
#define i18n_libfizmo_INVALID_ZSCII_OUTPUT_CODE_P0D 44
#define i18n_libfizmo_VALID_COMMANDS_ARE 45
#define i18n_libfizmo_RANDOM_GENERATOR_IS_NOW_IN_PREDICTABLE_MODE 46
#define i18n_libfizmo_RANDOM_GENERATOR_IS_NOW_IN_RANDOM_MODE 47
#define i18n_libfizmo_LIBFIZMO_VERSION_P0S 48
#define i18n_libfizmo_STORY_RELEASE_NUMBER 49
#define i18n_libfizmo_STORY_SERIAL_NUMBER 50
#define i18n_libfizmo_CURRENT_Z_STACK_SIZE_P0D_ENTRIES 51
#define i18n_libfizmo_CURRENT_Z_STACK_ENTRIES_IN_USE_P0D 52
#define i18n_libfizmo_HACK_01__ROUTINE_STACK_UNDERFLOW_CHECK_DISABLED 53
#define i18n_libfizmo_P0D_BYTES_USED_FOR_UNDO 54
#define i18n_libfizmo_P0D_BYTES_USED_BY_TEXT_HISTORY 55
#define i18n_libfizmo_P0D_BYTES_USED_BY_BLOCK_BUFFER 56
#define i18n_libfizmo_PRELOADED_INPUT_NOT_AVAILIABLE_IN_INTERFACE_P0S 57
#define i18n_libfizmo_TIMED_INPUT_NOT_IMPLEMENTED_IN_INTERFACE_P0S 58
#define i18n_libfizmo_PLEASE_ENTER_SAVEGAME_FILENAME 59
#define i18n_libfizmo_ERROR_WRITING_SAVE_FILE 60
#define i18n_libfizmo_CANT_FIND_CHUNK_IFHD 61
#define i18n_libfizmo_ERROR_READING_SAVE_FILE 62
#define i18n_libfizmo_COULD_NOT_READ_RELEASE_NUMBER 63
#define i18n_libfizmo_COULD_NOT_READ_SERIAL_NUMBER 64
#define i18n_libfizmo_COULD_NOT_READ_CHECKSUM 65
#define i18n_libfizmo_RELEASE_NR_SERIAL_NR_OR_CHECKSUM_DOESNT_MATCH 66
#define i18n_libfizmo_COULD_NOT_READ_RESTORE_PC 67
#define i18n_libfizmo_CANT_READ_CHUNK_LENGTH 68
#define i18n_libfizmo_COULD_NOT_FIND_ORIGINAL_STORY_FILE_P0S 69
#define i18n_libfizmo_CANT_FIND_CMEM_OR_UMEM_CHUNK 70
#define i18n_libfizmo_CANT_FIND_CHUNK_STKS 71
#define i18n_libfizmo_INVALID_IFF_ACCESS_MODE_P0D 72
#define i18n_libfizmo_CAUGHT_SIGNAL_P0D_ABORTING_INTERPRETER 73
#define i18n_libfizmo_CANNOT_DIVIDE_BY_ZERO 74
#define i18n_libfizmo_OPCODE_JE_WITH_ONLY_1_OPERAND_IS_ILLEGAL 75
#define i18n_libfizmo_FUNCTION_CALL_TIME_RETURNED_NEG_1 76
#define i18n_libfizmo_UNKNOWN_CONFIGURATION_OPTION_P0S 77
#define i18n_libfizmo_INVALID_VALUE_P0S_FOR_PARAMETER_P1S 78
#define i18n_libfizmo_STORY_HAS_Z_VERSION_NUMBER_P0D 79
#define i18n_libfizmo_HISTORYOUTPUT_NO_LONGER_VALID 80
#define i18n_libfizmo_FIZMO_VERSION_P0S 81

extern z_ucs libfizmo_module_name[];
extern z_ucs default_locale_name[];

#endif /* libfizmo_locales_h_INCLUDED */

