/*
 * Generic utility-functions, macros and defaults
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2002-2004 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef _TH_UTIL_H
#define _TH_UTIL_H
#include <stdarg.h>
#include <assert.h>

/*
 * Define some types
 */
typedef float			t_float;
typedef unsigned long int	t_ulint;
typedef unsigned int		t_uint;
typedef long int		t_lint;
typedef int			t_int;


#define	SET_MAX_BUF		(8192)


#if ((!defined(FALSE)) && (!defined(TRUE)) && (!defined(BOOL)))
typedef enum { FALSE=0, TRUE=1 } BOOL;
#endif

#ifndef BOOL
#ifdef bool
#define BOOL bool
#else
#define BOOL int
#endif
#endif


/*
 * Some helpful macros
 */
#define LPREV	(pNode->pPrev)
#define LTHIS	(pNode)
#define LNEXT	(pNode->pNext)


/*
 * Global variables
 */
extern	int	th_verbosityLevel;
extern	char	*th_prog_name,
		*th_prog_fullname,
		*th_prog_version,
		*th_prog_author,
		*th_prog_copyright,
		*th_prog_license;

/*
 * Functions
 */
void		th_init(char *progName, char *progFullName, char *progVersion,
		char *progAuthor, char *progLicense);
void		THERR(const char *, ...);
void		THMSG(int, const char *, ...);
void		THPRINT(int, const char *, ...);

#endif /* _TH_UTIL_H */
