/*
 * FISG - Helper functions for XML/HTML output modules
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2004 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#include "out_xhtmlgen.h"
#include "th_string.h"
#include <stdio.h>

typedef struct {
	int	entChar;
	char	*entStr;
} t_xmlentity;


t_xmlentity	xmlEntities[] = {
	{ '<',	"&lt;" },
	{ '>',	"&gt;" },
	{ '&',	"&amp;" },

	{ '',	"&iexcl;" },
	{ '',	"&cent;" },
	{ '',	"&pound;" },
	{ '',	"&curren;" },
	{ '',	"&yen;" },
	{ '',	"&brvbar;" },
	{ '',	"&sect;" },
	{ '',	"&uml;" },
	{ '',	"&copy;" },
	{ '',	"&ordf;" },
	{ '',	"&laquo;" },
	{ '',	"&not;" },
	{ '',	"&shy;" },
	{ '',	"&reg;" },
	{ '',	"&macr;" },
	{ '',	"&deg;" },
	{ '',	"&plusmn;" },
	{ '',	"&sup2;" },
	{ '',	"&sup3;" },
	{ '',	"&acute;" },
	{ '',	"&micro;" },
	{ '',	"&para;" },
	{ '',	"&middot;" },
	{ '',	"&cedil;" },
	{ '',	"&sup1;" },
	{ '',	"&ordm;" },
	{ '',	"&raquo;" },
	{ '',	"&frac14;" },
	{ '',	"&frac12;" },
	{ '',	"&frac34;" },
	{ '',	"&iquest;" },
	{ '',	"&Agrave;" },
	{ '',	"&Aacute;" },
	{ '',	"&Acirc;" },
	{ '',	"&Atilde;" },
	{ '',	"&Auml;" },
	{ '',	"&Aring;" },
	{ '',	"&AElig;" },
	{ '',	"&Ccedil;" },
	{ '',	"&Egrave;" },
	{ '',	"&Eacute;" },
	{ '',	"&Ecirc;" },
	{ '',	"&Euml;" },
	{ '',	"&Igrave;" },
	{ '',	"&Iacute;" },
	{ '',	"&Icirc;" },
	{ '',	"&Iuml;" },
	{ '',	"&ETH;" },
	{ '',	"&Ntilde;" },
	{ '',	"&Ograve;" },
	{ '',	"&Oacute;" },
	{ '',	"&Ocirc;" },
	{ '',	"&Otilde;" },
	{ '',	"&Ouml;" },
	{ '',	"&times;" },
	{ '',	"&Oslash;" },
	{ '',	"&Ugrave;" },
	{ '',	"&Uacute;" },
	{ '',	"&Ucirc;" },
	{ '',	"&Uuml;" },
	{ '',	"&Yacute;" },
	{ '',	"&THORN;" },
	{ '',	"&szlig;" },
	{ '',	"&agrave;" },
	{ '',	"&aacute;" },
	{ '',	"&acirc;" },
	{ '',	"&atilde;" },
	{ '',	"&auml;" },
	{ '',	"&aring;" },
	{ '',	"&aelig;" },
	{ '',	"&ccedil;" },
	{ '',	"&egrave;" },
	{ '',	"&eacute;" },
	{ '',	"&ecirc;" },
	{ '',	"&euml;" },
	{ '',	"&igrave;" },
	{ '',	"&iacute;" },
	{ '',	"&icirc;" },
	{ '',	"&iuml;" },
	{ '',	"&eth;" },
	{ '',	"&ntilde;" },
	{ '',	"&ograve;" },
	{ '',	"&oacute;" },
	{ '',	"&ocirc;" },
	{ '',	"&otilde;" },
	{ '',	"&ouml;" },
	{ '',	"&divide;" },
	{ '',	"&oslash;" },
	{ '',	"&ugrave;" },
	{ '',	"&uacute;" },
	{ '',	"&ucirc;" },
	{ '',	"&uuml;" },
	{ '',	"&yacute;" },
	{ '',	"&thorn;" },
	{ '',	"&yuml;" },
};

const t_uint	nXMLEntities = (sizeof(xmlEntities) / sizeof(t_xmlentity));


int xml_fprintf_entitize(FILE *outFile, char *fmt)
{
 BOOL isFound;
 int c;
 t_uint i;
 
 while ((c = *fmt))
 	{
 	/* Check character for entities */
	for (isFound = FALSE, i = 0; (i < nXMLEntities) && !isFound; i++)
		if (xmlEntities[i].entChar == c)
			{
			isFound = TRUE;
			break;
			}

	if (isFound)
		{
		if (fputs(xmlEntities[i].entStr, outFile) == EOF)
			return EOF;
		} else
		{
 		if (fputc(c, outFile) == EOF)
 			return EOF;
 		}
	
	fmt++;
 	}

 return 0;
}


int xml_fprintf_urlencode(FILE *outFile, char *fmt)
{
 int c;
 
 while ((c = *fmt))
 	{
 	if (th_isalnum(c) || th_ispunct(c))
 		{
 		if (fputc(c, outFile) == EOF)
 			return EOF;
 		} else {
 		fprintf(outFile, "%%%.2x", c & 0xff);
 		}

	fmt++;
 	}

 return 0;
}


t_xhtmlconfig	xhtml_cfg;

int output_xhtml_init(t_config *cfg)
{
 th_config_add_str(cfg, "xhtml_image_path",	NULL, &xhtml_cfg.dataPath, ".");
 th_config_add_str(cfg, "xhtml_css_path",	NULL, &xhtml_cfg.cssPath, "style.css");
 
 return 0;
}

