// Code generated by gen_all_horner_C_code.m in finufft/devel
// Authors: Alex Barnett & Ludvig af Klinteberg.
// (C) The Simons Foundation, Inc.
  if (w==2) {
    FLT c0[] = {2.3711015472112514E+01, 2.3711015472112514E+01, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c1[] = {2.5079742199350562E+01, -2.5079742199350562E+01, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c2[] = {-3.5023281580177050E+00, -3.5023281580177086E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c3[] = {-7.3894949249195587E+00, 7.3894949249195632E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    for (int i=0; i<4; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i])));
  } else if (w==3) {
    FLT c0[] = {5.9620016143346824E+01, 2.4110216701187497E+02, 5.9620016148621815E+01, 0.0000000000000000E+00};
    FLT c1[] = {9.7575520958604258E+01, 9.4807967775797928E-16, -9.7575520952908519E+01, 0.0000000000000000E+00};
    FLT c2[] = {3.5838417859768512E+01, -7.3472145274965371E+01, 3.5838417865129472E+01, 0.0000000000000000E+00};
    FLT c3[] = {-1.0721643298166471E+01, -2.1299978194824344E-16, 1.0721643303220413E+01, 0.0000000000000000E+00};
    FLT c4[] = {-7.0570630207138318E+00, 9.1538553399011260E+00, -7.0570630151506633E+00, 0.0000000000000000E+00};
    for (int i=0; i<4; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i]))));
  } else if (w==4) {
    FLT c0[] = {1.2612470018753689E+02, 1.1896204292999116E+03, 1.1896204292999118E+03, 1.2612470018753696E+02};
    FLT c1[] = {2.6158034850676626E+02, 5.6161104654809810E+02, -5.6161104654809844E+02, -2.6158034850676620E+02};
    FLT c2[] = {1.7145379463699527E+02, -1.6695967127766517E+02, -1.6695967127766514E+02, 1.7145379463699527E+02};
    FLT c3[] = {2.3525961965887870E+01, -1.0057439659768858E+02, 1.0057439659768873E+02, -2.3525961965887827E+01};
    FLT c4[] = {-1.5608307370340880E+01, 9.5627412100260845E+00, 9.5627412100260205E+00, -1.5608307370340908E+01};
    FLT c5[] = {-4.5715207776748699E+00, 7.9904373067895493E+00, -7.9904373067893877E+00, 4.5715207776749462E+00};
    for (int i=0; i<4; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i])))));
  } else if (w==5) {
    FLT c0[] = {2.4106943677442615E+02, 4.3538384278025542E+03, 9.3397486707381995E+03, 4.3538384278025515E+03, 2.4106943677442607E+02, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c1[] = {5.8781364250328272E+02, 3.4742855804122028E+03, -7.3041306797303120E-14, -3.4742855804122009E+03, -5.8781364250328249E+02, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c2[] = {5.1234107167555862E+02, 3.5219546517037116E+02, -1.7076861141633149E+03, 3.5219546517037247E+02, 5.1234107167555862E+02, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c3[] = {1.7540956907856057E+02, -3.5792356187777074E+02, -4.9888896652511712E-13, 3.5792356187777165E+02, -1.7540956907856059E+02, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c4[] = {-2.1768066955094961E-01, -7.8322173187697558E+01, 1.3904039464934516E+02, -7.8322173187697842E+01, -2.1768066955103071E-01, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c5[] = {-1.4207955403641256E+01, 1.6019466986221790E+01, 5.4386376890865855E-13, -1.6019466986220916E+01, 1.4207955403641320E+01, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c6[] = {-2.1966493586753826E+00, 5.0672636163194582E+00, -6.7340544905090631E+00, 5.0672636163189448E+00, -2.1966493586753089E+00, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    for (int i=0; i<8; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i]))))));
  } else if (w==6) {
    FLT c0[] = {4.3011762559089101E+02, 1.3368828836127070E+04, 4.9861340433371224E+04, 4.9861340433371253E+04, 1.3368828836127073E+04, 4.3011762559835148E+02, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c1[] = {1.1857225840065141E+03, 1.4112553227730617E+04, 1.5410005180819440E+04, -1.5410005180819426E+04, -1.4112553227730616E+04, -1.1857225839984601E+03, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c2[] = {1.2460481448413077E+03, 4.3127030215084960E+03, -5.5438591621431169E+03, -5.5438591621431306E+03, 4.3127030215084960E+03, 1.2460481448488902E+03, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c3[] = {6.0825549344387753E+02, -3.4106010789547094E+02, -1.9775725023673197E+03, 1.9775725023673208E+03, 3.4106010789547116E+02, -6.0825549343673094E+02, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c4[] = {1.1264961069783706E+02, -3.9740822717991142E+02, 2.7557540616463064E+02, 2.7557540616462472E+02, -3.9740822717991210E+02, 1.1264961070570448E+02, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c5[] = {-1.5387906304333878E+01, -3.2640579296387394E+01, 1.1683718215647470E+02, -1.1683718215646800E+02, 3.2640579296390861E+01, 1.5387906311562851E+01, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c6[] = {-9.3947198873910249E+00, 1.5069930500881778E+01, -8.0900452409597179E+00, -8.0900452409538364E+00, 1.5069930500884301E+01, -9.3947198802581902E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c7[] = {-5.6048841964539509E-01, 2.3377422080924530E+00, -4.2391567591836514E+00, 4.2391567591841817E+00, -2.3377422080928629E+00, 5.6048842664294984E-01, 0.0000000000000000E+00, 0.0000000000000000E+00};
    for (int i=0; i<8; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i])))))));
  } else if (w==7) {
    FLT c0[] = {7.2950392616203249E+02, 3.6439117038309480E+04, 2.1220891582018422E+05, 3.6180058567561524E+05, 2.1220891582018445E+05, 3.6439117038309487E+04, 7.2950392617434545E+02, 0.0000000000000000E+00};
    FLT c1[] = {2.2197790785452576E+03, 4.6392067080426248E+04, 1.1568051746995670E+05, -1.1902861988308852E-11, -1.1568051746995671E+05, -4.6392067080426241E+04, -2.2197790785319785E+03, 0.0000000000000000E+00};
    FLT c2[] = {2.6796845075663955E+03, 2.0921129984587249E+04, 3.9399551345574849E+01, -4.7251335435527435E+04, 3.9399551345580633E+01, 2.0921129984587245E+04, 2.6796845075789142E+03, 0.0000000000000000E+00};
    FLT c3[] = {1.6253748990844499E+03, 2.6138488347211564E+03, -1.0037546705421508E+04, 2.6823166126907972E-11, 1.0037546705421508E+04, -2.6138488347211546E+03, -1.6253748990726619E+03, 0.0000000000000000E+00};
    FLT c4[] = {4.9106375852553418E+02, -8.6668269315416171E+02, -1.0513434716618249E+03, 2.8444456471590756E+03, -1.0513434716618387E+03, -8.6668269315416057E+02, 4.9106375853851472E+02, 0.0000000000000000E+00};
    FLT c5[] = {4.0739167949763157E+01, -2.8515155742293922E+02, 3.9930326803801455E+02, 2.4847312048933061E-11, -3.9930326803798215E+02, 2.8515155742293899E+02, -4.0739167937835738E+01, 0.0000000000000000E+00};
    FLT c6[] = {-1.7148987139838667E+01, 7.5799002551700223E-01, 6.3260304953160343E+01, -1.0529869309160161E+02, 6.3260304953194023E+01, 7.5799002552709915E-01, -1.7148987128069749E+01, 0.0000000000000000E+00};
    FLT c7[] = {-4.5424411501060264E+00, 9.8749254058318616E+00, -9.6456179777547195E+00, 2.0621161109877312E-11, 9.6456179778118027E+00, -9.8749254058319202E+00, 4.5424411616514604E+00, 0.0000000000000000E+00};
    FLT c8[] = {-5.0793946806832954E-02, 7.3273813711856639E-01, -2.0117140544738263E+00, 2.6999257940856816E+00, -2.0117140545416512E+00, 7.3273813711318592E-01, -5.0793935653327994E-02, 0.0000000000000000E+00};
    for (int i=0; i<8; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i]))))))));
  } else if (w==8) {
    FLT c0[] = {1.1895823653767145E+03, 9.0980236725236929E+04, 7.7438826909537485E+05, 2.0077596413122697E+06, 2.0077596413122697E+06, 7.7438826909537497E+05, 9.0980236725236929E+04, 1.1895823653767147E+03};
    FLT c1[] = {3.9313191526977798E+03, 1.3318570706800820E+05, 5.7275848637687636E+05, 4.6250273225257988E+05, -4.6250273225257976E+05, -5.7275848637687659E+05, -1.3318570706800820E+05, -3.9313191526977798E+03};
    FLT c2[] = {5.2976026193612370E+03, 7.5628970871188430E+04, 1.0073339198368321E+05, -1.8165150843791291E+05, -1.8165150843791291E+05, 1.0073339198368321E+05, 7.5628970871188460E+04, 5.2976026193612397E+03};
    FLT c3[] = {3.7552239608473842E+03, 1.8376340228970901E+04, -2.3878081117551585E+04, -4.6296734056047833E+04, 4.6296734056048226E+04, 2.3878081117551632E+04, -1.8376340228970901E+04, -3.7552239608473833E+03};
    FLT c4[] = {1.4742862505418652E+03, 1.2842168112178376E+02, -9.1969665138398723E+03, 7.5990739935234687E+03, 7.5990739935234151E+03, -9.1969665138399178E+03, 1.2842168112178072E+02, 1.4742862505418645E+03};
    FLT c5[] = {2.8158981009344416E+02, -8.8613607108855206E+02, 5.3457145342334378E+01, 2.1750989694614777E+03, -2.1750989694609211E+03, -5.3457145342173561E+01, 8.8613607108856843E+02, -2.8158981009344393E+02};
    FLT c6[] = {-1.4786862436240726E+00, -1.3935442261830281E+02, 3.2599325739083491E+02, -1.9541889343332295E+02, -1.9541889343339443E+02, 3.2599325739083696E+02, -1.3935442261827953E+02, -1.4786862436237442E+00};
    FLT c7[] = {-1.1542034522902307E+01, 1.2000512051397084E+01, 1.9687328710129744E+01, -6.3962883082482271E+01, 6.3962883082874910E+01, -1.9687328710101575E+01, -1.2000512051407391E+01, 1.1542034522902124E+01};
    FLT c8[] = {-1.7448292513542445E+00, 4.8577330433956609E+00, -6.8794163043773890E+00, 3.4611708987408365E+00, 3.4611708985348386E+00, -6.8794163043605385E+00, 4.8577330433771184E+00, -1.7448292513550807E+00};
    FLT c9[] = {1.5044951479021193E-01, 9.6230159355094713E-02, -7.0399250398052082E-01, 1.3251401132916929E+00, -1.3251401128795544E+00, 7.0399250407339709E-01, -9.6230159355094713E-02, -1.5044951479003055E-01};
    for (int i=0; i<8; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i])))))))));
  } else if (w==9) {
    FLT c0[] = {1.8793738965776997E+03, 2.1220891582018419E+05, 2.5233246441351641E+06, 9.2877384983420596E+06, 1.4015330434461458E+07, 9.2877384983420689E+06, 2.5233246441351632E+06, 2.1220891582018507E+05, 1.8793738965777015E+03, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c1[] = {6.6675066501609344E+03, 3.4704155240986997E+05, 2.2890184838322559E+06, 3.8705035445351214E+06, -1.6037058324963857E-09, -3.8705035445351251E+06, -2.2890184838322555E+06, -3.4704155240987107E+05, -6.6675066501609363E+03, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c2[] = {9.8412775404612330E+03, 2.3171563090202375E+05, 6.8167589492092200E+05, -2.1140963571671984E+05, -1.4236515118873848E+06, -2.1140963571672366E+05, 6.8167589492092165E+05, 2.3171563090202425E+05, 9.8412775404612312E+03, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c3[] = {7.8762358364031033E+03, 7.6500585979636104E+04, 1.2434778984075023E+04, -2.8572091469430045E+05, 1.5952874106327477E-09, 2.8572091469430359E+05, -1.2434778984075045E+04, -7.6500585979636220E+04, -7.8762358364031052E+03, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c4[] = {3.6941911906762084E+03, 9.9232929169975941E+03, -3.3472877669902169E+04, -1.4082384858052235E+04, 6.7911966136972551E+04, -1.4082384858047793E+04, -3.3472877669902322E+04, 9.9232929169976087E+03, 3.6941911906762070E+03, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c5[] = {9.8900189723050266E+02, -1.2736589324621855E+03, -5.0407308390126955E+03, 9.8914296140171609E+03, 1.0742991696587890E-09, -9.8914296140222541E+03, 5.0407308390134704E+03, 1.2736589324621880E+03, -9.8900189723050198E+02, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c6[] = {1.1165868717715853E+02, -5.9057035448564977E+02, 5.5860705835603983E+02, 9.1996097522959656E+02, -2.0290255886377897E+03, 9.1996097523001129E+02, 5.5860705835622480E+02, -5.9057035448564693E+02, 1.1165868717715870E+02, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c7[] = {-1.3142584300868881E+01, -4.2852762793304592E+01, 1.8188640945795066E+02, -2.1362000457567430E+02, 6.1024810759112463E-10, 2.1362000457722939E+02, -1.8188640945795305E+02, 4.2852762793363922E+01, 1.3142584300866494E+01, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c8[] = {-5.8088068374878068E+00, 1.0201832931362965E+01, -3.5220973519213472E-01, -2.6632420896811951E+01, 4.2737607182672249E+01, -2.6632420895534445E+01, -3.5220973562147767E-01, 1.0201832931230712E+01, -5.8088068374901178E+00, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c9[] = {-4.0642645973308456E-01, 1.8389772328416343E+00, -3.5549484953682806E+00, 3.2273562233914270E+00, 1.3413454081272250E-09, -3.2273562258526494E+00, 3.5549484959023196E+00, -1.8389772328242200E+00, 4.0642645973371377E-01, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    for (int i=0; i<12; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i])))))))));
  } else if (w==10) {
    FLT c0[] = {2.8923571298063562E+03, 4.6856831608341925E+05, 7.5304732752870023E+06, 3.7576537584215783E+07, 7.9591606307847857E+07, 7.9591606307847857E+07, 3.7576537584215745E+07, 7.5304732752870042E+06, 4.6856831608341780E+05, 2.8923571298063575E+03, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c1[] = {1.0919387804943191E+04, 8.3976685277206497E+05, 7.9494027659552367E+06, 2.1606786285174552E+07, 1.4625897641453246E+07, -1.4625897641453277E+07, -2.1606786285174549E+07, -7.9494027659552367E+06, -8.3976685277206241E+05, -1.0919387804943171E+04, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c2[] = {1.7418455635504150E+04, 6.3489952164419880E+05, 3.1358985409389879E+06, 2.2547438801903646E+06, -6.0429762783920728E+06, -6.0429762783920513E+06, 2.2547438801903692E+06, 3.1358985409389860E+06, 6.3489952164419706E+05, 1.7418455635504110E+04, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c3[] = {1.5396188098732160E+04, 2.5490607173283451E+05, 4.2818880748176615E+05, -9.5435463094349275E+05, -1.2004850139039254E+06, 1.2004850139039545E+06, 9.5435463094349345E+05, -4.2818880748176581E+05, -2.5490607173283395E+05, -1.5396188098732138E+04, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c4[] = {8.2616700456447434E+03, 5.2880641964112285E+04, -6.1165055141131161E+04, -2.1590299490711108E+05, 2.1595822052157650E+05, 2.1595822052157007E+05, -2.1590299490713840E+05, -6.1165055141131197E+04, 5.2880641964112183E+04, 8.2616700456447306E+03, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c5[] = {2.7267169079066489E+03, 2.4572549134030801E+03, -2.6065821571078384E+04, 1.3919259807559451E+04, 4.6802084705699206E+04, -4.6802084705714289E+04, -1.3919259807536537E+04, 2.6065821571078890E+04, -2.4572549134029036E+03, -2.7267169079066425E+03, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c6[] = {5.0402062537834070E+02, -1.3640153425625381E+03, -1.4063198459019245E+03, 7.0858129627834105E+03, -4.8375233777605163E+03, -4.8375233777670810E+03, 7.0858129627894641E+03, -1.4063198459014579E+03, -1.3640153425626913E+03, 5.0402062537833700E+02, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c7[] = {2.4199726682542348E+01, -2.8393731159249540E+02, 5.1652001352543709E+02, 7.4578914842705018E+01, -1.1556759026365337E+03, 1.1556759026651935E+03, -7.4578914839714216E+01, -5.1652001352595710E+02, 2.8393731159268043E+02, -2.4199726682540959E+01, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c8[] = {-1.0545675122360885E+01, -3.0306758891224317E+00, 7.2305523762173834E+01, -1.3808908570221064E+02, 7.6293213403386517E+01, 7.6293213419205742E+01, -1.3808908572505672E+02, 7.2305523760424833E+01, -3.0306758894244412E+00, -1.0545675122369961E+01, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c9[] = {-2.1836930570474395E+00, 5.4992367509081630E+00, -4.5624617253163446E+00, -6.6492709819863256E+00, 2.0339240341691568E+01, -2.0339240351164950E+01, 6.6492710020476089E+00, 4.5624617253163446E+00, -5.4992367508501152E+00, 2.1836930570530630E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c10[] = {-9.1748741459757727E-02, 5.2562451739588611E-01, -1.4144257958835973E+00, 1.8629578990262812E+00, -9.0169874554123419E-01, -9.0169876258108816E-01, 1.8629579026113960E+00, -1.4144257947447987E+00, 5.2562451738534777E-01, -9.1748741464373396E-02, 0.0000000000000000E+00, 0.0000000000000000E+00};
    for (int i=0; i<12; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i]))))))))));
  } else if (w==11) {
    FLT c0[] = {4.3537972057094357E+03, 9.8872306817881018E+05, 2.0938056062983289E+07, 1.3701428307175827E+08, 3.8828289972017348E+08, 5.4292197128519189E+08, 3.8828289972017324E+08, 1.3701428307175821E+08, 2.0938056062983286E+07, 9.8872306817881099E+05, 4.3537972057093830E+03, 0.0000000000000000E+00};
    FLT c1[] = {1.7371472778611496E+04, 1.9155790709433770E+06, 2.4914432724618733E+07, 9.7792160665338323E+07, 1.3126779387874992E+08, 1.1003518489948497E-08, -1.3126779387874992E+08, -9.7792160665338367E+07, -2.4914432724618725E+07, -1.9155790709433774E+06, -1.7371472778611387E+04, 0.0000000000000000E+00};
    FLT c2[] = {2.9650558537745437E+04, 1.6014973065836846E+06, 1.1867448782239100E+07, 2.0812212822540633E+07, -1.1749875870571069E+07, -4.5121922350041404E+07, -1.1749875870571032E+07, 2.0812212822540659E+07, 1.1867448782239093E+07, 1.6014973065836851E+06, 2.9650558537745299E+04, 0.0000000000000000E+00};
    FLT c3[] = {2.8505604980264394E+04, 7.4166660874053277E+05, 2.5711466441825330E+06, -1.2146931938153899E+06, -8.3931576510116160E+06, -1.5221113764487218E-08, 8.3931576510117017E+06, 1.2146931938154220E+06, -2.5711466441825316E+06, -7.4166660874053324E+05, -2.8505604980264285E+04, 0.0000000000000000E+00};
    FLT c4[] = {1.7045632829988481E+04, 1.9785834209758078E+05, 8.6361403553701501E+04, -1.0584472412326147E+06, -1.3367486018960556E+05, 1.7818009619467217E+06, -1.3367486018952832E+05, -1.0584472412326441E+06, 8.6361403553699885E+04, 1.9785834209758087E+05, 1.7045632829988419E+04, 0.0000000000000000E+00};
    FLT c5[] = {6.5462464716912918E+03, 2.5347576368078855E+04, -7.5810878908805942E+04, -8.0774039751690128E+04, 2.5492801112955116E+05, 3.6655592491345995E-08, -2.5492801112950110E+05, 8.0774039751702396E+04, 7.5810878908810162E+04, -2.5347576368078677E+04, -6.5462464716912700E+03, 0.0000000000000000E+00};
    FLT c6[] = {1.5684149291082115E+03, -1.0302687059852267E+03, -1.3446845770824435E+04, 2.0814393480320545E+04, 1.4366994276523908E+04, -4.4581342385955380E+04, 1.4366994276463982E+04, 2.0814393480325110E+04, -1.3446845770824308E+04, -1.0302687059850016E+03, 1.5684149291082128E+03, 0.0000000000000000E+00};
    FLT c7[] = {1.9398419323286222E+02, -8.7329293867281388E+02, 2.4796533428938184E+02, 3.2905701326623416E+03, -4.8989871768459579E+03, 2.8861239463615327E-09, 4.8989871768722078E+03, -3.2905701326312101E+03, -2.4796533429068171E+02, 8.7329293867237629E+02, -1.9398419323287882E+02, 0.0000000000000000E+00};
    FLT c8[] = {-4.2288232505124679E+00, -9.9574929618003850E+01, 2.9563077146126534E+02, -1.9453049352240328E+02, -4.0107401572039475E+02, 7.9532514195009401E+02, -4.0107401576942334E+02, -1.9453049354949908E+02, 2.9563077145563869E+02, -9.9574929618160851E+01, -4.2288232505049734E+00, 0.0000000000000000E+00};
    FLT c9[] = {-5.3741131162167548E+00, 5.5350606003782072E+00, 1.9153744596147156E+01, -6.3189447483342484E+01, 6.6921287710344444E+01, 2.6543499136172006E-08, -6.6921287588490713E+01, 6.3189447458080132E+01, -1.9153744593546620E+01, -5.5350606004478644E+00, 5.3741131162113120E+00, 0.0000000000000000E+00};
    FLT c10[] = {-7.0359426508237854E-01, 2.2229112757468452E+00, -3.2054079720618520E+00, 8.3392526913327172E-02, 6.8879260281453520E+00, -1.0795498333352139E+01, 6.8879260220718077E+00, 8.3392507342704467E-02, -3.2054079702060019E+00, 2.2229112757257625E+00, -7.0359426507941902E-01, 0.0000000000000000E+00};
    FLT c11[] = {5.2648094861126392E-02, 9.9912561389764148E-02, -4.3913938527232693E-01, 7.9792987484770361E-01, -6.9191816827427566E-01, -1.2022534526020762E-09, 6.9191820562024531E-01, -7.9792984883890594E-01, 4.3913938443394634E-01, -9.9912561446925147E-02, -5.2648094869462925E-02, 0.0000000000000000E+00};
    for (int i=0; i<12; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i])))))))))));
  } else if (w==12) {
    FLT c0[] = {6.4299692685485315E+03, 2.0077596413122714E+06, 5.4904521978991628E+07, 4.5946106674819350E+08, 1.6835469840840104E+09, 3.1308386544851556E+09, 3.1308386544851556E+09, 1.6835469840840099E+09, 4.5946106674819458E+08, 5.4904521978991754E+07, 2.0077596413122730E+06, 6.4299692685634491E+03};
    FLT c1[] = {2.6965848540274073E+04, 4.1625245902732178E+06, 7.2097002594596952E+07, 3.8505085985474640E+08, 7.9479013671674240E+08, 4.7870231281824082E+08, -4.7870231281824046E+08, -7.9479013671674252E+08, -3.8505085985474682E+08, -7.2097002594597101E+07, -4.1625245902732178E+06, -2.6965848540258085E+04};
    FLT c2[] = {4.8869694409905111E+04, 3.7863371066322513E+06, 3.9530526716552719E+07, 1.1475134266581042E+08, 4.6311261797930710E+07, -2.0442837194260675E+08, -2.0442837194260725E+08, 4.6311261797930680E+07, 1.1475134266581020E+08, 3.9530526716552787E+07, 3.7863371066322504E+06, 4.8869694409920470E+04};
    FLT c3[] = {5.0530564260114021E+04, 1.9615784087727289E+06, 1.1044597342441007E+07, 7.9812418612436540E+06, -3.4042228324588493E+07, -3.3301805987927791E+07, 3.3301805987928167E+07, 3.4042228324588671E+07, -7.9812418612435497E+06, -1.1044597342440993E+07, -1.9615784087727286E+06, -5.0530564260099913E+04};
    FLT c4[] = {3.3081876469965493E+04, 6.2011956881368335E+05, 1.3086001239863748E+06, -3.1165484297367339E+06, -5.1982996003442882E+06, 6.3530947749618590E+06, 6.3530947749616513E+06, -5.1982996003444213E+06, -3.1165484297366543E+06, 1.3086001239863599E+06, 6.2011956881368288E+05, 3.3081876469981333E+04};
    FLT c5[] = {1.4308966168506788E+04, 1.1375573205951916E+05, -1.0318195403424598E+05, -6.6892418721462542E+05, 5.9223570255461533E+05, 1.1093685152673351E+06, -1.1093685152666988E+06, -5.9223570255418238E+05, 6.6892418721489178E+05, 1.0318195403424004E+05, -1.1375573205951886E+05, -1.4308966168492358E+04};
    FLT c6[] = {4.0848961919700960E+03, 7.5033277163528910E+03, -5.2578904182711594E+04, 6.3431596329919275E+03, 1.5984798504282799E+05, -1.2521363434070408E+05, -1.2521363434057294E+05, 1.5984798504289921E+05, 6.3431596327853522E+03, -5.2578904182714803E+04, 7.5033277163530738E+03, 4.0848961919843541E+03};
    FLT c7[] = {7.1658797373677544E+02, -1.5499947984100402E+03, -4.5490740453241297E+03, 1.4520122796414065E+04, -3.7896465826366048E+03, -2.3597107892645658E+04, 2.3597107892708405E+04, 3.7896465828577311E+03, -1.4520122796272850E+04, 4.5490740453326107E+03, 1.5499947984094520E+03, -7.1658797372277388E+02};
    FLT c8[] = {5.2022749592533359E+01, -4.0624258132650436E+02, 5.2256582980122801E+02, 9.3282469962834807E+02, -2.8710622267611107E+03, 1.7594166903207245E+03, 1.7594166904840572E+03, -2.8710622269566602E+03, 9.3282469973848731E+02, 5.2256582976889342E+02, -4.0624258132718376E+02, 5.2022749606062760E+01};
    FLT c9[] = {-7.0341875498860729E+00, -2.3043166229077922E+01, 1.2279331781679724E+02, -1.6714687548507158E+02, -4.4746498424591195E+01, 3.6060906024962412E+02, -3.6060905985137049E+02, 4.4746498852565225E+01, 1.6714687549695972E+02, -1.2279331779599295E+02, 2.3043166228938606E+01, 7.0341875614861786E+00};
    FLT c10[] = {-2.1556100132617875E+00, 4.1361104009993737E+00, 1.8107701723532290E+00, -2.1223400322208619E+01, 3.5820961861882218E+01, -1.8782945665578143E+01, -1.8782945409136026E+01, 3.5820961915195049E+01, -2.1223400242576908E+01, 1.8107701298380314E+00, 4.1361104007462801E+00, -2.1556100021452793E+00};
    FLT c11[] = {-1.1440899376747954E-01, 7.0567641591060326E-01, -1.4530217904770133E+00, 1.0571984613482723E+00, 1.4389002957406878E+00, -4.2241732762744180E+00, 4.2241733421252539E+00, -1.4389000664821670E+00, -1.0571984509828731E+00, 1.4530218285851431E+00, -7.0567641613924970E-01, 1.1440900438178304E-01};
    FLT c12[] = {-1.4486009663463860E-02, 2.9387825785034223E-03, -1.0265969715607470E-01, 2.6748267835596640E-01, -3.3606430399849180E-01, 1.5850148085005597E-01, 1.5850183161365292E-01, -3.3606448814949358E-01, 2.6748281866164947E-01, -1.0265975004478733E-01, 2.9387817050372631E-03, -1.4486000369842612E-02};
    for (int i=0; i<12; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i]))))))))))));
  } else if (w==13) {
    FLT c0[] = {9.3397060605267689E+03, 3.9447202186643109E+06, 1.3701428307175812E+08, 1.4375660883001409E+09, 6.6384519128895693E+09, 1.5848048271166529E+10, 2.1031560281976665E+10, 1.5848048271166502E+10, 6.6384519128895674E+09, 1.4375660883001378E+09, 1.3701428307175812E+08, 3.9447202186642843E+06, 9.3397060605268125E+03, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c1[] = {4.0984512931817764E+04, 8.6828943763566799E+06, 1.9558432133067656E+08, 1.3674961320373521E+09, 3.9251291128182430E+09, 4.5116631434426517E+09, 4.8375356630808043E-07, -4.5116631434426460E+09, -3.9251291128182402E+09, -1.3674961320373492E+09, -1.9558432133067656E+08, -8.6828943763566278E+06, -4.0984512931817771E+04, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c2[] = {7.8379538318778985E+04, 8.4928073133582603E+06, 1.1992091153966437E+08, 5.0561697705436689E+08, 6.1845897311593950E+08, -5.1306326495404470E+08, -1.4790096327029374E+09, -5.1306326495404077E+08, 6.1845897311593986E+08, 5.0561697705436659E+08, 1.1992091153966436E+08, 8.4928073133582156E+06, 7.8379538318778927E+04, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c3[] = {8.6417670227040013E+04, 4.8250267333349697E+06, 3.9836803808039002E+07, 7.5026052902191013E+07, -7.7565422849560052E+07, -2.5393835488011825E+08, 5.1202971235247489E-07, 2.5393835488012013E+08, 7.7565422849558711E+07, -7.5026052902191967E+07, -3.9836803808039002E+07, -4.8250267333349511E+06, -8.6417670227039998E+04, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c4[] = {6.1161604972829380E+04, 1.7331203720075535E+06, 7.0216196997558968E+06, -3.6027138646117523E+06, -3.1775875626364492E+07, 1.6544480876790185E+06, 4.9816566960114852E+07, 1.6544480876808946E+06, -3.1775875626363728E+07, -3.6027138646113039E+06, 7.0216196997558847E+06, 1.7331203720075490E+06, 6.1161604972829351E+04, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c5[] = {2.9177164557155938E+04, 3.9318079134661221E+05, 3.1307448297760956E+05, -2.7571366584957433E+06, -9.8421840747392306E+05, 6.8469173866731795E+06, 2.9232946975263515E-06, -6.8469173866698397E+06, 9.8421840747792379E+05, 2.7571366584955421E+06, -3.1307448297758284E+05, -3.9318079134660971E+05, -2.9177164557155946E+04, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c6[] = {9.5097815505886610E+03, 4.8799940773716655E+04, -1.2734023162441862E+05, -2.5472337176564379E+05, 6.3596049196278059E+05, 2.2361868201841635E+05, -1.0716559939651759E+06, 2.2361868202218774E+05, 6.3596049196161982E+05, -2.5472337176485342E+05, -1.2734023162441724E+05, 4.8799940773713337E+04, 9.5097815505886447E+03, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c7[] = {2.0601715730545379E+03, 1.9365931141472569E+02, -2.5304303117518622E+04, 2.9151392447034210E+04, 5.9055020355306144E+04, -1.1784846181665688E+05, 1.1400011168699383E-06, 1.1784846181507374E+05, -5.9055020356297522E+04, -2.9151392447480976E+04, 2.5304303117520958E+04, -1.9365931141621550E+02, -2.0601715730545466E+03, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c8[] = {2.5975061893404052E+02, -1.0025387650583972E+03, -6.8642481194759603E+02, 6.7515314205452096E+03, -7.0772939650079616E+03, -6.5444514139847633E+03, 1.6566898963381227E+04, -6.5444514164662887E+03, -7.0772939638053231E+03, 6.7515314202341915E+03, -6.8642481198706810E+02, -1.0025387650556635E+03, 2.5975061893403893E+02, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c9[] = {5.8705282128634133E+00, -1.4424362302822419E+02, 3.3390627215295177E+02, 4.8151337640374301E+01, -1.1431733953039347E+03, 1.4557114789663567E+03, 1.9301282133401762E-06, -1.4557114797747520E+03, 1.1431733969207255E+03, -4.8151337212400264E+01, -3.3390627213809154E+02, 1.4424362302302313E+02, -5.8705282128808269E+00, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c10[] = {-4.0954969508936898E+00, -1.2634947188543673E+00, 3.8134139835466350E+01, -8.4115524781317148E+01, 4.2766848228448069E+01, 1.0573434411021174E+02, -1.9636661067694894E+02, 1.0573435394677749E+02, 4.2766846813968300E+01, -8.4115525213218916E+01, 3.8134139824669184E+01, -1.2634947158177201E+00, -4.0954969509055461E+00, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c11[] = {-6.2702735486285888E-01, 1.8595467772479546E+00, -1.3027978470952948E+00, -4.9265265903267785E+00, 1.3906831953385087E+01, -1.3753762586104637E+01, 1.0604155239584518E-06, 1.3753756761963198E+01, -1.3906831509501583E+01, 4.9265273268806409E+00, 1.3027978586801867E+00, -1.8595467797630916E+00, 6.2702735486047489E-01, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c12[] = {-4.8290636703364975E-02, 1.7531876505199090E-01, -5.0041292774701596E-01, 6.3665145473474949E-01, -1.2476811514471326E-02, -1.2061603189510861E+00, 1.8595308638696268E+00, -1.2061633355215959E+00, -1.2475969680262359E-02, 6.3665088474340670E-01, -5.0041295405456876E-01, 1.7531876799797264E-01, -4.8290636708721864E-02, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c13[] = {2.2894665617766322E-02, -7.1358257229878720E-03, -1.4950743217821900E-02, 7.0611745711086651E-02, -1.2311302279978055E-01, 1.0342573392772816E-01, 5.7346192890547669E-07, -1.0342709034448951E-01, 1.2311300937219723E-01, -7.0611830251417942E-02, 1.4950741891648016E-02, 7.1358203725587141E-03, -2.2894665628191136E-02, 0.0000000000000000E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    for (int i=0; i<16; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i])))))))))))));
  } else if (w==14) {
    FLT c0[] = {1.3368785683552904E+04, 7.5304732752870144E+06, 3.2765764524434990E+08, 4.2418096936485257E+09, 2.4197690538177525E+10, 7.2227640697189651E+10, 1.2261475327356714E+11, 1.2261475327356711E+11, 7.2227640697189682E+10, 2.4197690538177582E+10, 4.2418096936485257E+09, 3.2765764524435169E+08, 7.5304732752870200E+06, 1.3368785683578039E+04, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c1[] = {6.1154444023081669E+04, 1.7488686085101541E+07, 5.0279014009863263E+08, 4.4777867842655849E+09, 1.6916819861812059E+10, 2.8971884004562843E+10, 1.6054555293734524E+10, -1.6054555293734529E+10, -2.8971884004562843E+10, -1.6916819861812090E+10, -4.4777867842655830E+09, -5.0279014009863406E+08, -1.7488686085101560E+07, -6.1154444023056145E+04, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c2[] = {1.2279790808348049E+05, 1.8230319600271538E+07, 3.3815815633683985E+08, 1.9369899011251254E+09, 3.9743454154781203E+09, 7.4954544638351786E+08, -7.0173920607395000E+09, -7.0173920607395000E+09, 7.4954544638351130E+08, 3.9743454154781117E+09, 1.9369899011251252E+09, 3.3815815633684093E+08, 1.8230319600271557E+07, 1.2279790808350699E+05, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c3[] = {1.4339321200624766E+05, 1.1200899688172188E+07, 1.2799140125169712E+08, 4.0176966726270604E+08, 7.9146174555810899E+07, -1.1719748245183561E+09, -9.6919138198233843E+08, 9.6919138198235476E+08, 1.1719748245183618E+09, -7.9146174555819452E+07, -4.0176966726270568E+08, -1.2799140125169776E+08, -1.1200899688172201E+07, -1.4339321200622554E+05, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c4[] = {1.0866548538632700E+05, 4.4565213401510641E+06, 2.8354150929531462E+07, 2.2805067924009934E+07, -1.2058223609889300E+08, -1.2775415620368913E+08, 1.9261201640091014E+08, 1.9261201640090343E+08, -1.2775415620368628E+08, -1.2058223609888241E+08, 2.2805067924009915E+07, 2.8354150929531943E+07, 4.4565213401510660E+06, 1.0866548538635390E+05, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c5[] = {5.6346565047794407E+04, 1.1743908345502375E+06, 3.0601086667309003E+06, -7.2274020134796975E+06, -1.6220595157143334E+07, 2.0773587344466623E+07, 2.8183198298701070E+07, -2.8183198298682313E+07, -2.0773587344454899E+07, 1.6220595157147046E+07, 7.2274020134809064E+06, -3.0601086667310768E+06, -1.1743908345502312E+06, -5.6346565047771022E+04, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c6[] = {2.0435142564639598E+04, 1.9450977300078847E+05, -1.1234667576926883E+05, -1.5205767549240857E+06, 1.0515640561047094E+06, 3.7458351782500809E+06, -3.3794074240119159E+06, -3.3794074240111569E+06, 3.7458351782506104E+06, 1.0515640561079446E+06, -1.5205767549239916E+06, -1.1234667576914738E+05, 1.9450977300078212E+05, 2.0435142564663307E+04, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c7[] = {5.1491366053560478E+03, 1.4735748500440239E+04, -8.1689482343683034E+04, -3.5176894225644079E+04, 3.7034248410400847E+05, -1.9109669530460562E+05, -5.2637978465735121E+05, 5.2637978465564619E+05, 1.9109669530912716E+05, -3.7034248412078863E+05, 3.5176894225852200E+04, 8.1689482343699274E+04, -1.4735748500439855E+04, -5.1491366053330485E+03, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c8[] = {8.5138795113645585E+02, -1.2978618911733427E+03, -8.7500873646623440E+03, 2.1319159613970569E+04, 7.6586611605801199E+03, -6.2424139811455236E+04, 4.2620771487921840E+04, 4.2620771491440872E+04, -6.2424139815176597E+04, 7.6586611693937375E+03, 2.1319159613447209E+04, -8.7500873648877496E+03, -1.2978618911701635E+03, 8.5138795115875257E+02, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c9[] = {7.2176142041616245E+01, -4.5543406155008586E+02, 2.8301959891624585E+02, 2.1994171513769957E+03, -4.5082500677203352E+03, 4.7658016853354945E+02, 7.1044827209848581E+03, -7.1044827023442112E+03, -4.7658015978385805E+02, 4.5082500694322307E+03, -2.1994171506161529E+03, -2.8301959873197922E+02, 4.5543406154525627E+02, -7.2176142022451799E+01, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c10[] = {-3.1135380163286266E+00, -3.8554406982628045E+01, 1.4396028111579378E+02, -1.1260050352192819E+02, -3.0073665460436297E+02, 7.2079162225452933E+02, -4.1195308319958349E+02, -4.1195308907344031E+02, 7.2079162228692246E+02, -3.0073665296314113E+02, -1.1260050391063737E+02, 1.4396028095922969E+02, -3.8554406981953719E+01, -3.1135379980309104E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c11[] = {-1.6022934776950781E+00, 1.8678197421257499E+00, 8.3368944138930576E+00, -3.0791578217513287E+01, 3.4749712345962102E+01, 1.2322522680262193E+01, -7.3924006859338746E+01, 7.3924005395986399E+01, -1.2322518095091780E+01, -3.4749717239655702E+01, 3.0791578812609753E+01, -8.3368942651188451E+00, -1.8678197375527952E+00, 1.6022934952009980E+00, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c12[] = {-1.9362061840948824E-01, 6.3024467669748396E-01, -9.3262278519229969E-01, -4.8908749318740480E-01, 4.0479376609320967E+00, -6.2829712900962678E+00, 3.1767825933699174E+00, 3.1767865219197975E+00, -6.2829777441520323E+00, 4.0479394849078085E+00, -4.8908801933495105E-01, -9.3262306580362497E-01, 6.3024467258732675E-01, -1.9362060312142931E-01, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c13[] = {1.8785913718903639E-02, 3.1605271252714680E-02, -1.3655798291459853E-01, 2.5016547139148904E-01, -1.6654308552073466E-01, -2.1682598043284024E-01, 6.1786085249849709E-01, -6.1785470804340159E-01, 2.1682794765059335E-01, 1.6654258378326353E-01, -2.5016523395036322E-01, 1.3655803190024704E-01, -3.1605272440421092E-02, -1.8785905282938619E-02, 0.0000000000000000E+00, 0.0000000000000000E+00};
    FLT c14[] = {-1.2896545140952162E-02, -3.7106972352948116E-03, 5.8857860695711909E-04, 1.3987176343065890E-02, -3.5714007561179102E-02, 4.3401590960273219E-02, -2.0034532372716081E-02, -2.0038454375630149E-02, 4.3401322628411031E-02, -3.5713348533616053E-02, 1.3987046090052241E-02, 5.8856319054218355E-04, -3.7106979912720915E-03, -1.2896537385752806E-02, 0.0000000000000000E+00, 0.0000000000000000E+00};
    for (int i=0; i<16; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i] + z*(c14[i]))))))))))))));
  } else if (w==15) {
    FLT c0[] = {1.8887777774374499E+04, 1.4015330434461417E+07, 7.5498683300180018E+08, 1.1900937739619951E+10, 8.2530965279375351E+10, 3.0178246269069604E+11, 6.3775691457119104E+11, 8.1471473119305554E+11, 6.3775691457119116E+11, 3.0178246269069641E+11, 8.2530965279375519E+10, 1.1900937739619963E+10, 7.5498683300180054E+08, 1.4015330434461435E+07, 1.8887777774374488E+04, 0.0000000000000000E+00};
    FLT c1[] = {8.9780907163796335E+04, 3.4167636285297148E+07, 1.2346880033823481E+09, 1.3719272724135921E+10, 6.5858241494816696E+10, 1.5266999939989539E+11, 1.5687794513790723E+11, -2.8523584844088883E-05, -1.5687794513790732E+11, -1.5266999939989545E+11, -6.5858241494816811E+10, -1.3719272724135933E+10, -1.2346880033823476E+09, -3.4167636285297163E+07, -8.9780907163796335E+04, 0.0000000000000000E+00};
    FLT c2[] = {1.8850321233130712E+05, 3.7693640983013541E+07, 8.9846818051570034E+08, 6.7094088040439653E+09, 1.9743296615199215E+10, 1.8072727219391140E+10, -2.0634615374559410E+10, -4.9654335197177498E+10, -2.0634615374559414E+10, 1.8072727219391048E+10, 1.9743296615199223E+10, 6.7094088040439672E+09, 8.9846818051570022E+08, 3.7693640983013526E+07, 1.8850321233130703E+05, 0.0000000000000000E+00};
    FLT c3[] = {2.3185006533495727E+05, 2.4789475362741601E+07, 3.7751696829092383E+08, 1.7167916788178182E+09, 1.9832401267745295E+09, -3.4881359830884194E+09, -7.8785602379628601E+09, 6.6906528952995499E-05, 7.8785602379629536E+09, 3.4881359830884261E+09, -1.9832401267745163E+09, -1.7167916788178096E+09, -3.7751696829092425E+08, -2.4789475362741597E+07, -2.3185006533495730E+05, 0.0000000000000000E+00};
    FLT c4[] = {1.8672970114818285E+05, 1.0741068109706732E+07, 9.8017949708492473E+07, 2.0291084954252145E+08, -2.7857869294214898E+08, -9.4112677968756318E+08, 1.7886520649334356E+08, 1.4579673547891481E+09, 1.7886520649344125E+08, -9.4112677968753338E+08, -2.7857869294217581E+08, 2.0291084954251301E+08, 9.8017949708492488E+07, 1.0741068109706739E+07, 1.8672970114818282E+05, 0.0000000000000000E+00};
    FLT c5[] = {1.0411891611891470E+05, 3.1771463075269456E+06, 1.4880104152842037E+07, -6.8136965447538150E+06, -8.7072998215422541E+07, 1.8024116530863210E+06, 1.9067730799615666E+08, 1.2078175959365315E-04, -1.9067730799603686E+08, -1.8024116529155241E+06, 8.7072998215445980E+07, 6.8136965447565373E+06, -1.4880104152841812E+07, -3.1771463075269484E+06, -1.0411891611891470E+05, 0.0000000000000000E+00};
    FLT c6[] = {4.1300641422694731E+04, 6.3217168592497683E+05, 7.7343707634845132E+05, -5.4575962381476769E+06, -3.7387211063063843E+06, 1.8451583614082869E+07, 3.0480804948189310E+06, -2.7500445095872246E+07, 3.0480804948457484E+06, 1.8451583614064269E+07, -3.7387211062890980E+06, -5.4575962381450543E+06, 7.7343707634841127E+05, 6.3217168592497602E+05, 4.1300641422694724E+04, 0.0000000000000000E+00};
    FLT c7[] = {1.1710443348523711E+04, 7.5405449195716908E+04, -1.6634736996487752E+05, -5.6069290801842115E+05, 1.1540571563940533E+06, 1.0209821660925965E+06, -2.9641921942009293E+06, -7.3770236318814628E-06, 2.9641921942630685E+06, -1.0209821662946860E+06, -1.1540571563987043E+06, 5.6069290801928868E+05, 1.6634736996459437E+05, -7.5405449195719295E+04, -1.1710443348523739E+04, 0.0000000000000000E+00};
    FLT c8[] = {2.3142324239350210E+03, 2.1710560541703007E+03, -3.6929625713151705E+04, 2.6143898219588682E+04, 1.4046980090353978E+05, -2.1033190114896413E+05, -1.1132269819276403E+05, 3.7491447373940505E+05, -1.1132269820720138E+05, -2.1033190120894444E+05, 1.4046980085134835E+05, 2.6143898217223435E+04, -3.6929625713258414E+04, 2.1710560541651053E+03, 2.3142324239349791E+03, 0.0000000000000000E+00};
    FLT c9[] = {2.8879718294281940E+02, -9.2801372612866078E+02, -1.9817144428357562E+03, 9.9004179214302640E+03, -5.7928268996319048E+03, -2.1083466266548403E+04, 3.3285502001854453E+04, 1.3615676123196788E-04, -3.3285501884684672E+04, 2.1083466388283239E+04, 5.7928269528908959E+03, -9.9004179214302640E+03, 1.9817144428357562E+03, 9.2801372612624596E+02, -2.8879718294281940E+02, 0.0000000000000000E+00};
    FLT c10[] = {1.3121871131759899E+01, -1.5978845118014243E+02, 2.7429718889479011E+02, 4.4598059431432415E+02, -1.8917609556521720E+03, 1.5303002256342920E+03, 1.7542368404254241E+03, -3.9411530187890685E+03, 1.7542368839611659E+03, 1.5303002335812619E+03, -1.8917609760379448E+03, 4.4598059250034765E+02, 2.7429718872202716E+02, -1.5978845118149314E+02, 1.3121871131760223E+01, 0.0000000000000000E+00};
    FLT c11[] = {-2.4286151057622600E+00, -6.7839829150137421E+00, 4.6999223003107119E+01, -7.4896070454665107E+01, -3.2010110856873055E+01, 2.5022929107925501E+02, -2.8786053481345135E+02, 1.4424367379967129E-05, 2.8786057555317575E+02, -2.5022937123192844E+02, 3.2010139421505684E+01, 7.4896073537460509E+01, -4.6999223012862650E+01, 6.7839829186720362E+00, 2.4286151057336860E+00, 0.0000000000000000E+00};
    FLT c12[] = {-5.4810555665671257E-01, 1.1436870859674571E+00, 8.2471504792547190E-01, -8.5602131787584241E+00, 1.5631631237511966E+01, -6.4979395997142886E+00, -1.8737629118679905E+01, 3.3283673647767003E+01, -1.8737705444926284E+01, -6.4980552114725620E+00, 1.5631576798962341E+01, -8.5602158445716778E+00, 8.2471481116140977E-01, 1.1436870769250529E+00, -5.4810555667406624E-01, 0.0000000000000000E+00};
    FLT c13[] = {-1.4554612891837512E-02, 1.7022157398269799E-01, -3.7563892964814216E-01, 2.0131145240492249E-01, 8.3554123561642435E-01, -2.1191317631421946E+00, 1.9961007770939201E+00, 5.0230495487029605E-05, -1.9960655197919825E+00, 2.1191435815870405E+00, -8.3552330614378623E-01, -2.0131363341395125E-01, 3.7563890238546094E-01, -1.7022157734534860E-01, 1.4554612875194470E-02, 0.0000000000000000E+00};
    FLT c14[] = {-1.2348455978815665E-02, 2.6143485494326945E-03, -2.9252290291144727E-02, 7.5392101552106419E-02, -8.7986538697867239E-02, 1.3073120666751545E-03, 1.5251801232957554E-01, -2.3235618419546245E-01, 1.5253703942622115E-01, 1.3217162898956957E-03, -8.7999818995735196E-02, 7.5391507930594778E-02, -2.9252395603998178E-02, 2.6143483927929994E-03, -1.2348455970768767E-02, 0.0000000000000000E+00};
    FLT c15[] = {1.4214685591273772E-02, -1.2364346992375923E-03, 1.2892328724708124E-03, 1.6178725688327468E-03, -8.2104229475896996E-03, 1.3914679473447157E-02, -1.1426959041713501E-02, 1.6590583007947697E-05, 1.1446333966460217E-02, -1.3912124902889801E-02, 8.2298310485774198E-03, -1.6155336438419190E-03, -1.2892162843503102E-03, 1.2364372911314208E-03, -1.4214685607473108E-02, 0.0000000000000000E+00};
    for (int i=0; i<16; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i] + z*(c14[i] + z*(c15[i])))))))))))))));
  } else if (w==16) {
    FLT c0[] = {2.6374086784014689E+04, 2.5501413681212645E+07, 1.6835469840840099E+09, 3.1953580806547867E+10, 2.6584910126662766E+11, 1.1715858191494619E+12, 3.0181658330343120E+12, 4.7888775408612773E+12, 4.7888775408612764E+12, 3.0181658330343125E+12, 1.1715858191494619E+12, 2.6584910126662772E+11, 3.1953580806547874E+10, 1.6835469840840104E+09, 2.5501413681212656E+07, 2.6374086784014886E+04};
    FLT c1[] = {1.2991568388123445E+05, 6.4986154651133664E+07, 2.9142305012947259E+09, 3.9748054433728149E+10, 2.3649443248440247E+11, 7.0471088240421252E+11, 1.0533888905987031E+12, 5.4832304482297632E+11, -5.4832304482297687E+11, -1.0533888905987034E+12, -7.0471088240421265E+11, -2.3649443248440250E+11, -3.9748054433728149E+10, -2.9142305012947259E+09, -6.4986154651133649E+07, -1.2991568388123448E+05};
    FLT c2[] = {2.8421223836872831E+05, 7.5448503558118582E+07, 2.2710828032883868E+09, 2.1491603403163826E+10, 8.4299374042308136E+10, 1.3384457365769528E+11, 1.8630012765531485E+09, -2.4384536789321179E+11, -2.4384536789321094E+11, 1.8630012765532806E+09, 1.3384457365769531E+11, 8.4299374042308090E+10, 2.1491603403163826E+10, 2.2710828032883863E+09, 7.5448503558118552E+07, 2.8421223836872820E+05};
    FLT c3[] = {3.6653021243297518E+05, 5.2693428548387080E+07, 1.0410094433021281E+09, 6.3986267576853533E+09, 1.3313926739756302E+10, -2.7909761561128025E+09, -3.9911638977027977E+10, -2.9236947704012939E+10, 2.9236947704012939E+10, 3.9911638977028267E+10, 2.7909761561128430E+09, -1.3313926739756279E+10, -6.3986267576853561E+09, -1.0410094433021276E+09, -5.2693428548387088E+07, -3.6653021243297518E+05};
    FLT c4[] = {3.1185660915838118E+05, 2.4564274645530280E+07, 3.0509279143241835E+08, 1.0432225146182569E+09, 6.4966284440222360E+07, -4.2483903608016477E+09, -3.1778261722524829E+09, 5.9880587942832708E+09, 5.9880587942832832E+09, -3.1778261722526174E+09, -4.2483903608017979E+09, 6.4966284440235756E+07, 1.0432225146182607E+09, 3.0509279143241805E+08, 2.4564274645530272E+07, 3.1185660915838124E+05};
    FLT c5[] = {1.8544733523229562E+05, 7.9824949938292839E+06, 5.6880943382648192E+07, 5.4097201999258779E+07, -3.0776449202833223E+08, -3.7659931821867347E+08, 6.8797698944719648E+08, 7.5429896889866996E+08, -7.5429896889781320E+08, -6.8797698944658160E+08, 3.7659931821898031E+08, 3.0776449202837497E+08, -5.4097201999252096E+07, -5.6880943382647842E+07, -7.9824949938292857E+06, -1.8544733523229562E+05};
    FLT c6[] = {7.9472339236673259E+04, 1.8159676553648398E+06, 5.7259818806751696E+06, -1.2786136236423338E+07, -3.8677490873147681E+07, 4.7651450515707508E+07, 9.0723760109202415E+07, -9.4532949239946112E+07, -9.4532949239604995E+07, 9.0723760109522834E+07, 4.7651450515667401E+07, -3.8677490873160362E+07, -1.2786136236416934E+07, 5.7259818806752721E+06, 1.8159676553648538E+06, 7.9472339236673215E+04};
    FLT c7[] = {2.4831718998299857E+04, 2.7536301841716090E+05, -5.1045953356025166E+04, -2.6996387880239477E+06, 1.1656554632125401E+06, 9.1521923449522462E+06, -6.8198180925621921E+06, -1.2555197000954127E+07, 1.2555197001087580E+07, 6.8198180925775450E+06, -9.1521923449367471E+06, -1.1656554632051867E+06, 2.6996387880183556E+06, 5.1045953355832869E+04, -2.7536301841717580E+05, -2.4831718998299897E+04};
    FLT c8[] = {5.6060763597396035E+03, 2.2154740880101843E+04, -1.0243462874810334E+05, -1.1802198892388590E+05, 6.4061699367506150E+05, -1.1166716749369531E+05, -1.4153578101923370E+06, 1.0790712965214122E+06, 1.0790712965802078E+06, -1.4153578102569627E+06, -1.1166716767280686E+05, 6.4061699367841065E+05, -1.1802198892652121E+05, -1.0243462874831920E+05, 2.2154740880096295E+04, 5.6060763597396262E+03};
    FLT c9[] = {8.7271993222049730E+02, -7.0074676859193858E+02, -1.2528372958474913E+04, 2.3643101054370443E+04, 3.1699060146436736E+04, -1.1270133578294520E+05, 3.6872846840416030E+04, 1.5168911768972370E+05, -1.5168911672801850E+05, -3.6872846329129716E+04, 1.1270133600206790E+05, -3.1699060140349993E+04, -2.3643101053229180E+04, 1.2528372958403583E+04, 7.0074676858840917E+02, -8.7271993222049730E+02};
    FLT c10[] = {7.8842259458727298E+01, -4.2070880913717718E+02, -1.0535142166729695E+02, 3.3375056757602101E+03, -4.9426353709826744E+03, -3.6567309465694352E+03, 1.5199085032737788E+04, -9.4972226150681072E+03, -9.4972224492176338E+03, 1.5199085307902486E+04, -3.6567309714471071E+03, -4.9426353751288962E+03, 3.3375056795609726E+03, -1.0535142205602271E+02, -4.2070880913447866E+02, 7.8842259458701932E+01};
    FLT c11[] = {8.9833076760252317E-02, -4.4163371177310189E+01, 1.2880771175011134E+02, 2.8722208980881483E+00, -5.7164632401064989E+02, 9.0417621054583299E+02, 1.1221311957018894E+00, -1.4190922684153286E+03, 1.4190926436578332E+03, -1.1219382673482139E+00, -9.0417616902565715E+02, 5.7164633587355513E+02, -2.8722219907225899E+00, -1.2880771149646372E+02, 4.4163371174871045E+01, -8.9833076793553943E-02};
    FLT c12[] = {-1.0900468357304585E+00, -1.1264666580175993E-01, 1.1810668498718398E+01, -3.0289105594116332E+01, 1.5494599855921946E+01, 6.0130016326899806E+01, -1.2330195579557967E+02, 6.7114292010484860E+01, 6.7114238133033894E+01, -1.2330200967294053E+02, 6.0129899592769000E+01, 1.5494588631452897E+01, -3.0289108821162568E+01, 1.1810668060273379E+01, -1.1264668224327026E-01, -1.0900468357482698E+00};
    FLT c13[] = {-1.1763610124684608E-01, 4.2939195551308978E-01, -2.7950231695310290E-01, -1.7354597875532083E+00, 5.1181749794184972E+00, -5.0538409872852545E+00, -2.1268758321444312E+00, 1.0709572497394593E+01, -1.0709247944735344E+01, 2.1270284132327628E+00, 5.0538814533614023E+00, -5.1181783143082038E+00, 1.7354587260576941E+00, 2.7950208340719496E-01, -4.2939195720020440E-01, 1.1763610121354666E-01};
    FLT c14[] = {-1.8020499708490779E-02, 3.6694576081450124E-02, -1.1331174689418615E-01, 1.3970801507325420E-01, 8.1708800731612838E-02, -5.4465632012605969E-01, 7.9628723318194716E-01, -3.9045387765910361E-01, -3.9034731591396871E-01, 7.9641679205120786E-01, -5.4465236519348836E-01, 8.1709687544577886E-02, 1.3970913694934384E-01, -1.1331198385459386E-01, 3.6694575058947500E-02, -1.8020499699434717E-02};
    FLT c15[] = {1.4589783457723899E-02, -7.8885273589694921E-04, -4.4854775481901451E-03, 1.8117810622567232E-02, -3.0563678378015532E-02, 1.9027105036022670E-02, 2.4778670881552757E-02, -6.7767913155521747E-02, 6.7979444868167399E-02, -2.4638534439549119E-02, -1.8992900331546877E-02, 3.0569915511324409E-02, -1.8117279802711158E-02, 4.4857097818771776E-03, 7.8885377265448060E-04, -1.4589783469873403E-02};
    FLT c16[] = {-1.0467998068898355E-02, -3.2140568385029999E-04, 5.2979866592800886E-04, -1.5800624712947203E-04, -1.4200041949817279E-03, 3.7626007108648857E-03, -3.8348321381240775E-03, 1.6547563335740942E-03, 1.5759584129276946E-03, -3.8873640852216617E-03, 3.7166352571544989E-03, -1.4265706883689335E-03, -1.5923746463956793E-04, 5.2952292450647511E-04, -3.2141610431099765E-04, -1.0467998084554094E-02};
    for (int i=0; i<16; i++) ker[i] = c0[i] + z*(c1[i] + z*(c2[i] + z*(c3[i] + z*(c4[i] + z*(c5[i] + z*(c6[i] + z*(c7[i] + z*(c8[i] + z*(c9[i] + z*(c10[i] + z*(c11[i] + z*(c12[i] + z*(c13[i] + z*(c14[i] + z*(c15[i] + z*(c16[i]))))))))))))))));
  } else
    printf("width not implemented!\n");
