# Flatiron Institute Nonuniform Fast Fourier Transform library: FINUFFT

Principal author **Alex H. Barnett**, main co-developers Jeremy F. Magland, Ludvig af Klinteberg, Yu-hsuan "Melody" Shih, Andrea Malleo, Libin Lu, and Joakim Andén.

This package provides a Python interface to the library, enabling fast computation of nonuniform discrete Fourier transforms to specified precision in one, two, and three dimensions.
It supports transforms of type 1 (nonuniform to uniform), type 2 (uniform to nonuniform) and type 3 (nonuniform to nonuniform).
For more information, see the [online documentation](https://finufft.readthedocs.io/en/latest/python.html).

If you find FINUFFT useful in your work, please cite this package and our paper:

    A parallel non-uniform fast Fourier transform library based on an ``exponential of semicircle'' kernel.
    A. H. Barnett, J. F. Magland, and L. af Klinteberg.
    SIAM J. Sci. Comput. 41(5), C479–C504 (2019).
