/*
 *      fhist - file history and comparison tools
 *      Copyright (C) 1991-1994, 1998-2000, 2002, 2008 Peter Miller
 *
 *      Derived from a work
 *      Copyright (C) 1990 David I. Bell.
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see
 *      <http://www.gnu.org/licenses/>.
 *
 * Definitions for local file handling routines.
 */

#ifndef FILEIO_H
#define FILEIO_H

#include <ac/stdio.h>

#include <main.h>


/*
 * Function Prototypes
 */
void seekf(FILE *, long, const char *);
int skipf(FILE *, long, const char *);
char *readlinef(FILE *, long *, int, const char *, int *);
long readf(FILE *, char *, long, const char *, int *);
void writefx(FILE *, char *, long, const char *);
int copyf(FILE *, FILE *, long, const char *, const char *);
void copyfx(FILE *, FILE *, long, const char *, const char *);
int typef(FILE *, const char *);
void typefx(FILE *, const char *);

#endif /* FILEIO_H */
