/***************************************************************************
 *   Copyright (C) 2009 by Andrey Afletdinov <fheroes2@gmail.com>          *
 *                                                                         *
 *   Part of the Free Heroes2 Engine:                                      *
 *   http://sourceforge.net/projects/fheroes2                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <cassert>

#include "game.h"
#include "heroes_recruits.h"
#include "save_format_version.h"
#include "serialize.h"
#include "world.h"

Recruit::Recruit()
    : _id( Heroes::UNKNOWN )
    , _surrenderDay( 0 )
{}

Recruit::Recruit( const Heroes & hero, const uint32_t surrenderDay )
    : _id( hero.GetID() )
    , _surrenderDay( surrenderDay )
{}

Recruit::Recruit( const Heroes & hero )
    : Recruit( hero, 0 )
{}

void Recruit::setSurrenderDayTmp( const uint32_t surrenderDay )
{
    static_assert( LAST_SUPPORTED_FORMAT_VERSION < FORMAT_VERSION_PRE2_0912_RELEASE, "Remove this method." );

    _surrenderDay = surrenderDay;
}

Recruits::Recruits()
    : std::pair<Recruit, Recruit>()
{}

void Recruits::Reset()
{
    first = {};
    second = {};
}

int Recruits::GetID1() const
{
    return first.getID();
}

int Recruits::GetID2() const
{
    return second.getID();
}

Heroes * Recruits::GetHero1() const
{
    return world.GetHeroes( first.getID() );
}

Heroes * Recruits::GetHero2() const
{
    return world.GetHeroes( second.getID() );
}

uint32_t Recruits::getSurrenderDayOfHero1() const
{
    return first.getSurrenderDay();
}

uint32_t Recruits::getSurrenderDayOfHero2() const
{
    return second.getSurrenderDay();
}

void Recruits::SetHero1( Heroes * hero )
{
    if ( hero ) {
        hero->SetModes( Heroes::RECRUIT );

        first = Recruit( *hero );
    }
    else {
        first = {};
    }
}

void Recruits::SetHero2( Heroes * hero )
{
    if ( hero ) {
        hero->SetModes( Heroes::RECRUIT );

        second = Recruit( *hero );
    }
    else {
        second = {};
    }
}

void Recruits::SetHero2Tmp( Heroes * hero, const uint32_t heroSurrenderDay )
{
    static_assert( LAST_SUPPORTED_FORMAT_VERSION < FORMAT_VERSION_PRE2_0912_RELEASE, "Remove this method." );
    assert( hero != nullptr );

    SetHero2( hero );

    second.setSurrenderDayTmp( heroSurrenderDay );
}

void Recruits::appendSurrenderedHero( Heroes & hero, const uint32_t heroSurrenderDay )
{
    assert( heroSurrenderDay > 0 );

    hero.SetModes( Heroes::RECRUIT );

    Recruit & recruit = ( first.getSurrenderDay() > second.getSurrenderDay() ? second : first );

    recruit = Recruit( hero, heroSurrenderDay );
}

StreamBase & operator<<( StreamBase & msg, const Recruit & recruit )
{
    return msg << recruit._id << recruit._surrenderDay;
}

StreamBase & operator>>( StreamBase & msg, Recruit & recruit )
{
    msg >> recruit._id;

    static_assert( LAST_SUPPORTED_FORMAT_VERSION < FORMAT_VERSION_PRE2_0912_RELEASE, "Remove the check below." );
    if ( Game::GetLoadVersion() >= FORMAT_VERSION_PRE2_0912_RELEASE ) {
        msg >> recruit._surrenderDay;
    }
    else {
        recruit._surrenderDay = 0;
    }

    return msg;
}
